---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 110
  claims_with_evidence: 106
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：libraries-System.Resources.Extensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：106 / 110、根拠なし：4
- 優先レビュー（高）
  1. **UT-SRE-093**：ValueUpdater.UpdateValueは抽象メソッドのため、派生クラスの実装確認が必要
  2. **UT-SRE-103**：SerializationInfoExtensions.UpdateValueはリフレクション経由のため動作確認推奨
  3. **UT-SRE-067, UT-SRE-068**：イベント発火のタイミングと順序の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/PreserializedResourceWriter.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/DeserializingResourceReader.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/TypeNameComparer.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/BinaryFormattedObject.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/BinaryFormattedObject.Options.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/BinaryFormattedObject.TypeResolver.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/Deserializer.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/ArrayRecordDeserializer.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/ClassRecordDeserializer.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/ObjectRecordDeserializer.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/ValueUpdater.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/Deserializer/PendingSerializationInfo.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/SerializationEvents.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/SerializationExtensions.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/BinaryFormat/SerializationInfoExtensions.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/BinaryWriterExtensions.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/BinaryReaderExtensions.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/src/System/Resources/Extensions/SerializationFormat.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Resources.Extensions/ref/System.Resources.Extensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-06 | PreserializedResourceWriter.AddResource引数検証 | E-01 (L73-75, L91-96) | ○ |
| C-07〜C-09 | AddTypeConverterResource機能・引数検証 | E-01 (L119-128) | ○ |
| C-10〜C-11 | AddBinaryFormattedResource機能 | E-01 (L137-155) | ○ |
| C-12〜C-13 | AddActivatorResource機能・ストリーム検証 | E-01 (L165-177) | ○ |
| C-14〜C-17 | WriteData各形式の書き込み処理 | E-01 (L193-263) | ○ |
| C-18〜C-20 | ValidateReaderType検証 | E-02 (L18-36) | ○ |
| C-21〜C-22 | ReadBinaryFormattedObject処理分岐 | E-02 (L38-56) | ○ |
| C-23〜C-29 | DeserializeObject各形式処理・例外 | E-02 (L113-234) | ○ |
| C-30〜C-34 | UndoTruncatedTypeNameSerializationBinder処理 | E-02 (L58-110) | ○ |
| C-35〜C-48 | TypeNameComparer.Equals/GetHashCode機能 | E-03 (L18-133) | ○ |
| C-49〜C-54 | BinaryFormattedObjectコンストラクタ・デシリアライズ | E-04 (L23-93) | ○ |
| C-55〜C-58 | BinaryFormattedObject.Optionsプロパティ | E-05 (L13-34) | ○ |
| C-59〜C-63 | DefaultTypeResolver型解決 | E-06 (L19-137) | ○ |
| C-64〜C-70 | Deserializerデシリアライズ処理 | E-07 (L52-397) | ○ |
| C-71〜C-79 | ArrayRecordDeserializer配列処理 | E-08 (L11-157) | ○ |
| C-80〜C-85 | ClassRecordDeserializer型処理 | E-09 (L16-98) | ○ |
| C-86〜C-92 | ObjectRecordDeserializer基本処理 | E-10 (L13-101) | ○ |
| C-93 | ValueUpdater.UpdateValue抽象メソッド | E-11 (L27) | △ |
| C-94〜C-97 | PendingSerializationInfo処理 | E-12 (L14-82) | ○ |
| C-98〜C-100 | SerializationEventsイベント取得 | E-13 (L12-114) | ○ |
| C-101〜C-102 | SerializationExtensions例外変換 | E-14 (L9-25) | ○ |
| C-103 | SerializationInfoExtensions.UpdateValue | E-15 (L10-24) | △ |
| C-104〜C-107 | BinaryWriterExtensions.Write7BitEncodedInt | E-16 (L8-20) | ○ |
| C-108〜C-110 | BinaryReaderExtensions.Read7BitEncodedInt | E-17 (L8-31) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SRE-093 (ValueUpdater.UpdateValue)**：抽象メソッドのため具体的な実装は派生クラス（ArrayUpdater、FieldValueUpdater、SerializationInfoValueUpdater）に依存。派生クラスのテストで網羅される。
  - 候補：ArrayUpdater.cs / FieldValueUpdater.cs / SerializationInfoValueUpdater.cs

- **UT-SRE-103 (SerializationInfoExtensions.UpdateValue)**：リフレクション経由でSerializationInfoの内部メソッドを呼び出しているため、.NETバージョン依存の可能性がある。
  - 候補：統合テストでの動作確認を推奨

- **一部の境界値テスト**：ストリーム長がint.MaxValueを超えるケース(UT-SRE-016)は環境依存で実行困難な可能性がある。
  - 候補：モック使用またはスキップ検討

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**：BinaryFormatter関連機能はObsolete警告があり、将来的に削除される可能性がある。テストの維持コストを考慮。
- **リスク0（低）**：TypeNameComparerのEquals/GetHashCodeは文字列比較のため、パフォーマンス影響は軽微。
- **リスク1（中）**：循環参照処理(UT-SRE-065)は複雑なグラフで予期しない動作の可能性がある。
- **リスク2（高）**：IObjectReference制約(UT-SRE-084)はセキュリティ関連の制約であり、厳密なテストが必要。

## 6) レビュアーチェックリスト（最小）
- [ ] PreserializedResourceWriterの各AddResourceメソッドで引数null検証が行われていることを確認
- [ ] DeserializingResourceReaderでSerializationFormat列挙値の全ケースが処理されていることを確認
- [ ] TypeNameComparerでmscorlib特別処理が正しく動作することを確認
- [ ] BinaryFormattedObjectのエラーハンドリングでSerializationExceptionにラップされることを確認
- [ ] Deserializerで循環参照検出時にSerializationExceptionがスローされることを確認
- [ ] ISerializable型とサロゲート型の両方のパスが正しくテストされていることを確認
- [ ] Read7BitEncodedInt/Write7BitEncodedIntの境界値（0, 127, 128, int.MaxValue, -1）がカバーされていることを確認
