---
generated_at: 2026-01-30 18:00:00
metrics:
  claims_total: 72
  claims_with_evidence: 70
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Resources.Writer.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：70 / 72、根拠なし：2
- 優先レビュー（高）
  1. **UT-RES-059～062（FindTypeCodeメソッド）**：privateメソッドのため直接テスト不可、統合テストで検証が必要
  2. **UT-RES-064～072（WriteValueメソッド）**：privateメソッドのため直接テスト不可、統合テストで検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Resources.Writer/src/System/Resources/ResourceWriter.core.cs`
- E-02: `src/libraries/System.Resources.Writer/src/System/Resources/IResourceWriter.cs`
- E-03: `src/libraries/System.Resources.Writer/src/System/Resources/__FastResourceComparer.cs`
- E-04: `src/libraries/System.Resources.Writer/ref/System.Resources.Writer.cs`
- E-05: `src/libraries/System.Resources.Writer/tests/ResourceWriterUnitTest.cs`
- E-06: `src/libraries/Common/src/System/Resources/ResourceWriter.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ResourceWriter(string)コンストラクタでファイルを作成 | E-04, E-06（L48-56） | ○ |
| C-02 | nullファイル名でArgumentNullException | E-06（L51） | ○ |
| C-03 | ResourceWriter(Stream)コンストラクタでStream指定 | E-04, E-06（L62-75） | ○ |
| C-04 | nullストリームでArgumentNullException | E-05（L25-31）, E-06（L65） | ○ |
| C-05 | 書き込み不可StreamでArgumentException | E-05（L34-45）, E-06（L67-70） | ○ |
| C-06 | AddResource(string, string)で文字列リソース追加 | E-04（L26）, E-06（L80-92） | ○ |
| C-07 | AddResource(string, string)でnull値許容 | E-04（L26）, E-06（L80-92） | ○ |
| C-08 | AddResource(string, string)でnullキー不可 | E-05（L47-56）, E-06（L82） | ○ |
| C-09 | 重複キーでArgumentException | E-05（L58-73）, E-06（L90-91） | ○ |
| C-10 | 大文字小文字重複でArgumentException | E-06（L90, L55, L41） | ○ |
| C-11 | Dispose後AddResourceでInvalidOperationException | E-05（L75-89）, E-06（L84-87） | ○ |
| C-12 | AddResource(string, object)でオブジェクト追加 | E-04（L25）, E-06（L97-117） | ○ |
| C-13 | AddResource(string, object)でnull値許容 | E-06（L97-117） | ○ |
| C-14 | Stream型オブジェクトはAddResourceInternalへ | E-06（L107-110） | ○ |
| C-15 | AddResource(string, object)でnullキー不可 | E-06（L99） | ○ |
| C-16 | AddResource(string, byte[])でバイト配列追加 | E-04（L22）, E-06（L160-172） | ○ |
| C-17 | AddResource(string, byte[])でnull値許容 | E-06（L160-172） | ○ |
| C-18 | 空のバイト配列も追加可能 | E-06（L160-172） | ○ |
| C-19 | AddResource(string, byte[])でnullキー不可 | E-06（L162） | ○ |
| C-20 | AddResource(string, Stream)でStream追加 | E-01（L25-33）, E-04（L23） | ○ |
| C-21 | AddResource(string, Stream)でnull値許容 | E-06（L139-144） | ○ |
| C-22 | シーク不可StreamでArgumentException | E-06（L148-149） | ○ |
| C-23 | AddResource(string, Stream)でnullキー不可 | E-01（L27） | ○ |
| C-24 | closeAfterWrite=trueでStream閉じられる | E-04（L24）, E-06（L608-611） | ○ |
| C-25 | closeAfterWrite=falseでStream開いたまま | E-06（L608条件分岐） | ○ |
| C-26 | AddResourceDataでシリアライズ済みデータ追加 | E-01（L35-42）, E-06（L174-184） | ○ |
| C-27 | AddResourceDataでnullキー不可 | E-01（L37） | ○ |
| C-28 | AddResourceDataでnull型名不可 | E-01（L38） | ○ |
| C-29 | AddResourceDataでnullデータ不可 | E-01（L39） | ○ |
| C-30 | Generateでリソースファイル生成 | E-04（L30）, E-06（L243-416） | ○ |
| C-31 | 空リソースで180バイトヘッダー出力 | E-05（L91-102） | ○ |
| C-32 | 複数型混在でも正しく生成 | E-05（L104-125）, E-06（L315-337） | ○ |
| C-33 | Dispose後GenerateでInvalidOperationException | E-06（L245-246） | ○ |
| C-34 | 2回目GenerateでInvalidOperationException | E-06（L415, L245-246） | ○ |
| C-35 | CloseでDisposeが呼ばれる | E-04（L28）, E-06（L213-216） | ○ |
| C-36 | Disposeで正常終了 | E-04（L29）, E-06（L233-236） | ○ |
| C-37 | 複数回Disposeが安全 | E-06（L222条件チェック） | ○ |
| C-38 | TypeNameConverterプロパティget/set | E-01（L20）, E-04（L21） | ○ |
| C-39 | TypeNameConverterにnull設定可能 | E-01（L20） | ○ |
| C-40 | FastResourceComparer.HashFunctionでハッシュ計算 | E-03（L25-34） | ○ |
| C-41 | 空文字列のハッシュ値は5381 | E-03（L30） | ○ |
| C-42 | 同じ文字列は同じハッシュ値 | E-03（L25-34） | ○ |
| C-43 | GetHashCodeはHashFunctionと同じ値 | E-03（L17-20） | ○ |
| C-44 | Compare同じ文字列で0 | E-03（L36-39） | ○ |
| C-45 | Compare a<bで負 | E-03（L36-39）string.CompareOrdinal | ○ |
| C-46 | Compare a>bで正 | E-03（L36-39）string.CompareOrdinal | ○ |
| C-47 | Compare null同士で0 | E-03（L36-39）string.CompareOrdinal仕様 | ○ |
| C-48 | Compare nullと文字列で負 | E-03（L36-39）string.CompareOrdinal仕様 | ○ |
| C-49 | Equals同じ文字列でtrue | E-03（L41-44） | ○ |
| C-50 | Equals異なる文字列でfalse | E-03（L41-44） | ○ |
| C-51 | Equals null同士でtrue | E-03（L41-44）string.Equals仕様 | ○ |
| C-52 | Equals nullと文字列でfalse | E-03（L41-44）string.Equals仕様 | ○ |
| C-53 | FastResourceComparer.Defaultでシングルトン | E-03（L15） | ○ |
| C-54 | IResourceWriter経由で文字列追加 | E-02, E-04 | ○ |
| C-55 | IResourceWriter経由でオブジェクト追加 | E-02, E-04 | ○ |
| C-56 | IResourceWriter経由でバイト配列追加 | E-02, E-04 | ○ |
| C-57 | IResourceWriter経由でClose | E-02, E-04 | ○ |
| C-58 | IResourceWriter経由でGenerate | E-02, E-04 | ○ |
| C-59 | FindTypeCodeで各プリミティブ型判定 | E-06（L420-495）**privateメソッド** | △ |
| C-60 | FindTypeCodeでnull判定 | E-06（L422-423）**privateメソッド** | △ |
| C-61 | FindTypeCodeでbyte[]判定 | E-06（L458-459） | ○ |
| C-62 | FindTypeCodeでStreamWrapper判定 | E-06（L460-461） | ○ |
| C-63 | FindTypeCodeで非サポート型でException | E-06（L484） | ○ |
| C-64 | WriteValueでnull書き込み | E-06（L503-504） | ○ |
| C-65 | WriteValueで文字列書き込み | E-06（L506-508） | ○ |
| C-66 | WriteValueで各プリミティブ型書き込み | E-06（L497-620） | ○ |
| C-67 | WriteValueでDateTime書き込み | E-06（L562-566） | ○ |
| C-68 | WriteValueでTimeSpan書き込み | E-06（L568-570） | ○ |
| C-69 | WriteValueでbyte[]書き込み | E-06（L573-579） | ○ |
| C-70 | WriteValueでMemoryStream書き込み | E-06（L583-592） | ○ |
| C-71 | WriteValueで通常Stream書き込み | E-06（L593-612） | ○ |
| C-72 | WriteValueでStream長さ超過でException | E-06（L587-588, L597-598） | ○ |

## 4) 不足情報（Unknown / Missing）
- FindTypeCode、WriteValueはprivateメソッドのため、直接の単体テストは不可
  - 候補：統合テストでカバー / Generateメソッド経由でテスト / InternalsVisibleToで公開

## 5) リスクフラグ（レビュー観点）
- リスク1（中）：privateメソッドのテストケース（UT-RES-059～072）は、publicメソッド経由の統合テストでカバーする必要がある
- リスク0（低）：既存テスト（ResourceWriterUnitTest.cs）との重複確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UT-RES-001～039：ResourceWriterクラスのpublicメソッドテストが網羅されているか
- [ ] UT-RES-040～053：FastResourceComparerのテストが適切か
- [ ] UT-RES-054～058：IResourceWriterインターフェーステストが必要か検討
- [ ] UT-RES-059～072：privateメソッドのテスト方針を決定（統合テスト or InternalsVisibleTo）
- [ ] 既存テスト（E-05）との重複・差分を確認
