---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 125
  claims_with_evidence: 123
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Runtime.Caching 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：123 / 125、根拠なし：2
- 優先レビュー（高）
  1. **UT-SRC-096 AbsoluteExpiration動作テスト**：タイミング依存のため実行環境で結果が異なる可能性
  2. **UT-SRC-097 SlidingExpiration動作テスト**：タイミング依存のため実行環境で結果が異なる可能性
  3. **UT-SRC-100 UpdateCallback動作テスト**：複雑な非同期処理のため実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCache.cs`
- E-02: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/ObjectCache.cs`
- E-03: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheItem.cs`
- E-04: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheItemPolicy.cs`
- E-05: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/ChangeMonitor.cs`
- E-06: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/HostFileChangeMonitor.cs`
- E-07: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCacheEntry.cs`
- E-08: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCacheStore.cs`
- E-09: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCacheEntryChangeMonitor.cs`
- E-10: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheEntryRemovedArguments.cs`
- E-11: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheEntryUpdateArguments.cs`
- E-12: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/FileChangeMonitor.cs`
- E-13: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheEntryChangeMonitor.cs`
- E-14: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheItemPriority.cs`
- E-15: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/CacheEntryRemovedReason.cs`
- E-16: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/DefaultCacheCapabilities.cs`
- E-17: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCacheKey.cs`
- E-18: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/MemoryCacheStatistics.cs`
- E-19: `src/libraries/System.Runtime.Caching/src/System/Runtime/Caching/Configuration/ConfigUtil.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryCacheコンストラクタがnullで例外をスローする | E-01 (line 324) | ○ |
| C-02 | MemoryCacheコンストラクタが空文字で例外をスローする | E-01 (line 326-329) | ○ |
| C-03 | MemoryCacheコンストラクタが'default'で例外をスローする | E-01 (line 330-333) | ○ |
| C-04 | Defaultプロパティがシングルトンインスタンスを返す | E-01 (line 262-275) | ○ |
| C-05 | Add操作が既存キーでfalseを返す | E-01 (line 553-557) | ○ |
| C-06 | AddOrGetExistingが新規追加時にnullを返す | E-01 (line 559-568) | ○ |
| C-07 | regionNameが指定された場合NotSupportedExceptionをスロー | E-01 (line 561-564) | ○ |
| C-08 | Getがnullキーで例外をスロー | E-01 (line 465) | ○ |
| C-09 | ValidatePolicyが両方の期限設定で例外をスロー | E-01 (line 229-234) | ○ |
| C-10 | ValidatePolicyが負のSlidingExpirationで例外をスロー | E-01 (line 235-238) | ○ |
| C-11 | ValidatePolicyが1年超のSlidingExpirationで例外をスロー | E-01 (line 235-238) | ○ |
| C-12 | ValidatePolicyが両方のコールバックで例外をスロー | E-01 (line 239-243) | ○ |
| C-13 | ValidatePolicyが無効なPriorityで例外をスロー | E-01 (line 244-247) | ○ |
| C-14 | DefaultCacheCapabilitiesが正しいフラグを持つ | E-01 (line 22-27), E-16 | ○ |
| C-15 | ObjectCache.Hostが一度しか設定できない | E-02 (line 31-37) | ○ |
| C-16 | InfiniteAbsoluteExpirationがDateTimeOffset.MaxValue | E-02 (line 20) | ○ |
| C-17 | NoSlidingExpirationがTimeSpan.Zero | E-02 (line 21) | ○ |
| C-18 | CacheItemコンストラクタの動作 | E-03 | ○ |
| C-19 | CacheItemPolicyのデフォルト値 | E-04 (line 49-54) | ○ |
| C-20 | ChangeMonitor.HasChangedの初期値がfalse | E-05 (line 174) | ○ |
| C-21 | ChangeMonitor.IsDisposedの初期値がfalse | E-05 (line 178) | ○ |
| C-22 | ChangeMonitor.Disposeが初期化前に例外をスロー | E-05 (line 207-212) | ○ |
| C-23 | NotifyOnChangedがnullで例外をスロー | E-05 (line 224) | ○ |
| C-24 | NotifyOnChangedが二度目の呼び出しで例外をスロー | E-05 (line 226-229) | ○ |
| C-25 | HostFileChangeMonitorがnullで例外をスロー | E-06 (line 162) | ○ |
| C-26 | HostFileChangeMonitorが空リストで例外をスロー | E-06 (line 164-167) | ○ |
| C-27 | HostFileChangeMonitorがnull/空パスで例外をスロー | E-06 (line 175-192) | ○ |
| C-28 | CacheEntryRemovedArgumentsがnullソースで例外をスロー | E-10 (line 29) | ○ |
| C-29 | CacheEntryRemovedArgumentsがnullキャッシュアイテムで例外をスロー | E-10 (line 30) | ○ |
| C-30 | CacheEntryUpdateArgumentsがnullソースで例外をスロー | E-11 (line 51) | ○ |
| C-31 | CacheEntryUpdateArgumentsがnullキーで例外をスロー | E-11 (line 52) | ○ |
| C-32 | ConfigUtil.GetIntValueの動作 | E-19 (line 21-52) | ○ |
| C-33 | ConfigUtil.GetIntValueFromTimeSpanの動作 | E-19 (line 54-77) | ○ |
| C-34 | ConfigUtil.GetBooleanValueの動作 | E-19 (line 79-95) | ○ |
| C-35 | MemoryCacheKeyのコンストラクタ動作 | E-17 | ○ |
| C-36 | enum CacheItemPriorityの値 | E-14 | ○ |
| C-37 | enum CacheEntryRemovedReasonの値 | E-15 | ○ |
| C-38 | enum DefaultCacheCapabilitiesの値 | E-16 | ○ |
| C-39 | MemoryCache.Trimの動作 | E-01 (line 516-532), E-08 (line 371-420) | ○ |
| C-40 | CreateCacheEntryChangeMonitorが空リストで例外をスロー | E-01 (line 419-422) | ○ |
| C-41 | CreateCacheEntryChangeMonitorがnullキーで例外をスロー | E-01 (line 424-429) | ○ |
| C-42 | タイミング依存のAbsoluteExpiration動作 | E-08 (line 289-301) | △ |
| C-43 | タイミング依存のSlidingExpiration動作 | E-07 (line 288-298), E-08 (line 131-162) | △ |

## 4) 不足情報（Unknown / Missing）
- **タイミング依存テスト（C-42, C-43）**：期限切れの正確なタイミングは実行環境のタイマー精度に依存
  - 候補：統合テスト環境での検証 / モック時刻の使用 / 既存テストコードの参照

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: タイミング依存テスト（UT-SRC-096, UT-SRC-097）は実行環境によって結果が異なる可能性がある
- **リスク0（低）**: その他のテストケースはソースコードから直接導出されており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] MemoryCacheの主要メソッド（Add, Get, Set, Remove）のテストケースが網羅されているか確認
- [ ] 異常系テスト（null入力、無効な引数）がすべてのパブリックメソッドに対して存在するか確認
- [ ] 有効期限関連のテスト（AbsoluteExpiration, SlidingExpiration）のタイミング設定が実行環境で安定するか確認
- [ ] コールバック関連のテスト（RemovedCallback, UpdateCallback）が正しいシナリオをカバーしているか確認
- [ ] ChangeMonitorの派生クラス（HostFileChangeMonitor, MemoryCacheEntryChangeMonitor）のテストケースが適切か確認
- [ ] Configuration関連のテスト（ConfigUtil）が境界値を適切にカバーしているか確認
- [ ] Priority.NotRemovableのTrim動作テストが正しいシナリオを想定しているか確認
