---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 35
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Runtime.CompilerServices.VisualC 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テスト・リファレンスファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：35 / 35、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Runtime.CompilerServices.VisualC/src/System/Runtime/CompilerServices/Attributes.cs` - 主要なソースコード
- E-02: `src/libraries/System.Runtime.CompilerServices.VisualC/ref/System.Runtime.CompilerServices.VisualC.cs` - リファレンス定義
- E-03: `src/libraries/System.Runtime.CompilerServices.VisualC/ref/System.Runtime.CompilerServices.VisualC.manual.cs` - 追加リファレンス定義（内部型）
- E-04: `src/libraries/System.Runtime.CompilerServices.VisualC/ref/System.Runtime.CompilerServices.VisualC.TypeForwards.cs` - 型フォワード定義
- E-05: `src/libraries/System.Runtime.CompilerServices.VisualC/tests/System/Runtime/CompilerServices/RequiredAttributeAttributeTests.cs` - 既存テスト
- E-06: `src/libraries/System.Runtime.CompilerServices.VisualC/tests/System/Runtime/CompilerServices/ScopelessEnumAttributeTests.cs` - 既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### RequiredAttributeAttribute関連（UT-VCC-001 - UT-VCC-008）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RequiredAttributeAttributeはnull型を引数に受け付ける | E-01 (Line 115-119), E-05 (Line 11-12) | ○ |
| C-02 | RequiredAttributeAttributeはType型を引数に受け付ける | E-01 (Line 117), E-05 (Line 13) | ○ |
| C-03 | RequiredAttributeAttributeはインターフェース型を引数に受け付ける | E-01 (Line 117) - Type型として受け取る | ○ |
| C-04 | RequiredAttributeAttributeはジェネリック型を引数に受け付ける | E-01 (Line 117) - Type型として受け取る | ○ |
| C-05 | RequiredContractプロパティはコンストラクタで設定した値を返す | E-01 (Line 117, 119) | ○ |
| C-06 | RequiredAttributeAttributeはClass/Struct/Enum/Interfaceに適用可能 | E-01 (Line 114) | ○ |
| C-07 | RequiredAttributeAttributeはAllowMultiple=true | E-01 (Line 114) | ○ |
| C-08 | RequiredAttributeAttributeはInherited=false | E-01 (Line 114) | ○ |

### HasCopySemanticsAttribute関連（UT-VCC-009 - UT-VCC-010）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | HasCopySemanticsAttributeはデフォルトコンストラクタを持つ | E-01 (Line 91-94), E-06 (Line 13) | ○ |
| C-10 | HasCopySemanticsAttributeはStructにのみ適用可能 | E-01 (Line 90) | ○ |

### ScopelessEnumAttribute関連（UT-VCC-011 - UT-VCC-012）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | ScopelessEnumAttributeはデフォルトコンストラクタを持つ | E-01 (Line 97-100), E-06 (Line 15) | ○ |
| C-12 | ScopelessEnumAttributeはEnumにのみ適用可能 | E-01 (Line 96) | ○ |

### NativeCppClassAttribute関連（UT-VCC-013 - UT-VCC-015）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | NativeCppClassAttributeはデフォルトコンストラクタを持つ | E-01 (Line 103-106), E-06 (Line 14) | ○ |
| C-14 | NativeCppClassAttributeはStructに適用可能 | E-01 (Line 102) | ○ |
| C-15 | NativeCppClassAttributeはInherited=true | E-01 (Line 102) | ○ |

### CppInlineNamespaceAttribute関連（UT-VCC-016 - UT-VCC-020）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | CppInlineNamespaceAttributeは名前空間名を引数に受け取る | E-01 (Line 109-112) | ○ |
| C-17 | CppInlineNamespaceAttributeは空文字列を許容する可能性がある | E-01 (Line 111) - バリデーションなし | ○ |
| C-18 | CppInlineNamespaceAttributeはnullを許容する可能性がある | E-01 (Line 111) - バリデーションなし | ○ |
| C-19 | CppInlineNamespaceAttributeはAssemblyにのみ適用可能 | E-01 (Line 108) | ○ |
| C-20 | CppInlineNamespaceAttributeはAllowMultiple=true | E-01 (Line 108) | ○ |

### 静的マーカークラス関連（UT-VCC-021 - UT-VCC-031）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | IsPinnedは静的クラスとして存在する | E-01 (Line 50-52) | ○ |
| C-22 | IsBoxedは静的クラスとして存在する | E-01 (Line 54-56) | ○ |
| C-23 | IsByValueは静的クラスとして存在する | E-01 (Line 58-60) | ○ |
| C-24 | IsCopyConstructedは静的クラスとして存在する | E-01 (Line 62-64) | ○ |
| C-25 | IsExplicitlyDereferencedは静的クラスとして存在する | E-01 (Line 66-68) | ○ |
| C-26 | IsImplicitlyDereferencedは静的クラスとして存在する | E-01 (Line 70-72) | ○ |
| C-27 | IsJitIntrinsicは静的クラスとして存在する | E-01 (Line 74-76) | ○ |
| C-28 | IsLongは静的クラスとして存在する | E-01 (Line 78-80) | ○ |
| C-29 | IsSignUnspecifiedByteは静的クラスとして存在する | E-01 (Line 82-84) | ○ |
| C-30 | IsUdtReturnは静的クラスとして存在する | E-01 (Line 86-88) | ○ |
| C-31 | CompilerMarshalOverrideは静的クラスとして存在する | E-01 (Line 148-150) | ○ |

### 型フォワード関連（UT-VCC-032 - UT-VCC-035）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | CallConvCdeclはTypeForwardされている | E-04 (Line 7) | ○ |
| C-33 | CallConvStdcallはTypeForwardされている | E-04 (Line 8) | ○ |
| C-34 | CallConvThiscallはTypeForwardされている | E-04 (Line 9) | ○ |
| C-35 | CallConvFastcallはTypeForwardされている | E-04 (Line 10) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースにソースコードまたは既存テストからの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：本モジュールはC++/CLI相互運用のためのマーカー型と属性を提供するシンプルなライブラリであり、複雑なロジックは存在しない
- 既存テストが限定的（3つの属性のコンストラクタテストのみ）であるため、AttributeUsageの検証テストは追加検討の価値あり

## 6) レビュアーチェックリスト（最小）
- [ ] RequiredAttributeAttributeのnull入力テスト（UT-VCC-001）が実際に期待通りに動作するか確認
- [ ] CppInlineNamespaceAttributeのnull/空文字列入力（UT-VCC-017, UT-VCC-018）の挙動を実機で確認
- [ ] 静的マーカークラスのテスト（UT-VCC-021 - UT-VCC-031）が有意義かどうか検討（型の存在確認のみ）
- [ ] 型フォワードテスト（UT-VCC-032 - UT-VCC-035）がランタイム環境に依存しないか確認
