---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Runtime.InteropServices.JavaScript 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-JSI-030 JSHost.GlobalThis**: ブラウザ環境依存のため実際の動作検証が必要
  2. **UT-JSI-031 JSHost.DotnetInstance**: ブラウザ環境依存のため実際の動作検証が必要
  3. **UT-JSI-068 JSFunctionBinding.BindJSFunction**: WebAssemblyプラットフォーム制約の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSObject.cs`
- E-02: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSObject.References.cs`
- E-03: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSHost.cs`
- E-04: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSException.cs`
- E-05: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSImportAttribute.cs`
- E-06: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSExportAttribute.cs`
- E-07: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSMarshalAsAttribute.cs`
- E-08: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSMarshalerArgument.cs`
- E-09: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSFunctionBinding.cs`
- E-10: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSMarshalerType.cs`
- E-11: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSType.cs`
- E-12: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/MarshalerType.cs`
- E-13: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSProxyContext.cs`
- E-14: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSHostImplementation.cs`
- E-15: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/CancelablePromise.cs`
- E-16: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSSynchronizationContext.cs`
- E-17: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSWebWorker.cs`
- E-18: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/JSAsyncTaskScheduler.cs`
- E-19: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/Marshaling/JSMarshalerArgument.Task.cs`
- E-20: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/Marshaling/JSMarshalerArgument.String.cs`
- E-21: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/Marshaling/JSMarshalerArgument.JSObject.cs`
- E-22: `src/libraries/System.Runtime.InteropServices.JavaScript/src/System/Runtime/InteropServices/JavaScript/Marshaling/JSMarshalerArgument.Exception.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSObject.HasPropertyはJavaScriptImports.HasPropertyを呼び出す | E-01 (line 27-31) | ○ |
| C-02 | JSObject.HasPropertyはAssertNotDisposedを呼び出す | E-01 (line 29) | ○ |
| C-03 | JSObject.GetTypeOfPropertyは"undefined"等を返却する | E-01 (line 36-43) | ○ |
| C-04 | JSObject.GetPropertyAsBooleanはbool値を返却する | E-01 (line 53-58) | ○ |
| C-05 | JSObject.GetPropertyAsInt32はint値を返却する | E-01 (line 68-73) | ○ |
| C-06 | JSObject.GetPropertyAsDoubleはdouble値を返却する | E-01 (line 83-88) | ○ |
| C-07 | JSObject.GetPropertyAsStringはstring/nullを返却する | E-01 (line 98-103) | ○ |
| C-08 | JSObject.GetPropertyAsJSObjectはJSObject/nullを返却する | E-01 (line 113-118) | ○ |
| C-09 | JSObject.GetPropertyAsByteArrayはbyte[]を返却する | E-01 (line 129-134) | ○ |
| C-10 | JSObject.SetProperty各オーバーロードが存在する | E-01 (line 141-207) | ○ |
| C-11 | JSObject.IsDisposedは_isDisposedを返却する | E-01 (line 19) | ○ |
| C-12 | JSObject.Disposeは_isDisposedをtrueにする | E-02 (line 58-64) | ○ |
| C-13 | JSObject.Equalsは同一JSHandleで等価判定する | E-02 (line 37) | ○ |
| C-14 | JSObject.GetHashCodeはJSHandleを返却する | E-02 (line 40) | ○ |
| C-15 | JSObject.ToStringはデバッグ用文字列を返却する | E-02 (line 43) | ○ |
| C-16 | JSObject.AssertNotDisposedはObjectDisposedExceptionをスローする | E-02 (line 48-56) | ○ |
| C-17 | JSHost.GlobalThisはJSObjectを返却する | E-03 (line 20-26) | ○ |
| C-18 | JSHost.DotnetInstanceはJSObjectを返却する | E-03 (line 31-37) | ○ |
| C-19 | JSHost.ImportAsyncはTask<JSObject>を返却する | E-03 (line 50-53) | ○ |
| C-20 | JSHost.ImportAsyncはCancellationTokenをサポートする | E-03 (line 50) | ○ |
| C-21 | JSException.ConstructorはMessageを設定する | E-04 (line 22-26) | ○ |
| C-22 | JSException.StackTraceはマネージドとJSを結合する | E-04 (line 35-84) | ○ |
| C-23 | JSException.StackTraceはjsExceptionがnullの場合base.StackTraceを返却する | E-04 (line 44-47) | ○ |
| C-24 | JSException.EqualsはjsExceptionで等価判定する | E-04 (line 88-91) | ○ |
| C-25 | JSException.GetHashCodeはjsExceptionを含むハッシュ値を返却する | E-04 (line 94-98) | ○ |
| C-26 | JSException.ToStringはMessageのみを返却する | E-04 (line 102-106) | ○ |
| C-27 | JSImportAttribute.Constructorは1引数と2引数がある | E-05 (line 45-64) | ○ |
| C-28 | JSImportAttribute.FunctionNameプロパティが存在する | E-05 (line 34) | ○ |
| C-29 | JSImportAttribute.ModuleNameプロパティが存在する | E-05 (line 39) | ○ |
| C-30 | JSExportAttribute.Constructorはパラメータなし | E-06 (line 25-27) | ○ |
| C-31 | JSMarshalAsAttribute<T>はジェネリック属性 | E-07 (line 22) | ○ |
| C-32 | JSMarshalerArgument.Initializeはslot.TypeをNoneに設定する | E-08 (line 83-93) | ○ |
| C-33 | JSMarshalerArgument.ToManagedContextプロパティが存在する | E-08 (line 108-133) | ○ |
| C-34 | JSMarshalerArgument.ToJSContextプロパティが存在する | E-08 (line 136-161) | ○ |
| C-35 | JSMarshalerArgument.AssertCurrentThreadContextが存在する | E-08 (line 165-182) | ○ |
| C-36 | JSFunctionBinding.BindJSFunctionはPlatformNotSupportedExceptionをスローする | E-09 (line 173-179) | ○ |
| C-37 | JSFunctionBinding.BindManagedFunctionはPlatformNotSupportedExceptionをスローする | E-09 (line 190-198) | ○ |
| C-38 | JSFunctionBinding.InvokeJSはJSImportを実行する | E-09 (line 157-160) | ○ |
| C-39 | JSFunctionBinding.ArgumentCountプロパティが存在する | E-09 (line 80-92) | ○ |
| C-40 | JSFunctionBinding.Versionプロパティが存在する | E-09 (line 94-106) | ○ |
| C-41 | JSMarshalerType.Voidは静的プロパティ | E-10 (line 33-36) | ○ |
| C-42 | JSMarshalerType.Discardは静的プロパティ | E-10 (line 42-45) | ○ |
| C-43 | JSMarshalerType.Booleanは静的プロパティ | E-10 (line 60-63) | ○ |
| C-44 | JSMarshalerType.Int32は静的プロパティ | E-10 (line 97-100) | ○ |
| C-45 | JSMarshalerType.Doubleは静的プロパティ | E-10 (line 124-127) | ○ |
| C-46 | JSMarshalerType.Stringは静的プロパティ | E-10 (line 169-172) | ○ |
| C-47 | JSMarshalerType.JSObjectは静的プロパティ | E-10 (line 151-154) | ○ |
| C-48 | JSMarshalerType.Exceptionは静的プロパティ | E-10 (line 178-181) | ○ |
| C-49 | JSMarshalerType.DateTimeは静的プロパティ | E-10 (line 187-190) | ○ |
| C-50 | JSMarshalerType.NullableはCheckNullableを呼び出す | E-10 (line 206-214) | ○ |
| C-51 | JSMarshalerType.CheckNullableは許可された型のみ受け入れる | E-10 (line 440-457) | ○ |
| C-52 | JSMarshalerType.Task()は静的メソッド | E-10 (line 225-228) | ○ |
| C-53 | JSMarshalerType.Task(result)は結果付きTask型を作成する | E-10 (line 235-243) | ○ |
| C-54 | JSMarshalerType.CheckTaskはTask/Action/Function/Arrayを拒否する | E-10 (line 482-497) | ○ |
| C-55 | JSMarshalerType.Arrayはelement型を受け取る | E-10 (line 250-258) | ○ |
| C-56 | JSMarshalerType.CheckArrayは許可された型のみ受け入れる | E-10 (line 459-470) | ○ |
| C-57 | JSMarshalerType.ArraySegmentはelement型を受け取る | E-10 (line 268-276) | ○ |
| C-58 | JSMarshalerType.Spanはelement型を受け取る | E-10 (line 284-292) | ○ |
| C-59 | JSMarshalerType.Action()は静的メソッド | E-10 (line 303-306) | ○ |
| C-60 | JSMarshalerType.Action(arg1)は引数付きAction型を作成する | E-10 (line 313-321) | ○ |
| C-61 | JSMarshalerType.Function(result)はFunc型を作成する | E-10 (line 367-375) | ○ |
| C-62 | JSMarshalerType.Function(arg1, result)は引数と結果付きFunc型を作成する | E-10 (line 383-393) | ○ |
| C-63 | JSType.Voidはsealed class | E-11 (line 18-21) | ○ |
| C-64 | JSType.Booleanはsealed class | E-11 (line 43-46) | ○ |
| C-65 | JSType.Array<T>はジェネリッククラス | E-11 (line 108-111) | ○ |
| C-66 | JSType.Promise<T>はジェネリッククラス | E-11 (line 117-120) | ○ |
| C-67 | JSType.Function<T1,T2,T3,T4>は4引数ジェネリック | E-11 (line 167-170) | ○ |
| C-68 | MarshalerType.Noneは0 | E-12 (line 10) | ○ |
| C-69 | MarshalerType.Voidは1 | E-12 (line 11) | ○ |
| C-70 | CancelablePromise.CancelPromiseは完了済みタスクで何もしない | E-15 (line 15-18) | ○ |
| C-71 | CancelablePromise.CancelPromiseは非PromiseでInvalidOperationExceptionをスローする | E-15 (line 20) | ○ |
| C-72 | JSProxyContext.IsJSVHandleは負の値でtrueを返却する | E-13 (line 269-272) | ○ |
| C-73 | JSProxyContext.IsGCVHandleは負の値でtrueを返却する | E-13 (line 275-278) | ○ |
| C-74 | JSProxyContext.AllocJSVHandleは連続した負の値を割り当てる | E-13 (line 280-296) | ○ |
| C-75 | JSProxyContext.FreeJSVHandleはFreeListに追加する | E-13 (line 298-306) | ○ |
| C-76 | JSProxyContext.GetJSOwnedObjectGCHandleはGCHandleを返却する | E-13 (line 315-335) | ○ |
| C-77 | JSProxyContext.CreatePromiseHolderはPromiseHolderを作成する | E-13 (line 337-345) | ○ |
| C-78 | JSProxyContext.GetPromiseHolderはGCHandleからPromiseHolderを取得する | E-13 (line 347-368) | ○ |
| C-79 | JSProxyContext.ReleasePromiseHolderはPromiseHolderを解放する | E-13 (line 370-408) | ○ |
| C-80 | JSProxyContext.CreateCSOwnedProxyはJSObjectプロキシを作成する | E-13 (line 455-471) | ○ |
| C-81 | JSProxyContext.ReleaseCSOwnedObjectはプロキシを解放する | E-13 (line 473-524) | ○ |
| C-82 | JSProxyContext.AssertIsInteropThreadは非インタロップスレッドで例外をスローする | E-13 (line 246-262) | ○ |
| C-83 | JSProxyContext.Disposeは全リソースを解放する | E-13 (line 530-598) | ○ |
| C-84 | JSHostImplementation.GetTaskResultDynamicはTask<T>の結果を取得する | E-14 (line 19-34) | ○ |
| C-85 | JSHostImplementation.GetTaskResultMethodInfoはMethodInfoを返却する | E-14 (line 49-65) | ○ |
| C-86 | JSHostImplementation.ThrowExceptionは例外をスローする | E-14 (line 70-79) | ○ |
| C-87 | JSHostImplementation.ImportAsyncはTask<JSObject>を返却する | E-14 (line 81-88) | ○ |
| C-88 | JSHostImplementation.CancellationHelperはキャンセルをサポートする | E-14 (line 93-106) | ○ |
| C-89 | JSHostImplementation.GetMethodSignatureはJSFunctionBindingを返却する | E-14 (line 109-184) | ○ |
| C-90 | JSHostImplementation.FreeMethodSignatureBufferはバッファを解放する | E-14 (line 186-191) | ○ |
| C-91 | JSHostImplementation.LoadLazyAssemblyはアセンブリをロードする | E-14 (line 194-200) | ○ |
| C-92 | JSHostImplementation.LoadSatelliteAssemblyはサテライトアセンブリをロードする | E-14 (line 203-206) | ○ |
| C-93 | JSHostImplementation.CallEntrypointはエントリポイントを実行する | E-14 (line 208-274) | ○ |
| C-94 | JSMarshalerArgument.ToManaged(out string)は文字列をマーシャリングする | E-20 (line 18-34) | ○ |
| C-95 | JSMarshalerArgument.ToJS(string)は文字列をJSにマーシャリングする | E-20 (line 44-69) | ○ |
| C-96 | JSMarshalerArgument.ToManaged(out JSObject)はJSObjectプロキシを作成する | E-21 (line 18-27) | ○ |
| C-97 | JSMarshalerArgument.ToJS(JSObject)はJSObjectをマーシャリングする | E-21 (line 37-64) | ○ |
| C-98 | JSMarshalerArgument.ToManaged(out Exception)は例外をマーシャリングする | E-22 (line 18-46) | ○ |
| C-99 | JSMarshalerArgument.ToJS(Exception)は例外をJSにマーシャリングする | E-22 (line 56-101) | ○ |
| C-100 | JSMarshalerArgument.ToManaged(out Task)はPromiseをTaskに変換する | E-19 (line 41-92) | ○ |
| C-101 | JSMarshalerArgument.ToJS(Task)はTaskをPromiseに変換する | E-19 (line 255-322) | ○ |
| C-102 | JSMarshalerArgument.ToJS<T>(Task<T>)は結果付きTaskを変換する | E-19 (line 331-402) | ○ |
| C-103 | JSMarshalerArgument.RejectPromiseは失敗Promiseを作成する | E-19 (line 444-477) | ○ |
| C-104 | JSMarshalerArgument.ResolveVoidPromiseは成功Promiseを作成する | E-19 (line 479-511) | ○ |
| C-105 | JSMarshalerArgument.ResolvePromiseは値付き成功Promiseを作成する | E-19 (line 513-546) | ○ |
| C-106 | JSHost.GlobalThisの実際の動作検証 | **根拠なし** | △ |
| C-107 | JSHost.DotnetInstanceの実際の動作検証 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **JSHost.GlobalThis/DotnetInstance**: ブラウザ環境でのみ動作するため、ソースコードからは完全な動作検証が困難
  - 候補：ブラウザベースの統合テスト / WebAssembly環境でのE2Eテスト / モック実装
- **スレッド関連テスト (FEATURE_WASM_MANAGED_THREADS)**: 条件付きコンパイルのため、マルチスレッド対応コードの一部は動作検証が限定的
  - 候補：マルチスレッドビルドでの追加テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケース（148件）はソースコードに明確な根拠がある
- **1: 中リスク** - JSHost.GlobalThis/DotnetInstance（2件）はブラウザ環境依存のため追加検証推奨
- **0: 低リスク** - MarshalerType列挙値のテストは定義が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-JSI-001〜029のJSObject関連）の網羅性確認
- [ ] マーシャリング関連テスト（UT-JSI-046〜067）の境界値テスト十分性確認
- [ ] JSFunctionBindingのバインディングテスト（UT-JSI-068〜075）のプラットフォーム制約確認
- [ ] JSProxyContext関連テスト（UT-JSI-106〜127）のスレッドセーフティ検証
- [ ] JSHostImplementation関連テスト（UT-JSI-128〜148）のエントリポイント処理確認
- [ ] ブラウザ環境依存テスト（JSHost.GlobalThis/DotnetInstance）の追加検証計画確認
