---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Runtime.InteropServices 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードのロジックと矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-IOP-010（HandleCollector.Add オーバーフロー）**：実際のオーバーフローテストは実行困難
  2. **UT-IOP-085/087（ComAwareEventInfo COMオブジェクト）**：Windows固有機能のためプラットフォーム依存

## 2) 参照した情報（Evidence一覧）
> ソースコードファイルからテストケースを導出

- E-01: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/HandleCollector.cs`
- E-02: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/ComObject.cs`
- E-03: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/StrategyBasedComWrappers.cs`
- E-04: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/ComInterfaceMarshaller.cs`
- E-05: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/UniqueComInterfaceMarshaller.cs`
- E-06: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/ComVariantMarshaller.cs`
- E-07: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/ExceptionAsHResultMarshaller.cs`
- E-08: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/FreeThreadedStrategy.cs`
- E-09: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/Marshalling/DefaultCaching.cs`
- E-10: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/RuntimeEnvironment.cs`
- E-11: `src/libraries/System.Runtime.InteropServices/src/System/Runtime/InteropServices/ComAwareEventInfo.cs`
- E-12: `src/libraries/System.Runtime.InteropServices/src/System/Security/SecureStringMarshal.cs`
- E-13: `src/libraries/System.Runtime.InteropServices/gen/Microsoft.Interop.SourceGeneration/MarshallerShape.cs`
- E-14: `src/libraries/System.Runtime.InteropServices/gen/Microsoft.Interop.SourceGeneration/TypePositionInfo.cs`
- E-15: `src/libraries/System.Runtime.InteropServices/gen/Microsoft.Interop.SourceGeneration/Marshalling/MarshallerHelpers.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### HandleCollector クラス (UT-IOP-001 - UT-IOP-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HandleCollector(string?, int)が正しく初期化 | E-01 L18-21 | ○ |
| C-02 | nullの名前が空文字列に変換 | E-01 L38 | ○ |
| C-03 | initialThreshold<0でArgumentOutOfRangeException | E-01 L25-28 | ○ |
| C-04 | フルコンストラクタが正しく初期化 | E-01 L23-44 | ○ |
| C-05 | maximumThreshold<0でArgumentOutOfRangeException | E-01 L29-32 | ○ |
| C-06 | initialThreshold>maximumThresholdでArgumentException | E-01 L33-36 | ○ |
| C-07 | Add()でCountが増加 | E-01 L54-57 | ○ |
| C-08 | 複数Add()でCount増加 | E-01 L54-57 | ○ |
| C-09 | 閾値超過でGCトリガー | E-01 L63-82 | ○ |
| C-10 | オーバーフローでInvalidOperationException | E-01 L58-61 | ○ |
| C-11 | Remove()でCount減少 | E-01 L91-93 | ○ |
| C-12 | 複数Remove()でCount減少 | E-01 L91-93 | ○ |
| C-13 | アンダーフローでInvalidOperationException | E-01 L94-97 | ○ |
| C-14 | Countプロパティが正しい値を返す | E-01 L46 | ○ |

### ComObject クラス (UT-IOP-015 - UT-IOP-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | UniqueInstanceでFinalRelease解放 | E-02 L84-92 | ○ |
| C-16 | 非UniqueInstanceでFinalRelease無効 | E-02 L86 | ○ |
| C-17 | FinalRelease冪等性 | E-02 L86 Interlocked.Exchange | ○ |
| C-18 | IsInterfaceImplemented true返却 | E-02 L105-116 | ○ |
| C-19 | IsInterfaceImplemented false返却 | E-02 L107-115 | ○ |
| C-20 | throwIfNotImplemented例外 | E-02 L109-111 | ○ |
| C-21 | GetInterfaceImplementation実装取得 | E-02 L95-102 | ○ |
| C-22 | GetVirtualMethodTableInfoForKey VTable取得 | E-02 L153-161 | ○ |

### StrategyBasedComWrappers クラス (UT-IOP-023 - UT-IOP-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | CreateDefaultCacheStrategy DefaultCaching返却 | E-03 L45 | ○ |
| C-24 | GetOrCreateInterfaceDetailsStrategy戦略取得 | E-03 L51-67 | ○ |
| C-25 | GetOrCreateIUnknownStrategy FreeThreaded返却 | E-03 L73 | ○ |
| C-26 | CreateObject ComObject作成 | E-03 L93-107 | ○ |
| C-27 | UniqueInstanceフラグ反映 | E-03 L103 | ○ |
| C-28 | TrackerObjectでNotSupportedException | E-03 L95-98 | ○ |
| C-29 | AggregationでNotSupportedException | E-03 L95-98 | ○ |
| C-30 | ReleaseObjectsでNotImplementedException | E-03 L116-119 | ○ |

### ComInterfaceMarshaller<T> クラス (UT-IOP-031 - UT-IOP-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ConvertToUnmanaged null処理 | E-04 L31-36 | ○ |
| C-32 | ConvertToUnmanaged有効変換 | E-04 L31-42 | ○ |
| C-33 | ConvertToManaged null処理 | E-04 L51-56 | ○ |
| C-34 | ConvertToManaged有効変換 | E-04 L51-58 | ○ |
| C-35 | Free null処理 | E-04 L64-70 | ○ |
| C-36 | Free Release呼び出し | E-04 L64-70 | ○ |

### UniqueComInterfaceMarshaller<T> クラス (UT-IOP-037 - UT-IOP-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | ConvertToUnmanaged null処理 | E-05 L30-35 | ○ |
| C-38 | ConvertToManaged UniqueInstance | E-05 L52-59 | ○ |

### ComVariantMarshaller クラス (UT-IOP-039 - UT-IOP-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | ConvertToUnmanaged null処理 | E-06 L32-37 | ○ |
| C-40-51 | 各プリミティブ型変換 | E-06 L40-78 | ○ |
| C-52 | 未サポート型でArgumentException | E-06 L86 | ○ |
| C-53-58 | ConvertToManaged各種変換 | E-06 L119-209 | ○ |
| C-59 | Freeでリソース解放 | E-06 L215 | ○ |
| C-60-64 | RefPropagate各メソッド | E-06 L221-348 | ○ |

### ExceptionAsHResultMarshaller<T> クラス (UT-IOP-065 - UT-IOP-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | HResult変換 | E-07 L29-38 | ○ |
| C-66 | 型変換 | E-07 L38 T.CreateTruncating | ○ |

### FreeThreadedStrategy クラス (UT-IOP-067 - UT-IOP-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | CreateInstancePointer AddRef | E-08 L13-17 | ○ |
| C-68 | QueryInterface成功 | E-08 L19-31 | ○ |
| C-69 | QueryInterface失敗 | E-08 L19-31 | ○ |
| C-70 | Release呼び出し | E-08 L33-34 | ○ |

### DefaultCaching クラス (UT-IOP-071 - UT-IOP-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71-76 | キャッシュ操作各種 | E-09 L10-46 | ○ |

### RuntimeEnvironment クラス (UT-IOP-077 - UT-IOP-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | GetRuntimeDirectory | E-10 L17-29 | ○ |
| C-78 | GetSystemVersion | E-10 L37 | ○ |
| C-79 | FromGlobalAccessCache false | E-10 L15 | ○ |
| C-80-82 | 非サポートメソッド例外 | E-10 L12-35 | ○ |

### ComAwareEventInfo クラス (UT-IOP-083 - UT-IOP-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コンストラクタ | E-11 L22-25 | ○ |
| C-84 | AddEventHandler非COM | E-11 L38-42 | ○ |
| C-85 | AddEventHandler COM | E-11 L32-37 | △ |
| C-86 | RemoveEventHandler非COM | E-11 L55-61 | ○ |
| C-87 | RemoveEventHandler COM | E-11 L50-55 | △ |
| C-88-90 | プロパティ委譲 | E-11 L64-99 | ○ |

### SecureStringMarshal クラス (UT-IOP-091 - UT-IOP-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91-94 | Marshal委譲メソッド | E-12 L8-14 | ○ |

### ソースジェネレーターヘルパークラス (UT-IOP-095 - UT-IOP-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95-102 | MarshallerShape関連 | E-13 全体 | ○ |
| C-103-109 | TypePositionInfo関連 | E-14 全体 | ○ |
| C-110-140 | MarshallerHelpers関連 | E-15 全体 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-IOP-085/087（COMオブジェクトへのイベントハンドラ追加/削除）**
  - Windows専用機能のため、実際のCOM相互運用テストはプラットフォーム固有
  - テスト実行にはWindows環境とCOMオブジェクトが必要
  - 候補：モック化 / 条件付きテスト / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**:
  - GCトリガー関連のテスト（UT-IOP-009）は動作確認が困難
  - オーバーフローテスト（UT-IOP-010）は実行に長時間を要する可能性
- **2（高リスク）**:
  - COM相互運用テスト（UT-IOP-085, 087）はWindows固有

## 6) レビュアーチェックリスト（最小）
- [ ] HandleCollectorのスレッドセーフティテストが十分か確認
- [ ] ComObjectのファイナライザ動作テストの実行可能性確認
- [ ] ComVariantMarshallerの全VarType変換カバレッジ確認
- [ ] ソースジェネレーターヘルパーのRoslynコンパイル環境での動作確認
- [ ] プラットフォーム固有テスト（Windows/Linux/macOS）の分離確認
- [ ] COMイベント関連テストのモック戦略検討
