---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 118
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：libraries-System.Runtime.Intrinsics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 118 / 125 = 0.94
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：118 / 125、根拠なし：7
- 優先レビュー（高）
  1. **UT-SRI-113～115 (IsHardwareAccelerated)**: 実行環境依存の動作であり、期待結果の確定が困難
  2. **VectorMathクラスの三角関数**: 内部実装の詳細なアルゴリズム検証が必要
  3. **飽和演算のエッジケース**: 型ごとの境界値動作の詳細検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector64.cs`
- E-02: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector64_1.cs`
- E-03: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector128.cs`
- E-04: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector128_1.cs`
- E-05: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector256.cs`
- E-06: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector256_1.cs`
- E-07: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector512.cs`
- E-08: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Vector512_1.cs`
- E-09: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Scalar.cs`
- E-10: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/ISimdVector_2.cs`
- E-11: `src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/VectorMath.cs`
- E-12: `src/libraries/System.Runtime.Intrinsics/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Vector64<T>.IsSupported で byte/double/short/int/long/nint/sbyte/float/ushort/uint/ulong/nuint がサポート | E-02 (IsSupported プロパティ, 行84-96) | ○ |
| C-02 | Vector64<T>.Count が Size/sizeof(T) で計算される | E-02 (Count プロパティ, 行46-54) | ○ |
| C-03 | Vector64.Size が 8 バイト | E-01 (Size 定数, 行14) | ○ |
| C-04 | Vector128.Size が 16 バイト | E-03 (Size 定数, 行35) | ○ |
| C-05 | Vector256.Size が 32 バイト | E-05 (Size 定数, 行33) | ○ |
| C-06 | Vector512.Size が 64 バイト | E-07 (Size 定数, 行32) | ○ |
| C-07 | Zero プロパティが default 値を返す | E-02 (Zero プロパティ, 行109-117) | ○ |
| C-08 | One プロパティが Scalar<T>.One を使用して作成される | E-02 (One プロパティ, 行99-105) | ○ |
| C-09 | AllBitsSet が Scalar<T>.AllBitsSet を使用して作成される | E-02 (AllBitsSet プロパティ, 行38-42) | ○ |
| C-10 | インデクサが GetElement を呼び出す | E-02 (this[int] プロパティ, 行126) | ○ |
| C-11 | 演算子 + が要素ごとの加算を実行 | E-02 (operator +, 行135-146) | ○ |
| C-12 | 演算子 & がビットANDを実行 | E-02 (operator &, 行155-163) | ○ |
| C-13 | 演算子 \| がビットORを実行 | E-02 (operator \|, 行170-180) | ○ |
| C-14 | Abs が符号なし型でそのまま返す | E-01 (Abs メソッド, 行112-134) | ○ |
| C-15 | Abs が符号付き型で絶対値を計算 | E-09 (Scalar<T>.Abs, 行138-200) | ○ |
| C-16 | AddSaturate が float/double で通常加算を使用 | E-01 (AddSaturate, 行143-161) | ○ |
| C-17 | All が vector == Create(value) で判定 | E-01 (All, 行171) | ○ |
| C-18 | Create(T value) が全要素を同一値で初期化 | E-10 (ISimdVector.Create, 行227) | ○ |
| C-19 | Create(ReadOnlySpan<T>) が LoadUnsafe を使用 | E-10 (Create, 行251-258) | ○ |
| C-20 | Scalar<T>.AllBitsSet が型ごとに正しい値を返す | E-09 (AllBitsSet プロパティ, 行16-75) | ○ |
| C-21 | Scalar<T> が非サポート型で NotSupportedException をスロー | E-09 (ThrowHelper.ThrowNotSupportedException, 行71-72) | ○ |
| C-22 | Vector128 が Vector64 の lower/upper で構成される | E-04 (_lower/_upper フィールド, 行34-35) | ○ |
| C-23 | Vector256 が Vector128 の lower/upper で構成される | E-06 (ソース構造から推定) | ○ |
| C-24 | Vector512 が Vector256 の lower/upper で構成される | E-08 (ソース構造から推定) | ○ |
| C-25 | ConditionalSelect が (left & condition) \| (right & ~condition) で実装 | E-10 (ConditionalSelect, 行170) | ○ |
| C-26 | Min/Max が要素ごとの比較を実行 | E-10 (Min/Max インターフェース定義) | ○ |
| C-27 | Sum が全要素の合計を返す | E-10 (Sum インターフェース定義, 行767) | ○ |
| C-28 | Dot が内積を計算する | E-10 (Dot インターフェース定義, 行297) | ○ |
| C-29 | Floor/Ceiling/Truncate/Round が浮動小数点演算を実行 | E-10 (インターフェース定義) | ○ |
| C-30 | LoadUnsafe/StoreUnsafe がメモリ操作を実行 | E-10 (インターフェース定義, 行551-558, 744-754) | ○ |
| C-31 | WithElement が指定インデックスの要素を変更 | E-10 (WithElement, 行803) | ○ |
| C-32 | GetElement が指定インデックスの要素を取得 | E-10 (GetElement, 行331) | ○ |
| C-33 | IsNaN/IsInfinity/IsFinite が浮動小数点の状態を検出 | E-10 (インターフェース定義, 行417-464) | ○ |
| C-34 | IsNegative/IsPositive/IsZero が符号/ゼロを検出 | E-10 (インターフェース定義, 行424-464) | ○ |
| C-35 | Clamp が値を min-max 範囲に制限 | E-10 (Clamp, 行153-154) | ○ |
| C-36 | Negate が符号を反転 | E-10 (Negate, 行667) | ○ |
| C-37 | Shuffle が要素を並べ替える | E-10 (インターフェース構造から推定) | △ |
| C-38 | CopyTo が配列にコピーする | E-10 (CopyTo, 行184-208) | ○ |
| C-39 | ToScalar が先頭要素を返す | E-10 (ToScalar, 行773) | ○ |
| C-40 | IsHardwareAccelerated がハードウェア状態を返す | E-01～E-07 (各クラスのプロパティ) | △ |

## 4) 不足情報（Unknown / Missing）
- **Shuffleメソッドの詳細仕様**: ISimdVectorインターフェースには直接定義がなく、各Vector実装クラスでの具体的な実装を確認する必要がある
- **IsHardwareAcceleratedの実行時動作**: JIT intrinsicによる動作であり、実行環境依存のため事前に期待値を確定できない
- **VectorMathの三角関数実装**: CosDouble/SinDouble等の内部アルゴリズムの精度検証には追加の数学的検証が必要
- **プラットフォーム固有の動作**: Arm/Wasm/X86固有のintrinsicsの動作確認には対応プラットフォームでのテストが必要
  - 候補：src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Arm/
  - 候補：src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/Wasm/
  - 候補：src/libraries/System.Private.CoreLib/src/System/Runtime/Intrinsics/X86/

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Vector64/128/256/512の基本プロパティ（Size, Count, Zero, One, AllBitsSet）
- **0 (低リスク)**: 算術演算子（+, -, *, /）および論理演算子（&, |, ^, ~）
- **1 (中リスク)**: 飽和演算（AddSaturate, SubtractSaturate）のエッジケース
- **1 (中リスク)**: 浮動小数点特殊値の処理（NaN, Infinity, NegativeZero）
- **2 (高リスク)**: IsHardwareAccelerated の期待値検証（実行環境依存）
- **1 (中リスク)**: Scalar<T>の非サポート型に対する例外処理

## 6) レビュアーチェックリスト（最小）
- [ ] Vector64/128/256/512のSize定数値がソースコードと一致することを確認
- [ ] IsSupported でサポートされる型一覧がソースコードと一致することを確認
- [ ] 算術演算子のテストケースで正の値、負の値、ゼロの組み合わせが網羅されていることを確認
- [ ] 境界値テスト（インデックス範囲外、飽和演算のオーバーフロー）が含まれていることを確認
- [ ] 浮動小数点型に特有のテスト（NaN, Infinity, NegativeZero）が含まれていることを確認
- [ ] Scalar<T>.AllBitsSet の各型の期待値がソースコードの実装と一致することを確認
- [ ] 非サポート型に対する例外スロー動作のテストケースが含まれていることを確認
