---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 96
  claims_with_evidence: 96
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Runtime.Loader 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：96 / 96、根拠なし：0
- 優先レビュー（高）
  1. なし：全テストケースにソースコードによる根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Loader/ref/System.Runtime.Loader.cs` - 公開API定義（リファレンスアセンブリ）
- E-02: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/AssemblyLoadContext.cs` - AssemblyLoadContext実装
- E-03: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/AssemblyDependencyResolver.cs` - AssemblyDependencyResolver実装
- E-04: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/AssemblyDependencyResolver.PlatformNotSupported.cs` - プラットフォーム非対応版実装
- E-05: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/LibraryNameVariation.cs` - LibraryNameVariation基本定義
- E-06: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/LibraryNameVariation.Unix.cs` - Unix版実装
- E-07: `src/libraries/System.Private.CoreLib/src/System/Runtime/Loader/LibraryNameVariation.Windows.cs` - Windows版実装
- E-08: `src/coreclr/System.Private.CoreLib/src/System/Reflection/Metadata/MetadataUpdater.cs` - MetadataUpdater実装（CoreCLR）
- E-09: `src/coreclr/System.Private.CoreLib/src/System/Reflection/Metadata/AssemblyExtensions.cs` - AssemblyExtensions実装
- E-10: `src/libraries/System.Private.CoreLib/src/System/Reflection/Metadata/MetadataUpdateHandlerAttribute.cs` - MetadataUpdateHandlerAttribute実装
- E-11: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/CreateNewOnMetadataUpdateAttribute.cs` - CreateNewOnMetadataUpdateAttribute実装
- E-12: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/MetadataUpdateDeletedAttribute.cs` - MetadataUpdateDeletedAttribute実装
- E-13: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/MetadataUpdateOriginalTypeAttribute.cs` - MetadataUpdateOriginalTypeAttribute実装

## 3) Claims と根拠の対応（レビューの主戦場）

### AssemblyLoadContext クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでnon-collectibleなALCが生成される | E-02 (L70-72) | ○ |
| C-02 | isCollectible=trueでcollectibleなALCが生成される | E-02 (L74-75) | ○ |
| C-03 | isCollectible=falseでGC.SuppressFinalizeが呼ばれる | E-02 (L93-98) | ○ |
| C-04 | 名前付きALCが生成できる | E-02 (L78-79), E-01 (L63) | ○ |
| C-05 | name=nullでALCが生成できる | E-02 (L78-79) | ○ |
| C-06 | DefaultプロパティでDefaultAssemblyLoadContextが返却される | E-02 (L264), E-02 (L808-815) | ○ |
| C-07 | Allプロパティで全ALCが列挙される（WeakReference管理） | E-02 (L272-301) | ○ |
| C-08 | GCで収集されたALCはAllに含まれない | E-02 (L293-298) | ○ |
| C-09 | AssembliesプロパティでロードされたアセンブリがIEnumerableで返却される | E-02 (L167-181) | ○ |
| C-10 | アセンブリ未ロード時は空のIEnumerableが返却される | E-02 (L167-181) | ○ |
| C-11 | IsCollectibleプロパティが正しく返却される | E-02 (L266), E-02 (L68) | ○ |
| C-12 | Nameプロパティが正しく返却される | E-02 (L268), E-02 (L60) | ○ |
| C-13 | ToStringが適切なフォーマットで返却される | E-02 (L270) | ○ |
| C-14 | GetAssemblyNameがAssemblyNameを返却する | E-02 (L304-309) | ○ |
| C-15 | GetAssemblyNameでnullはArgumentNullException | E-02 (L306) | ○ |
| C-16 | GetAssemblyNameで存在しないパスはFileNotFoundException | E-02 (L308) | ○ |
| C-17 | GetLoadContextがAssemblyLoadContextを返却する | E-01 (L77), E-02 | ○ |
| C-18 | GetLoadContextで動的アセンブリはnull | E-02 | ○ |
| C-19 | Loadメソッドがオーバーライド可能 | E-02 (L314-317), E-01 (L78) | ○ |
| C-20 | Loadのデフォルト実装はnullを返却 | E-02 (L316) | ○ |
| C-21 | LoadFromAssemblyNameがアセンブリをロードする | E-02 (L321-328), E-01 (L79) | ○ |
| C-22 | LoadFromAssemblyNameでnullはArgumentNullException | E-02 (L323) | ○ |
| C-23 | LoadFromAssemblyPathがアセンブリをロードする | E-02 (L334-349), E-01 (L80-81) | ○ |
| C-24 | LoadFromAssemblyPathでnullはArgumentNullException | E-02 (L336) | ○ |
| C-25 | LoadFromAssemblyPathで相対パスはArgumentException | E-02 (L338-341) | ○ |
| C-26 | LoadFromAssemblyPathでアンロード中はInvalidOperationException | E-02 (L343-345) | ○ |
| C-27 | LoadFromNativeImagePathがアセンブリをロードする | E-02 (L352-372), E-01 (L82-83) | ○ |
| C-28 | LoadFromNativeImagePathでnullはArgumentNullException | E-02 (L354) | ○ |
| C-29 | LoadFromNativeImagePathで相対パスはArgumentException | E-02 (L356-364) | ○ |
| C-30 | LoadFromStreamがストリームからアセンブリをロードする | E-02 (L375-434), E-01 (L84-87) | ○ |
| C-31 | LoadFromStreamでシンボルストリーム付きでロードできる | E-02 (L381-403) | ○ |
| C-32 | LoadFromStreamでnullはArgumentNullException | E-02 (L383) | ○ |
| C-33 | LoadFromStreamで空ストリームはBadImageFormatException | E-02 (L386-389) | ○ |
| C-34 | LoadFromStreamでアンロード中はInvalidOperationException | E-02 (L398-400) | ○ |
| C-35 | LoadUnmanagedDllがオーバーライド可能 | E-02 (L453-457), E-01 (L88) | ○ |
| C-36 | LoadUnmanagedDllのデフォルト実装はIntPtr.Zero | E-02 (L456) | ○ |
| C-37 | LoadUnmanagedDllFromPathがネイティブDLLをロードする | E-02 (L438-448), E-01 (L89) | ○ |
| C-38 | LoadUnmanagedDllFromPathで空文字はArgumentException | E-02 (L440) | ○ |
| C-39 | LoadUnmanagedDllFromPathで相対パスはArgumentException | E-02 (L442-445) | ○ |
| C-40 | Unloadでcollectible ALCがアンロードされる | E-02 (L459-468), E-01 (L93) | ○ |
| C-41 | Unloadでnon-collectibleはInvalidOperationException | E-02 (L461-464) | ○ |
| C-42 | UnloadでUnloadingイベントが発火する | E-02 (L128-132), E-02 (L136) | ○ |
| C-43 | Resolvingイベントが発火する | E-02 (L210-223), E-01 (L70) | ○ |
| C-44 | Resolvingで最初のnull以外が採用される | E-02 (L616-640) | ○ |
| C-45 | ResolvingUnmanagedDllイベントが発火する | E-02 (L189-202), E-01 (L71) | ○ |
| C-46 | ResolvingUnmanagedDllで最初のIntPtr.Zero以外が採用される | E-02 (L792-805) | ○ |
| C-47 | Unloadingイベントにハンドラを追加・削除できる | E-02 (L225-235), E-01 (L72) | ○ |
| C-48 | CurrentContextualReflectionContextがコンテキスト外でnull | E-02 (L525) | ○ |
| C-49 | EnterContextualReflection()でコンテキストに入る | E-02 (L545-548), E-01 (L73) | ○ |
| C-50 | EnterContextualReflection(Assembly)で静的にコンテキストに入る | E-02 (L560-569), E-01 (L74) | ○ |
| C-51 | EnterContextualReflection(null)でnullコンテキストに入る | E-02 (L562-563) | ○ |
| C-52 | EnterContextualReflectionで非RuntimeAssemblyはArgumentException | E-02 (L565-566) | ○ |
| C-53 | ContextualReflectionScope.Disposeで元のコンテキストに戻る | E-02 (L593-601) | ○ |
| C-54 | ContextualReflectionScope.Disposeは複数回呼んでも安全 | E-02 (L594-600) | ○ |
| C-55 | SetProfileOptimizationRootが設定できる | E-01 (L90) | ○ |
| C-56 | StartProfileOptimizationが開始できる | E-01 (L91) | ○ |
| C-57 | StartProfileOptimization(null)で無効化できる | E-01 (L91) | ○ |

### AssemblyDependencyResolver クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタでリゾルバが作成される | E-03 (L34-108), E-01 (L55) | ○ |
| C-59 | コンストラクタでnullはArgumentNullException | E-03 (L36) | ○ |
| C-60 | hostpolicyが見つからない場合InvalidOperationException | E-03 (L73-76, L78-80) | ○ |
| C-61 | 依存関係解決失敗でInvalidOperationException | E-03 (L82-90) | ○ |
| C-62 | ResolveAssemblyToPathがパスを解決する | E-03 (L110-156), E-01 (L56) | ○ |
| C-63 | ResolveAssemblyToPathで解決できない場合null | E-03 (L155) | ○ |
| C-64 | ResolveAssemblyToPathでnullはArgumentNullException | E-03 (L112) | ○ |
| C-65 | ResolveAssemblyToPathでサテライトアセンブリが解決できる | E-03 (L120-139) | ○ |
| C-66 | neutral文化はコードアセンブリとして扱われる | E-03 (L120-121) | ○ |
| C-67 | ファイルが存在しない場合null | E-03 (L147-151) | ○ |
| C-68 | ResolveUnmanagedDllToPathがパスを解決する | E-03 (L158-190), E-01 (L57) | ○ |
| C-69 | ResolveUnmanagedDllToPathで解決できない場合null | E-03 (L189) | ○ |
| C-70 | ResolveUnmanagedDllToPathでnullはArgumentNullException | E-03 (L160) | ○ |
| C-71 | パス区切りを含む名前はコンポーネントディレクトリから検索 | E-03 (L163-168) | ○ |
| C-72 | LibraryNameVariationでプラットフォーム固有バリエーション検索 | E-03 (L176-187), E-05, E-06, E-07 | ○ |

### MetadataUpdater クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | IsSupportedプロパティが取得できる | E-08 (L63-64), E-01 (L23-24) | ○ |
| C-74 | ApplyUpdateでメタデータ更新が適用できる | E-08 (L37-53), E-01 (L25) | ○ |
| C-75 | ApplyUpdateでnullはArgumentNullException | E-08 (L41) | ○ |
| C-76 | ApplyUpdateでRuntimeAssembly以外はArgumentException | E-08 (L39-42) | ○ |
| C-77 | 編集不可アセンブリでInvalidOperationException | E-08 (L35) | ○ |
| C-78 | サポートされていない変更でNotSupportedException | E-08 (L36) | ○ |

### AssemblyExtensions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | TryGetRawMetadataでメタデータが取得できる | E-09 (L31-47), E-01 (L11-12) | ○ |
| C-80 | TryGetRawMetadataで非RuntimeAssemblyはfalse | E-09 (L38-42) | ○ |
| C-81 | TryGetRawMetadataでnullはArgumentNullException | E-09 (L33) | ○ |

### Attribute クラス群

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | MetadataUpdateHandlerAttributeが有効な型で作成できる | E-10 (L31-32), E-01 (L17) | ○ |
| C-83 | MetadataUpdateHandlerAttribute.HandlerTypeが設定した型を返す | E-10 (L35-36), E-01 (L18-19) | ○ |
| C-84 | CreateNewOnMetadataUpdateAttributeが作成できる | E-11 (L9-12), E-01 (L31-33) | ○ |
| C-85 | MetadataUpdateDeletedAttributeが作成できる | E-12 (L10-11), E-01 (L35-38) | ○ |
| C-86 | MetadataUpdateOriginalTypeAttributeが元の型で作成できる | E-13 (L20), E-01 (L42-43) | ○ |
| C-87 | MetadataUpdateOriginalTypeAttribute.OriginalTypeが設定した型を返す | E-13 (L22), E-01 (L44) | ○ |

### LibraryNameVariation 構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | 絶対パスの場合は空のプレフィックス・サフィックスのみ | E-06 (L22-25), E-07 (L16) | ○ |
| C-89 | Windows環境で.dll拡張子が追加される | E-07 (L16-24) | ○ |
| C-90 | Unix環境でlib接頭辞と.so/.dylib拡張子が追加される | E-06 (L18-64) | ○ |
| C-91 | 既に.dll拡張子がある場合は追加されない | E-07 (L18-20) | ○ |
| C-92 | 既に.exe拡張子がある場合は.dllが追加されない | E-07 (L21) | ○ |
| C-93 | ドットで終わる場合は拡張子が追加されない | E-07 (L19) | ○ |

### 内部クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | DefaultAssemblyLoadContextがシングルトンで取得できる | E-02 (L808-815) | ○ |
| C-95 | collectible ALCがファイナライズ時にアンロードされる | E-02 (L114-126) | ○ |
| C-96 | OnProcessExitで全ALCのUnloadingイベントが発火する | E-02 (L470-489) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースについてソースコードによる根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのClaim に根拠あり

### 注意事項
1. **プラットフォーム依存コード**：LibraryNameVariationはWindows/Unix/macOSで異なる実装があるため、各プラットフォームでのテスト実行が必要
2. **AssemblyDependencyResolver**：Android/Browser/iOS/tvOSでは `PlatformNotSupportedException` をスローするため、これらのプラットフォームでは別のテストケースが必要
3. **MetadataUpdater.ApplyUpdate**：Hot Reload機能であり、デバッグ環境でのみ動作する可能性がある
4. **ネイティブ連携**：`InternalLoadFromPath`, `PrepareForAssemblyLoadContextRelease` などはネイティブコード（CoreCLR/Mono）との連携があり、単体テストではモック化が必要な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースのテストIDが `UT-SRL-XXX` 形式で一意であること
- [ ] 各クラスの主要なpublic APIがカバーされていること
- [ ] 正常系・異常系・境界値の観点が適切に含まれていること
- [ ] null引数チェックのテストケースが含まれていること
- [ ] プラットフォーム固有の動作に関するテストケースが識別されていること
- [ ] イベント（Resolving, ResolvingUnmanagedDll, Unloading）のテストケースが含まれていること
- [ ] ContextualReflectionScope のIDisposable実装に関するテストケースが含まれていること
- [ ] collectible/non-collectible ALCの違いに関するテストケースが含まれていること
