---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Runtime.Numerics 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **UT-NUM-188〜190（PopCount, TrailingZeroCount, LeadingZeroCount）**：実装詳細の確認が必要
  2. **UT-NUM-191〜192（BigInteger.RotateLeft/Right）**：メソッドの公開状況の確認
  3. **UT-NUM-194〜196（CreateChecked, CreateSaturating, CreateTruncating）**：ジェネリック数値インターフェース実装の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigInteger.cs`（メイン実装、3000行以上）
- E-02: `src/libraries/System.Runtime.Numerics/src/System/Numerics/Complex.cs`（Complex型実装）
- E-03: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.AddSub.cs`（加減算ロジック）
- E-04: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.DivRem.cs`（除算・剰余ロジック）
- E-05: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.SquMul.cs`（乗算・2乗ロジック）
- E-06: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.GcdInv.cs`（GCDアルゴリズム）
- E-07: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.PowMod.cs`（べき乗・モジュラー演算）
- E-08: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.ShiftRot.cs`（シフト・回転演算）
- E-09: `src/libraries/System.Runtime.Numerics/src/System/Numerics/BigIntegerCalculator.Utils.cs`（ユーティリティ関数）
- E-10: `src/libraries/System.Runtime.Numerics/src/System/Numerics/NumericsHelpers.cs`（ヘルパー関数）
- E-11: `src/libraries/System.Runtime.Numerics/src/System/Number.BigInteger.cs`（パース・フォーマット）
- E-12: `src/libraries/System.Runtime.Numerics/src/System/ThrowHelper.cs`（例外ヘルパー）

## 3) Claims と根拠の対応（レビューの主戦場）

### BigInteger コンストラクタ・基本プロパティ（UT-NUM-001〜023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-13 | BigIntegerコンストラクタの各種オーバーロード | E-01（行50-300付近のコンストラクタ実装） | ○ |
| C-14〜C-23 | Sign, IsZero, IsOne, IsEven, IsPowerOfTwoプロパティ | E-01（プロパティ定義部分） | ○ |

### BigInteger 算術演算子（UT-NUM-024〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24〜C-31 | 加算・減算・乗算演算子 | E-01（operator +, -, * 実装）, E-03 | ○ |
| C-32〜C-37 | 除算・剰余・DivRem | E-01（operator /, % 実装）, E-04 | ○ |
| C-38〜C-46 | シフト・ビット演算子 | E-01（operator <<, >>, >>>, &, |, ^, ~ 実装）, E-08 | ○ |

### BigInteger 数学関数（UT-NUM-047〜064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47〜C-51 | Abs, Negate, Max, Min | E-01（静的メソッド実装） | ○ |
| C-52〜C-57 | Pow, ModPow | E-01, E-07（PowMod.cs） | ○ |
| C-58〜C-60 | GreatestCommonDivisor | E-01, E-06（GcdInv.cs） | ○ |
| C-61〜C-64 | Log, Log10 | E-01（Log実装） | ○ |

### BigInteger パース・フォーマット（UT-NUM-065〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65〜C-75 | Parse, TryParse, ToString, TryFormat | E-01, E-11（Number.BigInteger.cs） | ○ |

### BigInteger バイト配列変換（UT-NUM-076〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76〜C-83 | ToByteArray, TryWriteBytes, GetByteCount, GetBitLength | E-01（TryGetBytes実装、行1346-1554） | ○ |

### BigInteger 比較・等価（UT-NUM-084〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84〜C-91 | Equals, CompareTo, GetHashCode | E-01（行1104-1231） | ○ |

### BigInteger 型変換演算子（UT-NUM-092〜101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92〜C-101 | explicit/implicit変換演算子 | E-01（行1841-2398） | ○ |

### Complex 構造体（UT-NUM-102〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102〜C-144 | Complex型の全機能 | E-02（Complex.cs全体） | ○ |

### BigIntegerCalculator 内部クラス（UT-NUM-145〜170）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145〜C-148 | Add, Subtract | E-03（AddSub.cs） | ○ |
| C-149〜C-154 | Multiply, Square, Divide, Remainder, DivRem | E-04, E-05 | ○ |
| C-155〜C-158 | Gcd | E-06（GcdInv.cs） | ○ |
| C-159〜C-163 | Pow, PowBound | E-07（PowMod.cs） | ○ |
| C-164〜C-166 | Compare, ActualLength | E-09（Utils.cs） | ○ |
| C-167〜C-170 | RotateLeft, RotateRight, LeftShiftSelf, RightShiftSelf | E-08（ShiftRot.cs） | ○ |

### NumericsHelpers（UT-NUM-171〜179）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-171〜C-179 | GetHi, GetLo, MakeUInt64, Abs, CbitHighZero, GetDoubleFromParts, DangerousMakeTwosComplement | E-10（NumericsHelpers.cs） | ○ |

### Number.BigInteger（UT-NUM-180〜183）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-180〜C-183 | FormatBigInteger, TryParseBigInteger | E-11（Number.BigInteger.cs） | ○ |

### ThrowHelper（UT-NUM-184〜187）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184〜C-187 | 各種例外スローメソッド | E-12（ThrowHelper.cs） | ○ |

### INumber<T>関連メソッド（UT-NUM-188〜200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-188 | PopCount | E-01（INumberインターフェース実装部分） | △ |
| C-189 | TrailingZeroCount | E-01（INumberインターフェース実装部分） | △ |
| C-190 | LeadingZeroCount | E-01（INumberインターフェース実装部分） | △ |
| C-191 | RotateLeft | E-01, E-08 | △ |
| C-192 | RotateRight | E-01, E-08 | △ |
| C-193〜C-200 | CopySign, CreateChecked, CreateSaturating, CreateTruncating, Clamp, IsNegative, IsPositive | E-01（INumberBase実装部分） | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-NUM-188〜190（ビット操作メソッド）**：BigInteger.csのIBinaryInteger<BigInteger>実装部分を確認する必要があります。.NET 7以降で追加されたジェネリック数値インターフェースの一部です。
  - 候補：BigInteger.cs後半部分 / IBinaryInteger<T>実装 / System.Numerics参照ソース
- **UT-NUM-191〜192（回転演算）**：BigIntegerの回転演算は内部的にBigIntegerCalculatorを使用していますが、公開APIとしての振る舞いの確認が必要です。
  - 候補：BigInteger.cs / IBinaryInteger<T>実装

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BigInteger基本演算（加減乗除、比較）：十分なソースコード根拠あり
- **0: 低リスク** - Complex型：完全なソースコード根拠あり
- **0: 低リスク** - BigIntegerCalculator内部クラス：詳細なアルゴリズム実装を確認済み
- **1: 中リスク** - INumber<T>関連メソッド（UT-NUM-188〜196）：.NET 7以降の新しいインターフェース実装部分、追加確認推奨
- **0: 低リスク** - 例外処理・エラーケース：ThrowHelperの実装を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] BigInteger算術演算のテストケースが境界値を適切にカバーしているか確認
- [ ] Complex型の三角関数・双曲線関数の精度要件を確認
- [ ] ModPowの大きな値に対するテストケースの妥当性を確認
- [ ] INumber<T>インターフェース関連メソッド（UT-NUM-188〜196）の実装詳細を確認
- [ ] バイト配列変換のエンディアン処理が網羅されているか確認
- [ ] 例外が発生するケース（ゼロ除算、オーバーフローなど）の網羅性を確認
- [ ] 内部クラスBigIntegerCalculatorのテストケースが単体テストとして適切か確認
