---
generated_at: 2026-01-30 18:15:00
metrics:
  claims_total: 155
  claims_with_evidence: 155
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Runtime.Serialization.Formatters 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：155 / 155、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接導出されており、高い信頼性を持つ
  2. シリアライズ/デシリアライズ機能のテストは.NET標準ライブラリの動作として確立されている
  3. Obsolete属性が付与されたAPIのテストであることに注意（BinaryFormatterはセキュリティ上の理由で非推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/FormatterServices.cs`
- E-02: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/FormatterConverter.cs`
- E-03: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/ObjectIDGenerator.cs`
- E-04: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/ObjectManager.cs`
- E-05: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/SurrogateSelector.cs`
- E-06: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/Formatter.cs`
- E-07: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/SerializationBinder.cs`
- E-08: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/SerializationObjectManager.cs`
- E-09: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/SerializationEventsCache.cs`
- E-10: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/MemberHolder.cs`
- E-11: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/SerializationFieldInfo.cs`
- E-12: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/ValueTypeFixupInfo.cs`
- E-13: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/Formatters/Binary/BinaryFormatter.cs`
- E-14: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/Formatters/Binary/BinaryFormatterEventSource.cs`
- E-15: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/Formatters/CommonEnums.cs`
- E-16: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/IFormatter.cs`
- E-17: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/ISurrogateSelector.cs`
- E-18: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/ISerializationSurrogate.cs`
- E-19: `src/libraries/System.Runtime.Serialization.Formatters/src/System/Runtime/Serialization/DeserializationEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### FormatterServices クラス (UT-SRF-001 ～ UT-SRF-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetSerializableMembersが[Serializable]型のフィールドを返却する | E-01 (L166-183) | ○ |
| C-02 | 継承階層を辿ってフィールドを収集する | E-01 (L45-83) | ○ |
| C-03 | null引数でArgumentNullExceptionをスローする | E-01 (L176) | ○ |
| C-04 | 非シリアライズ型でSerializationExceptionをスローする | E-01 (L34-37) | ○ |
| C-05 | インターフェース型で空配列を返却する | E-01 (L29-32) | ○ |
| C-06 | GetUninitializedObjectがRuntimeHelpers経由でインスタンス生成する | E-01 (L190-197) | ○ |
| C-07 | PopulateObjectMembersがフィールドに値を設定する | E-01 (L216-256) | ○ |
| C-08 | GetObjectDataがフィールド値を取得する | E-01 (L258-281) | ○ |
| C-09 | GetSurrogateForCyclicalReferenceがラッパーサロゲートを返却する | E-01 (L283-288) | ○ |
| C-10 | GetTypeFromAssemblyがアセンブリから型を取得する | E-01 (L290-296) | ○ |

### FormatterConverter クラス (UT-SRF-026 ～ UT-SRF-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | ConvertがSystem.Convert.ChangeTypeを使用する | E-02 (L11-16) | ○ |
| C-12 | 各ToXxx メソッドがSystem.Convert.ToXxxを使用する | E-02 (L25-131) | ○ |
| C-13 | null引数でArgumentNullExceptionをスローする | E-02 (L13, L20, L27など) | ○ |
| C-14 | InvariantCultureを使用する | E-02 (L15, L22, L29など) | ○ |

### ObjectIDGenerator クラス (UT-SRF-046 ～ UT-SRF-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | コンストラクタが_currentCount=1で初期化する | E-03 (L20-26) | ○ |
| C-16 | GetIdが新規オブジェクトにIDを割り当てる | E-03 (L65-93) | ○ |
| C-17 | HasIdが登録済みオブジェクトのIDを返却する | E-03 (L97-111) | ○ |
| C-18 | null引数でArgumentNullExceptionをスローする | E-03 (L67, L99) | ○ |
| C-19 | テーブル拡張時にRehashを実行する | E-03 (L116-145) | ○ |

### ObjectManager クラス (UT-SRF-054 ～ UT-SRF-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | コンストラクタがObjectHolder配列を初期化する | E-04 (L32-37) | ○ |
| C-21 | GetObjectが登録済みオブジェクトを返却する | E-04 (L615-631) | ○ |
| C-22 | RegisterObjectがオブジェクトを登録する | E-04 (L633-763) | ○ |
| C-23 | objectID<=0でArgumentOutOfRangeExceptionをスローする | E-04 (L617-620, L666-669) | ○ |
| C-24 | RecordFixupがフィックスアップを記録する | E-04 (L924-940) | ○ |
| C-25 | DoFixupsがフィックスアップを解決する | E-04 (L813-892) | ○ |
| C-26 | RaiseDeserializationEventがイベントを発火する | E-04 (L976-981) | ○ |

### SurrogateSelector クラス (UT-SRF-080 ～ UT-SRF-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | AddSurrogateがサロゲートを追加する | E-05 (L15-22) | ○ |
| C-28 | GetSurrogateがサロゲートを取得する | E-05 (L145-162) | ○ |
| C-29 | ChainSelectorがセレクタをチェーンする | E-05 (L54-138) | ○ |
| C-30 | 循環参照を検出して例外をスローする | E-05 (L59-128) | ○ |
| C-31 | RemoveSurrogateがサロゲートを削除する | E-05 (L166-172) | ○ |
| C-32 | null引数でArgumentNullExceptionをスローする | E-05 (L17-18, L56, L147, L168) | ○ |

### Formatter 抽象クラス (UT-SRF-097 ～ UT-SRF-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタがm_objectQueueとm_idGeneratorを初期化する | E-06 (L18-22) | ○ |
| C-34 | GetNextがキューからオブジェクトを取得する | E-06 (L28-46) | ○ |
| C-35 | Scheduleがオブジェクトをキューに追加する | E-06 (L48-63) | ○ |
| C-36 | WriteMemberが型に応じた書き込みメソッドを呼び出す | E-06 (L90-168) | ○ |

### SerializationBinder 抽象クラス (UT-SRF-107 ～ UT-SRF-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | BindToNameがデフォルトでnullを返却する | E-07 (L8-12) | ○ |
| C-38 | BindToTypeが抽象メソッドである | E-07 (L14) | ○ |

### SerializationObjectManager クラス (UT-SRF-109 ～ UT-SRF-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | RegisterObjectがOnSerializingを呼び出す | E-08 (L24-42) | ○ |
| C-40 | RaiseOnSerializedEventがOnSerializedを呼び出す | E-08 (L44) | ○ |
| C-41 | 同一オブジェクトの重複登録を防止する | E-08 (L34) | ○ |

### SerializationEvents / SerializationEventsCache クラス (UT-SRF-113 ～ UT-SRF-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | コンストラクタが各イベント属性のメソッドを収集する | E-09 (L19-25) | ○ |
| C-43 | HasOnSerializingEventsがイベント有無を判定する | E-09 (L56-57) | ○ |
| C-44 | InvokeOnXxxがイベントメソッドを呼び出す | E-09 (L59-66) | ○ |
| C-45 | キャッシュから同一インスタンスを返却する | E-09 (L98-102) | ○ |

### MemberHolder クラス (UT-SRF-120 ～ UT-SRF-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | コンストラクタが_memberTypeと_contextを設定する | E-10 (L14-20) | ○ |
| C-47 | GetHashCodeが_memberType.GetHashCode()を返却する | E-10 (L22) | ○ |
| C-48 | Equalsが型とStateで比較する | E-10 (L24-29) | ○ |

### SerializationFieldInfo クラス (UT-SRF-125 ～ UT-SRF-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタがプレフィックス付き名前を生成する | E-11 (L15-22) | ○ |
| C-50 | Nameがシリアライズ用の名前を返却する | E-11 (L26) | ○ |
| C-51 | 各プロパティ/メソッドがm_fieldに委譲する | E-11 (L31-53) | ○ |

### ValueTypeFixupInfo クラス (UT-SRF-130 ～ UT-SRF-137)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | コンストラクタが引数検証を行う | E-12 (L31-65) | ○ |
| C-53 | memberとparentIndexが両方nullで例外をスローする | E-12 (L35-38) | ○ |
| C-54 | memberとparentIndexが両方指定で例外をスローする | E-12 (L51-54) | ○ |
| C-55 | プロパティが対応フィールドを返却する | E-12 (L67-71) | ○ |

### BinaryFormatter クラス (UT-SRF-138 ～ UT-SRF-145)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | デフォルトコンストラクタがデフォルト設定を使用する | E-13 (L23-25) | ○ |
| C-57 | 2引数コンストラクタがselectorとcontextを設定する | E-13 (L27-31) | ○ |
| C-58 | 各プロパティが対応フィールドにアクセスする | E-13 (L16-21) | ○ |

### BinaryFormatterEventSource クラス (UT-SRF-146 ～ UT-SRF-151)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | SerializationStart/Stopがイベントを発火する | E-14 (L22-38) | ○ |
| C-60 | SerializingObjectが型名付きイベントを発火する | E-14 (L40-55) | ○ |
| C-61 | DeserializationStart/Stopがイベントを発火する | E-14 (L57-73) | ○ |
| C-62 | DeserializingObjectが型名付きイベントを発火する | E-14 (L75-90) | ○ |

### SurrogateForCyclicalReference クラス (UT-SRF-152 ～ UT-SRF-153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | GetObjectDataが内部サロゲートに委譲する | E-01 (L382-385) | ○ |
| C-64 | SetObjectDataが内部サロゲートに委譲する | E-01 (L387-390) | ○ |

### TypeLoadExceptionHolder クラス (UT-SRF-154 ～ UT-SRF-155)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタがTypeNameを設定する | E-04 (L1617-1619) | ○ |
| C-66 | TypeNameプロパティが設定値を返却する | E-04 (L1622) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。すべてのテストケースはソースコードから直接導出されている。
- 注意：このライブラリはObsolete属性が付与されており、セキュリティ上の理由でBinaryFormatterの使用は非推奨とされている。

## 5) リスクフラグ（レビュー観点）
- 0: このモジュールはレガシーシリアライズ機能を提供しており、.NET Core以降では非推奨（Obsolete）
- 1: BinaryFormatterはセキュリティ脆弱性の原因となる可能性があるため、新規コードでの使用は避けるべき
- 0: テストケースは既存APIの動作確認を目的としており、新機能開発には使用しない

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードのpublicメソッドを網羅しているか確認
- [ ] 異常系テストケース（null引数、範囲外値）が適切に定義されているか確認
- [ ] 境界値テストケース（空配列、最大値など）が考慮されているか確認
- [ ] Obsolete属性のあるAPIに対する適切な警告がテストで考慮されているか確認
- [ ] シリアライズ/デシリアライズの循環参照シナリオがカバーされているか確認
- [ ] ISerializable実装クラス、IObjectReference実装クラスのテストが含まれているか確認
