---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Runtime.Serialization.Json 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-SRJ-097 (ISerializable実装型のシリアライズ)**: 実装詳細の確認が必要
  2. **UT-SRJ-098 (拡張データオブジェクト)**: IExtensibleDataObjectの動作確認が必要
  3. **UT-SRJ-045 (SetSerializationSurrogateProvider)**: サロゲートプロバイダの具体的な動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Serialization.Json/ref/System.Runtime.Serialization.Json.cs` - 公開API定義（リファレンスアセンブリ）
- E-02: `src/libraries/System.Runtime.Serialization.Json/tests/DataContractJsonSerializer.cs` - 既存の単体テストコード（135,501バイト、3,127行）
- E-03: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/DataContractJsonSerializer.cs` - 実装コード
- E-04: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/DataContractJsonSerializerSettings.cs` - 設定クラス実装
- E-05: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/JsonReaderWriterFactory.cs` - Factory実装
- E-06: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/Json/DateTimeFormat.cs` - DateTimeFormat実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DataContractJsonSerializer(Type)コンストラクタの正常系テスト | E-01, E-02, E-03 | ○ |
| C-02 | DataContractJsonSerializer(Type)のnull入力チェック | E-03 | ○ |
| C-03 | DataContractJsonSerializer(Type, string)コンストラクタ | E-01, E-02, E-03 | ○ |
| C-04 | DataContractJsonSerializer(Type, IEnumerable<Type>)コンストラクタ | E-01, E-02, E-03 | ○ |
| C-05 | DataContractJsonSerializer(Type, DataContractJsonSerializerSettings)コンストラクタ | E-01, E-02, E-03, E-04 | ○ |
| C-06 | 設定オブジェクトnullの処理 | E-03 (line 85) | ○ |
| C-07 | bool型シリアライズ（DCJS_BoolAsRoot） | E-02 (line 34-38) | ○ |
| C-08 | int型シリアライズ（DCJS_IntAsRoot） | E-02 (line 203-208) | ○ |
| C-09 | string型シリアライズ（DCJS_StringAsRoot） | E-02 (line 255-304) | ○ |
| C-10 | null値シリアライズ | E-02 (line 44, 225) | ○ |
| C-11 | DateTime型シリアライズ（DCJS_DateTimeAsRoot） | E-02 (line 117-129) | ○ |
| C-12 | Guid型シリアライズ（DCJS_GuidAsRoot） | E-02 (line 194-200) | ○ |
| C-13 | 配列シリアライズ（DCJS_ArrayAsRoot） | E-02 (line 382-388) | ○ |
| C-14 | Dictionary型シリアライズ（DCJS_DictionaryGenericRoot） | E-02 (line 426-438) | ○ |
| C-15 | List型シリアライズ（DCJS_ListGenericRoot） | E-02 (line 627-639) | ○ |
| C-16 | DataContract属性付き型のシリアライズ（DCJS_DataContractAttribute） | E-02 (line 964-970) | ○ |
| C-17 | 特殊文字エスケープ処理 | E-02 (line 262-299) | ○ |
| C-18 | Unicode文字処理 | E-02 (line 257) | ○ |
| C-19 | WriteObject Streamのnullチェック | E-03 (line 301) | ○ |
| C-20 | MaxItemsInObjectGraph制限チェック | E-03 (line 453-456) | ○ |
| C-21 | bool型デシリアライズ | E-02 (line 34-38) | ○ |
| C-22 | int型デシリアライズ | E-02 (line 203-208) | ○ |
| C-23 | string型デシリアライズ | E-02 (line 255-304) | ○ |
| C-24 | null値デシリアライズ | E-02 (line 44, 225) | ○ |
| C-25 | DateTime型デシリアライズ | E-02 (line 117-129) | ○ |
| C-26 | 配列デシリアライズ | E-02 (line 382-388) | ○ |
| C-27 | Dictionaryデシリアライズ | E-02 (line 426-438) | ○ |
| C-28 | 空ストリーム読み込み例外（DCJS_EmptyString_Throws） | E-02 (line 1399-1418) | ○ |
| C-29 | 不正JSON読み込み例外 | E-02 | ○ |
| C-30 | XmlReader入力 | E-03 (line 255-258) | ○ |
| C-31 | verifyObjectName=true | E-03 (line 262-265) | ○ |
| C-32 | verifyObjectName検証失敗 | E-03 (line 458-468) | ○ |
| C-33 | IsStartObject正常系 | E-03 (line 230-242) | ○ |
| C-34 | IsStartObject不正ルート | E-03 (line 439-447) | ○ |
| C-35 | WriteStartObject | E-03 (line 338-350) | ○ |
| C-36 | WriteObjectContent | E-03 (line 324-334) | ○ |
| C-37 | WriteEndObject | E-03 (line 283-295) | ○ |
| C-38 | KnownTypesプロパティ | E-01, E-03 (line 116-125) | ○ |
| C-39 | MaxItemsInObjectGraphプロパティ | E-01, E-03 (line 145-148) | ○ |
| C-40 | DateTimeFormatプロパティ | E-01, E-03 (line 150-156) | ○ |
| C-41 | EmitTypeInformationプロパティ | E-01, E-03 (line 158-164) | ○ |
| C-42 | UseSimpleDictionaryFormat設定（DCJS_GetOonlyDictionary_UseSimpleDictionaryFormat） | E-02 (line 500-524) | ○ |
| C-43 | SerializeReadOnlyTypesプロパティ | E-01, E-03 (line 166-172) | ○ |
| C-44 | GetSerializationSurrogateProvider | E-01, E-03 (line 214-217) | ○ |
| C-45 | SetSerializationSurrogateProvider | E-01, E-03 (line 223-226) | ○ |
| C-46 | DataContractJsonSerializerSettingsコンストラクタ | E-04 (line 13) | ○ |
| C-47 | RootNameプロパティ | E-04 (line 20) | ○ |
| C-48 | KnownTypesプロパティ（Settings） | E-04 (line 25) | ○ |
| C-49 | MaxItemsInObjectGraphデフォルト値 | E-04 (line 15, 30-40) | ○ |
| C-50 | MaxItemsInObjectGraph設定 | E-04 (line 30-40) | ○ |
| C-51 | IgnoreExtensionDataObjectプロパティ | E-04 (line 46) | ○ |
| C-52 | EmitTypeInformationプロパティ（Settings） | E-04 (line 51) | ○ |
| C-53 | DateTimeFormatプロパティ（Settings） | E-04 (line 56) | ○ |
| C-54 | SerializeReadOnlyTypesプロパティ（Settings） | E-04 (line 61) | ○ |
| C-55 | UseSimpleDictionaryFormatプロパティ（Settings） | E-04 (line 66) | ○ |
| C-56 | CreateJsonReader(Stream, Quotas) | E-05 (line 17-20) | ○ |
| C-57 | CreateJsonReader(byte[], Quotas) | E-05 (line 22-27) | ○ |
| C-58 | CreateJsonReaderのnullチェック | E-05 (line 24) | ○ |
| C-59 | CreateJsonReader詳細オーバーロード | E-05 (line 29-34) | ○ |
| C-60 | CreateJsonReader部分配列 | E-05 (line 36-39) | ○ |
| C-61 | CreateJsonReader完全パラメータ | E-05 (line 41-46) | ○ |
| C-62 | CreateJsonWriter(Stream) | E-05 (line 48-51) | ○ |
| C-63 | CreateJsonWriter(Stream, Encoding) | E-05 (line 53-56) | ○ |
| C-64 | CreateJsonWriter(Stream, Encoding, bool) | E-05 (line 58-61) | ○ |
| C-65 | CreateJsonWriter(indent=true) | E-05 (line 63-66) | ○ |
| C-66 | CreateJsonWriter(indentChars指定) | E-05 (line 68-73) | ○ |
| C-67 | DateTimeFormat(string)コンストラクタ | E-06 (line 25-27) | ○ |
| C-68 | DateTimeFormat(string) nullチェック | E-06 (line 37) | ○ |
| C-69 | DateTimeFormat(string, IFormatProvider) | E-06 (line 35-43) | ○ |
| C-70 | DateTimeFormat IFormatProvider nullチェック | E-06 (line 38) | ○ |
| C-71 | FormatStringプロパティ | E-06 (line 48-54) | ○ |
| C-72 | FormatProviderプロパティ | E-06 (line 59-65) | ○ |
| C-73 | DateTimeStylesデフォルト値 | E-06 (line 42) | ○ |
| C-74 | DateTimeStyles設定 | E-06 (line 70-80) | ○ |
| C-75 | DateOnly型シリアライズ（DCJS_DateOnlyAsRoot） | E-02 (line 170-179) | ○ |
| C-76 | TimeOnly型シリアライズ（DCJS_TimeOnlyAsRoot） | E-02 (line 182-191) | ○ |
| C-77 | TimeSpan型シリアライズ（DCJS_TimeSpanAsRoot） | E-02 (line 339-345) | ○ |
| C-78 | Enum型シリアライズ（DCJS_EnumAsRoot） | E-02 (line 990-999) | ○ |
| C-79 | Nullable<T>型シリアライズ（DCJS_Nullables） | E-02 (line 1314-1336) | ○ |
| C-80 | XElement型シリアライズ（DCJS_XElementAsRoot） | E-02 (line 1132-1140) | ○ |
| C-81 | Uri型シリアライズ（DCJS_UriAsRoot） | E-02 (line 375-379) | ○ |
| C-82 | decimal型シリアライズ（DCJS_DecimalAsRoot） | E-02 (line 132-138) | ○ |
| C-83 | double型シリアライズ（DCJS_DoubleAsRoot） | E-02 (line 141-150) | ○ |
| C-84 | float型シリアライズ（DCJS_FloatAsRoot） | E-02 (line 153-167) | ○ |
| C-85 | 負のゼロ処理 | E-02 (line 145-146, 157-158) | ○ |
| C-86 | char型シリアライズ（DCJS_CharAsRoot） | E-02 (line 51-95) | ○ |
| C-87 | 特殊char値エスケープ | E-02 (line 77-79) | ○ |
| C-88 | byte配列シリアライズ（DCJS_ByteArrayAsRoot） | E-02 (line 42-48) | ○ |
| C-89 | XmlQualifiedNameシリアライズ（DCJS_XmlQualifiedNameAsRoot） | E-02 (line 230-234) | ○ |
| C-90 | DateTimeOffsetシリアライズ（DCJS_ClassWithDatetimeOffsetTypeProperty） | E-02 (line 1422-1427) | ○ |
| C-91 | IgnoreDataMemberAttribute（DCJS_IgnoreDataMemberAttribute） | E-02 (line 979-987) | ○ |
| C-92 | DataMemberAttribute Order（DCJS_DataMemberAttribute） | E-02 (line 973-976) | ○ |
| C-93 | KnownTypeAttribute（DCJS_CustomType） | E-02 (line 947-961) | ○ |
| C-94 | EmitTypeInformation=Always | E-02 | ○ |
| C-95 | EmitTypeInformation=Never | E-02 | ○ |
| C-96 | ConcurrentDictionary型（DCJS_ConcurrentDictionary） | E-02 (line 2934-2946) | ○ |
| C-97 | ISerializable型シリアライズ | E-02 (line 2323-2332) | △ |
| C-98 | 拡張データオブジェクト | E-02 (line 2360-2414) | △ |
| C-99 | ジャグ配列（DCJS_JaggedArrayAsRoot） | E-02 (line 1207-1244) | ○ |
| C-100 | LinkedList型（DCJS_ContainsLinkedList） | E-02 (line 1276-1292) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SRJ-097**: ISerializableを実装した型のシリアライズ動作の詳細な仕様確認が必要
  - 候補：.NET公式ドキュメント / 追加テストケース確認
- **UT-SRJ-098**: IExtensibleDataObjectの拡張データ保持の完全な動作確認
  - 候補：System.Private.DataContractSerializationの詳細実装確認
- **UT-SRJ-002, UT-SRJ-019**: null入力時の例外型の正確な確認
  - 候補：ArgumentNullException vs ArgumentExceptionの確認
- **UT-SRJ-029**: 不正JSONの定義と例外型の詳細確認
  - 候補：SerializationException vs XmlExceptionの確認
- **UT-SRJ-045**: サロゲートプロバイダの具体的な動作シナリオ
  - 候補：ISerializationSurrogateProviderの実装例確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: プリミティブ型のシリアライズ/デシリアライズ（UT-SRJ-007〜015, 021〜027）- 既存テストで十分にカバー
- **0 (低リスク)**: プロパティの設定/取得（UT-SRJ-038〜055, 071〜074）- 単純なプロパティアクセス
- **1 (中リスク)**: コンストラクタのnull入力チェック（UT-SRJ-002, 068, 070）- 例外型の確認が必要
- **1 (中リスク)**: Factory メソッドのパラメータバリエーション（UT-SRJ-056〜066）- 境界値テストの追加検討
- **2 (高リスク)**: ISerializable/IExtensibleDataObject関連（UT-SRJ-097, 098）- 複雑な動作の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 既存テスト（E-02）との整合性確認：既存テストメソッド名とテストケースIDの対応は適切か
- [ ] プリミティブ型の網羅性：bool, int, long, float, double, decimal, char, string, byte[], DateTime, DateOnly, TimeOnly, TimeSpan, Guid, Uri, Enumがすべてカバーされているか
- [ ] コレクション型の網羅性：Array, List<T>, Dictionary<K,V>, ConcurrentDictionary<K,V>, LinkedList<T>がカバーされているか
- [ ] 異常系テストの妥当性：null入力、空入力、不正入力の各ケースが適切か
- [ ] 境界値テストの妥当性：MaxValue, MinValue, 空配列/コレクション、ネストした構造のケースが適切か
- [ ] 優先度の妥当性：金額計算や認証関連はないが、シリアライズの正確性は「高」優先度として適切か
- [ ] テストID命名規則：UT-SRJ-XXX形式が一貫しているか
