---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 87
  claims_with_evidence: 87
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Runtime.Serialization.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：87 / 87、根拠なし：0
- 優先レビュー（高）
  1. **インターフェーステスト（UT-SRP-073〜079）**：実装クラスを用いたテストのため、モック実装が必要
  2. **AttributeUsageテスト（UT-SRP-080〜087）**：コンパイル時検証のため、実行時テストでは検証方法を検討
  3. **Order負数バリデーション（UT-SRP-024）**：InvalidDataContractExceptionのスロー確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/DataContractAttribute.cs`
- E-02: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/DataMemberAttribute.cs`
- E-03: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/KnownTypeAttribute.cs`
- E-04: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/CollectionDataContractAttribute.cs`
- E-05: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/EnumMemberAttribute.cs`
- E-06: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/ContractNamespaceAttribute.cs`
- E-07: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/IgnoreDataMemberAttribute.cs`
- E-08: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/InvalidDataContractException.cs`
- E-09: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/ISerializationSurrogateProvider.cs`
- E-10: `src/libraries/System.Runtime.Serialization.Primitives/src/System/Runtime/Serialization/ISerializationSurrogateProvider2.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DataContractAttribute (UT-SRP-001〜015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでインスタンス生成可能 | E-01 L16-18 | ○ |
| C-02 | Nameプロパティ初期値がnull | E-01 L9 `_name` フィールドがnull初期化 | ○ |
| C-03 | Name設定時に値が保存される | E-01 L44-51 setter実装 | ○ |
| C-04 | Name設定時にIsNameSetExplicitlyがtrue | E-01 L50 `_isNameSetExplicitly = true` | ○ |
| C-05 | Nameにnull設定可能 | E-01 L44 `string?` 型定義 | ○ |
| C-06 | Nameに空文字設定可能 | E-01 型制約なし | ○ |
| C-07 | IsNameSetExplicitly初期値がfalse | E-01 L11 フィールド初期化なし（デフォルトfalse） | ○ |
| C-08 | Namespaceプロパティ初期値がnull | E-01 L10 `_ns` フィールドがnull初期化 | ○ |
| C-09 | Namespace設定時に値が保存される | E-01 L32-39 setter実装 | ○ |
| C-10 | Namespace設定時にIsNamespaceSetExplicitlyがtrue | E-01 L38 `_isNamespaceSetExplicitly = true` | ○ |
| C-11 | IsNamespaceSetExplicitly初期値がfalse | E-01 L12 フィールド初期化なし | ○ |
| C-12 | IsReference初期値がfalse | E-01 L13 フィールド初期化なし（デフォルトfalse） | ○ |
| C-13 | IsReference設定時に値が保存される | E-01 L20-28 setter実装 | ○ |
| C-14 | IsReference設定時にIsReferenceSetExplicitlyがtrue | E-01 L26 `_isReferenceSetExplicitly = true` | ○ |
| C-15 | IsReferenceSetExplicitly初期値がfalse | E-01 L14 フィールド初期化なし | ○ |

### DataMemberAttribute (UT-SRP-016〜029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | デフォルトコンストラクタでインスタンス生成可能 | E-02 L13-15 | ○ |
| C-17 | Nameプロパティ初期値がnull | E-02 L9 `_name` フィールド | ○ |
| C-18 | Name設定時に値が保存される | E-02 L17-25 setter実装 | ○ |
| C-19 | Name設定時にIsNameSetExplicitlyがtrue | E-02 L23 `_isNameSetExplicitly = true` | ○ |
| C-20 | IsNameSetExplicitly初期値がfalse | E-02 L10 フィールド初期化なし | ○ |
| C-21 | Order初期値が-1 | E-02 L11 `_order = -1` | ○ |
| C-22 | Order設定時に値が保存される | E-02 L29-40 setter実装 | ○ |
| C-23 | Order=0設定可能 | E-02 L34 `if (value < 0)` の条件 | ○ |
| C-24 | Order<0でInvalidDataContractExceptionスロー | E-02 L34-37 throw文 | ○ |
| C-25 | Order=int.MaxValue設定可能 | E-02 int型で制約なし | ○ |
| C-26 | IsRequired初期値がfalse | E-02 L43 自動プロパティ初期値 | ○ |
| C-27 | IsRequired設定時に値が保存される | E-02 L43 自動プロパティ | ○ |
| C-28 | EmitDefaultValue初期値がtrue | E-02 L45 `= true` 初期化 | ○ |
| C-29 | EmitDefaultValue設定時に値が保存される | E-02 L45 自動プロパティ | ○ |

### KnownTypeAttribute (UT-SRP-030〜035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | Type引数コンストラクタでインスタンス生成可能 | E-03 L9-12 | ○ |
| C-31 | Type引数にnull渡し可能 | E-03 L9 nullチェックなし | ○ |
| C-32 | methodName引数コンストラクタでインスタンス生成可能 | E-03 L14-17 | ○ |
| C-33 | methodName引数にnull渡し可能 | E-03 L14 nullチェックなし | ○ |
| C-34 | Typeプロパティ取得可能 | E-03 L21 get-onlyプロパティ | ○ |
| C-35 | MethodNameプロパティ取得可能 | E-03 L19 get-onlyプロパティ | ○ |

### CollectionDataContractAttribute (UT-SRP-036〜054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | デフォルトコンストラクタでインスタンス生成可能 | E-04 L22-24 | ○ |
| C-37 | Name設定時に値が保存される | E-04 L38-46 setter実装 | ○ |
| C-38 | Name設定時にIsNameSetExplicitlyがtrue | E-04 L44 | ○ |
| C-39 | IsNameSetExplicitly初期値がfalse | E-04 L15 フィールド初期化なし | ○ |
| C-40 | Namespace設定時に値が保存される | E-04 L26-34 setter実装 | ○ |
| C-41 | Namespace設定時にIsNamespaceSetExplicitlyがtrue | E-04 L32 | ○ |
| C-42 | IsNamespaceSetExplicitly初期値がfalse | E-04 L16 フィールド初期化なし | ○ |
| C-43 | ItemName設定時に値が保存される | E-04 L50-58 setter実装 | ○ |
| C-44 | ItemName設定時にIsItemNameSetExplicitlyがtrue | E-04 L56 | ○ |
| C-45 | IsItemNameSetExplicitly初期値がfalse | E-04 L18 フィールド初期化なし | ○ |
| C-46 | KeyName設定時に値が保存される | E-04 L62-70 setter実装 | ○ |
| C-47 | KeyName設定時にIsKeyNameSetExplicitlyがtrue | E-04 L68 | ○ |
| C-48 | IsKeyNameSetExplicitly初期値がfalse | E-04 L19 フィールド初期化なし | ○ |
| C-49 | ValueName設定時に値が保存される | E-04 L86-94 setter実装 | ○ |
| C-50 | ValueName設定時にIsValueNameSetExplicitlyがtrue | E-04 L92 | ○ |
| C-51 | IsValueNameSetExplicitly初期値がfalse | E-04 L20 フィールド初期化なし | ○ |
| C-52 | IsReference設定時に値が保存される | E-04 L74-82 setter実装 | ○ |
| C-53 | IsReference設定時にIsReferenceSetExplicitlyがtrue | E-04 L80 | ○ |
| C-54 | IsReferenceSetExplicitly初期値がfalse | E-04 L17 フィールド初期化なし | ○ |

### EnumMemberAttribute (UT-SRP-055〜060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | デフォルトコンストラクタでインスタンス生成可能 | E-05 L12-14 | ○ |
| C-56 | Value初期値がnull | E-05 L9 `_value` フィールド | ○ |
| C-57 | Value設定時に値が保存される | E-05 L16-24 setter実装 | ○ |
| C-58 | Value設定時にIsValueSetExplicitlyがtrue | E-05 L22 | ○ |
| C-59 | IsValueSetExplicitly初期値がfalse | E-05 L10 フィールド初期化なし | ○ |
| C-60 | Valueにnull設定可能 | E-05 L16 `string?` 型定義 | ○ |

### ContractNamespaceAttribute (UT-SRP-061〜065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | contractNamespace引数コンストラクタでインスタンス生成可能 | E-06 L9-12 | ○ |
| C-62 | contractNamespaceにnull渡し可能 | E-06 L9 nullチェックなし | ○ |
| C-63 | ContractNamespaceプロパティ取得可能 | E-06 L16 get-onlyプロパティ | ○ |
| C-64 | ClrNamespace初期値がnull | E-06 L14 自動プロパティ初期値 | ○ |
| C-65 | ClrNamespace設定時に値が保存される | E-06 L14 自動プロパティ | ○ |

### IgnoreDataMemberAttribute (UT-SRP-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | デフォルトコンストラクタでインスタンス生成可能 | E-07 L9-11 | ○ |

### InvalidDataContractException (UT-SRP-067〜072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | パラメータなしコンストラクタでインスタンス生成可能 | E-08 L14-17 | ○ |
| C-68 | message引数コンストラクタでインスタンス生成可能 | E-08 L19-22 | ○ |
| C-69 | messageにnull渡し可能 | E-08 L19 `string?` 型定義 | ○ |
| C-70 | message・innerException引数コンストラクタでインスタンス生成可能 | E-08 L24-27 | ○ |
| C-71 | innerExceptionにnull渡し可能 | E-08 L24 `Exception?` 型定義 | ○ |
| C-72 | Exceptionクラスを継承している | E-08 L12 `class InvalidDataContractException : Exception` | ○ |

### ISerializationSurrogateProvider (UT-SRP-073〜075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | GetSurrogateTypeメソッドが定義されている | E-09 L21 | ○ |
| C-74 | GetObjectToSerializeメソッドが定義されている | E-09 L30 | ○ |
| C-75 | GetDeserializedObjectメソッドが定義されている | E-09 L39 | ○ |

### ISerializationSurrogateProvider2 (UT-SRP-076〜079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | GetCustomDataToExport(MemberInfo, Type)が定義されている | E-10 L23 | ○ |
| C-77 | GetCustomDataToExport(Type, Type)が定義されている | E-10 L31 | ○ |
| C-78 | GetKnownCustomDataTypesが定義されている | E-10 L37 | ○ |
| C-79 | GetReferencedTypeOnImportが定義されている | E-10 L46 | ○ |

### AttributeUsage検証 (UT-SRP-080〜087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | DataContractAttributeがClass, Struct, Enumに適用可能 | E-01 L6 `AttributeUsage(AttributeTargets.Class \| AttributeTargets.Struct \| AttributeTargets.Enum` | ○ |
| C-81 | DataContractAttributeがインターフェースに適用不可 | E-01 L6 `AttributeTargets` に Interface なし | ○ |
| C-82 | DataMemberAttributeがField, Propertyに適用可能 | E-02 L6 `AttributeUsage(AttributeTargets.Field \| AttributeTargets.Property` | ○ |
| C-83 | KnownTypeAttributeが複数回適用可能 | E-03 L6 `AllowMultiple = true` | ○ |
| C-84 | CollectionDataContractAttributeがClass, Structに適用可能 | E-04 L6 `AttributeUsage(AttributeTargets.Class \| AttributeTargets.Struct` | ○ |
| C-85 | EnumMemberAttributeがFieldに適用可能 | E-05 L6 `AttributeUsage(AttributeTargets.Field` | ○ |
| C-86 | ContractNamespaceAttributeが複数回適用可能 | E-06 L6 `AllowMultiple = true` | ○ |
| C-87 | IgnoreDataMemberAttributeがField, Propertyに適用可能 | E-07 L6 `AttributeUsage(AttributeTargets.Field \| AttributeTargets.Property` | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのテストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードに基づいており、属性クラスとインターフェースの単純な構造のため、テストケースの網羅性は高い
- **1: 中リスク** - インターフェーステスト（ISerializationSurrogateProvider, ISerializationSurrogateProvider2）は実装クラスを用いたモックテストが必要
- **0: 低リスク** - AttributeUsageのコンパイル時検証は、リフレクションまたはRoslyn Analyzerでの検証を検討

## 6) レビュアーチェックリスト（最小）
- [ ] DataMemberAttribute.OrderのInvalidDataContractExceptionスロー条件（value < 0）が正しくテストされているか
- [ ] インターフェーステストのモック実装方針を確認
- [ ] AttributeUsageの検証方法（コンパイル時 vs 実行時リフレクション）を決定
- [ ] null許容プロパティのテストケースが網羅されているか
- [ ] EmitDefaultValueの初期値trueが正しくテストされているか
- [ ] KnownTypeAttributeの2つのコンストラクタオーバーロードが両方テストされているか
