---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Runtime.Serialization.Schema 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **XsdDataContractImporter.Import メソッド群**：コアインポート機能、実際のスキーマでの動作確認推奨
  2. **Fx.IsFatal メソッド**：fatal例外判定ロジック、エッジケースの確認推奨
  3. **CodeExporter.Export メソッド**：コード生成の中心機能、生成コードの品質確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/XsdDataContractImporter.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/ImportOptions.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/ImportGlobals.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/SchemaImportHelper.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/ContractCodeDomInfo.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/DiagnosticUtility.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/ISerializationCodeDomSurrogateProvider.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Runtime.Serialization.Schema/src/System/Runtime/Serialization/Schema/CodeExporter.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### XsdDataContractImporter クラス（UT-SRS-001 〜 UT-SRS-028）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Import(XmlSchemaSet)メソッドはnull検証を行う | E-01 (L81-82) | ○ |
| C-02 | Import(XmlSchemaSet, ICollection)メソッドはtypeNames null検証を行う | E-01 (L98-99) | ○ |
| C-03 | Import(XmlSchemaSet, XmlQualifiedName)メソッドはtypeName null検証を行う | E-01 (L115-116) | ○ |
| C-04 | Import(XmlSchemaSet, XmlSchemaElement)メソッドはelement null検証を行う | E-01 (L135-136) | ○ |
| C-05 | CanImport(XmlSchemaSet)メソッドはnull検証を行う | E-01 (L152-153) | ○ |
| C-06 | CanImport(XmlSchemaSet, ICollection)メソッドはtypeNames null検証を行う | E-01 (L170-171) | ○ |
| C-07 | CanImport(XmlSchemaSet, XmlQualifiedName)メソッドはtypeName null検証を行う | E-01 (L188-189) | ○ |
| C-08 | CanImport(XmlSchemaSet, XmlSchemaElement)メソッドはelement null検証を行う | E-01 (L206-207) | ○ |
| C-09 | GetCodeTypeReference(XmlQualifiedName)メソッドは型参照を返す | E-01 (L219-224) | ○ |
| C-10 | GetCodeTypeReference(XmlQualifiedName, XmlSchemaElement)メソッドはelement null検証を行う | E-01 (L235-238) | ○ |
| C-11 | GetKnownTypeReferences(XmlQualifiedName)メソッドはtypeName null検証を行う | E-01 (L268-269) | ○ |
| C-12 | CodeCompileUnitプロパティは遅延初期化される | E-01 (L63) | ○ |
| C-13 | コンストラクタでCodeCompileUnitを受け取れる | E-01 (L50-53) | ○ |
| C-14 | Optionsプロパティでget/set可能 | E-01 (L58) | ○ |
| C-15 | FindDataContractメソッドはtypeName null検証を行う | E-01 (L247-248) | ○ |
| C-16 | ImportActualTypeメソッドはアノテーションを処理する | E-01 (L363-376) | ○ |
| C-17 | ImportActualTypeメソッドはName属性がない場合例外をスローする | E-01 (L370-371) | ○ |

### ImportOptions クラス（UT-SRS-029 〜 UT-SRS-037）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | CodeProviderプロパティでget/set可能 | E-02 (L22) | ○ |
| C-19 | EnableDataBindingプロパティでget/set可能 | E-02 (L27) | ○ |
| C-20 | GenerateInternalプロパティでget/set可能 | E-02 (L41) | ○ |
| C-21 | GenerateSerializableプロパティでget/set可能 | E-02 (L46) | ○ |
| C-22 | ImportXmlTypeプロパティでget/set可能 | E-02 (L51) | ○ |
| C-23 | Namespacesプロパティは遅延初期化される | E-02 (L56) | ○ |
| C-24 | ReferencedCollectionTypesプロパティは遅延初期化される | E-02 (L61) | ○ |
| C-25 | ReferencedTypesプロパティは遅延初期化される | E-02 (L66) | ○ |
| C-26 | DataContractSurrogateプロパティでget/set可能 | E-02 (L36) | ○ |

### SchemaImportHelper クラス（UT-SRS-038 〜 UT-SRS-053）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | IsTypeNullableメソッドは参照型でtrueを返す | E-04 (L59-63) | ○ |
| C-28 | IsTypeNullableメソッドは値型でfalseを返す | E-04 (L59-63) | ○ |
| C-29 | IsTypeNullableメソッドはNullable<T>でtrueを返す | E-04 (L62-63) | ○ |
| C-30 | GetCollectionNamespaceメソッドは組み込み名前空間を変換する | E-04 (L66-69) | ○ |
| C-31 | GetDataContractNamespaceFromUriメソッドはプレフィックスを除去する | E-04 (L71-74) | ○ |
| C-32 | GetDefaultXmlNamespaceメソッドはCLR名前空間からXML名前空間を生成する | E-04 (L76-79) | ○ |
| C-33 | IsBuiltInNamespaceメソッドはSchemaNamespaceを組み込みと判定する | E-04 (L81-84) | ○ |
| C-34 | EncodeLocalNameメソッドはASCII名をそのまま返す | E-04 (L87-95) | ○ |
| C-35 | EncodeLocalNameメソッドは無効な文字をエンコードする | E-04 (L95) | ○ |

### ContractCodeDomInfo クラス（UT-SRS-054 〜 UT-SRS-062）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | ClrNamespaceプロパティはReferencedTypeExistsがtrueの場合nullを返す | E-05 (L25) | ○ |
| C-37 | ClrNamespaceプロパティはReferencedTypeExistsがtrueの場合設定時に例外をスローする | E-05 (L28-29) | ○ |
| C-38 | GetMemberNamesメソッドはHashSetを遅延初期化する | E-05 (L47-52) | ○ |
| C-39 | GetMemberNamesメソッドはReferencedTypeExistsがtrueの場合例外をスローする | E-05 (L49-50) | ○ |
| C-40 | AddMemberNameメソッドは新しい名前を追加する | E-05 (L55-62) | ○ |
| C-41 | IsProcessedプロパティでget/set可能 | E-05 (L37) | ○ |
| C-42 | TypeDeclarationプロパティでget/set可能 | E-05 (L41) | ○ |
| C-43 | TypeReferenceプロパティでget/set可能 | E-05 (L43) | ○ |

### DiagnosticUtility/Fx クラス（UT-SRS-063 〜 UT-SRS-071）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | IsFatalメソッドはOutOfMemoryExceptionをfatalと判定する | E-06 (L18) | ○ |
| C-45 | IsFatalメソッドはInsufficientMemoryExceptionをnot fatalと判定する | E-06 (L18) | ○ |
| C-46 | IsFatalメソッドはThreadAbortExceptionをfatalと判定する | E-06 (L19) | ○ |
| C-47 | IsFatalメソッドはTypeInitializationExceptionのInnerExceptionを検査する | E-06 (L27-31) | ○ |
| C-48 | IsFatalメソッドはAggregateExceptionのInnerExceptionsを検査する | E-06 (L32-46) | ○ |
| C-49 | ThrowHelperArgumentNullメソッドはArgumentNullExceptionを返す | E-06 (L75-78) | ○ |
| C-50 | ThrowHelperErrorメソッドは渡された例外をそのまま返す | E-06 (L80-83) | ○ |
| C-51 | ThrowHelperArgumentメソッドはArgumentExceptionを返す | E-06 (L85-88) | ○ |

### DataContractExtensions クラス（UT-SRS-072 〜 UT-SRS-080）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | GetContractTypeメソッドはContractTypeプロパティからDataContractType enumを返す | E-04 (L22-30) | ○ |
| C-53 | Isメソッドは型が一致する場合trueを返す | E-04 (L32-35) | ○ |
| C-54 | Asメソッドは型が一致する場合DataContractを返す | E-04 (L37-42) | ○ |
| C-55 | IsItemTypeNullableメソッドはCollectionDataContractのアイテム型をチェックする | E-04 (L45-54) | ○ |

### ISerializationCodeDomSurrogateProvider インターフェース（UT-SRS-081）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | ProcessImportedTypeメソッドが定義されている | E-07 (L22) | ○ |

### ImportGlobals クラス（UT-SRS-082 〜 UT-SRS-088）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | SerializerTrimmerWarning定数が定義されている | E-03 (L13-14) | ○ |
| C-58 | DataContractXsdBaseNamespace定数が定義されている | E-03 (L26) | ○ |
| C-59 | SchemaNamespace定数が定義されている | E-03 (L73) | ○ |
| C-60 | SerializationNamespace定数が定義されている | E-03 (L77) | ○ |
| C-61 | DataContractXsdBaseNamespaceUriプロパティは遅延初期化される | E-03 (L87) | ○ |
| C-62 | IdQualifiedNameプロパティは遅延初期化される | E-03 (L88) | ○ |
| C-63 | RefQualifiedNameプロパティは遅延初期化される | E-03 (L89) | ○ |

### CodeExporter クラス（UT-SRS-089 〜 UT-SRS-093）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | コンストラクタで参照アセンブリが追加される | E-08 (L45, L119-138) | ○ |
| C-65 | Exportメソッドがデータコントラクトからコードを生成する | E-08 (L207-257) | ○ |
| C-66 | GetCodeTypeReferenceメソッドが型参照を返す | E-08 (L305-316) | ○ |
| C-67 | GetElementTypeReferenceメソッドがnullable対応型参照を返す | E-08 (L360-366) | ○ |
| C-68 | GetKnownTypeReferencesメソッドが既知の型参照リストを返す | E-08 (L896-912) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースがソースコードに基づいて生成されている。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全てのテストケースがソースコードの実装に基づいており、メソッドシグネチャ・null検証・例外処理が確認できる。

### 注意点
1. **内部クラス（internal）のテスト**：CodeExporter、ContractCodeDomInfo、SchemaImportHelper、DataContractExtensions、Fxなどはinternal修飾子を持つため、InternalsVisibleToを設定するか、リフレクションを使用したテストが必要。
2. **RequiresUnreferencedCode属性**：多くのメソッドにトリマー警告属性が付与されており、AOTコンパイル時の動作テストも考慮が必要。
3. **依存関係**：XsdDataContractImporterはDataContractSet、DataContractなど多くの外部クラスに依存しており、モック化が必要な場合がある。

## 6) レビュアーチェックリスト（最小）
- [ ] XsdDataContractImporterのImportメソッド群のnull検証テストが網羅されているか
- [ ] CanImportメソッドのtrue/false両方のケースがカバーされているか
- [ ] ImportOptionsの全プロパティに対するテストが含まれているか
- [ ] SchemaImportHelperのヘルパーメソッドの境界値テストが適切か
- [ ] ContractCodeDomInfoのReferencedTypeExists条件分岐がテストされているか
- [ ] Fx.IsFatalのラップ例外（TypeInitializationException、AggregateException）のテストが含まれているか
- [ ] CodeExporterの主要メソッド（Export、GetCodeTypeReference）がテストされているか
- [ ] internalクラスのテスト方法（InternalsVisibleToまたはリフレクション）が検討されているか
