---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 190
  claims_with_evidence: 185
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Runtime.Serialization.Xml.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：185 / 190、根拠なし：5
- 優先レビュー（高）
  1. **DataContractResolver関連テスト（C-10, C-16）**：カスタムリゾルバの動作仕様を実装から推測
  2. **XPathQueryGenerator（C-65）**：使用例が限定的でテストケースが推測的
  3. **DataContractSet（C-69, C-70）**：内部クラスのため公開APIのテスト観点が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime.Serialization.Xml/ref/System.Runtime.Serialization.Xml.cs` - 公開API定義
- E-02: `src/libraries/System.Runtime.Serialization.Xml/ref/System.Runtime.Serialization.Xml.Forwards.cs` - 型転送定義
- E-03: `src/libraries/System.Runtime.Serialization.Xml/src/System.Runtime.Serialization.Xml.csproj` - プロジェクト構成
- E-04: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/DataContractSerializer.cs` - DataContractSerializer実装
- E-05: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/XmlObjectSerializer.cs` - XmlObjectSerializer実装
- E-06: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/DataContractSerializerSettings.cs` - DataContractSerializerSettings実装
- E-07: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/XsdDataContractExporter.cs` - XsdDataContractExporter実装
- E-08: `src/libraries/System.Private.DataContractSerialization/src/System/Runtime/Serialization/XmlSerializableServices.cs` - XmlSerializableServices実装
- E-09: `src/libraries/System.Private.DataContractSerialization/src/System/Xml/UniqueId.cs` - UniqueId実装
- E-10: `src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionaryReaderQuotas.cs` - XmlDictionaryReaderQuotas実装
- E-11: `src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionary.cs` - XmlDictionary実装
- E-12: `src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlBinaryWriterSession.cs` - XmlBinaryWriterSession実装
- E-13: `src/libraries/System.Private.DataContractSerialization/src/System/Xml/XmlDictionaryReader.cs` - XmlDictionaryReader実装

## 3) Claims と根拠の対応（レビューの主戦場）

### DataContractSerializer関連（C-01 〜 C-29）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型を指定してシリアライザを生成できること | E-04 (line 66-69) | ○ |
| C-02 | null型でArgumentNullExceptionがスローされること | E-04 (line 124) | ○ |
| C-03 | 既知の型を指定してシリアライザを生成できること | E-04 (line 71-74) | ○ |
| C-04 | 設定を指定してシリアライザを生成できること | E-04 (line 108-113) | ○ |
| C-05 | ルート名と名前空間を指定して生成できること | E-04 (line 76-78, 86-91) | ○ |
| C-06 | オブジェクトをストリームにシリアライズできること | E-05 (line 33-40) | ○ |
| C-07 | nullストリームでArgumentNullExceptionがスローされること | E-05 (line 35) | ○ |
| C-08 | XmlWriterを使用してシリアライズできること | E-04 (line 255-258) | ○ |
| C-09 | XmlDictionaryWriterを使用してシリアライズできること | E-04 (line 283-286) | ○ |
| C-10 | DataContractResolverを使用してシリアライズできること | E-04 (line 302-307) | △ |
| C-11 | ストリームからオブジェクトをデシリアライズできること | E-05 (line 270-275) | ○ |
| C-12 | nullストリームでArgumentNullExceptionがスローされること | E-05 (line 272) | ○ |
| C-13 | XmlReaderからデシリアライズできること | E-04 (line 311-314) | ○ |
| C-14 | オブジェクト名検証付きでデシリアライズできること | E-04 (line 316-321) | ○ |
| C-15 | 不正なオブジェクト名でSerializationExceptionがスローされること | E-04 (line 468-483) | ○ |
| C-16 | DataContractResolverを使用してデシリアライズできること | E-04 (line 344-349) | △ |
| C-17 | 開始オブジェクトの場合trueを返すこと | E-04 (line 325-328) | ○ |
| C-18 | 開始オブジェクトでない場合falseを返すこと | E-04 (line 508-511) | ○ |
| C-19 | オブジェクトの開始要素を書き込めること | E-04 (line 262-265) | ○ |
| C-20 | オブジェクトのコンテンツを書き込めること | E-04 (line 269-272) | ○ |
| C-21 | 開始要素がない状態でSerializationExceptionがスローされること | E-05 (line 188-189) | ○ |
| C-22 | オブジェクトの終了要素を書き込めること | E-04 (line 276-279) | ○ |
| C-23 | MaxItemsInObjectGraphプロパティが取得できること | E-04 (line 191-194) | ○ |
| C-24 | MaxItemsInObjectGraph=0でシリアライズ時にExceptionがスローされること | E-04 (line 369-370) | ○ |
| C-25 | KnownTypesコレクションが取得できること | E-04 (line 162-171) | ○ |
| C-26 | PreserveObjectReferencesプロパティが取得できること | E-04 (line 202-205) | ○ |
| C-27 | IgnoreExtensionDataObjectプロパティが取得できること | E-04 (line 207-210) | ○ |
| C-28 | DataContractResolverプロパティが取得できること | E-04 (line 212-215) | ○ |
| C-29 | SerializeReadOnlyTypesプロパティが取得できること | E-04 (line 217-220) | ○ |

### DataContractSerializerSettings関連（C-30 〜 C-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | デフォルトコンストラクタで初期化できること | E-06 (line 13-15) | ○ |
| C-31 | RootNameプロパティを設定・取得できること | E-06 (line 20) | ○ |
| C-32 | RootNamespaceプロパティを設定・取得できること | E-06 (line 25) | ○ |
| C-33 | KnownTypesプロパティを設定・取得できること | E-06 (line 30) | ○ |
| C-34 | MaxItemsInObjectGraphプロパティを設定・取得できること | E-06 (line 35-39) | ○ |
| C-35 | 負の値でArgumentOutOfRangeExceptionがスローされること | E-04 (line 137) | ○ |
| C-36 | サロゲートプロバイダを取得できること | E-01 (line 79) | ○ |
| C-37 | サロゲートプロバイダを設定できること | E-01 (line 80) | ○ |

### XmlObjectSerializer関連（C-38 〜 C-40）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | オブジェクトをストリームに書き込めること | E-05 (line 33-40) | ○ |
| C-39 | ストリームからオブジェクトを読み取れること | E-05 (line 270-275) | ○ |
| C-40 | XmlDictionaryReaderから読み取れること | E-05 (line 286-291) | ○ |

### XmlSerializableServices関連（C-41 〜 C-47）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | XMLノードを読み取れること | E-08 (line 12-45) | ○ |
| C-42 | nullリーダーでArgumentNullExceptionがスローされること | E-08 (line 14) | ○ |
| C-43 | XMLノードを書き込めること | E-08 (line 55-63) | ○ |
| C-44 | nullライターでArgumentNullExceptionがスローされること | E-08 (line 57) | ○ |
| C-45 | nullノード配列で何も書き込まれないこと | E-08 (line 59-62) | ○ |
| C-46 | デフォルトスキーマを追加できること | E-08 (line 66-72) | ○ |
| C-47 | nullスキーマセットでArgumentNullExceptionがスローされること | E-08 (line 68) | ○ |

### XsdDataContractExporter関連（C-48 〜 C-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | デフォルトコンストラクタで初期化できること | E-07 (line 39-41) | ○ |
| C-49 | スキーマセットを指定して初期化できること | E-07 (line 47-50) | ○ |
| C-50 | 型をスキーマにエクスポートできること | E-07 (line 163-180) | ○ |
| C-51 | null型でArgumentNullExceptionがスローされること | E-07 (line 167) | ○ |
| C-52 | ジェネリック型パラメータを含む型でInvalidDataContractExceptionがスローされること | E-07 (line 93-96) | ○ |
| C-53 | 複数の型をエクスポートできること | E-07 (line 134-157) | ○ |
| C-54 | アセンブリ内の型をエクスポートできること | E-07 (line 104-128) | ○ |
| C-55 | エクスポート可能な型でtrueを返すこと | E-07 (line 378-401) | ○ |
| C-56 | エクスポート不可能な型でfalseを返すこと | E-07 (line 391-394) | ○ |
| C-57 | 型のスキーマ型名を取得できること | E-07 (line 187-199) | ○ |
| C-58 | 型のスキーマ型を取得できること | E-07 (line 206-218) | ○ |
| C-59 | ルート要素名を取得できること | E-07 (line 225-242) | ○ |
| C-60 | Schemasプロパティでスキーマセットを取得できること | E-07 (line 64-71) | ○ |
| C-61 | Optionsプロパティを設定・取得できること | E-07 (line 55-59) | ○ |
| C-62 | ExportOptionsデフォルトコンストラクタで初期化できること | E-01 (line 94-96) | ○ |
| C-63 | KnownTypesコレクションを取得できること | E-01 (line 98) | ○ |
| C-64 | DataContractSurrogateプロパティを設定・取得できること | E-01 (line 97) | ○ |

### XPathQueryGenerator関連（C-65）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | XPathクエリを生成できること | E-01 (line 166-174) | △ |

### DataContract関連（C-66 〜 C-70）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | 型のXML名を取得できること | E-01 (line 246-247) | ○ |
| C-67 | 組み込みデータコントラクトを取得できること | E-01 (line 243) | ○ |
| C-68 | 存在しない組み込み型でnullを返すこと | E-01 (line 243) | ○ |
| C-69 | DataContractSetコンストラクタで初期化できること | E-01 (line 253-255) | △ |
| C-70 | 型のデータコントラクトを取得できること | E-01 (line 262) | △ |

### UniqueId関連（C-71 〜 C-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | デフォルトコンストラクタでGUIDベースのIDが生成されること | E-09 (line 53-55) | ○ |
| C-72 | GUIDからUniqueIdを生成できること | E-09 (line 57-59) | ○ |
| C-73 | バイト配列からUniqueIdを生成できること | E-09 (line 61-63) | ○ |
| C-74 | null配列でArgumentNullExceptionがスローされること | E-09 (line 67) | ○ |
| C-75 | 16バイト未満の配列でArgumentExceptionがスローされること | E-09 (line 72-73) | ○ |
| C-76 | オフセット付きでバイト配列からUniqueIdを生成できること | E-09 (line 65-79) | ○ |
| C-77 | 負のオフセットでArgumentOutOfRangeExceptionがスローされること | E-09 (line 69) | ○ |
| C-78 | URN文字列からUniqueIdを生成できること | E-09 (line 81-92, 144-196) | ○ |
| C-79 | 任意の文字列からUniqueIdを生成できること | E-09 (line 81-92) | ○ |
| C-80 | null文字列でArgumentNullExceptionがスローされること | E-09 (line 83) | ○ |
| C-81 | 空文字列でFormatExceptionがスローされること | E-09 (line 85-86) | ○ |
| C-82 | 文字配列からUniqueIdを生成できること | E-09 (line 94-114) | ○ |
| C-83 | GUIDベースの場合trueを返すこと | E-09 (line 142) | ○ |
| C-84 | 非GUIDの場合falseを返すこと | E-09 (line 142) | ○ |
| C-85 | GUID形式の場合45を返すこと | E-09 (line 117-126, 14) | ○ |
| C-86 | 非GUID形式の場合文字列長を返すこと | E-09 (line 121-122) | ○ |
| C-87 | 文字配列に変換できること | E-09 (line 198-213) | ○ |
| C-88 | null配列でArgumentNullExceptionがスローされること | E-09 (line 200) | ○ |
| C-89 | 配列サイズ不足でArgumentOutOfRangeExceptionがスローされること | E-09 (line 208-209) | ○ |
| C-90 | 文字列表現を取得できること | E-09 (line 300-301) | ○ |
| C-91 | GUID形式の場合Guidを取得できること | E-09 (line 264-275) | ○ |
| C-92 | 非GUID形式の場合falseを返すこと | E-09 (line 264-275) | ○ |
| C-93 | バイト配列にGUIDを書き込めること | E-09 (line 277-298) | ○ |
| C-94 | 非GUID形式の場合falseを返すこと | E-09 (line 279) | ○ |
| C-95 | 同じGUIDで等価の場合trueを返すこと | E-09 (line 303-317) | ○ |
| C-96 | 異なるGUIDで等価でない場合falseを返すこと | E-09 (line 303-317) | ○ |
| C-97 | nullとの比較でfalseを返すこと | E-09 (line 308-309) | ○ |
| C-98 | ハッシュコードを取得できること | E-09 (line 329-340) | ○ |
| C-99 | 同じGUIDで等価の場合trueを返すこと（演算子） | E-09 (line 303-317) | ○ |
| C-100 | 異なるGUIDで不等価の場合trueを返すこと（演算子） | E-09 (line 319-322) | ○ |

### XmlDictionary関連（C-101 〜 C-119）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | デフォルトコンストラクタで初期化できること | E-11 (line 24-29) | ○ |
| C-102 | 初期容量を指定して初期化できること | E-11 (line 31-36) | ○ |
| C-103 | 文字列を追加できること | E-11 (line 38-60) | ○ |
| C-104 | 同じ文字列を追加すると同じインスタンスが返ること | E-11 (line 40-41) | ○ |
| C-105 | 存在する文字列でtrueを返すこと | E-11 (line 62-65) | ○ |
| C-106 | 存在しない文字列でfalseを返すこと | E-11 (line 62-65) | ○ |
| C-107 | 存在するキーでtrueを返すこと | E-11 (line 67-76) | ○ |
| C-108 | 存在しないキーでfalseを返すこと | E-11 (line 68-72) | ○ |
| C-109 | 負のキーでfalseを返すこと | E-11 (line 69) | ○ |
| C-110 | 同じDictionaryのXmlDictionaryStringでtrueを返すこと | E-11 (line 78-89) | ○ |
| C-111 | 別のDictionaryのXmlDictionaryStringでfalseを返すこと | E-11 (line 82-86) | ○ |
| C-112 | nullでArgumentNullExceptionがスローされること | E-11 (line 80) | ○ |
| C-113 | Emptyプロパティで空のIXmlDictionaryを取得できること | E-11 (line 22) | ○ |
| C-114 | XmlDictionaryStringコンストラクタで初期化できること | E-01 (line 540) | ○ |
| C-115 | Dictionaryプロパティを取得できること | E-01 (line 541) | ○ |
| C-116 | Valueプロパティを取得できること | E-01 (line 544) | ○ |
| C-117 | Keyプロパティを取得できること | E-01 (line 543) | ○ |
| C-118 | ToString()でValueと同じ文字列が返されること | E-01 (line 545) | ○ |
| C-119 | Emptyプロパティで空のXmlDictionaryStringを取得できること | E-01 (line 542) | ○ |

### XmlDictionaryReaderQuotas関連（C-120 〜 C-141）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | デフォルトコンストラクタで初期化できること | E-10 (line 37-44) | ○ |
| C-121 | Maxプロパティで最大値のQuotasを取得できること | E-10 (line 34-35, 57-63) | ○ |
| C-122 | MaxDepthプロパティを設定・取得できること | E-10 (line 138-153) | ○ |
| C-123 | MaxDepthのデフォルト値が32であること | E-10 (line 29, 39) | ○ |
| C-124 | MaxDepthで0以下の値でArgumentOutOfRangeExceptionがスローされること | E-10 (line 148) | ○ |
| C-125 | MaxDepthで読み取り専用の場合InvalidOperationExceptionがスローされること | E-10 (line 146-147) | ○ |
| C-126 | MaxStringContentLengthプロパティを設定・取得できること | E-10 (line 86-100) | ○ |
| C-127 | MaxStringContentLengthのデフォルト値が8192であること | E-10 (line 30, 40) | ○ |
| C-128 | MaxStringContentLengthで0以下の値でArgumentOutOfRangeExceptionがスローされること | E-10 (line 96) | ○ |
| C-129 | MaxArrayLengthプロパティを設定・取得できること | E-10 (line 103-117) | ○ |
| C-130 | MaxArrayLengthのデフォルト値が16384であること | E-10 (line 31, 41) | ○ |
| C-131 | MaxArrayLengthで0以下の値でArgumentOutOfRangeExceptionがスローされること | E-10 (line 113) | ○ |
| C-132 | MaxBytesPerReadプロパティを設定・取得できること | E-10 (line 120-135) | ○ |
| C-133 | MaxBytesPerReadのデフォルト値が4096であること | E-10 (line 32, 42) | ○ |
| C-134 | MaxBytesPerReadで0以下の値でArgumentOutOfRangeExceptionがスローされること | E-10 (line 130) | ○ |
| C-135 | MaxNameTableCharCountプロパティを設定・取得できること | E-10 (line 156-171) | ○ |
| C-136 | MaxNameTableCharCountのデフォルト値が16384であること | E-10 (line 33, 43) | ○ |
| C-137 | MaxNameTableCharCountで0以下の値でArgumentOutOfRangeExceptionがスローされること | E-10 (line 166) | ○ |
| C-138 | ModifiedQuotasプロパティで変更されたクォータを取得できること | E-10 (line 173-179) | ○ |
| C-139 | CopyToでクォータをコピーできること | E-10 (line 65-83) | ○ |
| C-140 | CopyToでnullでArgumentNullExceptionがスローされること | E-10 (line 67) | ○ |
| C-141 | CopyToで読み取り専用のコピー先でInvalidOperationExceptionがスローされること | E-10 (line 69-70) | ○ |

### XmlBinaryReaderSession/WriterSession関連（C-142 〜 C-153）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | XmlBinaryReaderSessionデフォルトコンストラクタで初期化できること | E-01 (line 362) | ○ |
| C-143 | XmlBinaryReaderSession.Addでエントリを追加できること | E-01 (line 363) | ○ |
| C-144 | XmlBinaryReaderSession.TryLookup(int)で存在するIDでtrueを返すこと | E-01 (line 365) | ○ |
| C-145 | XmlBinaryReaderSession.TryLookup(int)で存在しないIDでfalseを返すこと | E-01 (line 365) | ○ |
| C-146 | XmlBinaryReaderSession.TryLookup(string)で存在する文字列でtrueを返すこと | E-01 (line 366) | ○ |
| C-147 | XmlBinaryReaderSession.TryLookup(XmlDictionaryString)でtrueを返すこと | E-01 (line 367) | ○ |
| C-148 | XmlBinaryReaderSession.Clearでセッションをクリアできること | E-01 (line 364) | ○ |
| C-149 | XmlBinaryWriterSessionデフォルトコンストラクタで初期化できること | E-12 (line 21-26) | ○ |
| C-150 | XmlBinaryWriterSession.TryAddでエントリを追加できること | E-12 (line 28-53) | ○ |
| C-151 | XmlBinaryWriterSession.TryAddでnullでArgumentNullExceptionがスローされること | E-12 (line 30) | ○ |
| C-152 | XmlBinaryWriterSession.TryAddで同じ値を2回追加するとInvalidOperationExceptionがスローされること | E-12 (line 40-42) | ○ |
| C-153 | XmlBinaryWriterSession.Resetでセッションをリセットできること | E-12 (line 69-74) | ○ |

### XmlDictionaryReader関連（C-154 〜 C-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | CreateDictionaryReaderでXmlReaderをラップできること | E-13 (line 22-27) | ○ |
| C-155 | 既にXmlDictionaryReaderの場合そのまま返すこと | E-13 (line 26) | ○ |
| C-156 | CreateDictionaryReaderでnullでArgumentNullExceptionがスローされること | E-13 (line 24) | ○ |
| C-157 | CreateBinaryReaderでバイナリリーダーを生成できること | E-13 (line 29-60) | ○ |
| C-158 | CreateBinaryReaderでnullバッファでArgumentNullExceptionがスローされること | E-13 (line 31) | ○ |
| C-159 | CreateBinaryReaderでストリームからバイナリリーダーを生成できること | E-13 (line 62-86) | ○ |
| C-160 | CreateTextReaderでテキストリーダーを生成できること | E-13 (line 88-108) | ○ |
| C-161 | CreateTextReaderでnullバッファでArgumentNullExceptionがスローされること | E-13 (line 90) | ○ |
| C-162 | CreateTextReaderでストリームからテキストリーダーを生成できること | E-13 (line 110-122) | ○ |
| C-163 | CreateMtomReaderでPlatformNotSupportedExceptionがスローされること | E-13 (line 144, 167) | ○ |
| C-164 | MoveToStartElementで開始要素に移動できること | E-13 (line 196-200) | ○ |
| C-165 | MoveToStartElementで開始要素でない場合XmlExceptionがスローされること | E-13 (line 198-199) | ○ |
| C-166 | ReadFullStartElementで完全な開始要素を読み取れること | E-13 (line 246-252) | ○ |
| C-167 | ReadFullStartElementで空要素でXmlExceptionがスローされること | E-13 (line 249-250) | ○ |
| C-168 | IsLocalNameでローカル名と一致する場合trueを返すこと | E-13 (line 220-223) | ○ |
| C-169 | IsNamespaceUriで名前空間URIと一致する場合trueを返すこと | E-13 (line 232-237) | ○ |
| C-170 | ReadContentAsGuidでGUIDコンテンツを読み取れること | E-01 (line 458) | ○ |
| C-171 | ReadContentAsUniqueIdでUniqueIdコンテンツを読み取れること | E-01 (line 465) | ○ |
| C-172 | ReadElementContentAsGuidで要素のGUIDを読み取れること | E-01 (line 479) | ○ |
| C-173 | ReadElementContentAsUniqueIdで要素のUniqueIdを読み取れること | E-01 (line 484) | ○ |
| C-174 | QuotasプロパティでQuotasを取得できること | E-13 (line 178-184) | ○ |
| C-175 | CanCanonicalizeプロパティでfalseを取得できること | E-13 (line 170-176) | ○ |

### XmlDictionaryWriter関連（C-176 〜 C-190）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-176 | CreateDictionaryWriterでXmlWriterをラップできること | E-01 (line 556) | ○ |
| C-177 | CreateBinaryWriterでバイナリライターを生成できること | E-01 (line 552) | ○ |
| C-178 | CreateBinaryWriterでディクショナリ付きバイナリライターを生成できること | E-01 (line 553) | ○ |
| C-179 | CreateTextWriterでテキストライターを生成できること | E-01 (line 559) | ○ |
| C-180 | CreateTextWriterでエンコーディング指定でテキストライターを生成できること | E-01 (line 560) | ○ |
| C-181 | CreateTextWriterでストリーム所有権指定でテキストライターを生成できること | E-01 (line 561) | ○ |
| C-182 | CreateMtomWriterでPlatformNotSupportedExceptionがスローされること | E-01 (line 557-558) | ○ |
| C-183 | WriteValue(Guid)でGUIDを書き込めること | E-01 (line 599) | ○ |
| C-184 | WriteValue(TimeSpan)でTimeSpanを書き込めること | E-01 (line 600) | ○ |
| C-185 | WriteValue(UniqueId)でUniqueIdを書き込めること | E-01 (line 602) | ○ |
| C-186 | WriteStartElementでXmlDictionaryStringで開始要素を書き込めること | E-01 (line 595-596) | ○ |
| C-187 | WriteAttributeStringでXmlDictionaryStringで属性を書き込めること | E-01 (line 585-586) | ○ |
| C-188 | WriteXmlnsAttributeでxmlns属性を書き込めること | E-01 (line 607-608) | ○ |
| C-189 | WriteArrayでint配列を書き込めること | E-01 (line 571) | ○ |
| C-190 | CanCanonicalizeプロパティでfalseを取得できること | E-01 (line 550) | ○ |

## 4) 不足情報（Unknown / Missing）
- **DataContractResolverの動作仕様**：カスタムリゾルバの使用例やテストケースの具体的な期待結果が実装からの推測に依存
  - 候補：既存テストファイルの参照 / WCFドキュメント / サンプルコード
- **XPathQueryGeneratorの使用例**：メンバーパスからXPathを生成する具体的なシナリオが限定的
  - 候補：WCFドキュメント / 実際の使用例
- **DataContractSetの内部動作**：公開APIとしての使用方法が不明確
  - 候補：System.Runtime.Serialization.Schemaモジュールの参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケース - 実装コードから直接確認可能
- **1（中リスク）**: C-10, C-16 - DataContractResolverの動作仕様
- **1（中リスク）**: C-65 - XPathQueryGeneratorの使用例が限定的
- **1（中リスク）**: C-69, C-70 - DataContractSetの公開API仕様

## 6) レビュアーチェックリスト（最小）
- [ ] DataContractSerializer.WriteObject/ReadObjectのシリアライズ/デシリアライズサイクルテストケースが十分か確認
- [ ] XmlDictionaryReaderQuotasの各クォータ値の境界値テストが適切か確認
- [ ] UniqueIdのGUID形式と非GUID形式の両方のテストカバレッジを確認
- [ ] XmlDictionary/XmlDictionaryStringの辞書操作テストが十分か確認
- [ ] MTOMサポート外（PlatformNotSupportedException）のテストケースが適切か確認
- [ ] DataContractResolverを使用するテストケースの期待結果が実装と一致するか確認
- [ ] XsdDataContractExporterのスキーマエクスポートテストが型の網羅性を満たしているか確認
