---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Runtime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたSystem.Runtimeライブラリの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストファイル・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 95 / 100 = 0.95
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-SRT-093 (Half)**: 一部のテストケースが既存テストファイルで明示的に確認されていない
  2. **UT-SRT-094 (Half.NaN)**: 特殊値の処理に関する詳細なテストケースの確認が必要
  3. **UT-SRT-084 (DependentHandle)**: ランタイム固有機能のためテスト条件の確認が必要
  4. **UT-SRT-085 (DependentHandle.Dispose)**: GC連携動作の確認が必要
  5. **UT-SRT-086-088 (SecureString)**: プラットフォーム依存の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/StringTests.cs`
- E-02: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/IndexTests.cs`
- E-03: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/RangeTests.cs`
- E-04: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/ArraySegmentTests.cs`
- E-05: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/HashCodeTests.cs`
- E-06: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/LazyTests.cs`
- E-07: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/ExceptionTests.cs`
- E-08: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/WeakReferenceTests.cs`
- E-09: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/Runtime/CompilerServices/RuntimeHelpersTests.cs`
- E-10: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/Runtime/CompilerServices/ConditionalWeakTableTests.cs`
- E-11: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/DelegateTests.cs`
- E-12: `src/libraries/System.Runtime/tests/System.IO.Tests/MemoryStream/MemoryStreamTests.cs`
- E-13: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/TimeZoneInfoTests.cs`
- E-14: `src/libraries/System.Runtime/tests/System.Reflection.Tests/AssemblyNameTests.cs`
- E-15: `src/libraries/System.Runtime/tests/System.Buffers.Tests/ArrayPool/ArrayPoolTest.cs`
- E-16: `src/libraries/System.Runtime/tests/System.ValueTuple.Tests/ValueTupleTests.cs`
- E-17: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/Runtime/ExceptionServices/ExceptionDispatchInfoTests.cs`
- E-18: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/Runtime/DependentHandleTests.cs`
- E-19: `src/libraries/System.Runtime/tests/System.Security.SecureString.Tests/SecureStringTests.cs`
- E-20: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/CharTests.cs`
- E-21: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/HalfTests.cs`
- E-22: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/Int128Tests.GenericMath.cs`
- E-23: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/UInt128Tests.GenericMath.cs`
- E-24: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/DateTimeOffsetTests.cs`
- E-25: `src/libraries/System.Runtime/tests/System.Runtime.Tests/System/TupleTests.cs`
- E-26: `src/libraries/System.Runtime/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | System.String Ctor(ReadOnlySpan<char>) - 空のSpanから空文字列生成 | E-01 | ○ |
| C-02 | System.String Ctor(ReadOnlySpan<char>) - 文字配列Span変換 | E-01 | ○ |
| C-03 | System.String Create - null action引数バリデーション | E-01 | ○ |
| C-04 | System.String Create - 負のlength引数バリデーション | E-01 | ○ |
| C-05 | System.String Create - length=0境界値 | E-01 | ○ |
| C-06 | System.String Create - null状態許容 | E-01 | ○ |
| C-07 | System.String Contains(char) - 含まれる文字検索 | E-01 | ○ |
| C-08 | System.String Contains(char) - 含まれない文字検索 | E-01 | ○ |
| C-09 | System.String Contains(char) - 空文字列境界値 | E-01 | ○ |
| C-10 | System.Index Ctor - FromStart値設定 | E-02 | ○ |
| C-11 | System.Index Ctor - FromEnd値設定 | E-02 | ○ |
| C-12 | System.Index Ctor - 負の値引数バリデーション | E-02 | ○ |
| C-13 | System.Index GetOffset - FromStart計算 | E-02 | ○ |
| C-14 | System.Index GetOffset - FromEnd計算 | E-02 | ○ |
| C-15 | System.Index Equals - 同値等価性 | E-02 | ○ |
| C-16 | System.Index Equals - 異FromEnd等価性 | E-02 | ○ |
| C-17 | System.Index ToString - FromStart表示 | E-02 | ○ |
| C-18 | System.Index ToString - FromEnd表示 | E-02 | ○ |
| C-19 | System.Range Ctor - Start/End設定 | E-03 | ○ |
| C-20 | System.Range StartAt - 開始位置指定 | E-03 | ○ |
| C-21 | System.Range EndAt - 終了位置指定 | E-03 | ○ |
| C-22 | System.Range All - 全範囲 | E-03 | ○ |
| C-23 | System.Range GetOffsetAndLength - 正常計算 | E-03 | ○ |
| C-24 | System.Range GetOffsetAndLength - 長さ不足例外 | E-03 | ○ |
| C-25 | System.Range Equals - 等価性 | E-03 | ○ |
| C-26 | ArraySegment Ctor - 配列/オフセット/カウント設定 | E-04 | ○ |
| C-27 | ArraySegment Ctor - null配列バリデーション | E-04 | ○ |
| C-28 | ArraySegment Ctor - 負のオフセットバリデーション | E-04 | ○ |
| C-29 | ArraySegment CopyTo - defaultセグメント例外 | E-04 | ○ |
| C-30 | ArraySegment Empty - 空配列セグメント | E-04 | ○ |
| C-31 | ArraySegment GetEnumerator - 型確認 | E-04 | ○ |
| C-32 | ArraySegment GetEnumerator - default例外 | E-04 | ○ |
| C-33 | HashCode Add - 複数値ハッシュ計算 | E-05 | ○ |
| C-34 | HashCode Add - 同値同結果 | E-05 | ○ |
| C-35 | HashCode Add<T> - null許容 | E-05 | ○ |
| C-36 | HashCode Add - カスタムコンペアラ | E-05 | ○ |
| C-37 | HashCode AddBytes - バイト配列ハッシュ | E-05 | ○ |
| C-38 | Lazy<T> Ctor - IsValueCreated初期値 | E-06 | ○ |
| C-39 | Lazy<T> Ctor(Func<T>) - ファクトリ関数 | E-06 | ○ |
| C-40 | Lazy<T> Ctor(Func<T>) - nullファクトリ例外 | E-06 | ○ |
| C-41 | Lazy<T> Ctor(LazyThreadSafetyMode) - 無効モード例外 | E-06 | ○ |
| C-42 | Lazy<T> ToString - Value未作成時 | E-06 | ○ |
| C-43 | Lazy<T> Value - 再帰呼び出し例外 | E-06 | ○ |
| C-44 | Exception Ctor - デフォルトコンストラクタ | E-07 | ○ |
| C-45 | Exception Ctor(string) - メッセージ設定 | E-07 | ○ |
| C-46 | Exception Ctor(string, Exception) - 内部例外設定 | E-07 | ○ |
| C-47 | Exception GetBaseException - 最内部例外取得 | E-07 | ○ |
| C-48 | Exception TargetSite - スロー元メソッド取得 | E-07 | ○ |
| C-49 | WeakReference Ctor - 弱参照作成 | E-08 | ○ |
| C-50 | WeakReference Target - GC後null | E-08 | ○ |
| C-51 | WeakReference<T> TryGetTarget - 有効参照取得 | E-08 | ○ |
| C-52 | WeakReference<T> SetTarget - ターゲット更新 | E-08 | ○ |
| C-53 | RuntimeHelpers GetHashCode - ID系ハッシュ | E-09 | ○ |
| C-54 | RuntimeHelpers GetHashCode - null処理 | E-09 | ○ |
| C-55 | RuntimeHelpers GetObjectValue - ボックス化 | E-09 | ○ |
| C-56 | RuntimeHelpers Equals - 値型等価性 | E-09 | ○ |
| C-57 | RuntimeHelpers RunClassConstructor - 型初期化 | E-09 | ○ |
| C-58 | RuntimeHelpers PrepareMethod - JIT準備 | E-09 | ○ |
| C-59 | ConditionalWeakTable Add - nullキー例外 | E-10 | ○ |
| C-60 | ConditionalWeakTable Add - 重複キー例外 | E-10 | ○ |
| C-61 | ConditionalWeakTable TryGetValue - 値取得 | E-10 | ○ |
| C-62 | ConditionalWeakTable TryAdd - 条件付き追加 | E-10 | ○ |
| C-63 | ConditionalWeakTable GetOrAdd - 取得・追加 | E-10 | ○ |
| C-64 | Delegate DynamicInvoke - 動的呼び出し | E-11 | ○ |
| C-65 | Delegate DynamicInvoke - ref/out引数 | E-11 | ○ |
| C-66 | MemoryStream WriteTo - ストリームコピー | E-12 | ○ |
| C-67 | MemoryStream WriteTo - null例外 | E-12 | ○ |
| C-68 | MemoryStream WriteTo - 読み取り専用例外 | E-12 | ○ |
| C-69 | MemoryStream Seek - オーバーフロー例外 | E-12 | ○ |
| C-70 | TimeZoneInfo FindSystemTimeZoneById - タイムゾーン取得 | E-13 | ○ |
| C-71 | TimeZoneInfo Local - ローカルタイムゾーン | E-13 | ○ |
| C-72 | TimeZoneInfo Utc - UTCタイムゾーン | E-13 | ○ |
| C-73 | AssemblyName Ctor - デフォルトコンストラクタ | E-14 | ○ |
| C-74 | AssemblyName Ctor(string) - 名前からの作成 | E-14 | ○ |
| C-75 | AssemblyName Ctor(string) - null例外 | E-14 | ○ |
| C-76 | AssemblyName Ctor(string) - 空文字例外 | E-14 | ○ |
| C-77 | ArrayPool Rent - 配列レンタル | E-15 | ○ |
| C-78 | ArrayPool Return - 配列返却 | E-15 | ○ |
| C-79 | ValueTuple Create - ファクトリメソッド | E-16 | ○ |
| C-80 | ValueTuple Equals - 等価性 | E-16 | ○ |
| C-81 | ValueTuple CompareTo - 比較 | E-16 | ○ |
| C-82 | ExceptionDispatchInfo Capture - キャプチャ | E-17 | ○ |
| C-83 | ExceptionDispatchInfo Throw - 再スロー | E-17 | ○ |
| C-84 | DependentHandle Ctor - ターゲット/Dependent設定 | E-18 | △ |
| C-85 | DependentHandle Dispose - リソース解放 | E-18 | △ |
| C-86 | SecureString AppendChar - 文字追加 | E-19 | ○ |
| C-87 | SecureString MakeReadOnly - 読み取り専用化 | E-19 | ○ |
| C-88 | SecureString AppendChar - 読み取り専用例外 | E-19 | ○ |
| C-89 | Char IsDigit - 数字判定 | E-20 | ○ |
| C-90 | Char IsLetter - 文字判定 | E-20 | ○ |
| C-91 | Char ToUpper - 大文字変換 | E-20 | ○ |
| C-92 | Char ToLower - 小文字変換 | E-20 | ○ |
| C-93 | Half Ctor - 型変換 | E-21 | △ |
| C-94 | Half NaN - 特殊値判定 | E-21 | △ |
| C-95 | Int128 Parse - 文字列パース | E-22 | ○ |
| C-96 | UInt128 Parse - 文字列パース | E-23 | ○ |
| C-97 | DateTimeOffset Ctor - 作成 | E-24 | ○ |
| C-98 | DateTimeOffset UtcNow - 現在UTC時刻 | E-24 | ○ |
| C-99 | Tuple Create - ファクトリメソッド | E-25 | ○ |
| C-100 | Tuple Equals - 等価性 | E-25 | △ |

## 4) 不足情報（Unknown / Missing）
- **DependentHandle (C-84, C-85)**: ランタイム内部機能であり、詳細なテストケースの確認が必要。プラットフォーム固有の動作確認が推奨される。
  - 候補：System.Runtime.DependentHandleTests.cs / CoreCLR内部実装
- **Half型の特殊値 (C-93, C-94)**: IEEE 754半精度浮動小数点の特殊値処理に関する詳細テストの確認が必要。
  - 候補：HalfTests.cs / System.Numerics関連テスト
- **Tuple.Equals (C-100)**: 参照型要素を含むTupleの等価性判定に関する詳細確認が推奨される。
  - 候補：TupleTests.cs / IStructuralEquatable実装

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: String, Index, Range, ArraySegment - 基本的な型で既存テストが充実
- **0（低リスク）**: HashCode, Lazy - 明確なテストケースが存在
- **1（中リスク）**: RuntimeHelpers, ConditionalWeakTable - ランタイム機能のためプラットフォーム依存の可能性
- **1（中リスク）**: TimeZoneInfo - プラットフォーム/ロケール依存
- **1（中リスク）**: Half, Int128, UInt128 - 新しい数値型で一部テストカバレッジに不確実性
- **2（高リスク）**: DependentHandle - ランタイム内部機能で詳細なテストケースの確認が困難

## 6) レビュアーチェックリスト（最小）
- [ ] System.String関連テストケース(UT-SRT-001〜009)が実際のStringTests.csのテストパターンと整合しているか
- [ ] System.Index/Range関連テストケース(UT-SRT-010〜025)の境界値テストが網羅されているか
- [ ] ArraySegment関連テストケース(UT-SRT-026〜032)のdefault値処理が正確か
- [ ] HashCode関連テストケース(UT-SRT-033〜037)のハッシュ計算ロジックが妥当か
- [ ] Lazy<T>関連テストケース(UT-SRT-038〜043)のスレッドセーフティモードが網羅されているか
- [ ] Exception関連テストケース(UT-SRT-044〜048)のスタックトレース保持が検証されているか
- [ ] WeakReference関連テストケース(UT-SRT-049〜052)のGC連携テストが有効か
- [ ] RuntimeHelpers関連テストケース(UT-SRT-053〜058)がランタイム実装と整合するか
- [ ] ConditionalWeakTable関連テストケース(UT-SRT-059〜063)のメモリリーク検証が含まれているか
- [ ] DependentHandle関連テストケース(UT-SRT-084〜085)のプラットフォーム依存性を確認
- [ ] SecureString関連テストケース(UT-SRT-086〜088)の非推奨API使用について検討
- [ ] Half/Int128/UInt128関連テストケース(UT-SRT-093〜096)の数値精度が検証されているか
