---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 230
  claims_with_evidence: 228
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Security.AccessControl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：228 / 230、根拠なし：2
- 優先レビュー（高）
  1. **Privilege.Enable/Revert のスレッド安全性テスト**：実行環境依存のため実際の動作確認が必要
  2. **NativeObjectSecurity のWin32 API連携テスト**：Windows環境でのみ実行可能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/ACE.cs`
- E-02: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/ACL.cs`
- E-03: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/SecurityDescriptor.cs`
- E-04: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/Rules.cs`
- E-05: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/ObjectSecurity.cs`
- E-06: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/ObjectSecurityT.cs`
- E-07: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/CommonObjectSecurity.cs`
- E-08: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/NativeObjectSecurity.cs`
- E-09: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/Privilege.cs`
- E-10: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/PrivilegeNotHeldException.cs`
- E-11: `src/libraries/System.Security.AccessControl/src/System/Security/AccessControl/Enums.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ACE（Access Control Entry）関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GenericAce.CreateFromBinaryFormはバイナリからACEを生成する | E-01 (270-382行) | ○ |
| C-02 | GenericAce.Copyはバイナリ形式経由で複製を作成する | E-01 (513-524行) | ○ |
| C-03 | GenericAce.Equalsはバイナリ比較で等価性を判定する | E-01 (526-555行) | ○ |
| C-04 | GenericAce.GetHashCodeはバイナリを4バイト単位でXORする | E-01 (557-582行) | ○ |
| C-05 | CommonAceはAccessAllowed/Denied/Audit/Alarmの4タイプをサポート | E-01 (1327-1592行) | ○ |
| C-06 | ObjectAceはGUID付きACEをサポートし、GUIDの有無でBinaryLengthが変化 | E-01 (1686-2144行) | ○ |
| C-07 | CompoundAceはImpersonationタイプのみサポート | E-01 (873-1041行) | ○ |
| C-08 | CustomAceは定義済みACEタイプ以外のみ受け付ける | E-01 (729-746行) | ○ |
| C-09 | KnownAce.SecurityIdentifierはnullを許容しない | E-01 (687-692行) | ○ |
| C-10 | QualifiedAce.SetOpaqueは4の倍数でない長さを拒否する | E-01 (1245-1264行) | ○ |

### ACL（Access Control List）関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | RawAclはバイナリ形式から生成可能 | E-02 (403-407行) | ○ |
| C-12 | RawAcl.InsertAceはMaxBinaryLength超過時にOverflowException | E-02 (542-552行) | ○ |
| C-13 | RawAcl.RemoveAceは指定インデックスのACEを削除 | E-02 (558-561行) | ○ |
| C-14 | GenericAcl.IsSynchronizedは常にfalseを返す | E-02 (195-198行) | ○ |
| C-15 | GenericAcl.SyncRootはthisを返す | E-02 (200-203行) | ○ |
| C-16 | AceEnumeratorは列挙開始前のCurrentアクセスで例外をスロー | E-02 (52-64行) | ○ |

### Security Descriptor関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | RawSecurityDescriptorはSDDL文字列から生成可能 | E-03 (452-455行) | ○ |
| C-18 | RawSecurityDescriptorはリビジョン1のみサポート | E-03 (488-492行) | ○ |
| C-19 | RawSecurityDescriptorは自己相対形式のみサポート | E-03 (516-521行) | ○ |
| C-20 | RawSecurityDescriptor.SetFlagsはSelfRelativeを強制追加 | E-03 (785-793行) | ○ |
| C-21 | CommonSecurityDescriptorはnull DACLでEveryoneFullAccessを設定 | E-03 (869行) | ○ |
| C-22 | CommonSecurityDescriptor.SetSystemAclProtectionは継承ACE削除を制御 | E-03 (1137-1152行) | ○ |
| C-23 | CommonSecurityDescriptor.SetDiscretionaryAclProtectionは継承ACE削除を制御 | E-03 (1154-1173行) | ○ |
| C-24 | CommonSecurityDescriptor.PurgeAccessControlはnull SIDで例外をスロー | E-03 (1175-1180行) | ○ |

### Rules（AuthorizationRule、AccessRule、AuditRule）関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | AuthorizationRuleはnull identityで例外をスロー | E-04 (40行) | ○ |
| C-26 | AuthorizationRuleはaccessMask=0で例外をスロー | E-04 (42-45行) | ○ |
| C-27 | AuthorizationRuleはInheritanceFlags=Noneの場合PropagationFlagsを0にする | E-04 (71-78行) | ○ |
| C-28 | AccessRuleはAllow/Deny以外のtypeで例外をスロー | E-04 (133-137行) | ○ |
| C-29 | AuditRuleはAuditFlags=Noneで例外をスロー | E-04 (245-248行) | ○ |
| C-30 | ObjectAccessRuleは空GUIDでObjectAceTypePresentを設定しない | E-04 (182-190行) | ○ |
| C-31 | AuthorizationRuleCollectionはルールの追加が可能 | E-04 (344-347行) | ○ |

### ObjectSecurity関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | ObjectSecurityはReaderWriterLockSlimでスレッド安全性を提供 | E-05 (35行) | ○ |
| C-33 | ObjectSecurity.GetOwnerはOwner nullでnullを返す | E-05 (336-352行) | ○ |
| C-34 | ObjectSecurity.SetOwnerはnull identityで例外をスロー | E-05 (357行) | ○ |
| C-35 | ObjectSecurity.OwnerModifiedはロック無しアクセスで例外をスロー | E-05 (169-177行) | ○ |
| C-36 | ObjectSecurity.SetSecurityDescriptorSddlFormはsections=Noneで例外をスロー | E-05 (572-577行) | ○ |

### CommonObjectSecurity関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | CommonObjectSecurityはDACLが無い場合に自動生成する | E-07 (234-246行) | ○ |
| C-38 | CommonObjectSecurity.ModifyAccessはAccessControlModificationに応じた操作を実行 | E-07 (225-346行) | ○ |
| C-39 | CommonObjectSecurity.GetAccessRulesは無効なtargetTypeで例外をスロー | E-07 (55-68行) | ○ |

### NativeObjectSecurity関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | NativeObjectSecurityはWin32 APIを呼び出してセキュリティ情報を取得 | E-08 (97-175行) | ○ |
| C-41 | NativeObjectSecurity.PersistはWin32 APIを呼び出してセキュリティ情報を設定 | E-08 (181-328行) | ○ |

### Privilege関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Privilegeはnull特権名で例外をスロー | E-09 (363行) | ○ |
| C-43 | Privilege.EnableはRevert前の再呼び出しで例外をスロー | E-09 (413-416行) | ○ |
| C-44 | Privilege.EnableとRevertは同一スレッドでのみ実行可能 | E-09 (404-407行, 515-518行) | ○ |
| C-45 | Privilege.Enableは特権未保持時にPrivilegeNotHeldExceptionをスロー | E-09 (491-493行) | ○ |
| C-46 | PrivilegeNotHeldExceptionはUnauthorizedAccessExceptionを継承 | E-10 (13行) | ○ |

### ジェネリッククラス（AccessRule<T>、AuditRule<T>、ObjectSecurity<T>）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | AccessRule<T>.Rightsはジェネリック型にキャストして返す | E-06 (114-117行) | ○ |
| C-48 | AuditRule<T>.Rightsはジェネリック型にキャストして返す | E-06 (205-208行) | ○ |
| C-49 | ObjectSecurity<T>.AccessRightTypeはtypeof(T)を返す | E-06 (401-404行) | ○ |
| C-50 | ObjectSecurity<T>.AccessRuleTypeはtypeof(AccessRule<T>)を返す | E-06 (406-409行) | ○ |

### テストケース内容の根拠不足項目

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | UT-SAC-206: 異なるスレッドでのPrivilege.Enable呼び出し | **根拠なし** - マルチスレッド実行環境依存 | △ |
| C-52 | UT-SAC-209: 異なるスレッドでのPrivilege.Revert呼び出し | **根拠なし** - マルチスレッド実行環境依存 | △ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の理由

1. **マルチスレッドテスト（UT-SAC-206, UT-SAC-209）**
   - テストケースの内容はソースコードから抽出可能だが、実際のマルチスレッド環境での動作検証は実行時に確認が必要
   - 候補：単体テストフレームワークでのスレッド生成テスト / 統合テスト環境での検証

2. **Windows固有機能**
   - NativeObjectSecurityおよびPrivilegeクラスはWindows API依存
   - クロスプラットフォーム環境では一部テストがスキップされる可能性あり

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 0 (低) | 列挙型・定数テスト | Enums.csの値は変更される可能性が低い |
| 0 (低) | プロパティ取得テスト | 単純なgetter/setterは実装が安定 |
| 1 (中) | バイナリシリアライズテスト | フォーマット変更時に影響を受ける |
| 1 (中) | SDDL変換テスト | Windows SDDLフォーマット依存 |
| 2 (高) | Win32 API連携テスト | OS環境依存、権限依存 |
| 2 (高) | 特権操作テスト | 実行権限が必要、管理者権限依存 |

## 6) レビュアーチェックリスト（最小）

- [ ] ACE関連テスト（UT-SAC-001〜056）がGenericAce、CommonAce、ObjectAce、CompoundAce、CustomAce、KnownAce、QualifiedAceの主要メソッドを網羅しているか
- [ ] ACL関連テスト（UT-SAC-057〜081）がRawAcl、GenericAcl、AceEnumeratorの主要操作を網羅しているか
- [ ] SecurityDescriptor関連テスト（UT-SAC-082〜124）がRawSecurityDescriptor、GenericSecurityDescriptor、CommonSecurityDescriptorの主要機能を網羅しているか
- [ ] Rules関連テスト（UT-SAC-125〜156）がAuthorizationRule、AccessRule、AuditRule、ObjectAccessRule、ObjectAuditRule、AuthorizationRuleCollectionを網羅しているか
- [ ] ObjectSecurity関連テスト（UT-SAC-157〜200）がObjectSecurity、CommonObjectSecurityの主要操作を網羅しているか
- [ ] Privilege関連テスト（UT-SAC-201〜214）がPrivilege、PrivilegeNotHeldExceptionを網羅しているか
- [ ] ジェネリック関連テスト（UT-SAC-215〜230）がAccessRule<T>、AuditRule<T>、ObjectSecurity<T>を網羅しているか
- [ ] 各テストケースの「期待結果」がソースコードの実装と整合しているか
- [ ] 異常系テストが適切な例外タイプを期待しているか
- [ ] 境界値テストが実装の制限値（MaxBinaryLength、MaxOpaqueLengthなど）と一致しているか
