---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 180
  claims_with_evidence: 175
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Security.Claims 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケース一覧の内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：175 / 180、根拠なし：5
- 優先レビュー（高）
  1. **UT-CLI-072/073 (CreateClaim)**: protectedメソッドのため直接テスト困難
  2. **UT-CLP-046/047 (CreateClaimsIdentity)**: protectedメソッドのため直接テスト困難
  3. **UT-GNP-012 (空白ロール)**: 内部実装の詳細に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/Claim.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/ClaimsIdentity.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/ClaimsPrincipal.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/GenericIdentity.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/GenericPrincipal.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/ClaimTypes.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/src/System/Security/Claims/ClaimValueTypes.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/tests/ClaimTests.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/tests/ClaimsIdentityTests.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/tests/ClaimsPrincipalTests.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/tests/GenericIdentityTests.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Claims/tests/GenericPrincipalTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Claimクラス（UT-CLM-001〜UT-CLM-031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Claim基本コンストラクタのテスト（UT-CLM-001〜011） | E-01 (L156-237), E-08 | ○ |
| C-02 | BinaryReader/Writerによるシリアライゼーション（UT-CLM-012〜024） | E-01 (L47-139, L403-508), E-08 (L21-51) | ○ |
| C-03 | Cloneメソッドのテスト（UT-CLM-016〜017） | E-01 (L383-396) | ○ |
| C-04 | プロパティテスト（UT-CLM-018〜031） | E-01 (L320-378, L344, L517-520) | ○ |
| C-05 | ArgumentNullException検証（複数） | E-01 (L61, L253-254, L290, L416), E-08 (L15-18) | ○ |

### ClaimsIdentityクラス（UT-CLI-001〜UT-CLI-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | コンストラクタバリエーション（UT-CLI-001〜022） | E-02 (L55-287), E-09 (L17-446) | ○ |
| C-07 | IsAuthenticated判定ロジック（UT-CLI-024〜025） | E-02 (L322-325), E-09 (L33-78) | ○ |
| C-08 | Actor循環参照検出（UT-CLI-027〜028, 014） | E-02 (L331-344, L977-997) | ○ |
| C-09 | Claim追加・削除（UT-CLI-039〜049） | E-02 (L467-551) | ○ |
| C-10 | FindAll/FindFirst/HasClaimメソッド（UT-CLI-050〜069） | E-02 (L601-734), E-09 (L524-815) | ○ |
| C-11 | StringComparison対応（UT-CLI-021〜022, 055〜062） | E-02 (L220-287, L1036-1050), E-09 (L479-798) | ○ |
| C-12 | WriteTo/BinaryReaderシリアライゼーション（UT-CLI-015〜018, 070〜073） | E-02 (L196-227, L762-835, L854-970) | ○ |
| C-13 | CreateClaimメソッド（UT-CLI-072〜073） | E-02 (L842-847) | △ |

### ClaimsPrincipalクラス（UT-CLP-001〜UT-CLP-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタバリエーション（UT-CLP-001〜012） | E-03 (L90-187), E-10 (L17-203) | ○ |
| C-15 | Identity追加（UT-CLP-013〜016） | E-03 (L194-211) | ○ |
| C-16 | Current/Selector（UT-CLP-022〜026） | E-03 (L30-48, L75-85, L265-272), E-10 (L206-263) | ○ |
| C-17 | FindAll/FindFirst/HasClaim/IsInRole（UT-CLP-027〜047） | E-03 (L281-487) | ○ |
| C-18 | CreateClaimsIdentityメソッド（UT-CLP-046〜047） | E-03 (L255-260) | △ |

### GenericIdentityクラス（UT-GNI-001〜UT-GNI-011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | コンストラクタ（UT-GNI-001〜005） | E-04 (L14-33), E-11 (L13-44) | ○ |
| C-20 | IsAuthenticated判定（UT-GNI-008〜009） | E-04 (L74-79), E-11 (L31-37) | ○ |
| C-21 | Clone/プロパティ（UT-GNI-006〜007, 010〜011） | E-04 (L45-56, L58-72) | ○ |

### GenericPrincipalクラス（UT-GNP-001〜UT-GNP-012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタ（UT-GNP-001〜004） | E-05 (L15-30), E-12 (L14-46) | ○ |
| C-23 | IsInRoleメソッド（UT-GNP-006〜011） | E-05 (L70-83), E-12 (L22-40) | ○ |
| C-24 | 空白ロールの扱い（UT-GNP-012） | E-05 (L53) | △ |

### 定数クラス（UT-CTY, UT-CVT）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | ClaimTypes定数値（UT-CTY-001〜003） | E-06 (L26, L57, L50) | ○ |
| C-26 | ClaimValueTypes定数値（UT-CVT-001〜003） | E-07 (L15, L25, L21) | ○ |

## 4) 不足情報（Unknown / Missing）

### UT-CLI-072/073, UT-CLP-046/047 (protectedメソッド)
- **理由**: `CreateClaim`および`CreateClaimsIdentity`はprotectedメソッドのため、直接の単体テストが困難
- **候補**:
  - 派生クラスを作成してテスト
  - シリアライゼーション経由で間接的にテスト
  - 既存テストではBinaryReader経由でテストされている (E-09 L830-843)

### UT-GNP-012 (空白ロールのスキップ)
- **理由**: `AddIdentityWithRoles`メソッド内の`string.IsNullOrWhiteSpace`チェック (E-05 L53) の挙動を確認するテストケース
- **候補**:
  - 空白のみの文字列を含むroles配列でIsInRoleをテスト
  - ExternalClaimsに追加されないことを確認

## 5) リスクフラグ（レビュー観点）

| リスク | 項目 | 説明 |
|--------|------|------|
| 1 (中) | シリアライゼーション | BinaryReader/Writerの互換性は.NETバージョン間で注意が必要 |
| 1 (中) | StringComparison | CurrentCulture/CurrentCultureIgnoreCaseは明示的に拒否される仕様 |
| 0 (低) | 循環参照検出 | Actor設定時の循環参照チェックは既存テストで十分にカバー |
| 0 (低) | 定数値 | ClaimTypes/ClaimValueTypesは定数のため変更リスク低 |

## 6) レビュアーチェックリスト（最小）

- [ ] UT-CLM-012〜013: BinaryReaderコンストラクタのシリアライゼーション形式が正しいか確認
- [ ] UT-CLI-027〜028: Actor循環参照の間接参照ケースが網羅されているか確認
- [ ] UT-CLI-055〜062: StringComparison.Ordinalの場合の大文字小文字区別が正しくテストされているか確認
- [ ] UT-CLP-022〜024: Thread.CurrentPrincipalの挙動がプラットフォームによって異なる可能性を確認
- [ ] UT-GNP-008: IsInRoleの大文字小文字無視がOrdinalIgnoreCaseであることを確認
- [ ] protectedメソッド(CreateClaim, CreateClaimsIdentity)のテスト方針を検討
