---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 172
  claims_with_evidence: 168
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Security.Cryptography.Cng 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 168 / 172 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：168 / 172、根拠なし：4
- 優先レビュー（高）
  1. **UT-CNG-082 UIPolicy取得**：UIポリシー設定済み鍵の前提条件の詳細が不明確
  2. **UT-CNG-075 IsMachineKey判定**：マシン鍵作成の具体的条件が不明確
  3. **UT-CNG-169 弱鍵検出**：TripleDESの弱鍵パターンの具体的な値が不明確
  4. **UT-CNG-170 Two-Key 3DES対応**：16バイト鍵拡張ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngAlgorithm.cs`
- E-02: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngProvider.cs`
- E-03: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngAlgorithmGroup.cs`
- E-04: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKeyBlobFormat.cs`
- E-05: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.cs`
- E-06: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Create.cs`
- E-07: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Open.cs`
- E-08: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Exists.cs`
- E-09: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Delete.cs`
- E-10: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Export.cs`
- E-11: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Import.cs`
- E-12: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.Properties.cs`
- E-13: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKey.StandardProperties.cs`
- E-14: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngProperty.cs`
- E-15: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngUIPolicy.cs`
- E-16: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CngKeyCreationParameters.cs`
- E-17: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RSACng.cs`
- E-18: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DSACng.cs`
- E-19: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/ECDsaCng.cs`
- E-20: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/ECDiffieHellmanCng.cs`
- E-21: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/AesCng.Windows.cs`
- E-22: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/TripleDESCng.Windows.cs`
- E-23: `src/libraries/System.Security.Cryptography.Cng/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）

### CngAlgorithm クラス (UT-CNG-001 〜 UT-CNG-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CngAlgorithmコンストラクタで有効なアルゴリズム名を受け付ける | E-01 (line 18-22) | ○ |
| C-02 | nullパラメータでArgumentExceptionがスローされる | E-01 (line 20: ThrowIfNullOrEmpty) | ○ |
| C-03 | 空文字でArgumentExceptionがスローされる | E-01 (line 20: ThrowIfNullOrEmpty) | ○ |
| C-04 | Algorithmプロパティで設定値を取得 | E-01 (line 27-32) | ○ |
| C-05 | Equals(CngAlgorithm)で同一比較がtrue | E-01 (line 62-70) | ○ |
| C-06 | Equals(CngAlgorithm)で異なる比較がfalse | E-01 (line 62-70) | ○ |
| C-07 | null比較でfalseを返す | E-01 (line 64-66) | ○ |
| C-08 | GetHashCodeで一貫したハッシュ値 | E-01 (line 72-76) | ○ |
| C-09 | ToStringでアルゴリズム名を返す | E-01 (line 78-82) | ○ |
| C-10 | operator ==で同一比較 | E-01 (line 35-43) | ○ |
| C-11 | operator !=で異なる比較 | E-01 (line 45-53) | ○ |
| C-12 | 静的プロパティRsa | E-01 (line 88-94) | ○ |
| C-13 | 静的プロパティECDsa | E-01 (line 128-134) | ○ |
| C-14 | 静的プロパティECDiffieHellman | E-01 (line 96-102) | ○ |
| C-15 | 静的プロパティSha256 | E-01 (line 176-181) | ○ |

### CngProvider クラス (UT-CNG-016 〜 UT-CNG-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | CngProviderコンストラクタで有効なプロバイダ名を受け付ける | E-02 (line 18-21) | ○ |
| C-17 | nullパラメータでArgumentNullException | E-02 (line 20: ThrowIfNullOrEmpty) | ○ |
| C-18 | 空文字でArgumentException | E-02 (line 20: ThrowIfNullOrEmpty) | ○ |
| C-19 | Providerプロパティで設定値を取得 | E-02 (line 24-32) | ○ |
| C-20 | Equals(CngProvider)で同一比較 | E-02 (line 60-67) | ○ |
| C-21 | MicrosoftSoftwareKeyStorageProvider静的プロパティ | E-02 (line 106-112) | ○ |
| C-22 | MicrosoftSmartCardKeyStorageProvider静的プロパティ | E-02 (line 98-104) | ○ |
| C-23 | MicrosoftPlatformCryptoProvider静的プロパティ | E-02 (line 90-96) | ○ |

### CngAlgorithmGroup クラス (UT-CNG-024 〜 UT-CNG-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | CngAlgorithmGroupコンストラクタ | E-03 (line 19-22) | ○ |
| C-25 | nullパラメータでArgumentNullException | E-03 (line 21: ThrowIfNullOrEmpty) | ○ |
| C-26 | 静的プロパティRsa | E-03 (line 121-126) | ○ |
| C-27 | 静的プロパティECDsa | E-03 (line 113-118) | ○ |
| C-28 | 静的プロパティECDiffieHellman | E-03 (line 105-110) | ○ |
| C-29 | 静的プロパティDsa | E-03 (line 97-102) | ○ |

### CngKeyBlobFormat クラス (UT-CNG-030 〜 UT-CNG-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | CngKeyBlobFormatコンストラクタ | E-04 (line 19-22) | ○ |
| C-31 | nullパラメータでArgumentNullException | E-04 (line 21: ThrowIfNullOrEmpty) | ○ |
| C-32 | Formatプロパティで設定値を取得 | E-04 (line 28-33) | ○ |
| C-33 | 静的プロパティEccPublicBlob | E-04 (line 97-103) | ○ |
| C-34 | 静的プロパティEccPrivateBlob | E-04 (line 89-95) | ○ |
| C-35 | 静的プロパティPkcs8PrivateBlob | E-04 (line 226-232) | ○ |
| C-36 | 静的プロパティGenericPublicBlob | E-04 (line 129-135) | ○ |

### CngKey クラス - Create/Open/Exists/Delete (UT-CNG-037 〜 UT-CNG-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | Create(CngAlgorithm)で鍵作成 | E-06 (line 23-26) | ○ |
| C-38 | Create - nullでArgumentNullException | E-06 (line 37) | ○ |
| C-39 | Create(algorithm, keyName)で名前付き鍵作成 | E-06 (line 28-31) | ○ |
| C-40 | keyName=nullでエフェメラル鍵作成 | E-06 (line 64-67) | ○ |
| C-41 | Create(algorithm, keyName, params)で詳細鍵作成 | E-06 (line 34-77) | ○ |
| C-42 | Open(keyName)で既存鍵オープン | E-07 (line 21-24) | ○ |
| C-43 | Open - nullでArgumentNullException | E-07 (line 35) | ○ |
| C-44 | 存在しない鍵でCryptographicException | E-07 (line 41-45) | ○ |
| C-45 | Open(keyName, provider)でプロバイダ指定オープン | E-07 (line 27-30) | ○ |
| C-46 | Open - provider nullでArgumentNullException | E-07 (line 36) | ○ |
| C-47 | Exists(keyName)で存在確認true | E-08 (line 21-55) | ○ |
| C-48 | Exists - 存在しない鍵でfalse | E-08 (line 44-45) | ○ |
| C-49 | Exists - nullでArgumentNullException | E-08 (line 35) | ○ |
| C-50 | Exists(keyName, provider)でプロバイダ指定確認 | E-08 (line 27-30) | ○ |
| C-51 | Delete()で鍵削除 | E-09 (line 18-27) | ○ |
| C-52 | Delete後にハンドル無効化 | E-09 (line 23-26) | ○ |
| C-53 | Dispose()でリソース解放 | E-05 (line 26-30) | ○ |

### CngKey クラス - Export/Import (UT-CNG-054 〜 UT-CNG-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Export(format)で鍵エクスポート | E-10 (line 18-34) | ○ |
| C-55 | Export - formatがnullでArgumentNullException | E-10 (line 20) | ○ |
| C-56 | エクスポート不可の鍵でCryptographicException | E-10 (line 24-25, 29-30) | ○ |
| C-57 | Import(keyBlob, format)で鍵インポート | E-11 (line 26-29) | ○ |
| C-58 | Import - keyBlobがnullでArgumentNullException | E-11 (line 109) | ○ |
| C-59 | Import - formatがnullでArgumentNullException | E-11 (line 120) | ○ |
| C-60 | 不正なBLOBでCryptographicException | E-11 (line 141-145) | ○ |

### CngKey クラス - Properties (UT-CNG-061 〜 UT-CNG-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | GetProperty(name, options)でプロパティ取得 | E-12 (line 18-30) | ○ |
| C-62 | GetProperty - nameがnullでArgumentNullException | E-12 (line 20) | ○ |
| C-63 | 存在しないプロパティでCryptographicException | E-12 (line 23-24) | ○ |
| C-64 | HasProperty - 存在するプロパティでtrue | E-12 (line 35-48) | ○ |
| C-65 | HasProperty - 存在しないプロパティでfalse | E-12 (line 42-43) | ○ |
| C-66 | HasProperty - nameがnullでArgumentNullException | E-12 (line 37) | ○ |
| C-67 | SetPropertyでプロパティ設定 | E-12 (line 53-70) | ○ |
| C-68 | SetProperty - 値がnullでCryptographicException | E-12 (line 60-61) | ○ |
| C-69 | Algorithmプロパティ取得 | E-13 (line 30-44) | ○ |
| C-70 | AlgorithmGroupプロパティ取得 | E-13 (line 49-67) | ○ |
| C-71 | ExportPolicyプロパティ取得 | E-13 (line 72-84) | ○ |
| C-72 | Handleプロパティ取得 | E-13 (line 89-95) | ○ |
| C-73 | IsEphemeral - エフェメラル鍵でtrue | E-13 (line 113-138) | ○ |
| C-74 | IsEphemeral - 永続化鍵でfalse | E-13 (line 113-138) | ○ |
| C-75 | IsMachineKey判定 | E-13 (line 155-163) | △ |
| C-76 | KeyName取得 | E-13 (line 169-179) | ○ |
| C-77 | KeyName - エフェメラル鍵でnull | E-13 (line 174-175) | ○ |
| C-78 | KeySizeプロパティ取得 | E-13 (line 185-253) | ○ |
| C-79 | KeyUsageプロパティ取得 | E-13 (line 259-265) | ○ |
| C-80 | Providerプロパティ取得 | E-13 (line 292-310) | ○ |
| C-81 | ProviderHandleプロパティ取得 | E-13 (line 315-320) | ○ |
| C-82 | UIPolicyプロパティ取得 | E-13 (line 326-378) | △ |
| C-83 | UniqueNameプロパティ取得 | E-13 (line 385-395) | ○ |

### CngProperty 構造体 (UT-CNG-084 〜 UT-CNG-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | CngPropertyコンストラクタ | E-14 (line 19-28) | ○ |
| C-85 | コンストラクタ - nameがnullでArgumentNullException | E-14 (line 22) | ○ |
| C-86 | Nameプロパティ取得 | E-14 (line 43-44) | ○ |
| C-87 | GetValue()で値のコピー取得 | E-14 (line 50) | ○ |
| C-88 | GetValue - nullの場合null返却 | E-14 (line 50, CloneByteArray実装) | ○ |
| C-89 | Optionsプロパティ取得 | E-14 (line 55) | ○ |
| C-90 | Equals(CngProperty) - 同一でtrue | E-14 (line 62-81) | ○ |
| C-91 | Equals(CngProperty) - 異なるでfalse | E-14 (line 62-81) | ○ |
| C-92 | GetHashCode一貫性 | E-14 (line 83-106) | ○ |

### CngUIPolicy クラス (UT-CNG-093 〜 UT-CNG-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | CngUIPolicy(protectionLevel)コンストラクタ | E-15 (line 14-16) | ○ |
| C-94 | CngUIPolicy全パラメータコンストラクタ | E-15 (line 34-41) | ○ |
| C-95 | ProtectionLevelプロパティ | E-15 (line 46) | ○ |
| C-96 | FriendlyNameプロパティ | E-15 (line 52) | ○ |

### CngKeyCreationParameters クラス (UT-CNG-097 〜 UT-CNG-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | デフォルトコンストラクタ | E-16 (line 15-19) | ○ |
| C-98 | ExportPolicyプロパティ | E-16 (line 24) | ○ |
| C-99 | KeyCreationOptionsプロパティ | E-16 (line 29) | ○ |
| C-100 | KeyUsageプロパティ | E-16 (line 34) | ○ |
| C-101 | Providerプロパティ取得・設定 | E-16 (line 48-61) | ○ |
| C-102 | Provider - nullでArgumentNullException | E-16 (line 58) | ○ |
| C-103 | Parametersプロパティ取得 | E-16 (line 39) | ○ |

### RSACng クラス (UT-CNG-104 〜 UT-CNG-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | RSACng(CngKey)コンストラクタ | E-17 (line 24-32) | ○ |
| C-105 | コンストラクタ - nullでArgumentNullException | E-17 (line 26) | ○ |
| C-106 | 非RSA鍵でArgumentException | E-17 (line 28-29) | ○ |
| C-107 | Dispose()でリソース解放 | E-17 (line 53-56) | ○ |

### DSACng クラス (UT-CNG-108 〜 UT-CNG-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | DSACng(CngKey)コンストラクタ | E-18 (line 24-32) | ○ |
| C-109 | コンストラクタ - nullでArgumentNullException | E-18 (line 26) | ○ |
| C-110 | 非DSA鍵でArgumentException | E-18 (line 28-29) | ○ |
| C-111 | Dispose()でリソース解放 | E-18 (line 53-56) | ○ |

### ECDsaCng クラス (UT-CNG-112 〜 UT-CNG-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | ECDsaCng(CngKey)コンストラクタ | E-19 (line 42-50) | ○ |
| C-113 | コンストラクタ - nullでArgumentNullException | E-19 (line 44) | ○ |
| C-114 | 非ECC鍵でArgumentException | E-19 (line 46-47) | ○ |
| C-115 | HashAlgorithmデフォルト値Sha256 | E-19 (line 14) | ○ |
| C-116 | HashAlgorithm設定・取得 | E-19 (line 19-30) | ○ |
| C-117 | HashAlgorithm - nullでArgumentNullException | E-19 (line 27) | ○ |
| C-118 | SignData(byte[])で署名生成 | E-19 (line 196-197) | ○ |
| C-119 | VerifyData - 有効署名でtrue | E-19 (line 209-210) | ○ |
| C-120 | VerifyData - 無効署名でfalse | E-19 (line 209-210) | ○ |
| C-121 | TryExportPkcs8PrivateKey | E-19 (line 152-172) | ○ |
| C-122 | Dispose()でリソース解放 | E-19 (line 71-74) | ○ |

### ECDiffieHellmanCng クラス (UT-CNG-123 〜 UT-CNG-139)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | ECDiffieHellmanCng(CngKey)コンストラクタ | E-20 (line 24-32) | ○ |
| C-124 | コンストラクタ - nullでArgumentNullException | E-20 (line 26) | ○ |
| C-125 | 非ECDH鍵でArgumentException | E-20 (line 28-29) | ○ |
| C-126 | HashAlgorithmデフォルト値Sha256 | E-20 (line 15) | ○ |
| C-127 | HashAlgorithm設定・取得 | E-20 (line 47-60) | ○ |
| C-128 | HashAlgorithm - nullでArgumentNullException | E-20 (line 56) | ○ |
| C-129 | KeyDerivationFunctionデフォルト値Hash | E-20 (line 16) | ○ |
| C-130 | KeyDerivationFunction設定・取得 | E-20 (line 65-80) | ○ |
| C-131 | KeyDerivationFunction - 無効値でArgumentOutOfRangeException | E-20 (line 74-77) | ○ |
| C-132 | HmacKey設定・取得 | E-20 (line 86-90) | ○ |
| C-133 | UseSecretAgreementAsHmacKey - HmacKey=nullでtrue | E-20 (line 131-134) | ○ |
| C-134 | UseSecretAgreementAsHmacKey - HmacKey設定でfalse | E-20 (line 131-134) | ○ |
| C-135 | SecretPrepend設定・取得 | E-20 (line 113-117) | ○ |
| C-136 | SecretAppend設定・取得 | E-20 (line 104-108) | ○ |
| C-137 | Label設定・取得 | E-20 (line 95-99) | ○ |
| C-138 | Seed設定・取得 | E-20 (line 122-126) | ○ |
| C-139 | Dispose()でリソース解放 | E-20 (line 136-139) | ○ |

### AesCng クラス (UT-CNG-140 〜 UT-CNG-161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | AesCng()デフォルトコンストラクタ | E-21 (line 22-25) | ○ |
| C-141 | AesCng(keyName)コンストラクタ | E-21 (line 27-30) | ○ |
| C-142 | AesCng(keyName, provider)コンストラクタ | E-21 (line 32-36) | ○ |
| C-143 | AesCng(CngKey)コンストラクタ | E-21 (line 67-74) | ○ |
| C-144 | AesCng(CngKey) - nullでArgumentNullException | E-21 (line 69) | ○ |
| C-145 | Key取得 | E-21 (line 77-81) | ○ |
| C-146 | Key設定 | E-21 (line 82-85) | ○ |
| C-147 | KeySize取得 | E-21 (line 88-91) | ○ |
| C-148 | KeySize設定 | E-21 (line 93-98) | ○ |
| C-149 | CreateEncryptor() | E-21 (line 112-115) | ○ |
| C-150 | CreateEncryptor(key, iv) | E-21 (line 117-120) | ○ |
| C-151 | CreateDecryptor() | E-21 (line 101-105) | ○ |
| C-152 | CreateDecryptor(key, iv) | E-21 (line 107-110) | ○ |
| C-153 | GenerateKey | E-21 (line 122-125) | ○ |
| C-154 | GenerateIV | E-21 (line 127-130) | ○ |
| C-155 | TryEncryptEcbCore | E-21 (line 151-167) | ○ |
| C-156 | TryDecryptEcbCore | E-21 (line 133-149) | ○ |
| C-157 | TryEncryptCbcCore | E-21 (line 169-186) | ○ |
| C-158 | TryDecryptCbcCore | E-21 (line 188-205) | ○ |
| C-159 | TryEncryptCfbCore | E-21 (line 227-245) | ○ |
| C-160 | TryDecryptCfbCore | E-21 (line 207-225) | ○ |
| C-161 | Dispose()でリソース解放 | E-21 (line 247-256) | ○ |

### TripleDESCng クラス (UT-CNG-162 〜 UT-CNG-172)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | TripleDESCng()デフォルトコンストラクタ | E-22 (line 20-24) | ○ |
| C-163 | TripleDESCng(keyName)コンストラクタ | E-22 (line 26-29) | ○ |
| C-164 | Key設定・取得 | E-22 (line 44-54) | ○ |
| C-165 | CreateEncryptor() | E-22 (line 80-84) | ○ |
| C-166 | CreateDecryptor() | E-22 (line 69-73) | ○ |
| C-167 | GenerateKey | E-22 (line 91-94) | ○ |
| C-168 | GenerateIV | E-22 (line 96-99) | ○ |
| C-169 | IsWeakKey - 弱鍵検出 | E-22 (line 223-226) | △ |
| C-170 | PreprocessKey - 16バイト鍵拡張 | E-22 (line 243-256) | △ |
| C-171 | PreprocessKey - 24バイト鍵そのまま | E-22 (line 255) | ○ |
| C-172 | Dispose()でリソース解放 | E-22 (line 215-218) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なしの理由

1. **UT-CNG-075 (IsMachineKey)**: マシン鍵を作成する際の具体的な条件（CngKeyCreationOptions.MachineKeyの使用等）についての詳細なドキュメントが不足
   - 候補: Windows CNG APIドキュメント / NCrypt.h ヘッダーファイル / 既存テストコード

2. **UT-CNG-082 (UIPolicy)**: UIポリシーが設定された鍵を作成する手順の詳細が不足
   - 候補: CngKeyCreationParametersのUIPolicyプロパティ使用例 / Windows CNG UIドキュメント

3. **UT-CNG-169 (IsWeakKey)**: TripleDESの弱鍵パターンの具体的なバイト値が不明確
   - 候補: TripleDES.IsWeakKey実装 / FIPS 46-3仕様

4. **UT-CNG-170 (PreprocessKey)**: Two-Key 3DESから Three-Key 3DESへの変換ロジックの詳細確認が必要
   - 候補: TripleDESCng.PreprocessKey実装（E-22 line 243-256で確認済みだが、ロジックの詳細検証が推奨）

## 5) リスクフラグ（レビュー観点）

| レベル | 項目 | 理由 |
|--------|------|------|
| 0 | CngAlgorithm, CngProvider, CngAlgorithmGroup | 単純なラッパークラス、リスク低 |
| 0 | CngKeyBlobFormat, CngUIPolicy, CngProperty | 値オブジェクト、リスク低 |
| 1 | CngKey.Create/Open/Delete | 暗号鍵のライフサイクル管理、中リスク |
| 1 | CngKey.Export/Import | 鍵データの外部入出力、中リスク |
| 1 | RSACng, DSACng, ECDsaCng | 非対称暗号操作、中リスク |
| 1 | AesCng, TripleDESCng | 対称暗号操作、中リスク |
| 2 | ECDiffieHellmanCng | 鍵導出・鍵交換、高リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] Windows環境での動作が前提となるテストケースが適切にマークされているか
- [ ] null入力検証のテストケースが全てのpublicメソッドに対して網羅されているか
- [ ] 暗号鍵のエクスポートポリシーに関するテストケースが十分か
- [ ] エフェメラル鍵と永続化鍵の違いがテストケースで明確に区別されているか
- [ ] CngKeyのDispose後の操作に対するテストケースが含まれているか
- [ ] 境界値テスト（空配列、最大サイズ等）が適切に含まれているか
- [ ] TripleDESの弱鍵検出テストケースの具体的な入力値を確認
- [ ] Two-Key 3DESから Three-Key 3DESへの変換テストケースの正確性を確認
