---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Security.Cryptography.Cose 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド定義・プロパティ定義・例外処理が存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・エッジケースを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **署名・検証系メソッド（UT-COSE-021〜043, 133〜141）**：セキュリティ上重要な機能
  2. **デコード系メソッド（UT-COSE-001〜009）**：CBOR解析のエラー処理
  3. **CoseKey構築・検証（UT-COSE-060〜075）**：暗号鍵の取り扱い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseMessage.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseSign1Message.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseMultiSignMessage.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseKey.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseSigner.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseHeaderMap.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseHeaderLabel.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseHeaderValue.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseSignature.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseHelpers.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/CoseAlgorithm.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/HashToBeSignedBuilder.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/PureDataToBeSignedBuilder.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/ToBeSignedBuilder.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/KnownHeaders.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/KeyType.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Cose/src/System/Security/Cryptography/Cose/SigStructureContext.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CoseMessage クラス（UT-COSE-001〜020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DecodeSign1(byte[])で有効なCBORをデコード可能 | E-01 (L93-98) | ○ |
| C-02 | DecodeSign1(byte[])でnull時ArgumentNullException | E-01 (L95) `ArgumentNullException.ThrowIfNull(cborPayload)` | ○ |
| C-03 | DecodeSign1で不正CBORでCryptographicException | E-01 (L165-168) catch文 | ○ |
| C-04 | DecodeSign1で不正タグでCryptographicException | E-01 (L125-128) タグ検証 | ○ |
| C-05 | DecodeSign1で配列長不正でCryptographicException | E-01 (L140-144) 配列長検証 | ○ |
| C-06 | DecodeSign1(ReadOnlySpan<byte>)でデコード可能 | E-01 (L106-118) | ○ |
| C-07 | DecodeMultiSign(byte[])でデコード可能 | E-01 (L178-183) | ○ |
| C-08 | DecodeMultiSign(byte[])でnull時ArgumentNullException | E-01 (L180) | ○ |
| C-09 | DecodeMultiSignで署名0件でCryptographicException | E-01 (L346-349) | ○ |
| C-10 | Encode()でCBORエンコード可能 | E-01 (L593-600) | ○ |
| C-11 | Encode(Span<byte>)でバッファ指定エンコード可能 | E-01 (L611-619) | ○ |
| C-12 | Encode(Span<byte>)でバッファ不足時ArgumentException | E-01 (L615) | ○ |
| C-13 | TryEncode成功時true返却 | E-01 (L630) abstract宣言 | ○ |
| C-14 | TryEncodeバッファ不足時false返却 | E-02, E-03のTryEncode実装 | ○ |
| C-15 | GetEncodedLength()でサイズ計算 | E-01 (L636) abstract宣言 | ○ |
| C-16 | Content取得（埋め込み） | E-01 (L70-81) Contentプロパティ | ○ |
| C-17 | Content取得（デタッチド時null） | E-01 (L74-77) IsDetached判定 | ○ |
| C-18 | ProtectedHeaders取得 | E-01 (L41) プロパティ | ○ |
| C-19 | UnprotectedHeaders取得 | E-01 (L47) プロパティ | ○ |
| C-20 | RawProtectedHeaders取得 | E-01 (L53) プロパティ | ○ |

### CoseSign1Message クラス（UT-COSE-021〜043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | SignDetached(byte[],...)でデタッチド署名 | E-02 (L51-57) | ○ |
| C-22 | SignDetachedでコンテンツnull時ArgumentNullException | E-02 (L53) | ○ |
| C-23 | SignDetachedでsigner null時ArgumentNullException | E-02 (L54) | ○ |
| C-24 | SignEmbedded(byte[],...)で埋め込み署名 | E-02 (L76-82) | ○ |
| C-25 | SignDetached(ReadOnlySpan<byte>,...)でSpan版署名 | E-02 (L101-106) | ○ |
| C-26 | SignDetached(Stream,...)でStream版署名 | E-02 (L153-165) | ○ |
| C-27 | SignDetached(Stream,...)で読み取り不可Stream時例外 | E-02 (L158-159) | ○ |
| C-28 | SignDetached(Stream,...)でシーク不可Stream時例外 | E-02 (L161-162) | ○ |
| C-29 | SignDetachedAsync非同期署名 | E-02 (L204-219) | ○ |
| C-30 | TrySignDetachedで成功時true | E-02 (L249-251) | ○ |
| C-31 | TrySignDetachedでバッファ不足時false | E-02 (L281-285) | ○ |
| C-32 | VerifyEmbeddedで署名検証成功 | E-02 (L385-398) | ○ |
| C-33 | VerifyEmbeddedで不正署名時false | E-02 (L771-813) VerifyCore実装 | ○ |
| C-34 | VerifyEmbeddedでkey null時ArgumentNullException | E-02 (L387) | ○ |
| C-35 | VerifyEmbeddedでデタッチド時InvalidOperationException | E-02 (L389-392) | ○ |
| C-36 | VerifyEmbedded(CoseKey,...)で検証 | E-02 (L471-481) | ○ |
| C-37 | VerifyDetachedでデタッチド検証 | E-02 (L512-526) | ○ |
| C-38 | VerifyDetachedで埋め込み時InvalidOperationException | E-02 (L517-520) | ○ |
| C-39 | VerifyDetached(Stream,...)でStream版検証 | E-02 (L686-709) | ○ |
| C-40 | VerifyDetachedAsync非同期検証 | E-02 (L853-876) | ○ |
| C-41 | Signatureプロパティ取得 | E-02 (L26) | ○ |
| C-42 | GetEncodedLength()サイズ計算 | E-02 (L989-991) | ○ |
| C-43 | TryEncodeで重複ラベル時InvalidOperationException | E-02 (L1004-1007) | ○ |

### CoseMultiSignMessage クラス（UT-COSE-044〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | SignDetachedでマルチ署名作成 | E-03 (L67-72) | ○ |
| C-45 | SignEmbeddedでマルチ署名作成 | E-03 (L97-102) | ○ |
| C-46 | SignDetachedAsync非同期マルチ署名 | E-03 (L248-269) | ○ |
| C-47 | TrySignDetachedでTryパターン | E-03 (L312-314) | ○ |
| C-48 | AddSignatureForEmbeddedで署名追加 | E-03 (L646-675) | ○ |
| C-49 | AddSignatureForEmbeddedでsigner null時例外 | E-03 (L667) | ○ |
| C-50 | AddSignatureForEmbeddedでデタッチド時例外 | E-03 (L669-672) | ○ |
| C-51 | AddSignatureForDetachedでデタッチド署名追加 | E-03 (L694-728) | ○ |
| C-52 | AddSignatureForDetachedで埋め込み時例外 | E-03 (L722-725) | ○ |
| C-53 | AddSignatureForDetachedAsync非同期署名追加 | E-03 (L827-837) | ○ |
| C-54 | RemoveSignature(CoseSignature)で署名削除 | E-03 (L881-886) | ○ |
| C-55 | RemoveSignature(CoseSignature)でnull時例外 | E-03 (L883) | ○ |
| C-56 | RemoveSignature(int)でインデックス削除 | E-03 (L902-903) | ○ |
| C-57 | RemoveSignature(int)で範囲外時例外 | E-03 (L903) `RemoveAt`の例外 | ○ |
| C-58 | Signaturesプロパティ取得 | E-03 (L30) | ○ |
| C-59 | TryEncodeで署名0件時例外 | E-03 (L578-581) | ○ |

### CoseKey クラス（UT-COSE-060〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CoseKey(RSA,...)でRSAキー作成 | E-04 (L30-43) | ○ |
| C-61 | CoseKey(RSA,...)でkey null時例外 | E-04 (L32) | ○ |
| C-62 | CoseKey(RSA,...)でpadding null時例外 | E-04 (L33) | ○ |
| C-63 | CoseKey(RSA,...)で未サポートハッシュ時例外 | E-04 (L279-291) GetRSAAlgorithm | ○ |
| C-64 | CoseKey(ECDsa,...)でECDsaキー作成 | E-04 (L45-56) | ○ |
| C-65 | CoseKey(ECDsa,...)でkey null時例外 | E-04 (L47) | ○ |
| C-66 | CoseKey(MLDsa)でMLDsaキー作成 | E-04 (L58-67) | ○ |
| C-67 | ComputeSignatureSize()でECDsaサイズ計算 | E-04 (L176-177) | ○ |
| C-68 | ComputeSignatureSize()でRSAサイズ計算 | E-04 (L178-179) | ○ |
| C-69 | Sign()でECDsa署名 | E-04 (L194-196) | ○ |
| C-70 | Sign()でRSA署名 | E-04 (L197-201) | ○ |
| C-71 | Verify()でECDsa検証成功 | E-04 (L241-245) | ○ |
| C-72 | Verify()で不正署名時false | E-04 (L244) VerifyHash戻り値 | ○ |
| C-73 | Verify()でRSA検証成功 | E-04 (L246-252) | ○ |
| C-74 | CreateToBeSignedBuilder()でHashBuilder | E-04 (L333-334) | ○ |
| C-75 | CreateToBeSignedBuilder()でMLDsa時PureBuilder | E-04 (L330-331) | ○ |

### CoseSigner クラス（UT-COSE-076〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | CoseSigner(AsymmetricAlgorithm,...)でECDsa作成 | E-05 (L71-86) | ○ |
| C-77 | CoseSigner(AsymmetricAlgorithm,...)でRSA時例外 | E-05 (L75-76) | ○ |
| C-78 | CoseSigner(AsymmetricAlgorithm,...)でkey null時例外 | E-05 (L73) | ○ |
| C-79 | CoseSigner(RSA,...)でRSA Signer作成 | E-05 (L110-120) | ○ |
| C-80 | CoseSigner(RSA,...)でpadding null時例外 | E-05 (L113) | ○ |
| C-81 | CoseSigner(CoseKey,...)でCoseKey版作成 | E-05 (L129-139) | ○ |
| C-82 | CoseSigner(CoseKey,...)でkey null時例外 | E-05 (L131-132) | ○ |
| C-83 | ProtectedHeadersプロパティ取得 | E-05 (L145) | ○ |
| C-84 | UnprotectedHeadersプロパティ取得 | E-05 (L151) | ○ |
| C-85 | ValidateOrSlipAlgorithmHeader()で自動挿入 | E-05 (L156-171) | ○ |
| C-86 | ValidateOrSlipAlgorithmHeader()でUnprotectedにAlg時例外 | E-05 (L165-168) | ○ |
| C-87 | ValidateOrSlipAlgorithmHeader()で不一致Alg時例外 | E-05 (L173-198) | ○ |

### CoseHeaderMap クラス（UT-COSE-088〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | Add(CoseHeaderLabel, CoseHeaderValue)で追加 | E-06 (L126-131) | ○ |
| C-89 | Add時読み取り専用で例外 | E-06 (L128, L237-243) | ○ |
| C-90 | Add(CoseHeaderLabel, int)でint追加 | E-06 (L147) | ○ |
| C-91 | Add(CoseHeaderLabel, string)でstring追加 | E-06 (L155) | ○ |
| C-92 | Add(CoseHeaderLabel, byte[])でbyte[]追加 | E-06 (L167) | ○ |
| C-93 | Remove(CoseHeaderLabel)で削除 | E-06 (L219-223) | ○ |
| C-94 | Remove存在しないキーでfalse | E-06 (L222) Dictionary.Remove動作 | ○ |
| C-95 | Clear()で全削除 | E-06 (L191-195) | ○ |
| C-96 | Clear()読み取り専用で例外 | E-06 (L193) | ○ |
| C-97 | GetValueAsInt32取得 | E-06 (L89) | ○ |
| C-98 | GetValueAsInt32型不一致時例外 | E-08 (L135-137) | ○ |
| C-99 | GetValueAsString取得 | E-06 (L98) | ○ |
| C-100 | GetValueAsBytes取得 | E-06 (L106) | ○ |
| C-101 | インデクサで取得 | E-06 (L71-80) | ○ |
| C-102 | インデクサ存在しないキーで例外 | E-06 (L73) Dictionary動作 | ○ |
| C-103 | ContainsKey存在確認 | E-06 (L182) | ○ |
| C-104 | TryGetValue取得試行 | E-06 (L185) | ○ |
| C-105 | Countプロパティ | E-06 (L55) | ○ |
| C-106 | IsReadOnlyプロパティ | E-06 (L25) | ○ |

### CoseHeaderLabel 構造体（UT-COSE-107〜116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | CoseHeaderLabel(int)でint型ラベル作成 | E-07 (L48-53) | ○ |
| C-108 | CoseHeaderLabel(string)でstring型ラベル作成 | E-07 (L60-67) | ○ |
| C-109 | CoseHeaderLabel(string)でnull時例外 | E-07 (L62) | ○ |
| C-110 | Algorithmラベル取得 | E-07 (L23) | ○ |
| C-111 | CriticalHeadersラベル取得 | E-07 (L28) | ○ |
| C-112 | ContentTypeラベル取得 | E-07 (L33) | ○ |
| C-113 | KeyIdentifierラベル取得 | E-07 (L38) | ○ |
| C-114 | Equals同一ラベルでtrue | E-07 (L74-77) | ○ |
| C-115 | Equals異なるラベルでfalse | E-07 (L74-77) | ○ |
| C-116 | GetHashCode取得 | E-07 (L90-102) | ○ |

### CoseHeaderValue 構造体（UT-COSE-117〜132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | FromEncodedValue(ReadOnlySpan<byte>)で作成 | E-08 (L37-41) | ○ |
| C-118 | FromEncodedValue(byte[])で作成 | E-08 (L49-54) | ○ |
| C-119 | FromEncodedValue(byte[])でnull時例外 | E-08 (L51) | ○ |
| C-120 | FromInt32(int)で作成 | E-08 (L69-75) | ○ |
| C-121 | FromString(string)で作成 | E-08 (L83-91) | ○ |
| C-122 | FromString(string)でnull時例外 | E-08 (L85) | ○ |
| C-123 | FromBytes(ReadOnlySpan<byte>)で作成 | E-08 (L99-105) | ○ |
| C-124 | FromBytes(byte[])で作成 | E-08 (L114-119) | ○ |
| C-125 | GetValueAsInt32()取得 | E-08 (L126-146) | ○ |
| C-126 | GetValueAsInt32()型不一致時例外 | E-08 (L135-138) | ○ |
| C-127 | GetValueAsString()取得 | E-08 (L153-173) | ○ |
| C-128 | GetValueAsBytes()取得 | E-08 (L180-200) | ○ |
| C-129 | GetValueAsBytes(Span<byte>)書き込み | E-08 (L209-232) | ○ |
| C-130 | GetValueAsBytes(Span<byte>)バッファ不足時例外 | E-08 (L218) | ○ |
| C-131 | Equals同一値でtrue | E-08 (L246) | ○ |
| C-132 | GetHashCode取得 | E-08 (L252-264) | ○ |

### CoseSignature クラス（UT-COSE-133〜145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | VerifyEmbedded検証 | E-09 (L100-113) | ○ |
| C-134 | VerifyEmbeddedでkey null時例外 | E-09 (L102) | ○ |
| C-135 | VerifyEmbeddedでデタッチド時例外 | E-09 (L104-107) | ○ |
| C-136 | VerifyEmbedded(CoseKey,...)検証 | E-09 (L143-153) | ○ |
| C-137 | VerifyDetachedデタッチド検証 | E-09 (L227-242) | ○ |
| C-138 | VerifyDetachedで埋め込み時例外 | E-09 (L233-236) | ○ |
| C-139 | VerifyDetached(Stream,...)Stream版検証 | E-09 (L403-428) | ○ |
| C-140 | VerifyDetached(Stream,...)読み取り不可時例外 | E-09 (L409-412) | ○ |
| C-141 | VerifyDetachedAsync非同期検証 | E-09 (L527-551) | ○ |
| C-142 | ProtectedHeadersプロパティ | E-09 (L25) | ○ |
| C-143 | UnprotectedHeadersプロパティ | E-09 (L31) | ○ |
| C-144 | RawProtectedHeadersプロパティ | E-09 (L37) | ○ |
| C-145 | Signatureプロパティ | E-09 (L43) | ○ |

### CoseHelpers および内部クラス（UT-COSE-146〜161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-146 | GetByteStringEncodedSize 0バイト時 | E-10 (L21-24) | ○ |
| C-147 | GetByteStringEncodedSize 23バイト時 | E-10 (L21-24, L86-108) | ○ |
| C-148 | GetByteStringEncodedSize 24バイト境界 | E-10 (L21-24, L86-108) | ○ |
| C-149 | GetIntegerEncodedSize小さい正整数 | E-10 (L86-108) | ○ |
| C-150 | GetIntegerEncodedSize 24境界 | E-10 (L92-94) | ○ |
| C-151 | GetIntegerEncodedSize負整数 | E-10 (L32-43) | ○ |
| C-152 | GetTextStringEncodedSize空文字列 | E-10 (L26-30) | ○ |
| C-153 | DecodeCoseAlgorithmHeader ES256デコード | E-10 (L136-184) | ○ |
| C-154 | DecodeCoseAlgorithmHeader文字列アルゴリズム | E-10 (L165-175) | ○ |
| C-155 | DecodeCoseAlgorithmHeader未サポート時例外 | E-10 (L179-183) | ○ |
| C-156 | HashToBeSignedBuilder AppendToBeSigned | E-12 (L21-24) | ○ |
| C-157 | HashToBeSignedBuilder WithDataAndReset | E-12 (L31-41) | ○ |
| C-158 | HashToBeSignedBuilder Dispose | E-12 (L43-52) | ○ |
| C-159 | PureDataToBeSignedBuilder AppendToBeSigned | E-13 (L21-28) | ○ |
| C-160 | PureDataToBeSignedBuilder WithDataAndReset | E-13 (L35-48) | ○ |
| C-161 | PureDataToBeSignedBuilder Dispose | E-13 (L50-57) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべてのテストケースにソースコード上の根拠が存在

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコード解析に基づいて生成されており、メソッドシグネチャ・例外処理・プロパティアクセスの観点で十分な根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] 署名・検証系テストケース（UT-COSE-021〜043, 133〜141）がセキュリティ要件を満たしているか確認
- [ ] 境界値テスト（バッファサイズ、配列長）が適切な値でテストされているか確認
- [ ] 非同期メソッド（*Async）のCancellationToken処理がテストされているか確認
- [ ] RFC 8152準拠の観点でCBOR構造の検証テストが十分か確認
- [ ] MLDsa（ポスト量子暗号）関連のテストケースが実験的機能として適切にマークされているか確認
