---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 180
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Security.Cryptography.Csp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：180 / 180、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CspParameters.cs` - CspParametersクラスの実装
- E-02: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CspProviderFlags.cs` - CspProviderFlags列挙型の定義
- E-03: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/KeyNumber.cs` - KeyNumber列挙型の定義
- E-04: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/ICspAsymmetricAlgorithm.cs` - ICspAsymmetricAlgorithmインターフェースの定義
- E-05: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RSACryptoServiceProvider.Windows.cs` - RSACryptoServiceProvider Windows実装
- E-06: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RSACryptoServiceProvider.Unix.cs` - RSACryptoServiceProvider Unix実装
- E-07: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DSACryptoServiceProvider.Windows.cs` - DSACryptoServiceProvider Windows実装
- E-08: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DSACryptoServiceProvider.Unix.cs` - DSACryptoServiceProvider Unix実装
- E-09: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/AesCryptoServiceProvider.cs` - AesCryptoServiceProviderクラスの実装
- E-10: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DESCryptoServiceProvider.Windows.cs` - DESCryptoServiceProvider Windows実装
- E-11: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DESCryptoServiceProvider.Unix.cs` - DESCryptoServiceProvider Unix実装
- E-12: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/TripleDESCryptoServiceProvider.Wrap.cs` - TripleDESCryptoServiceProviderクラスの実装
- E-13: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RC2CryptoServiceProvider.Windows.cs` - RC2CryptoServiceProvider Windows実装
- E-14: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RC2CryptoServiceProvider.Unix.cs` - RC2CryptoServiceProvider Unix実装
- E-15: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RNGCryptoServiceProvider.cs` - RNGCryptoServiceProviderクラスの実装
- E-16: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/MD5CryptoServiceProvider.cs` - MD5CryptoServiceProviderクラスの実装
- E-17: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SHA1CryptoServiceProvider.cs` - SHA1CryptoServiceProviderクラスの実装
- E-18: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SHA256CryptoServiceProvider.cs` - SHA256CryptoServiceProviderクラスの実装
- E-19: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SHA384CryptoServiceProvider.cs` - SHA384CryptoServiceProviderクラスの実装
- E-20: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SHA512CryptoServiceProvider.cs` - SHA512CryptoServiceProviderクラスの実装
- E-21: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/PasswordDeriveBytes.cs` - PasswordDeriveBytesクラスの実装
- E-22: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/CspKeyContainerInfo.Windows.cs` - CspKeyContainerInfoクラスの実装
- E-23: `src/libraries/shims/System.Security.Cryptography.Csp/src/System.Security.Cryptography.Csp.cs` - 型転送定義
- E-24: `src/libraries/System.Security.Cryptography.Csp/README.md` - モジュール説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CspParameters.CspParameters()がProviderTypeとKeyNumberを初期化 | E-01 (L52-58) | ○ |
| C-02 | CspParameters.Flagsプロパティがバリデーション付きで設定可能 | E-01 (L22-47) | ○ |
| C-03 | CspParameters.Flagsに無効値でArgumentExceptionがスロー | E-01 (L40-44) | ○ |
| C-04 | RSACryptoServiceProvider()がデフォルト1024ビットで初期化 | E-05 (L24-31), E-06 (L18-19) | ○ |
| C-05 | RSACryptoServiceProvider(int)が指定サイズで初期化 | E-05 (L33-41), E-06 (L21-28) | ○ |
| C-06 | RSACryptoServiceProvider(int)に負値でArgumentOutOfRangeException | E-05 (L57), E-06 (L24) | ○ |
| C-07 | RSACryptoServiceProvider.Encrypt()がPKCS#1とOAEPパディングをサポート | E-05 (L319-339), E-06 (L85-111) | ○ |
| C-08 | RSACryptoServiceProvider.Decrypt()がサイズ検証を実施 | E-05 (L262-278), E-06 (L42-51) | ○ |
| C-09 | RSACryptoServiceProvider.SignHash()がPublicOnlyでCryptographicException | E-05 (L487-488), E-06 (L260-261) | ○ |
| C-10 | RSACryptoServiceProvider.LegalKeySizesが384-16384,8を返却 | E-05 (L201-207) | ○ |
| C-11 | RSACryptoServiceProvider.SignatureAlgorithmがXMLDSig URL | E-05 (L669-675), E-06 (L175) | ○ |
| C-12 | DSACryptoServiceProvider()がデフォルト1024ビットで初期化 | E-07 (L24-33), E-08 (L40-54) | ○ |
| C-13 | DSACryptoServiceProvider.SignHash()がSHA1のみサポート | E-07 (L480-498), E-08 (L227-241) | ○ |
| C-14 | DSACryptoServiceProvider.SignHash()がハッシュサイズ20バイトを検証 | E-07 (L489-490), E-08 (L233-234) | ○ |
| C-15 | DSACryptoServiceProvider.LegalKeySizesがFIPS 186-2準拠 | E-07 (L212-218), E-08 (L172) | ○ |
| C-16 | AesCryptoServiceProvider()がFeedbackSize=8で初期化 | E-09 (L16-21) | ○ |
| C-17 | AesCryptoServiceProviderが内部でAes.Create()をラップ | E-09 (L13-19) | ○ |
| C-18 | DESCryptoServiceProvider.GenerateKey()が弱いキーを除外 | E-10 (L21-31) | ○ |
| C-19 | DESCryptoServiceProvider.CreateTransform()が弱いキーでCryptographicException | E-10 (L73-76) | ○ |
| C-20 | DESCryptoServiceProvider.CreateTransform()が短いIVでCryptographicException | E-10 (L92-93) | ○ |
| C-21 | TripleDESCryptoServiceProviderが内部でTripleDES.Create()をラップ | E-12 (L12-19) | ○ |
| C-22 | TripleDESCryptoServiceProvider.CreateEncryptor/Decryptorがlarger IVをトリミング | E-12 (L71-75) | ○ |
| C-23 | RC2CryptoServiceProvider.EffectiveKeySizeがKeySizeと異なる値でException | E-13 (L31-42) | ○ |
| C-24 | RC2CryptoServiceProvider.UseSaltがUnixでtrue設定でPlatformNotSupportedException | E-14 (L110-119) | ○ |
| C-25 | RC2CryptoServiceProvider.LegalKeySizesが40-128,8 | E-13 (L18-21), E-14 (L15-18) | ○ |
| C-26 | RNGCryptoServiceProvider()がRandomNumberGeneratorをラップ | E-15 (L12-25) | ○ |
| C-27 | RNGCryptoServiceProvider(CspParameters)でPlatformNotSupportedException | E-15 (L20-21) | ○ |
| C-28 | MD5CryptoServiceProviderがIncrementalHashを使用 | E-16 (L13-18) | ○ |
| C-29 | SHA1CryptoServiceProviderがHashSizeInBits=160で初期化 | E-17 (L19-23) | ○ |
| C-30 | SHA256/384/512CryptoServiceProviderが対応するハッシュサイズで初期化 | E-18, E-19, E-20 | ○ |
| C-31 | PasswordDeriveBytes()がデフォルトSHA1/iterations=100 | E-21 (L46-53) | ○ |
| C-32 | PasswordDeriveBytes.HashName設定後のGetBytesでCryptographicException | E-21 (L76-77) | ○ |
| C-33 | PasswordDeriveBytes.IterationCountが0以下でArgumentOutOfRangeException | E-21 (L89) | ○ |
| C-34 | PasswordDeriveBytes.GetBytes()がprefix>999でCryptographicException | E-21 (L262-263) | ○ |
| C-35 | CspKeyContainerInfo.Accessibleが存在しないキーでfalse | E-22 (L46-59) | ○ |
| C-36 | CspKeyContainerInfo.ExportableがHardwareDeviceでfalse | E-22 (L65-77) | ○ |
| C-37 | CspKeyContainerInfo.ProtectedがHardwareDeviceでtrue | E-22 (L126-138) | ○ |
| C-38 | CspProviderFlags列挙型の各値が正しく定義 | E-02 (L9-20) | ○ |
| C-39 | KeyNumber列挙型がExchange=1, Signature=2 | E-03 (L10-15) | ○ |
| C-40 | ICspAsymmetricAlgorithmインターフェースの3メソッド定義 | E-04 (L6-11) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに基づいて生成されています

注記：System.Security.Cryptography.Cspモジュールは型転送のみを行うshimアセンブリであり、実際の実装はSystem.Security.Cryptographyライブラリに統合されています（E-23, E-24参照）。テストケースは実装先のソースコードを解析して生成しました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいている
- 注意点：
  - Windows専用機能（CspParameters、CspKeyContainerInfo）はクロスプラットフォームテストで注意が必要
  - 一部のクラス（DSACryptoServiceProvider等）はプラットフォームによって実装が異なる
  - Obsolete属性が付与されているクラスが多いため、将来的な非推奨化に注意

## 6) レビュアーチェックリスト（最小）
- [ ] CSVファイルの文字エンコーディングがUTF-8 with BOMであること
- [ ] テストIDの採番（UT-CSP-001〜180）が正しいこと
- [ ] 対象クラスの完全修飾名が正確であること
- [ ] Windows専用機能のテストケースにプラットフォーム制限が明記されていること
- [ ] 暗号化/復号、署名/検証のペアテストが網羅されていること
- [ ] 境界値テスト（キーサイズ、IVサイズ等）が含まれていること
- [ ] 例外テスト（ArgumentNullException、CryptographicException等）が含まれていること
