---
generated_at: 2026-01-30 18:00:00
metrics:
  claims_total: 62
  claims_with_evidence: 62
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Security.Cryptography.OpenSsl.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：62 / 62、根拠なし：0
- 優先レビュー（高）
  1. **ENGINE/Providerテスト**：実際のENGINE環境での動作確認が必要
  2. **プラットフォーム互換性テスト**：サポート対象/非対象プラットフォームでの動作検証
  3. **ネイティブハンドル管理テスト**：参照カウントの正確性検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SafeEvpPKeyHandle.OpenSsl.cs`
- E-02: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/SafeEvpPKeyHandle.OpenSsl.Unix.cs`
- E-03: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/DSAOpenSsl.cs`
- E-04: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/ECDiffieHellmanOpenSsl.cs`
- E-05: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/ECDsaOpenSsl.cs`
- E-06: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/RSAOpenSsl.cs`
- E-07: `src/libraries/System.Security.Cryptography/src/System/Security/Cryptography/OpenSsl.NotSupported.cs`
- E-08: `src/libraries/shims/System.Security.Cryptography.OpenSsl/src/System.Security.Cryptography.OpenSsl.cs`
- E-09: `src/libraries/System.Security.Cryptography.OpenSsl/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）

### SafeEvpPKeyHandle クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタで無効なハンドルが作成される | E-01 (L25-28) | ○ |
| C-02 | 有効なハンドルとownsHandle=trueで初期化される | E-01 (L35-38) | ○ |
| C-03 | ownsHandle=falseで参照カウント増加されない | E-01 (L35-38) | ○ |
| C-04 | サポートされないプラットフォームでPlatformNotSupportedException | E-07 (L243-246) | ○ |
| C-05 | IntPtr.Zeroの場合にIsInvalid=true | E-01 (L55-58) | ○ |
| C-06 | 有効なポインタの場合にIsInvalid=false | E-01 (L55-58) | ○ |
| C-07 | ReleaseHandleでEvpPkeyDestroyが呼ばれる | E-01 (L46-53) | ○ |
| C-08 | DuplicateHandleで有効なハンドルの複製が作成される | E-01 (L65-90) | ○ |
| C-09 | 無効なハンドルでInvalidOperationException | E-01 (L67-68) | ○ |
| C-10 | UpRefEvpPkey失敗時にCryptographicException | E-01 (L74-82) | ○ |
| C-11 | OpenSslVersionでバージョン番号が取得できる | E-02 (L22) | ○ |
| C-12 | OpenSslVersionでPlatformNotSupportedException（非対応プラットフォーム） | E-07 (L263-264) | ○ |
| C-13 | OpenPrivateKeyFromEngineで秘密鍵ハンドルが取得できる | E-01 (L131-142) | ○ |
| C-14 | OpenPrivateKeyFromEngineでengineNameがnullでArgumentNullException | E-01 (L133) | ○ |
| C-15 | OpenPrivateKeyFromEngineでkeyIdがnullでArgumentNullException | E-01 (L134) | ○ |
| C-16 | OpenPrivateKeyFromEngineでengineNameが空文字でArgumentException | E-01 (L133) | ○ |
| C-17 | OpenPrivateKeyFromEngineでkeyIdが空文字でArgumentException | E-01 (L134) | ○ |
| C-18 | OpenPrivateKeyFromEngineで無効なエンジン名でCryptographicException | E-01 (L141) | ○ |
| C-19 | OpenPublicKeyFromEngineで公開鍵ハンドルが取得できる | E-01 (L184-195) | ○ |
| C-20 | OpenPublicKeyFromEngineでengineNameがnullでArgumentNullException | E-01 (L186) | ○ |
| C-21 | OpenPublicKeyFromEngineでkeyIdがnullでArgumentNullException | E-01 (L187) | ○ |
| C-22 | OpenKeyFromProviderでキーハンドルが取得できる | E-01 (L236-247) | ○ |
| C-23 | OpenKeyFromProviderでproviderNameがnullでArgumentNullException | E-01 (L238) | ○ |
| C-24 | OpenKeyFromProviderでkeyUriがnullでArgumentNullException | E-01 (L239) | ○ |
| C-25 | OpenKeyFromProviderでproviderNameが空文字でArgumentException | E-01 (L238) | ○ |

### DSAOpenSsl クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | DSAParametersからDSAOpenSslインスタンスが作成される | E-03 (L16-22) | ○ |
| C-27 | サポートされないプラットフォームでPlatformNotSupportedException | E-03 (L18), E-07 (L18) | ○ |
| C-28 | 有効なSafeEvpPKeyHandleからDSAOpenSslインスタンスが作成される | E-03 (L39-56) | ○ |
| C-29 | pkeyHandleがnullでArgumentNullException | E-03 (L41) | ○ |
| C-30 | 無効なpkeyHandleでArgumentException | E-03 (L43-44) | ○ |
| C-31 | DSA以外の鍵タイプでCryptographicException | E-03 (L48-53) | ○ |
| C-32 | 有効なDSA*ポインタからDSAOpenSslインスタンスが作成される | E-03 (L73-81) | ○ |
| C-33 | handle=IntPtr.ZeroでArgumentException | E-03 (L75-76) | ○ |
| C-34 | DuplicateKeyHandleで現在の鍵のSafeEvpPKeyHandleコピーが返される | E-03 (L88-110) | ○ |

### ECDiffieHellmanOpenSsl クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | 有効なEC鍵ハンドルからECDiffieHellmanOpenSslインスタンスが作成される | E-04 (L25-41) | ○ |
| C-36 | pkeyHandleがnullでArgumentNullException | E-04 (L27) | ○ |
| C-37 | 無効なpkeyHandleでArgumentException | E-04 (L29-30) | ○ |
| C-38 | EC以外の鍵タイプでCryptographicException | E-04 (L34-37) | ○ |
| C-39 | 有効なEC_KEY*ポインタからECDiffieHellmanOpenSslインスタンスが作成される | E-04 (L58-72) | ○ |
| C-40 | handle=IntPtr.ZeroでArgumentException | E-04 (L60-61) | ○ |
| C-41 | DuplicateKeyHandleで現在の鍵のSafeEvpPKeyHandleコピーが返される | E-04 (L79-83) | ○ |
| C-42 | 破棄済みインスタンスでObjectDisposedException | E-04 (L81) ThrowIfDisposed | ○ |

### ECDsaOpenSsl クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | 有効なEC鍵ハンドルからECDsaOpenSslインスタンスが作成される | E-05 (L25-41) | ○ |
| C-44 | pkeyHandleがnullでArgumentNullException | E-05 (L27) | ○ |
| C-45 | 無効なpkeyHandleでArgumentException | E-05 (L29-30) | ○ |
| C-46 | EC以外の鍵タイプでCryptographicException | E-05 (L34-37) | ○ |
| C-47 | 有効なEC_KEY*ポインタからECDsaOpenSslインスタンスが作成される | E-05 (L58-72) | ○ |
| C-48 | handle=IntPtr.ZeroでArgumentException | E-05 (L60-61) | ○ |
| C-49 | DuplicateKeyHandleで現在の鍵のSafeEvpPKeyHandleコピーが返される | E-05 (L79-83) | ○ |
| C-50 | 破棄済みインスタンスでObjectDisposedException | E-05 (L81) ThrowIfDisposed | ○ |

### RSAOpenSsl クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | RSAParametersからRSAOpenSslインスタンスが作成される | E-06 (L17-24) | ○ |
| C-52 | サポートされないプラットフォームでPlatformNotSupportedException | E-06 (L19), E-07 (L189) | ○ |
| C-53 | 有効なRSA鍵ハンドルからRSAOpenSslインスタンスが作成される | E-06 (L68-84) | ○ |
| C-54 | pkeyHandleがnullでArgumentNullException | E-06 (L70) | ○ |
| C-55 | 無効なpkeyHandleでArgumentException | E-06 (L72-73) | ○ |
| C-56 | RSA以外の鍵タイプでCryptographicException | E-06 (L77-80) | ○ |
| C-57 | 有効なRSA*ポインタからRSAOpenSslインスタンスが作成される | E-06 (L41-51) | ○ |
| C-58 | handle=IntPtr.ZeroでArgumentException | E-06 (L43-44) | ○ |
| C-59 | DuplicateKeyHandleで現在の鍵のSafeEvpPKeyHandleコピーが返される | E-06 (L91-94) | ○ |

### 追加のSafeEvpPKeyHandle機能
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | ExtraHandleがプロバイダロード時に保持される | E-01 (L18, L40-44) | ○ |
| C-61 | ReleaseHandleでExtraHandleも解放される | E-01 (L48-49) | ○ |
| C-62 | DuplicateHandleでExtraHandleもコピーされる | E-01 (L87-88) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本モジュールのソースコードはSystem.Security.Cryptographyに統合されているため、すべてのテストケースはそちらの実装に基づいている
- 実際のENGINE/OSSL_PROVIDER環境でのテストは環境依存のため、モックテストの検討が必要
  - 候補：OpenSSLテスト用ENGINE / ソフトウェアHSMシミュレータ / tpmプロバイダ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型転送のみのアセンブリであり、実装はSystem.Security.Cryptographyに統合済み
- 1: 中リスク - ネイティブハンドル管理のテストは参照カウント管理の正確性に依存
- 1: 中リスク - プラットフォーム制約テストは複数OS環境での実行が必要
- 2: 高リスク - ENGINE/Providerテストは実際のハードウェアまたはソフトウェアエミュレータが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各OpenSslクラスのコンストラクタが正しいパラメータ検証を行っているか確認
- [ ] SafeEvpPKeyHandleの参照カウント管理が適切にテストされているか確認
- [ ] プラットフォーム非対応時の例外スローが漏れなくテストされているか確認
- [ ] ENGINE/Providerロード機能のモックテスト戦略が適切か確認
- [ ] Disposeパターンの遵守がテストされているか確認
