---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 185
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Security.Cryptography.Pkcs 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：クラスのpublicメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：185 / 190、根拠なし：5
- 優先レビュー（高）
  1. **UT-PKCS-042**: RecipientInfos Encrypt後アクセス - プラットフォーム固有の挙動
  2. **UT-PKCS-056/057**: Decrypt状態遷移 - PkcsPalの内部実装依存
  3. **UT-PKCS-140**: ProcessResponse不正レスポンス - 具体的なエラーパターンの検証

## 2) 参照した情報（Evidence一覧）
> ここに実在するソースファイルを列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/SignedCms.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/EnvelopedCms.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/CmsSigner.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/SignerInfo.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/CmsRecipient.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/ContentInfo.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/Rfc3161TimestampRequest.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/Rfc3161TimestampToken.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/Rfc3161TimestampTokenInfo.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/SubjectIdentifier.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Security.Cryptography.Pkcs/src/System/Security/Cryptography/Pkcs/RecipientInfoCollection.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SignedCms クラス (UT-PKCS-001 - UT-PKCS-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでArgumentNullExceptionがスローされる | E-01 Line 46-49 | ○ |
| C-02 | SubjectIdentifierTypeの正規化処理 | E-01 Line 56-66 | ○ |
| C-03 | Certificatesプロパティの初期状態 | E-01 Line 73-101 | ○ |
| C-04 | SignerInfosプロパティの初期状態 | E-01 Line 103-114 | ○ |
| C-05 | Encodeで未署名時InvalidOperationException | E-01 Line 116-121 | ○ |
| C-06 | Decodeでnull引数チェック | E-01 Line 156-158 | ○ |
| C-07 | ComputeSignatureでArgumentNullException | E-01 Line 303 | ○ |
| C-08 | ComputeSignatureで空コンテンツチェック | E-01 Line 308-311 | ○ |
| C-09 | NoSignature署名の制約 | E-01 Line 313-319 | ○ |
| C-10 | RemoveSignatureのインデックス検証 | E-01 Line 388-398 | ○ |
| C-11 | CheckSignatureの状態検証 | E-01 Line 603-611 | ○ |
| C-12 | AddCertificateの重複チェック | E-01 Line 676-684 | ○ |
| C-13 | RemoveCertificateの存在チェック | E-01 Line 709-731 | ○ |

### EnvelopedCms クラス (UT-PKCS-036 - UT-PKCS-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタでArgumentNullException | E-02 Line 30-31 | ○ |
| C-15 | RecipientInfosの状態依存動作 | E-02 Line 58-80 | ○ |
| C-16 | Encryptでnull引数チェック | E-02 Line 87, 94 | ○ |
| C-17 | Encryptで空コレクションチェック | E-02 Line 97-98 | ○ |
| C-18 | Encodeで未暗号化時例外 | E-02 Line 114-116 | ○ |
| C-19 | Decodeでnull引数チェック | E-02 Line 125 | ○ |
| C-20 | Decryptの状態検証 | E-02 Line 268-288 | ○ |
| C-21 | DecryptでArgumentNullException | E-02 Line 180, 188 | ○ |

### CmsSigner クラス (UT-PKCS-063 - UT-PKCS-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | SignerIdentifierTypeの検証 | E-03 Line 72-74 | ○ |
| C-23 | SignaturePaddingの検証 | E-03 Line 57-63 | ○ |
| C-24 | RSASignaturePaddingの不正値チェック | E-03 Line 185-189 | ○ |
| C-25 | デフォルトDigestAlgorithm | E-03 Line 19, 216 | ○ |
| C-26 | デフォルトIncludeOption | E-03 Line 196, 199, 203 | ○ |
| C-27 | CheckCertificateValueの検証 | E-03 Line 224-240 | ○ |

### SignerInfo クラス (UT-PKCS-078 - UT-PKCS-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Versionプロパティ | E-04 Line 21 | ○ |
| C-29 | SignerIdentifierプロパティ | E-04 Line 22 | ○ |
| C-30 | Certificateプロパティ | E-04 Line 74-75 | ○ |
| C-31 | DigestAlgorithmプロパティ | E-04 Line 93 | ○ |
| C-32 | SignatureAlgorithmプロパティ | E-04 Line 100 | ○ |
| C-33 | CounterSignerInfosの動作 | E-04 Line 77-91 | ○ |
| C-34 | ComputeCounterSignatureの検証 | E-04 Line 292-344 | ○ |
| C-35 | RemoveCounterSignatureの検証 | E-04 Line 346-424 | ○ |
| C-36 | CheckSignatureの検証 | E-04 Line 449-469 | ○ |
| C-37 | CheckHashの検証 | E-04 Line 471-482 | ○ |
| C-38 | AddUnsignedAttributeの動作 | E-04 Line 183-222 | ○ |
| C-39 | RemoveUnsignedAttributeの動作 | E-04 Line 229-254 | ○ |

### CmsRecipient クラス (UT-PKCS-105 - UT-PKCS-111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | コンストラクタでArgumentNullException | E-05 Line 47 | ○ |
| C-41 | 不正なSubjectIdentifierTypeチェック | E-05 Line 58-59 | ○ |
| C-42 | RSAEncryptionPaddingのnullチェック | E-05 Line 25, 39 | ○ |
| C-43 | 非RSA証明書でのパディング指定チェック | E-05 Line 75-84 | ○ |

### ContentInfo クラス (UT-PKCS-112 - UT-PKCS-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタでArgumentNullException | E-06 Line 24-25 | ○ |
| C-45 | GetContentTypeでArgumentNullException | E-06 Line 37 | ○ |
| C-46 | GetContentType(ReadOnlySpan)の動作 | E-06 Line 43-46 | ○ |

### Rfc3161TimestampRequest クラス (UT-PKCS-119 - UT-PKCS-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | Versionプロパティ | E-07 Line 25 | ○ |
| C-48 | GetMessageHashメソッド | E-07 Line 26 | ○ |
| C-49 | HashAlgorithmIdプロパティ | E-07 Line 27 | ○ |
| C-50 | RequestedPolicyIdプロパティ | E-07 Line 28 | ○ |
| C-51 | Encodeメソッド | E-07 Line 146-149 | ○ |
| C-52 | TryEncodeメソッド | E-07 Line 151-162 | ○ |
| C-53 | CreateFromSignerInfoのnullチェック | E-07 Line 172 | ○ |
| C-54 | TryDecodeの動作 | E-07 Line 341-380 | ○ |
| C-55 | ProcessResponseの動作 | E-07 Line 60-71 | ○ |

### Rfc3161TimestampToken クラス (UT-PKCS-141 - UT-PKCS-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | TokenInfoプロパティ | E-08 Line 23 | ○ |
| C-57 | AsSignedCmsメソッド | E-08 Line 40 | ○ |
| C-58 | VerifySignatureForDataメソッド | E-08 Line 74-95 | ○ |
| C-59 | VerifySignatureForHashメソッド | E-08 Line 97-149 | ○ |
| C-60 | VerifySignatureForSignerInfoのnullチェック | E-08 Line 156 | ○ |
| C-61 | TryDecodeの動作 | E-08 Line 290-422 | ○ |

### Rfc3161TimestampTokenInfo クラス (UT-PKCS-153 - UT-PKCS-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタでArgumentNullException | E-09 Line 326-327 | ○ |
| C-63 | Versionプロパティ | E-09 Line 81 | ○ |
| C-64 | PolicyIdプロパティ | E-09 Line 87 | ○ |
| C-65 | Timestampプロパティ | E-09 Line 111 | ○ |
| C-66 | Encodeメソッド | E-09 Line 202-205 | ○ |
| C-67 | TryEncodeメソッド | E-09 Line 213-224 | ○ |
| C-68 | TryDecodeの精度境界値チェック | E-09 Line 285-292 | ○ |

### SubjectIdentifier クラス (UT-PKCS-175 - UT-PKCS-181)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Typeプロパティ | E-10 Line 98 | ○ |
| C-70 | Valueプロパティ | E-10 Line 99 | ○ |
| C-71 | MatchesCertificateメソッド | E-10 Line 106-133 | ○ |

### RecipientInfoCollection クラス (UT-PKCS-182 - UT-PKCS-190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | インデクサの境界値チェック | E-11 Line 33-34 | ○ |
| C-73 | Countプロパティ | E-11 Line 39-45 | ○ |
| C-74 | CopyToのnullチェック | E-11 Line 59, 76 | ○ |
| C-75 | CopyToの次元チェック | E-11 Line 61-62 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-PKCS-042**: `RecipientInfos`のEncrypt後アクセス時の例外タイプはPkcsPalの実装依存のため、プラットフォームごとのテストが必要
  - 候補：Windows / Linux / macOS での挙動確認
- **UT-PKCS-056/057**: `Decrypt`の二重呼び出し/Encrypt後呼び出しの例外タイプはPkcsPal内部実装に依存
  - 候補：PkcsPal.Windows / PkcsPal.AnyOS の実装詳細確認
- **UT-PKCS-140**: ProcessResponseの具体的なエラーパターン検証にはRFC3161のテストベクターが必要
  - 候補：RFC3161仕様書 / 既存テストデータファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 基本的なプロパティ取得、null検証（大半のケース）
- **1: 中リスク**: 状態遷移、境界値テスト、コレクション操作
- **2: 高リスク**: 暗号化・復号化処理、署名検証、RFC3161タイムスタンプ処理

## 6) レビュアーチェックリスト（最小）
- [ ] SignedCmsの署名追加・削除フローが正しくテストされているか
- [ ] EnvelopedCmsの状態遷移（Ctor -> Encrypt -> Encode / Decode -> Decrypt）が網羅されているか
- [ ] RFC3161タイムスタンプの作成・検証フローが網羅されているか
- [ ] 各クラスのnull引数検証が含まれているか
- [ ] 境界値テスト（空配列、範囲外インデックス）が含まれているか
- [ ] プラットフォーム依存の挙動に関するテストケースが適切にマークされているか
