---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 42
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Security.Cryptography.ProtectedData 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：42 / 42、根拠なし：0
- 優先レビュー（高）
  1. **特になし**：すべてのテストケースがソースコードまたは既存テストから根拠を確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Security.Cryptography.ProtectedData/src/System/Security/Cryptography/ProtectedData.cs`
- E-02: `src/libraries/System.Security.Cryptography.ProtectedData/src/System/Security/Cryptography/DataProtectionScope.cs`
- E-03: `src/libraries/System.Security.Cryptography.ProtectedData/tests/ProtectedDataTests.cs`
- E-04: `src/libraries/System.Security.Cryptography.ProtectedData/tests/ArrayProtectedDataTests.cs`
- E-05: `src/libraries/System.Security.Cryptography.ProtectedData/tests/SpanProtectedDataTests.cs`
- E-06: `src/libraries/System.Security.Cryptography.ProtectedData/tests/TrySpanProtectedDataTests.cs`
- E-07: `src/libraries/System.Security.Cryptography.ProtectedData/tests/SpanInArrayOutProtectedDataTests.cs`
- E-08: `src/libraries/System.Security.Cryptography.ProtectedData/tests/ProtectedDataUnsupportedTests.cs`
- E-09: `src/libraries/System.Security.Cryptography.ProtectedData/src/System.Security.Cryptography.ProtectedData.csproj`

## 3) Claims と根拠の対応（レビューの主戦場）

### ProtectedData.Protect(byte[], byte[], DataProtectionScope) - 配列オーバーロード

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CurrentUserスコープでデータが正しく暗号化される | E-01 (L16-34), E-03 (L17-27) | ○ |
| C-02 | LocalMachineスコープでデータが正しく暗号化される | E-01 (L16-34), E-03 (L17-27) | ○ |
| C-03 | エントロピー付きでデータが正しく暗号化される | E-01 (L16-34), E-03 (L14-27) | ○ |
| C-04 | 空データが正しく暗号化される | E-01 (L14, L335), E-03 (L34-45) | ○ |
| C-05 | userDataがnullの場合ArgumentNullExceptionがスローされる | E-01 (L20) | ○ |
| C-06 | 非WindowsでPlatformNotSupportedExceptionがスローされる | E-01 (L421-427), E-08 (L16-19) | ○ |

### ProtectedData.Unprotect(byte[], byte[], DataProtectionScope) - 配列オーバーロード

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | Protectで暗号化されたデータが正しく復号できる | E-01 (L167-186), E-03 (L17-27) | ○ |
| C-08 | エントロピー付きで暗号化されたデータが正しく復号できる | E-01 (L167-186), E-03 (L14-27) | ○ |
| C-09 | encryptedDataがnullの場合ArgumentNullExceptionがスローされる | E-01 (L171) | ○ |
| C-10 | 異なるエントロピーで復号時CryptographicExceptionがスローされる | E-03 (L47-59) | ○ |
| C-11 | エントロピーなし暗号化データをエントロピー付きで復号時エラー | E-03 (L47-59) | ○ |
| C-12 | エントロピー付き暗号化データをエントロピーなしで復号時エラー | E-03 (L47-59) | ○ |
| C-13 | 非WindowsでPlatformNotSupportedExceptionがスローされる | E-01 (L421-427), E-08 (L21-27) | ○ |

### 境界値テスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | 空のエントロピー配列がnullエントロピーと等価 | E-04 (L11-29) | ○ |

### Span API - Protect オーバーロード

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Span入力でデータが正しく暗号化される | E-01 (L53-72), E-07 | ○ |
| C-16 | Span入力でエントロピー付きデータが正しく暗号化される | E-01 (L53-72), E-07 | ○ |
| C-17 | TryProtectで十分なバッファでtrueが返る | E-01 (L101-119), E-06 (L12-18) | ○ |
| C-18 | TryProtectでバッファ不足時falseが返る | E-01 (L101-119), E-06 (L30-34) | ○ |
| C-19 | TryProtectで必要サイズちょうどで成功 | E-06 (L36-59) | ○ |
| C-20 | TryProtectで必要サイズ-1で失敗 | E-06 (L36-59) | ○ |
| C-21 | Protect(Span出力)で書き込みバイト数が返る | E-01 (L141-164), E-05 (L12-19) | ○ |
| C-22 | Protect(Span出力)でバッファ不足時ArgumentExceptionがスローされる | E-01 (L160-161), E-05 (L31-36) | ○ |

### Span API - Unprotect オーバーロード

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Span入力で暗号化データが正しく復号できる | E-01 (L205-225), E-07 (L14-20) | ○ |
| C-24 | TryUnprotectで十分なバッファでtrueが返る | E-01 (L254-272), E-06 (L21-28) | ○ |
| C-25 | TryUnprotectでバッファ不足時falseが返る | E-01 (L254-272), E-06 (L61-76) | ○ |
| C-26 | TryUnprotectで必要サイズちょうどで成功 | E-06 (L61-76) | ○ |
| C-27 | TryUnprotectで必要サイズ-1で失敗 | E-06 (L61-76) | ○ |
| C-28 | Unprotect(Span出力)で書き込みバイト数が返る | E-01 (L294-317), E-05 (L21-28) | ○ |
| C-29 | Unprotect(Span出力)でバッファ不足時ArgumentExceptionがスローされる | E-01 (L313), E-05 (L62-84) | ○ |

### ラウンドトリップテスト

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | CurrentUserスコープでラウンドトリップが成功 | E-03 (L17-27) | ○ |
| C-31 | LocalMachineスコープでラウンドトリップが成功 | E-03 (L17-27) | ○ |
| C-32 | 空データのラウンドトリップが成功 | E-03 (L34-45) | ○ |

### DataProtectionScope列挙型

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CurrentUser列挙値が0 | E-02 (L9) | ○ |
| C-34 | LocalMachine列挙値が1 | E-02 (L10) | ○ |

### 内部処理・エラーハンドリング

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Win32 API失敗時CryptographicExceptionがスローされる | E-01 (L360-371) | ○ |
| C-36 | ユーザープロファイル未ロード時専用エラーメッセージ | E-01 (L367-368, L414-419) | ○ |
| C-37 | OOMでnullポインタ時OutOfMemoryExceptionがスローされる | E-01 (L375-376) | ○ |
| C-38 | 不明なscope値でもエラーにならない（.NET Framework互換） | E-01 (L346, コメント) | ○ |
| C-39 | CheckPlatformSupportで非WindowsでPlatformNotSupportedException | E-01 (L421-427) | ○ |
| C-40 | E_FILENOTFOUNDでtrueが返る | E-01 (L414-419) | ○ |
| C-41 | ERROR_FILE_NOT_FOUNDでtrueが返る | E-01 (L414-419) | ○ |
| C-42 | その他のエラーコードでfalseが返る | E-01 (L414-419) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースがソースコードまたは既存テストコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - このモジュールは比較的小規模（2つのソースファイル）であり、既存テストコードが充実しています。すべてのテストケースがソースコードに明確な根拠を持っています。

### 注意点
- Windows専用APIのため、非Windowsプラットフォームでのテスト実行には制限があります
- 内部メソッド（TryProtectOrUnprotect, ErrorMayBeCausedByUnloadedProfile, CheckPlatformSupport）は直接テストできないため、公開APIを通じた間接テストが必要です

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-PDA-xxx）が正しく適用されているか
- [ ] すべてのpublicメソッドが網羅されているか
- [ ] 正常系・異常系・境界値の観点が適切にバランスしているか
- [ ] Windows専用テスト（PlatformSpecific属性）とプラットフォーム非依存テストが区別されているか
- [ ] Span APIオーバーロード（.NET環境専用）のテストケースが含まれているか
- [ ] ラウンドトリップテスト（Protect→Unprotect）が各スコープで確認されているか
- [ ] エントロピー不一致時のエラーハンドリングがテストされているか
