---
generated_at: 2026-01-30 18:00:00
metrics:
  claims_total: 205
  claims_with_evidence: 195
  claims_without_evidence: 10
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Security.Cryptography.Xml 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 195 / 205 = 0.95
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：195 / 205、根拠なし：10
- 優先レビュー（高）
  1. **UT-SCX-125〜127**: X509IncludeOption処理のチェーン検証詳細
  2. **UT-SCX-088**: Reference数上限値の具体的な値
  3. **UT-SCX-100**: Transform数上限値の具体的な値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/SignedXml.cs`
- E-02: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/EncryptedXml.cs`
- E-03: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/Signature.cs`
- E-04: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/SignedInfo.cs`
- E-05: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/Reference.cs`
- E-06: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/KeyInfo.cs`
- E-07: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/Transform.cs`
- E-08: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/TransformChain.cs`
- E-09: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/CipherData.cs`
- E-10: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/DataObject.cs`
- E-11: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/EncryptedType.cs`
- E-12: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/EncryptedKey.cs`
- E-13: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/RSAKeyValue.cs`
- E-14: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/DSAKeyValue.cs`
- E-15: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/KeyInfoX509Data.cs`
- E-16: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/SymmetricKeyWrap.cs`
- E-17: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/EncryptionMethod.cs`
- E-18: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/XmlDsigC14NTransform.cs`
- E-19: `src/libraries/System.Security.Cryptography.Xml/src/System/Security/Cryptography/Xml/XmlDsigEnvelopedSignatureTransform.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-05 | SignedXmlコンストラクタのテストケース | E-01 (SignedXml.cs L89-110) | ○ |
| C-06〜C-12 | ComputeSignatureメソッドのテストケース | E-01 (SignedXml.cs L381-464) | ○ |
| C-13〜C-22 | CheckSignatureメソッドのテストケース | E-01 (SignedXml.cs L248-378) | ○ |
| C-23〜C-30 | SignedXmlその他メソッドのテストケース | E-01 | ○ |
| C-31〜C-68 | EncryptedXmlクラスのテストケース | E-02 (EncryptedXml.cs) | ○ |
| C-69〜C-77 | Signatureクラスのテストケース | E-03 (Signature.cs) | ○ |
| C-78〜C-90 | SignedInfoクラスのテストケース | E-04 (SignedInfo.cs) | ○ |
| C-88 | Reference数上限超過テスト | E-04 (L258: MaxReferencesPerSignedInfo) | △ |
| C-91〜C-102 | Referenceクラスのテストケース | E-05 (Reference.cs) | ○ |
| C-100 | Transform数上限超過テスト | E-05 (L245: MaxTransformsPerReference) | △ |
| C-103〜C-109 | KeyInfoクラスのテストケース | E-06 (KeyInfo.cs) | ○ |
| C-110〜C-116 | RSAKeyValueクラスのテストケース | E-13 (RSAKeyValue.cs) | ○ |
| C-117〜C-122 | DSAKeyValueクラスのテストケース | E-14 (DSAKeyValue.cs) | ○ |
| C-123〜C-138 | KeyInfoX509Dataクラスのテストケース | E-15 (KeyInfoX509Data.cs) | ○ |
| C-125〜C-127 | X509IncludeOptionのチェーン処理 | E-15 (L57-98) | △ |
| C-139〜C-148 | CipherDataクラスのテストケース | E-09 (CipherData.cs) | ○ |
| C-149〜C-155 | DataObjectクラスのテストケース | E-10 (DataObject.cs) | ○ |
| C-156〜C-161 | EncryptionMethodクラスのテストケース | E-17 (EncryptionMethod.cs) | ○ |
| C-162〜C-170 | EncryptedKeyクラスのテストケース | E-12 (EncryptedKey.cs) | ○ |
| C-171〜C-177 | TransformChainクラスのテストケース | E-08 (TransformChain.cs) | ○ |
| C-178〜C-188 | XmlDsigC14NTransformクラスのテストケース | E-18 (XmlDsigC14NTransform.cs) | ○ |
| C-189〜C-196 | XmlDsigEnvelopedSignatureTransformクラスのテストケース | E-19 (XmlDsigEnvelopedSignatureTransform.cs) | ○ |
| C-197〜C-205 | SymmetricKeyWrapクラスのテストケース | E-16 (SymmetricKeyWrap.cs) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Reference数・Transform数の上限値**: Utils.MaxReferencesPerSignedInfo / Utils.MaxTransformsPerReference の具体的な値はUtils.csで定義されているが、今回の解析対象外。テストケースでは境界値として記載。
  - 候補：Utils.cs / AppContext スイッチ / 環境変数設定
- **X509チェーン検証の詳細動作**: X509Chain.Buildの動作はプラットフォーム依存。部分チェーンの具体的なシナリオは外部証明書ストアに依存。
  - 候補：プラットフォーム固有テスト / モック証明書
- **暗号アルゴリズムのサポート状況**: プラットフォームによりDESやTripleDESのサポート状況が異なる可能性あり。
  - 候補：プラットフォーム固有テスト / Feature Detection

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 大半のテストケースはソースコードから直接導出され、明確な根拠がある
- 1 (中リスク): X509チェーン検証（C-125〜C-127）はプラットフォーム依存の可能性あり
- 1 (中リスク): 上限値テスト（C-88, C-100）は具体的な数値の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（SignedXml.ComputeSignature、CheckSignature、EncryptedXml暗号化/復号）が網羅されているか
- [ ] セキュリティ関連の異常系テスト（不正な署名検出、チェックサム検証失敗）が含まれているか
- [ ] null入力検証がすべての公開メソッドに対して存在するか
- [ ] XML読み込み時の必須要素チェックがテストされているか
- [ ] 鍵ラップ/アンラップのラウンドトリップテストが設計されているか
- [ ] プラットフォーム固有の制限（DSAのiOS/tvOS非対応等）が考慮されているか
