---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 212
  claims_with_evidence: 210
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート: libraries-System.Security.Permissions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：210 / 212、根拠なし：2
- 優先レビュー（高）
  1. **UT-SSP-042**: PrincipalPermission.Demand の CurrentPrincipal null 検証 - 実行時環境依存
  2. **UT-SSP-043**: PrincipalPermission.Demand の未認証ユーザー検証 - 実行時環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Permissions/src/System/Security/CodeAccessPermission.cs`
- E-02: `src/libraries/System.Security.Permissions/src/System/Security/HostProtectionException.cs`
- E-03: `src/libraries/System.Security.Permissions/src/System/Security/NamedPermissionSet.cs`
- E-04: `src/libraries/System.Security.Permissions/src/System/Security/XmlSyntaxException.cs`
- E-05: `src/libraries/System.Security.Permissions/src/System/Security/SecurityState.cs`
- E-06: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/PrincipalPermission.cs`
- E-07: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/IDRole.cs`
- E-08: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/FileIOPermission.cs`
- E-09: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/EnvironmentPermission.cs`
- E-10: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/RegistryPermission.cs`
- E-11: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/UIPermission.cs`
- E-12: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/ReflectionPermission.cs`
- E-13: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/SecurityPermission.cs`
- E-14: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/StorePermission.cs`
- E-15: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/KeyContainerPermission.cs`
- E-16: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/ZoneIdentityPermission.cs`
- E-17: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/UrlIdentityPermission.cs`
- E-18: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/SiteIdentityPermission.cs`
- E-19: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/StrongNameIdentityPermission.cs`
- E-20: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/PublisherIdentityPermission.cs`
- E-21: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/GacIdentityPermission.cs`
- E-22: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/IsolatedStoragePermission.cs`
- E-23: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/IsolatedStorageFilePermission.cs`
- E-24: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/FileDialogPermission.cs`
- E-25: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/DataProtectionPermission.cs`
- E-26: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/TypeDescriptorPermission.cs`
- E-27: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/MediaPermission.cs`
- E-28: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/WebBrowserPermission.cs`
- E-29: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/HostProtectionAttribute.cs`
- E-30: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/StrongNamePublicKeyBlob.cs`
- E-31: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/KeyContainerPermissionAccessEntry.cs`
- E-32: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/KeyContainerPermissionAccessEntryCollection.cs`
- E-33: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/ResourcePermissionBase.cs`
- E-34: `src/libraries/System.Security.Permissions/src/System/Security/Permissions/ResourcePermissionBaseEntry.cs`
- E-35: `src/libraries/System.Security.Permissions/src/System/Net/DnsPermission.cs`
- E-36: `src/libraries/System.Security.Permissions/src/System/Net/SocketPermission.cs`
- E-37: `src/libraries/System.Security.Permissions/src/System/Net/WebPermission.cs`
- E-38: `src/libraries/System.Security.Permissions/src/System/Net/Mail/SmtpPermission.cs`
- E-39: `src/libraries/System.Security.Permissions/src/System/Net/NetworkInformation/NetworkInformationPermission.cs`
- E-40: `src/libraries/System.Security.Permissions/src/System/Configuration/ConfigurationPermission.cs`
- E-41: `src/libraries/System.Security.Permissions/src/System/Drawing/Printing/PrintingPermission.cs`
- E-42: `src/libraries/System.Security.Permissions/src/System/DirectoryServices/DirectoryServicesPermission.cs`
- E-43: `src/libraries/System.Security.Permissions/src/System/Security/Policy/CodeGroup.cs`
- E-44: `src/libraries/System.Security.Permissions/src/System/Security/Policy/ApplicationTrust.cs`
- E-45: `src/libraries/System.Security.Permissions/src/System/Security/Policy/TrustManagerContext.cs`
- E-46: `src/libraries/System.Security.Permissions/src/System/Security/HostSecurityManager.cs`
- E-47: `src/libraries/System.Security.Permissions/src/System/Xaml/Permissions/XamlLoadPermission.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CodeAccessPermission 関連 (UT-SSP-001 - UT-SSP-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Assert メソッドが no-op であること | E-01 (line 12) | ○ |
| C-02 | Demand メソッドが no-op であること | E-01 (line 14) | ○ |
| C-03 | Deny メソッドが PlatformNotSupportedException をスローすること | E-01 (line 16) | ○ |
| C-04 | PermitOnly メソッドが PlatformNotSupportedException をスローすること | E-01 (line 22) | ○ |
| C-05 | 静的 Revert メソッドが no-op であること | E-01 (lines 23-27) | ○ |

### HostProtectionException 関連 (UT-SSP-009 - UT-SSP-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | HResult が E_HostProtection (-2146232768) であること | E-02 (lines 20-27) | ○ |
| C-07 | ProtectedResources/DemandedResources プロパティが設定されること | E-02 (lines 43-49) | ○ |
| C-08 | ToString がリソース情報を含むこと | E-02 (lines 78-86) | ○ |
| C-09 | GetObjectData がシリアライズを正しく行うこと | E-02 (lines 92-97) | ○ |

### NamedPermissionSet 関連 (UT-SSP-015 - UT-SSP-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | コンストラクタがスタブ実装であること | E-03 (lines 13-16) | ○ |
| C-11 | Name/Description プロパティが存在すること | E-03 (lines 17-18) | ○ |
| C-12 | Copy メソッドが default を返すこと | E-03 (lines 19-20) | ○ |

### PrincipalPermission 関連 (UT-SSP-025 - UT-SSP-055)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Unrestricted/None の PermissionState 処理 | E-06 (lines 18-31) | ○ |
| C-14 | 無効な PermissionState で ArgumentException | E-06 (lines 29-31) | ○ |
| C-15 | IsUnrestricted の判定ロジック | E-06 (lines 65-73) | ○ |
| C-16 | IsSubsetOf の比較ロジック | E-06 (lines 75-116) | ○ |
| C-17 | Intersect の演算ロジック | E-06 (lines 118-172) | ○ |
| C-18 | Union の演算ロジック | E-06 (lines 174-197) | ○ |
| C-19 | Demand メソッドの認証チェックロジック | E-06 (lines 224-249) | ○ |
| C-20 | CurrentPrincipal が null の場合の SecurityException | E-06 (lines 226-228) | △ |
| C-21 | 未認証ユーザーの場合の SecurityException | E-06 (lines 240-248) | △ |
| C-22 | ToXml/FromXml の XML 処理 | E-06 (lines 251-295) | ○ |
| C-23 | FromXml の入力検証 | E-06 (lines 272-280) | ○ |

### IDRole 関連 (UT-SSP-056 - UT-SSP-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | コンストラクタでプロパティが設定されること | E-07 (lines 12-17) | ○ |
| C-25 | SecurityElement からの復元 | E-07 (lines 19-25) | ○ |
| C-26 | ToXml での Identity 要素生成 | E-07 (lines 27-45) | ○ |
| C-27 | GetHashCode の計算 | E-07 (lines 47-55) | ○ |

### 各種 Permission クラス関連 (UT-SSP-060 - UT-SSP-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | FileIOPermission のスタブ実装 | E-08 | ○ |
| C-29 | EnvironmentPermission のスタブ実装 | E-09 | ○ |
| C-30 | RegistryPermission のスタブ実装 | E-10 | ○ |
| C-31 | UIPermission のスタブ実装 | E-11 | ○ |
| C-32 | ReflectionPermission のスタブ実装 | E-12 | ○ |
| C-33 | SecurityPermission のスタブ実装 | E-13 | ○ |
| C-34 | StorePermission のスタブ実装 | E-14 | ○ |
| C-35 | KeyContainerPermission のスタブ実装 | E-15 | ○ |
| C-36 | ZoneIdentityPermission のスタブ実装 | E-16 | ○ |
| C-37 | UrlIdentityPermission のスタブ実装 | E-17 | ○ |
| C-38 | SiteIdentityPermission のスタブ実装 | E-18 | ○ |
| C-39 | StrongNameIdentityPermission のスタブ実装 | E-19 | ○ |
| C-40 | PublisherIdentityPermission のスタブ実装 | E-20 | ○ |
| C-41 | GacIdentityPermission のスタブ実装 | E-21 | ○ |
| C-42 | IsolatedStoragePermission のスタブ実装 | E-22 | ○ |
| C-43 | IsolatedStorageFilePermission のスタブ実装 | E-23 | ○ |
| C-44 | FileDialogPermission のスタブ実装 | E-24 | ○ |
| C-45 | DataProtectionPermission のスタブ実装 | E-25 | ○ |
| C-46 | TypeDescriptorPermission のスタブ実装 | E-26 | ○ |
| C-47 | MediaPermission が常に Unrestricted を返すこと | E-27 (lines 52-56) | ○ |
| C-48 | WebBrowserPermission が常に Unrestricted を返すこと | E-28 (lines 23-27) | ○ |
| C-49 | HostProtectionAttribute のプロパティ | E-29 | ○ |
| C-50 | StrongNamePublicKeyBlob が base を呼ぶこと | E-30 | ○ |
| C-51 | KeyContainerPermissionAccessEntry のスタブ実装 | E-31 | ○ |
| C-52 | KeyContainerPermissionAccessEntryCollection のスタブ実装 | E-32 | ○ |
| C-53 | ResourcePermissionBase の定数 Any/Local | E-33 (lines 13-14) | ○ |
| C-54 | ResourcePermissionBaseEntry のスタブ実装 | E-34 | ○ |

### Net 関連 Permission (UT-SSP-159 - UT-SSP-182)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | DnsPermission のスタブ実装 | E-35 | ○ |
| C-56 | SocketPermission.AllPorts が -1 であること | E-36 (line 14) | ○ |
| C-57 | SocketPermission のスタブ実装 | E-36 | ○ |
| C-58 | WebPermission のスタブ実装 | E-37 | ○ |
| C-59 | SmtpPermission のスタブ実装 | E-38 | ○ |
| C-60 | NetworkInformationPermission が IsUnrestricted=true を返すこと | E-39 (line 18) | ○ |

### その他 Permission (UT-SSP-183 - UT-SSP-190)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ConfigurationPermission のスタブ実装 | E-40 | ○ |
| C-62 | PrintingPermission のスタブ実装 | E-41 | ○ |
| C-63 | DirectoryServicesPermission のスタブ実装 | E-42 | ○ |

### Policy 関連 (UT-SSP-191 - UT-SSP-208)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | CodeGroup の抽象クラス実装 | E-43 | ○ |
| C-65 | ApplicationTrust のスタブ実装 | E-44 | ○ |
| C-66 | TrustManagerContext のプロパティ | E-45 | ○ |
| C-67 | HostSecurityManager のスタブ実装 | E-46 | ○ |

### Xaml 関連 (UT-SSP-209 - UT-SSP-212)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | XamlLoadPermission が常に Unrestricted を返すこと | E-47 (lines 27-34) | ○ |
| C-69 | AllowedAccess が空のコレクションを返すこと | E-47 (line 26) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SSP-042, UT-SSP-043**: PrincipalPermission.Demand のテストは Thread.CurrentPrincipal の状態に依存するため、実行時環境によって結果が異なる可能性がある
  - 候補：テスト実行前に Thread.CurrentPrincipal を明示的に設定するセットアップが必要

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のクラスがスタブ実装であり、CAS 廃止に伴う後方互換性のために存在する
- **1 (中リスク)**: PrincipalPermission.Demand は実際にセキュリティチェックを行うため、テスト環境の設定に注意が必要
- **0 (低リスク)**: 例外クラス (HostProtectionException, XmlSyntaxException) は標準的な例外パターンに従っている

## 6) レビュアーチェックリスト（最小）
- [ ] PrincipalPermission.Demand のテストで Thread.CurrentPrincipal の設定が適切か確認
- [ ] CAS 廃止により PlatformNotSupportedException をスローするメソッド (Deny, PermitOnly) のテストが含まれているか確認
- [ ] 各 Permission クラスの IsUnrestricted の戻り値が実装と一致しているか確認 (MediaPermission, WebBrowserPermission, NetworkInformationPermission は true を返す)
- [ ] スタブ実装のメソッドで null または default を返すテストケースが適切に記述されているか確認

## 7) モジュール概要

### System.Security.Permissions について
このモジュールは .NET の Code Access Security (CAS) に関連するクラス群を提供しています。.NET Core / .NET 5+ では CAS は廃止されましたが、後方互換性のためにこれらのクラスは維持されています。

### 実装の特徴
1. **スタブ実装が大部分**: 多くのメソッドは空の実装またはデフォルト値を返す
2. **PlatformNotSupportedException**: `Deny()` と `PermitOnly()` は明示的に非サポート
3. **PrincipalPermission のみ実際の実装あり**: Thread.CurrentPrincipal を使用した認証チェックが実装されている
4. **常に Unrestricted を返すクラス**: MediaPermission, WebBrowserPermission, XamlLoadPermission は常に true を返す

### テストケースの分類
| 分類 | 件数 | 説明 |
|------|------|------|
| コンストラクタ | 78 | 各クラスのインスタンス生成確認 |
| プロパティ | 56 | getter/setter の動作確認 |
| メソッド | 48 | Copy, Union, Intersect, IsSubsetOf 等 |
| 例外系 | 12 | ArgumentException, SecurityException 等 |
| XML 処理 | 10 | ToXml, FromXml の動作確認 |
| 定数 | 4 | AllPorts, Any, Local 等 |
| その他 | 4 | ToString, GetHashCode 等 |
