---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 142
  claims_with_evidence: 138
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Security.Principal.Windows 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：138 / 142、根拠なし：4
- 優先レビュー（高）
  1. **UT-SPW-003（UPN認証）**：実際のKerberos環境でのテストが必要
  2. **UT-SPW-007/008（偽装検出）**：環境依存の動作確認が必要
  3. **UT-SPW-033（デバイスクレーム）**：Windows 8以降限定機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/WindowsIdentity.cs`
- E-02: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/WindowsPrincipal.cs`
- E-03: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/SID.cs`
- E-04: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/NTAccount.cs`
- E-05: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/IdentityReference.cs`
- E-06: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/IRCollection.cs`
- E-07: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/IdentityNotMappedException.cs`
- E-08: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/TokenAccessLevels.cs`
- E-09: `src/libraries/System.Security.Principal.Windows/src/System/Security/Principal/Win32.cs`
- E-10: `src/libraries/System.Security.Principal.Windows/src/Microsoft/Win32/SafeHandles/SafeAccessTokenHandle.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### WindowsIdentity クラス（UT-SPW-001 〜 UT-SPW-034）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WindowsIdentity(IntPtr)コンストラクタが有効なトークンを受け入れる | E-01 L62-71, L103-109, L317-320 | ○ |
| C-02 | IntPtr.Zeroが渡された場合にArgumentExceptionがスローされる | E-01 L258-263 (DuplicateAccessToken) | ○ |
| C-03 | UPNからWindowsIdentityが生成される | E-01 L130-230 | ○ |
| C-04 | null UPNでArgumentNullExceptionがスローされる | E-01 L152 | ○ |
| C-05 | 長すぎるUPNは切り詰められる | E-01 L155-159 | ○ |
| C-06 | GetCurrent()が現在のIdentityを返す | E-01 L343-347 | ○ |
| C-07 | GetCurrent(bool)が偽装中のみIdentityを返す | E-01 L350-354, L809-827 | ○ |
| C-08 | GetAnonymous()が無効トークンのIdentityを返す | E-01 L368-371 | ○ |
| C-09 | AuthenticationTypeが認証パッケージ名を返す | E-01 L377-410 | ○ |
| C-10 | ImpersonationLevelが正しい値を返す | E-01 L413-447 | ○ |
| C-11 | IsAuthenticatedが認証状態を返す | E-01 L450-466 | ○ |
| C-12 | IsGuest/IsSystem/IsAnonymousプロパティ | E-01 L516-564 | ○ |
| C-13 | Nameプロパティがユーザー名を返す | E-01 L567-593 | ○ |
| C-14 | Owner/User/Groupsプロパティ | E-01 L595-669 | ○ |
| C-15 | AccessToken/Tokenプロパティ | E-01 L672-686 | ○ |
| C-16 | RunImpersonatedメソッド群 | E-01 L692-726, L751-792 | ○ |
| C-17 | Disposeメソッド | E-01 L728-743 | ○ |
| C-18 | Cloneメソッド | E-01 L973-976 | ○ |
| C-19 | UserClaims/DeviceClaims/Claimsプロパティ | E-01 L981-1026, L1032-1077 | ○ |

### WindowsPrincipal クラス（UT-SPW-035 〜 UT-SPW-047）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | WindowsPrincipalコンストラクタがnullを拒否 | E-02 L33-38 | ○ |
| C-21 | Identityプロパティ | E-02 L44 | ○ |
| C-22 | IsInRole(string)の動作 | E-02 L50-70 | ○ |
| C-23 | IsInRole(WindowsBuiltInRole)の範囲チェック | E-02 L114-120 | ○ |
| C-24 | IsInRole(int)の動作 | E-02 L122-131 | ○ |
| C-25 | IsInRole(SecurityIdentifier)の動作 | E-02 L138-180 | ○ |
| C-26 | UserClaims/DeviceClaimsプロパティ | E-02 L76-112 | ○ |

### SecurityIdentifier クラス（UT-SPW-048 〜 UT-SPW-086）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | SDDL文字列からのコンストラクタ | E-03 L488-513 | ○ |
| C-28 | バイナリ形式からのコンストラクタ | E-03 L519-524, L395-478 | ○ |
| C-29 | IntPtrからのコンストラクタ | E-03 L530-533 | ○ |
| C-30 | WellKnownSidTypeからのコンストラクタ | E-03 L544-622 | ○ |
| C-31 | LogonIdsSidの拒否 | E-03 L550-553 | ○ |
| C-32 | ドメインSIDの検証 | E-03 L568-603 | ○ |
| C-33 | BinaryLength/AccountDomainSidプロパティ | E-03 L655, L664-676 | ○ |
| C-34 | Valueプロパティ | E-03 L738-744 | ○ |
| C-35 | Equals/GetHashCodeメソッド | E-03 L682-700 | ○ |
| C-36 | ToStringメソッド | E-03 L702-736 | ○ |
| C-37 | IsValidTargetTypeメソッド | E-03 L746-765 | ○ |
| C-38 | Translateメソッド | E-03 L806-828 | ○ |
| C-39 | IsAccountSidメソッド | E-03 L789-803 | ○ |
| C-40 | IsWellKnownメソッド | E-03 L919-922, E-09 L230-246 | ○ |
| C-41 | GetBinaryFormメソッド | E-03 L924-927 | ○ |
| C-42 | IsEqualDomainSidメソッド | E-03 L935-938, E-09 L175-191 | ○ |
| C-43 | CompareToメソッド | E-03 L862-900 | ○ |
| C-44 | 演算子==と!= | E-03 L834-856 | ○ |

### NTAccount クラス（UT-SPW-087 〜 UT-SPW-106）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | ドメイン+アカウント名コンストラクタ | E-04 L34-56 | ○ |
| C-46 | 単一名コンストラクタ | E-04 L58-68 | ○ |
| C-47 | 最大長検証 | E-04 L22-28, L38-46, L62-65 | ○ |
| C-48 | Valueプロパティ | E-04 L73-79 | ○ |
| C-49 | IsValidTargetTypeメソッド | E-04 L81-95 | ○ |
| C-50 | Translateメソッド | E-04 L97-119 | ○ |
| C-51 | Equals/GetHashCodeメソッド | E-04 L121-129 | ○ |
| C-52 | ToStringメソッド | E-04 L131-134 | ○ |
| C-53 | 演算子==と!= | E-04 L174-196 | ○ |

### IdentityReference/IdentityReferenceCollection（UT-SPW-107 〜 UT-SPW-126）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | IdentityReference演算子 | E-05 L25-47 | ○ |
| C-55 | IdentityReferenceCollectionコンストラクタ | E-06 L30-42 | ○ |
| C-56 | Add/Remove/Clear/Containsメソッド | E-06 L69-98 | ○ |
| C-57 | インデクサとCopyTo | E-06 L48-51, L118-129 | ○ |
| C-58 | Count/GetEnumerator | E-06 L53-112 | ○ |
| C-59 | Translateメソッド | E-06 L140-358 | ○ |

### IdentityNotMappedException（UT-SPW-127 〜 UT-SPW-130）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | 各種コンストラクタ | E-07 L15-39 | ○ |
| C-61 | UnmappedIdentitiesプロパティ | E-07 L48 | ○ |

### SafeAccessTokenHandle（UT-SPW-131 〜 UT-SPW-136）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタ群 | E-10 L15-21 | ○ |
| C-63 | InvalidHandleプロパティ | E-10 L23-29 | ○ |
| C-64 | IsInvalidプロパティ | E-10 L31-37 | ○ |

### 列挙型（UT-SPW-137 〜 UT-SPW-142）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | TokenAccessLevels値 | E-08 L6-35 | ○ |
| C-66 | WindowsAccountType値 | E-01 L27-33 | ○ |
| C-67 | WindowsBuiltInRole値 | E-02 L12-23 | ○ |
| C-68 | WellKnownSidType値 | E-03 L51-247 | ○ |

### 根拠不足の項目

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | UPN認証の実際の動作 | E-01（コードのみ） | △ |
| C-07 | 偽装検出の環境依存動作 | E-01（コードのみ） | △ |
| C-08 | 偽装なし時のnull返却 | E-01（コードのみ） | △ |
| C-19 | デバイスクレームのWindows 8以降制限 | E-01 L1061（コメントのみ） | △ |

## 4) 不足情報（Unknown / Missing）

- **環境依存のテスト条件**: 一部のテストケース（特に偽装、Kerberos認証）は実際のWindows環境での検証が必要
  - 候補：Windows Server環境 / Active Directory環境 / ローカルマシン環境

- **Windows バージョン依存**: DeviceClaims関連はWindows 8以降でのみ動作
  - 候補：Windows 8 / Windows 10 / Windows 11 / Windows Server 2012以降

- **権限依存のテスト**: 一部のテスト（システムアカウント判定等）は特定の権限が必要
  - 候補：LocalSystem / 管理者権限 / 一般ユーザー権限

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 内容 |
|-------------|------|
| 1 | UPN認証テスト（UT-SPW-003）：Kerberos環境がない場合はスキップまたはモック化が必要 |
| 1 | 偽装関連テスト（UT-SPW-026-029）：正しいセキュリティコンテキストでの実行が必要 |
| 1 | デバイスクレーム（UT-SPW-033）：Windows 8未満ではテスト不可 |
| 0 | その他のテストケース：通常のユニットテスト環境で実行可能 |

## 6) レビュアーチェックリスト（最小）

- [ ] WindowsIdentityコンストラクタの異常系テストが網羅されているか確認
- [ ] SecurityIdentifierの境界値テスト（MaxSubAuthorities=15）が含まれているか確認
- [ ] NTAccountの大文字小文字無視の等値比較がテストされているか確認
- [ ] IdentityReferenceCollection.Translateの複合型（SID+NTAccount混在）ケースが含まれているか確認
- [ ] 環境依存テストの前提条件が明確に記載されているか確認
- [ ] 高優先度テストケースが実際のセキュリティ要件を反映しているか確認
