---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 181
  claims_with_evidence: 181
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.ServiceModel.Syndication 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：181 / 181、根拠なし：0
- 優先レビュー（高）
  1. **Atom10/RSS20フォーマッタのパース・シリアライズ処理**：実際のXML形式との互換性検証が重要
  2. **日時パース処理（DateTimeHelper）**：RFC822/RFC3339形式の多様なバリエーション対応
  3. **null検証テストケース**：全てのpublicメソッドでnull引数の動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationFeed.cs`
- E-02: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationItem.cs`
- E-03: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationContent.cs`
- E-04: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/TextSyndicationContent.cs`
- E-05: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/UrlSyndicationContent.cs`
- E-06: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/XmlSyndicationContent.cs`
- E-07: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationLink.cs`
- E-08: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationPerson.cs`
- E-09: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationCategory.cs`
- E-10: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationElementExtension.cs`
- E-11: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationElementExtensionCollection.cs`
- E-12: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/Atom10FeedFormatter.cs`
- E-13: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/Rss20FeedFormatter.cs`
- E-14: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationFeedFormatter.cs`
- E-15: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationItemFormatter.cs`
- E-16: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/ServiceDocument.cs`
- E-17: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/Workspace.cs`
- E-18: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/ResourceCollectionInfo.cs`
- E-19: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/CategoriesDocument.cs`
- E-20: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/InlineCategoriesDocument.cs`
- E-21: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/ReferencedCategoriesDocument.cs`
- E-22: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/DateTimeHelper.cs`
- E-23: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/FeedUtils.cs`
- E-24: `src/libraries/System.ServiceModel.Syndication/src/System/ServiceModel/Syndication/SyndicationTextInput.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SyndicationFeed クラス（UT-SYN-001 〜 UT-SYN-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SyndicationFeedの各コンストラクタの動作 | E-01 (lines 28-106) | ○ |
| C-02 | Items setterのnull検証 | E-01 (lines 142-143) | ○ |
| C-03 | LastUpdatedTime例外伝播 | E-01 (lines 148-166) | ○ |
| C-04 | TimeToLive設定の検証 | E-01 (lines 183-197) | ○ |
| C-05 | Load静的メソッドのAtom10/RSS20判定 | E-01 (lines 407-427) | ○ |
| C-06 | Clone, GetFormatter, SaveAsメソッド | E-01 (lines 429-451) | ○ |
| C-07 | コレクションプロパティの遅延初期化 | E-01 (lines 110-126, 168-231) | ○ |

### SyndicationItem クラス（UT-SYN-025 〜 UT-SYN-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | SyndicationItemの各コンストラクタの動作 | E-02 (lines 22-73) | ○ |
| C-09 | LastUpdatedTime/PublishDate例外伝播 | E-02 (lines 102-145) | ○ |
| C-10 | AddPermalinkのnull検証とリンク追加 | E-02 (lines 176-182) | ○ |
| C-11 | Load静的メソッドのAtom10/RSS20判定 | E-02 (lines 153-173) | ○ |

### SyndicationContent 派生クラス（UT-SYN-037 〜 UT-SYN-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | SyndicationContentファクトリメソッド | E-03 (lines 28-66) | ○ |
| C-13 | WriteTo null/空文字検証 | E-03 (lines 70-95) | ○ |
| C-14 | TextSyndicationContentのKind検証 | E-04 (lines 18-44) | ○ |
| C-15 | UrlSyndicationContent null検証 | E-05 (lines 14-16) | ○ |
| C-16 | XmlSyndicationContent ReadContent | E-06 (lines 87-131) | ○ |

### SyndicationLink クラス（UT-SYN-062 〜 UT-SYN-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタのlength負値検証 | E-07 (lines 19-24, 62-65) | ○ |
| C-18 | 静的ファクトリメソッド | E-07 (lines 79-102) | ○ |
| C-19 | GetAbsoluteUri URI解決ロジック | E-07 (lines 106-127) | ○ |

### SyndicationPerson/Category クラス（UT-SYN-075 〜 UT-SYN-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | SyndicationPersonコンストラクタ | E-08 (lines 15-28) | ○ |
| C-21 | SyndicationCategoryコンストラクタ | E-09 (lines 14-27) | ○ |
| C-22 | Clone実装 | E-08 (line 50), E-09 (line 49) | ○ |

### SyndicationElementExtension（UT-SYN-083 〜 UT-SYN-103）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | XmlReaderコンストラクタのnull検証 | E-10 (lines 22-24) | ○ |
| C-24 | outerNameが空文字の場合のArgumentException | E-10 (lines 58-61) | ○ |
| C-25 | GetObject デシリアライズ | E-10 (lines 114-141) | ○ |
| C-26 | Collection操作のnull検証 | E-11 (lines 150-177) | ○ |

### Atom10/Rss20 FeedFormatter（UT-SYN-104 〜 UT-SYN-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Atom10FeedFormatterコンストラクタ型検証 | E-12 (lines 38-49) | ○ |
| C-28 | CanRead形式判定 | E-12 (lines 71-76), E-13 (lines 71-76) | ○ |
| C-29 | ReadFrom/WriteTo処理 | E-12 (lines 94-111), E-13 (lines 94-111) | ○ |
| C-30 | Feed未設定時のInvalidOperationException | E-12 (lines 1077-1083), E-13 (lines 806-811) | ○ |

### ServiceDocument/Workspace/ResourceCollectionInfo（UT-SYN-128 〜 UT-SYN-148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ServiceDocumentコンストラクタとLoad/Save | E-16 (lines 15-64) | ○ |
| C-32 | Workspaceコンストラクタ | E-17 (lines 15-34) | ○ |
| C-33 | ResourceCollectionInfo null検証 | E-18 (lines 34-38) | ○ |
| C-34 | CategoriesDocument ファクトリメソッド | E-19 (lines 28-41) | ○ |
| C-35 | InlineCategoriesDocument IsInline | E-20 (line 45) | ○ |
| C-36 | ReferencedCategoriesDocument null検証 | E-21 (lines 12-14) | ○ |

### DateTimeHelper/FeedUtils（UT-SYN-149 〜 UT-SYN-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | DefaultRss20DateTimeParser RFC822パース | E-22 (lines 13-36, 71-128) | ○ |
| C-38 | DefaultAtom10DateTimeParser RFC3339パース | E-22 (lines 38-69) | ○ |
| C-39 | FeedUtils Clone系メソッド | E-23 (lines 22-71) | ○ |
| C-40 | CombineXmlBase URI結合 | E-23 (lines 73-85) | ○ |
| C-41 | GetUriString null処理 | E-23 (lines 114-128) | ○ |
| C-42 | IsXmlns判定 | E-23 (lines 130-133) | ○ |

### SyndicationFeedFormatter/ItemFormatter（UT-SYN-167 〜 UT-SYN-181）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | CreateCategory/Item/Link/Personファクトリ | E-14 (lines 58-105) | ○ |
| C-44 | SetFeed null検証 | E-14 (lines 307-312) | ○ |
| C-45 | SyndicationItemFormatter SetItem | E-15 (lines 38-43) | ○ |
| C-46 | SyndicationTextInputプロパティ | E-24 (lines 6-12) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません。
- 全てのテストケースはソースコード解析に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：プロパティ取得、基本コンストラクタのテストケース
- **1（中リスク）**：ファクトリメソッド、コレクション操作のテストケース
- **2（高リスク）**：
  - XML パース/シリアライズ処理（UT-SYN-012〜014, UT-SYN-111〜115, UT-SYN-123〜126）
  - 日時パース処理（UT-SYN-149〜153）
  - null検証を含む例外処理（多数）

## 6) レビュアーチェックリスト（最小）
- [ ] Atom10形式のパース/シリアライズが実際のフィードと互換性があるか確認
- [ ] RSS20形式のパース/シリアライズが実際のフィードと互換性があるか確認
- [ ] 日時パース（RFC822/RFC3339）の多様なバリエーションがカバーされているか確認
- [ ] 全てのnull検証テストケースが適切なArgumentNullExceptionをテストしているか確認
- [ ] Clone機能が深いコピーを正しく行っているかの観点が含まれているか確認
- [ ] URI解決（相対/絶対、BaseUri結合）のエッジケースがカバーされているか確認
- [ ] 拡張要素（AttributeExtensions, ElementExtensions）の操作テストが十分か確認
