---
generated_at: 2026-01-30 18:00:00
metrics:
  claims_total: 145
  claims_with_evidence: 145
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: libraries-System.ServiceProcess.ServiceController 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・プロパティ・ロジックの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・境界条件を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要な項目を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：145 / 145、根拠なし：0
- 優先レビュー（高）
  1. **サービス制御系メソッド（Start/Stop/Pause/Continue）**：Windows Service Manager APIとの連携確認が必要
  2. **WaitForStatus**：タイムアウト処理の実装確認
  3. **ServiceBase.Run**：SCMとの連携処理

## 2) 参照した情報（Evidence一覧）
> ソースコードファイルから抽出した根拠

- E-01: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceController.cs`（998行）
- E-02: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceBase.cs`（965行）
- E-03: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/SessionChangeDescription.cs`（39行）
- E-04: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/TimeoutException.cs`（40行）
- E-05: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceProcessDescriptionAttribute.cs`（41行）
- E-06: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceType.cs`（18行）
- E-07: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceControllerStatus.cs`（16行）
- E-08: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/ServiceStartMode.cs`（14行）
- E-09: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/SessionChangeReason.cs`（56行）
- E-10: `src/libraries/System.ServiceProcess.ServiceController/src/System/ServiceProcess/PowerBroadcastStatus.cs`（18行）
- E-11: `src/libraries/System.ServiceProcess.ServiceController/src/Microsoft/Win32/SafeHandles/SafeServiceHandle.cs`（33行）

## 3) Claims と根拠の対応（レビューの主戦場）

### ServiceController クラス（UT-SPC-001 - UT-SPC-060）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceController引数なしコンストラクタのデフォルト値検証 | E-01: 行42-46 | ○ |
| C-02 | ServiceController(string)コンストラクタの動作 | E-01: 行52-55 | ○ |
| C-03 | ServiceController(string, string)コンストラクタの動作 | E-01: 行63-77 | ○ |
| C-04 | マシン名null時のArgumentException | E-01: 行65-66, CheckMachineName | ○ |
| C-05 | マシン名バックスラッシュ時のArgumentException | E-01: 行456-459, CheckMachineName | ○ |
| C-06 | サービス名null時のArgumentNullException | E-01: 行68 | ○ |
| C-07 | サービス名空文字時のArgumentException | E-01: 行69-72 | ○ |
| C-08 | CanPauseAndContinueプロパティの実装 | E-01: 行115-122 | ○ |
| C-09 | CanShutdownプロパティの実装 | E-01: 行127-133 | ○ |
| C-10 | CanStopプロパティの実装 | E-01: 行139-145 | ○ |
| C-11 | DisplayNameプロパティのgetter/setter | E-01: 行151-175 | ○ |
| C-12 | DisplayName nullセット時のArgumentNullException | E-01: 行161-162 | ○ |
| C-13 | ServiceNameプロパティのgetter/setter | E-01: 行264-292 | ○ |
| C-14 | ServiceName検証ロジック（80文字制限、スラッシュ禁止） | E-01: 行285-286, E-02: 行291-294 | ○ |
| C-15 | MachineNameプロパティのgetter/setter | E-01: 行237-258 | ○ |
| C-16 | DependentServicesプロパティの実装 | E-01: 行180-231 | ○ |
| C-17 | ServicesDependedOnプロパティの実装 | E-01: 行297-378 | ○ |
| C-18 | StartTypeプロパティの実装 | E-01: 行381-416 | ○ |
| C-19 | Statusプロパティの実装 | E-01: 行432-438 | ○ |
| C-20 | ServiceTypeプロパティの実装 | E-01: 行447-453 | ○ |
| C-21 | ServiceHandleプロパティの実装 | E-01: 行418-424 | ○ |
| C-22 | Closeメソッドの実装 | E-01: 行469-480 | ○ |
| C-23 | Disposeメソッドの実装 | E-01: 行485-490 | ○ |
| C-24 | Refreshメソッドの実装 | E-01: 行851-857 | ○ |
| C-25 | Start()メソッドの実装 | E-01: 行862-865 | ○ |
| C-26 | Start(string[])メソッドの実装 | E-01: 行870-912 | ○ |
| C-27 | Start引数null時のArgumentNullException | E-01: 行872 | ○ |
| C-28 | Start引数配列内null時のArgumentNullException | E-01: 行881-882 | ○ |
| C-29 | Stop()メソッドの実装 | E-01: 行919-921 | ○ |
| C-30 | Stop(bool)メソッドの実装 | E-01: 行939-965 | ○ |
| C-31 | Pauseメソッドの実装 | E-01: 行804-815 | ○ |
| C-32 | Continueメソッドの実装 | E-01: 行820-830 | ○ |
| C-33 | ExecuteCommandメソッドの実装 | E-01: 行836-846 | ○ |
| C-34 | WaitForStatus(ServiceControllerStatus)の実装 | E-01: 行971-974 | ○ |
| C-35 | WaitForStatus(ServiceControllerStatus, TimeSpan)の実装 | E-01: 行981-996 | ○ |
| C-36 | WaitForStatus無効ステータス時のArgumentException | E-01: 行983-984 | ○ |
| C-37 | WaitForStatusタイムアウト時のTimeoutException | E-01: 行990-991 | ○ |
| C-38 | GetServices()静的メソッドの実装 | E-01: 行702-705 | ○ |
| C-39 | GetServices(string)静的メソッドの実装 | E-01: 行712-715 | ○ |
| C-40 | GetDevices()静的メソッドの実装 | E-01: 行662-665 | ○ |
| C-41 | GetDevices(string)静的メソッドの実装 | E-01: 行672-675 | ○ |
| C-42 | CheckMachineName内部メソッドの実装 | E-01: 行456-459 | ○ |

### ServiceBase クラス（UT-SPC-061 - UT-SPC-107）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | ServiceBaseコンストラクタのデフォルト値 | E-02: 行45-50 | ○ |
| C-44 | MaxNameLength定数が80であること | E-02: 行40 | ○ |
| C-45 | ServiceNameプロパティのgetter/setter | E-02: 行271-289 | ○ |
| C-46 | ServiceName変更時の_nameFrozen検証 | E-02: 行280-281 | ○ |
| C-47 | ValidServiceNameメソッドの実装 | E-02: 行291-294 | ○ |
| C-48 | AutoLogプロパティの実装 | E-02: 行99-100 | ○ |
| C-49 | ExitCodeプロパティの実装 | E-02: 行106-116 | ○ |
| C-50 | CanHandlePowerEventプロパティの実装 | E-02: 行122-143 | ○ |
| C-51 | CanHandlePowerEvent凍結後の変更でInvalidOperationException | E-02: 行131-132 | ○ |
| C-52 | CanHandleSessionChangeEventプロパティの実装 | E-02: 行148-169 | ○ |
| C-53 | CanPauseAndContinueプロパティの実装 | E-02: 行174-195 | ○ |
| C-54 | CanShutdownプロパティの実装 | E-02: 行200-221 | ○ |
| C-55 | CanStopプロパティの実装 | E-02: 行226-247 | ○ |
| C-56 | EventLogプロパティの遅延初期化 | E-02: 行252-257 | ○ |
| C-57 | ServiceHandleプロパティの実装 | E-02: 行259-266 | ○ |
| C-58 | RequestAdditionalTime(int)の実装 | E-02: 行58-74 | ○ |
| C-59 | RequestAdditionalTime Pending状態以外でInvalidOperationException | E-02: 行62-68 | ○ |
| C-60 | RequestAdditionalTime(TimeSpan)の実装 | E-02: 行83-93 | ○ |
| C-61 | ToIntMillisecondsの範囲検証 | E-02: 行85-92 | ○ |
| C-62 | Run(ServiceBase[])の実装 | E-02: 行579-643 | ○ |
| C-63 | Run null/空配列時のArgumentException | E-02: 行581-582 | ○ |
| C-64 | Run(ServiceBase)の実装 | E-02: 行651-657 | ○ |
| C-65 | Stopメソッドの実装 | E-02: 行659-662 | ○ |
| C-66 | OnStartメソッドの実装 | E-02: 行378-380 | ○ |
| C-67 | OnStopメソッドの実装 | E-02: 行389-391 | ○ |
| C-68 | OnPauseメソッドの実装 | E-02: 行328-331 | ○ |
| C-69 | OnContinueメソッドの実装 | E-02: 行318-320 | ○ |
| C-70 | OnShutdownメソッドの実装 | E-02: 行358-361 | ○ |
| C-71 | OnCustomCommandメソッドの実装 | E-02: 行570-572 | ○ |
| C-72 | OnPowerEventメソッドの実装 | E-02: 行339-342 | ○ |
| C-73 | OnSessionChangeメソッドの実装 | E-02: 行348-350 | ○ |
| C-74 | Disposeメソッドの実装 | E-02: 行302-308 | ○ |
| C-75 | Initializeメソッドの実装 | E-02: 行664-693 | ○ |
| C-76 | Initialize Dispose済み時のObjectDisposedException | E-02: 行669-670 | ○ |

### SessionChangeDescription 構造体（UT-SPC-108 - UT-SPC-117）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | コンストラクタの実装 | E-03: 行13-17 | ○ |
| C-78 | Reasonプロパティの実装 | E-03: 行19 | ○ |
| C-79 | SessionIdプロパティの実装 | E-03: 行21 | ○ |
| C-80 | GetHashCodeの実装 | E-03: 行23-24 | ○ |
| C-81 | Equals(object)の実装 | E-03: 行26-27 | ○ |
| C-82 | Equals(SessionChangeDescription)の実装 | E-03: 行29-31 | ○ |
| C-83 | operator==の実装 | E-03: 行33-34 | ○ |
| C-84 | operator!=の実装 | E-03: 行36-37 | ○ |

### TimeoutException クラス（UT-SPC-118 - UT-SPC-121）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | コンストラクタ()の実装とHResult設定 | E-04: 行15-18 | ○ |
| C-86 | コンストラクタ(string)の実装 | E-04: 行20-23 | ○ |
| C-87 | コンストラクタ(string, Exception)の実装 | E-04: 行25-29 | ○ |
| C-88 | ServiceControllerTimeout定数の値 | E-04: 行13 | ○ |

### ServiceProcessDescriptionAttribute クラス（UT-SPC-122 - UT-SPC-124）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | コンストラクタの実装 | E-05: 行21-23 | ○ |
| C-90 | Descriptionプロパティの実装 | E-05: 行28-38 | ○ |
| C-91 | _replacedフラグの動作 | E-05: 行32-36 | ○ |

### SafeServiceHandle クラス（UT-SPC-125 - UT-SPC-130）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | コンストラクタ()の実装 | E-11: 行14-16 | ○ |
| C-93 | コンストラクタ(IntPtr)の実装 | E-11: 行18-21 | ○ |
| C-94 | IsInvalidプロパティの実装 | E-11: 行23-26 | ○ |
| C-95 | ReleaseHandleの実装 | E-11: 行28-31 | ○ |

### 列挙型（UT-SPC-131 - UT-SPC-145）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | ServiceType列挙型の定義 | E-06: 行6-17 | ○ |
| C-97 | ServiceControllerStatus列挙型の定義 | E-07: 行6-15 | ○ |
| C-98 | ServiceStartMode列挙型の定義 | E-08: 行6-13 | ○ |
| C-99 | SessionChangeReason列挙型の定義 | E-09: 行9-55 | ○ |
| C-100 | PowerBroadcastStatus列挙型の定義 | E-10: 行6-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースはソースコードの実装に基づいて作成されています。
- ただし、以下の点は実行環境依存のため、テスト実行時に確認が必要：
  - Windows Service Control Manager (SCM) との連携テスト
  - 実際のサービスの起動・停止テスト
  - リモートマシンへの接続テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 列挙型、構造体、属性クラスのテストケース
- **1: 中リスク** - プロパティのgetter/setter、基本的なメソッドのテストケース
- **2: 高リスク** - 以下の項目は実環境でのテストが必要
  - サービス制御メソッド（Start, Stop, Pause, Continue）
  - ServiceBase.Run (SCMとの連携)
  - WaitForStatus (タイムアウト処理)
  - DependentServices/ServicesDependedOn (依存関係の解決)

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceControllerのコンストラクタ引数検証が網羅されているか
- [ ] サービス制御メソッド（Start/Stop/Pause/Continue）の正常系・異常系が含まれているか
- [ ] WaitForStatusのタイムアウト処理が適切にテストされているか
- [ ] ServiceBaseの各イベントハンドラ（OnStart, OnStop等）が網羅されているか
- [ ] 列挙型の値がInterop定数と一致することを確認するテストが含まれているか
- [ ] SessionChangeDescriptionの等価比較（Equals, ==, !=）が網羅されているか
- [ ] SafeServiceHandleのIsInvalid判定（IntPtr.Zero, -1）が含まれているか
- [ ] プロパティの状態凍結（_nameFrozen, _commandPropsFrozen）後の変更エラーがテストされているか
