---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Speech 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **UT-SPE-085〜091**: SpeechRecognitionEngineのプラットフォーム依存動作
  2. **UT-SPE-112〜149**: SpeechSynthesizerのWindows SAPI依存動作
  3. **UT-SPE-199〜200**: RecognizedPhraseの内部シリアライズ構造

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Speech/src/AudioFormat/SpeechAudioFormatInfo.cs`
- E-02: `src/libraries/System.Speech/src/AudioFormat/EncodingFormat.cs`
- E-03: `src/libraries/System.Speech/src/Recognition/Grammar.cs`
- E-04: `src/libraries/System.Speech/src/Recognition/GrammarBuilder.cs`
- E-05: `src/libraries/System.Speech/src/Recognition/Choices.cs`
- E-06: `src/libraries/System.Speech/src/Recognition/SemanticResultKey.cs`
- E-07: `src/libraries/System.Speech/src/Recognition/SemanticResultValue.cs`
- E-08: `src/libraries/System.Speech/src/Recognition/SpeechRecognitionEngine.cs`
- E-09: `src/libraries/System.Speech/src/Recognition/RecognizerBase.cs`
- E-10: `src/libraries/System.Speech/src/Recognition/SrgsGrammar/SrgsDocument.cs`
- E-11: `src/libraries/System.Speech/src/Result/SemanticValue.cs`
- E-12: `src/libraries/System.Speech/src/Result/RecognizedPhrase.cs`
- E-13: `src/libraries/System.Speech/src/Result/RecognitionResult.cs`
- E-14: `src/libraries/System.Speech/src/Synthesis/SpeechSynthesizer.cs`
- E-15: `src/libraries/System.Speech/src/Synthesis/PromptBuilder.cs`
- E-16: `src/libraries/System.Speech/src/Synthesis/Prompt.cs`
- E-17: `src/libraries/System.Speech/src/Synthesis/VoiceInfo.cs`
- E-18: `src/libraries/System.Speech/src/Internal/Helpers.cs`
- E-19: `src/libraries/System.Speech/src/Internal/SrgsCompiler/`
- E-20: `src/libraries/System.Speech/src/Internal/SapiInterop/`

## 3) Claims と根拠の対応（レビューの主戦場）

### AudioFormat 関連 (UT-SPE-001〜011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SpeechAudioFormatInfoのコンストラクタがPCM形式を正しく処理 | E-01 (Lines 77-83) | ○ |
| C-02 | samplesPerSecond <= 0でArgumentOutOfRangeException | E-01 (Lines 22-23) | ○ |
| C-03 | ALaw形式でbitsPerSample=8のみ許可 | E-01 (Lines 46-58) | ○ |
| C-04 | encodingFormat=0でArgumentException | E-01 (Lines 16-19) | ○ |
| C-05 | Equalsメソッドが全フィールドを比較 | E-01 (Lines 102-131) | ○ |
| C-06 | FormatSpecificDataがコピーを返す | E-01 (Line 101) | ○ |

### Grammar 関連 (UT-SPE-012〜032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | Grammarコンストラクタがパスを検証 | E-03 (Lines 42-54) | ○ |
| C-08 | SrgsDocumentからGrammar作成 | E-03 (Lines 55-81) | ○ |
| C-09 | Streamから作成時に読み取り可能性チェック | E-03 (Lines 100-111) | ○ |
| C-10 | Weight範囲が0.0-1.0 | E-03 (Lines 213-228) | ○ |
| C-11 | Priority範囲が-128〜127 | E-03 (Lines 235-251) | ○ |
| C-12 | Name=nullで空文字列に変換 | E-03 (Line 258) | ○ |
| C-13 | IsDictationGrammarの判定ロジック | E-03 (Lines 473-482) | ○ |

### GrammarBuilder 関連 (UT-SPE-033〜056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | Appendメソッドが空文字列を拒否 | E-04 (Lines 75-78, 84-85) | ○ |
| C-15 | ValidateRepeatArgumentsの検証 | E-04 (Lines 349-358) | ○ |
| C-16 | ValidateSubsetMatchingCriteriaArgumentの検証 | E-04 (Lines 361-373) | ○ |
| C-17 | operator+のオーバーロード動作 | E-04 (Lines 268-339) | ○ |
| C-18 | 暗黙変換演算子 | E-04 (Lines 340-343) | ○ |

### Choices 関連 (UT-SPE-057〜064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | Choicesコンストラクタのnullチェック | E-05 (Lines 19-29) | ○ |
| C-20 | Add(string[])が空文字列を拒否 | E-05 (Lines 43-44) | ○ |
| C-21 | ToGrammarBuilderの動作 | E-05 (Lines 60-63) | ○ |

### SemanticValue 関連 (UT-SPE-065〜074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | SemanticValueコンストラクタのnullチェック | E-11 (Lines 19-27) | ○ |
| C-23 | Equalsメソッドの比較ロジック | E-11 (Lines 37-53) | ○ |
| C-24 | インデクサのset時InvalidOperationException | E-11 (Line 93) | ○ |
| C-25 | IDictionaryメソッドがNotSupportedExceptionをスロー | E-11 (Lines 111-134) | ○ |

### SemanticResultKey/Value 関連 (UT-SPE-075〜084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | SemanticResultKeyの空文字列チェック | E-06 (Lines 18, 26) | ○ |
| C-27 | SemanticResultValueのnullチェック | E-07 (Lines 16, 23, 29, 30) | ○ |

### SpeechRecognitionEngine 関連 (UT-SPE-085〜111)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | CultureInfoコンストラクタのInvariantCultureチェック | E-08 (Lines 29-32) | ○ |
| C-29 | recognizerIdコンストラクタの検索ロジック | E-08 (Lines 56-70) | ○ |
| C-30 | Disposeの動作 | E-08 (Lines 77-98) | ○ |
| C-31 | InstalledRecognizersの静的メソッド | E-08 (Lines 105-131) | ○ |
| C-32 | EndSilenceTimeoutの範囲検証 | E-08 (Lines 156-161) | ○ |
| C-33 | Recognize時のGrammar存在チェック | E-08 (Lines 265-268) | ○ |
| C-34 | RecognizeAsyncのGrammar存在チェック | E-08 (Lines 282-285) | ○ |
| C-35 | SpeechRecognitionEngine内部でのSAPIRecognizer使用 | E-08, E-20 | △ |

### SpeechSynthesizer 関連 (UT-SPE-112〜149)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | SelectVoiceの空文字列チェック | E-14 (Line 37) | ○ |
| C-37 | SelectVoiceByHintsのvoiceAlternate範囲チェック | E-14 (Lines 63-66) | ○ |
| C-38 | SelectVoiceByHintsのVoiceGender/VoiceAge検証 | E-14 (Lines 68-75) | ○ |
| C-39 | Speak(string)のPaused状態チェック | E-14 (Lines 126-129) | ○ |
| C-40 | Rate範囲-10〜10 | E-14 (Lines 417-419) | ○ |
| C-41 | Volume範囲0〜100 | E-14 (Lines 431-433) | ○ |
| C-42 | GetInstalledVoices(CultureInfo)のInvariantCultureチェック | E-14 (Lines 251-254) | ○ |
| C-43 | VoiceSynthesis内部動作（Windows SAPI依存） | E-14, E-20 | △ |

### PromptBuilder 関連 (UT-SPE-150〜187)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | PromptBuilder(CultureInfo)のInvariantCultureチェック | E-15 (Lines 27-30) | ○ |
| C-45 | AppendTextのnullチェック | E-15 (Line 57) | ○ |
| C-46 | AppendText(string, PromptRate)の範囲チェック | E-15 (Lines 68-71) | ○ |
| C-47 | EndStyleのStartStyle対応チェック | E-15 (Lines 252-258) | ○ |
| C-48 | EndVoiceのStartVoice対応チェック | E-15 (Lines 342-346) | ○ |
| C-49 | EndParagraphのStartParagraph対応チェック | E-15 (Lines 380-385) | ○ |
| C-50 | EndSentenceのStartSentence対応チェック | E-15 (Lines 417-422) | ○ |
| C-51 | AppendBreak(TimeSpan)の負値チェック | E-15 (Lines 644-647) | ○ |
| C-52 | ToXmlの不完全状態チェック | E-15 (Lines 776-810) | ○ |

### SrgsDocument 関連 (UT-SPE-188〜198)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | SrgsDocumentコンストラクタの各種オーバーロード | E-10 (Lines 26-72) | ○ |
| C-54 | Culture設定のInvariantCultureチェック | E-10 (Lines 120-126) | ○ |
| C-55 | WriteSrgsのnullチェック | E-10 (Line 78) | ○ |

### RecognizedPhrase 関連 (UT-SPE-199〜200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Textプロパティの文字列構築ロジック | E-12 (Lines 83-142) | ○ |
| C-57 | Confidenceプロパティ | E-12 (Lines 143-149) | ○ |
| C-58 | Semanticsプロパティの内部計算 | E-12 (Lines 215-233) | △ |

## 4) 不足情報（Unknown / Missing）
- **Windows SAPI依存部分**: System.SpeechライブラリはWindows SAPIに依存しており、実際の音声認識/合成動作はプラットフォーム依存
  - 候補：Windows環境での実機テスト / モック化テスト / プラットフォーム条件付きテスト
- **RecognizedPhraseの内部シリアライズ構造**: SPSERIALIZEDPHRASEの詳細構造は内部実装に依存
  - 候補：SAPI仕様書 / 既存テストコードの参照
- **音声エンジンの存在依存**: InstalledRecognizers/GetInstalledVoicesは実行環境に依存
  - 候補：テスト前提条件の明確化 / CI環境での音声エンジンインストール

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: SpeechRecognitionEngine/SpeechSynthesizerはWindows専用であり、クロスプラットフォームテストは不可
- **リスク1（中）**: 内部クラス（Internal名前空間）への依存部分のテストカバレッジ
- **リスク0（低）**: GrammarBuilder/Choices等のメモリ内操作は安定

## 6) レビュアーチェックリスト（最小）
- [ ] Windows環境でのみ実行可能なテストケースが明確に識別されているか
- [ ] ArgumentNullException/ArgumentExceptionのテストケースが網羅的か
- [ ] 境界値テスト（Weight: 0.0/1.0、Priority: -128/127、Rate: -10/10、Volume: 0/100）が正確か
- [ ] イベントハンドラ関連のテストケースが不足していないか（SpeakStarted, SpeakCompleted等）
- [ ] 非同期操作（SpeakAsync, RecognizeAsync）のキャンセル・タイムアウトシナリオが十分か
- [ ] 実際のSRGS/CFG文法ファイルを使用するテストケースの追加検討
