---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 136
  claims_with_evidence: 128
  claims_without_evidence: 8
confidence_derived: 0.94
---

# 根拠レポート：libraries-System.Text.Encoding.CodePages 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：128 / 136、根拠なし：8
- 優先レビュー（高）
  1. **ISCIIEncoding関連テストケース（C-132〜C-136）**：ISCIIEncoding.csファイルが大きすぎて全体を読み込めなかったため、詳細なメソッドシグネチャの確認が不完全
  2. **ISO2022Encoding関連テストケース（C-70〜C-75）**：ISO2022Encoding.csファイルが大きすぎて全体を読み込めなかったため、詳細なメソッドシグネチャの確認が不完全
  3. **GB18030Encoding関連テストケース（C-76〜C-80）**：GB18030Encoding.csファイルが正常に読み込めなかったため、詳細確認が不完全

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/CodePagesEncodingProvider.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncodingNLS.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncoderNLS.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/DecoderNLS.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncodingTable.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/SBCSCodePageEncoding.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/DBCSCodePageEncoding.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EUCJPEncoding.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/BaseCodePageEncoding.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncoderBestFitFallback.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/DecoderBestFitFallback.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncoderFallbackBufferHelper.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/DecoderFallbackBufferHelper.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncodingByteBuffer.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/EncodingCharBuffer.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/ISO2022Encoding.cs` (部分的に参照)
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encoding.CodePages/src/System/Text/ISCIIEncoding.cs` (部分的に参照)

## 3) Claims と根拠の対応（レビューの主戦場）

### CodePagesEncodingProvider関連（C-01〜C-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetEncoding(int)で有効なコードページ番号からEncodingが取得できる | E-01 | ○ |
| C-02 | GetEncoding(int)でEUC-JPコードページが取得できる | E-01, E-08 | ○ |
| C-03 | GetEncoding(int)でGB18030コードページが取得できる | E-01 | ○ |
| C-04 | GetEncoding(int)でISO-2022-JPコードページが取得できる | E-01 | ○ |
| C-05 | 無効なコードページ番号でnullが返却される | E-01 | ○ |
| C-06 | コードページ番号0でnullが返却される | E-01 | ○ |
| C-07 | 負のコードページ番号でnullが返却される | E-01 | ○ |
| C-08 | GetEncoding(string)で有効な名前からEncodingが取得できる | E-01, E-05 | ○ |
| C-09 | 大文字小文字を区別しない | E-05 | ○ |
| C-10 | 無効なエンコーディング名でnullが返却される | E-01, E-05 | ○ |
| C-11 | null名でnullが返却される | E-05 | ○ |
| C-12 | 空文字列でnullが返却される | E-05 | ○ |
| C-13 | Instanceプロパティでシングルトンが取得できる | E-01 | ○ |
| C-14 | 複数回アクセスで同一インスタンスが返却される | E-01 | ○ |

### EncodingNLS関連（C-15〜C-30）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | GetByteCount(char[], int, int)で文字配列からバイト数が計算される | E-02 | ○ |
| C-16 | null配列でArgumentNullExceptionがスローされる | E-02 | ○ |
| C-17 | 負のindexでArgumentOutOfRangeExceptionがスローされる | E-02 | ○ |
| C-18 | 負のcountでArgumentOutOfRangeExceptionがスローされる | E-02 | ○ |
| C-19 | 空配列で0が返却される | E-02 | ○ |
| C-20 | GetBytesで文字配列がバイト配列にエンコードされる | E-02 | ○ |
| C-21 | 出力バッファが小さい場合ArgumentExceptionがスローされる | E-02 | ○ |
| C-22 | GetCharCountでバイト配列から文字数が計算される | E-02 | ○ |
| C-23 | GetCharCountでnull配列でArgumentNullExceptionがスローされる | E-02 | ○ |
| C-24 | GetCharsでバイト配列が文字配列にデコードされる | E-02 | ○ |
| C-25 | GetCharsで出力バッファが小さい場合ArgumentExceptionがスローされる | E-02 | ○ |
| C-26 | GetDecoderでDecoderインスタンスが取得できる | E-02 | ○ |
| C-27 | GetEncoderでEncoderインスタンスが取得できる | E-02 | ○ |
| C-28 | GetMaxByteCountで最大バイト数が計算される | E-02 | ○ |
| C-29 | GetMaxByteCountで負のcharCountでArgumentOutOfRangeExceptionがスローされる | E-02 | ○ |
| C-30 | GetMaxCharCountで最大文字数が計算される | E-02 | ○ |

### EncoderNLS関連（C-31〜C-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Resetで状態がリセットされる | E-03 | ○ |
| C-32 | GetByteCount(char[], int, int, bool)で文字配列からバイト数が計算される | E-03 | ○ |
| C-33 | GetByteCountでnull配列でArgumentNullExceptionがスローされる | E-03 | ○ |
| C-34 | GetBytesで文字がバイトにエンコードされる | E-03 | ○ |
| C-35 | Convertで部分的な変換が正しく行われる | E-03 | ○ |
| C-36 | HasStateでcharLeftOverがある場合trueが返却される | E-03 | ○ |
| C-37 | HasStateでcharLeftOverがない場合falseが返却される | E-03 | ○ |

### DecoderNLS関連（C-38〜C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | Resetで状態がリセットされる | E-04 | ○ |
| C-39 | GetCharCount(byte[], int, int)でバイト配列から文字数が計算される | E-04 | ○ |
| C-40 | GetCharCount(byte[], int, int, bool)でflush指定で文字数が計算される | E-04 | ○ |
| C-41 | GetCharsでバイトが文字にデコードされる | E-04 | ○ |
| C-42 | Convertで部分的な変換が正しく行われる | E-04 | ○ |
| C-43 | HasStateで状態がない場合falseが返却される | E-04 | ○ |

### EncodingTable関連（C-44〜C-52）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | GetCodePageFromNameで有効な名前からコードページが取得できる | E-05 | ○ |
| C-45 | GetCodePageFromNameで大文字小文字を区別しない | E-05 | ○ |
| C-46 | GetCodePageFromNameで無効な名前で0が返却される | E-05 | ○ |
| C-47 | GetCodePageFromNameでnullで0が返却される | E-05 | ○ |
| C-48 | GetWebNameFromCodePageでコードページからWeb名が取得できる | E-05 | ○ |
| C-49 | GetWebNameFromCodePageで無効なコードページでnullが返却される | E-05 | ○ |
| C-50 | GetEnglishNameFromCodePageでコードページから英語名が取得できる | E-05 | ○ |
| C-51 | GetCodePageItemでコードページ情報が取得できる | E-05 | ○ |
| C-52 | GetCodePageItemでushort.MaxValueを超える値でデフォルトが返却される | E-05 | ○ |

### SBCSCodePageEncoding関連（C-53〜C-58）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | GetByteCountでSBCSでバイト数が正しく計算される | E-06 | ○ |
| C-54 | GetBytesでSBCSで文字がバイトにエンコードされる | E-06 | ○ |
| C-55 | GetCharCountでSBCSでバイトから文字数が計算される | E-06 | ○ |
| C-56 | GetCharsでSBCSでバイトが文字にデコードされる | E-06 | ○ |
| C-57 | GetMaxByteCountでSBCSで最大バイト数が正しく計算される | E-06 | ○ |
| C-58 | GetMaxCharCountでSBCSで最大文字数が正しく計算される | E-06 | ○ |

### DBCSCodePageEncoding関連（C-59〜C-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | GetByteCountでDBCSでバイト数が正しく計算される | E-07 | ○ |
| C-60 | GetBytesでDBCSで文字がバイトにエンコードされる | E-07 | ○ |
| C-61 | GetCharCountでDBCSでバイトから文字数が計算される | E-07 | ○ |
| C-62 | GetCharsでDBCSでバイトが文字にデコードされる | E-07 | ○ |
| C-63 | GetCharsで不正なリードバイトでフォールバックが発生する | E-07 | ○ |
| C-64 | GetMaxByteCountでDBCSで最大バイト数が正しく計算される | E-07 | ○ |

### EUCJPEncoding関連（C-65〜C-69）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | GetByteCountでEUC-JPでバイト数が正しく計算される | E-08 | ○ |
| C-66 | GetBytesでEUC-JPで文字がバイトにエンコードされる | E-08 | ○ |
| C-67 | GetCharsでEUC-JPでバイトが文字にデコードされる | E-08 | ○ |
| C-68 | CleanUpBytesで半角カタカナが正しく処理される | E-08 | ○ |
| C-69 | CleanUpBytesでJIS X 0208範囲が正しく処理される | E-08 | ○ |

### ISO2022Encoding関連（C-70〜C-75）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | GetByteCountでISO-2022-JPでバイト数が正しく計算される | E-16 | △ |
| C-71 | GetBytesでISO-2022-JPで文字がバイトにエンコードされる | E-16 | △ |
| C-72 | GetCharsでISO-2022-JPでバイトが文字にデコードされる | E-16 | △ |
| C-73 | GetBytesでASCII/JISモード切り替えが正しく行われる | E-16 | △ |
| C-74 | GetDecoderで状態を保持するDecoderが取得できる | E-16 | ○ |
| C-75 | GetEncoderで状態を保持するEncoderが取得できる | E-16 | ○ |

### GB18030Encoding関連（C-76〜C-80）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | GetByteCountでGB18030でバイト数が正しく計算される | **根拠なし** | △ |
| C-77 | GetBytesでGB18030で文字がバイトにエンコードされる | **根拠なし** | △ |
| C-78 | GetCharsでGB18030でバイトが文字にデコードされる | **根拠なし** | △ |
| C-79 | GetBytesで4バイトGB18030が正しくエンコードされる | **根拠なし** | △ |
| C-80 | GetCharsで4バイトGB18030が正しくデコードされる | **根拠なし** | △ |

### InternalEncoderBestFitFallback関連（C-81〜C-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | CreateFallbackBufferでFallbackBufferが作成される | E-10 | ○ |
| C-82 | MaxCharCountで最大文字数が1である | E-10 | ○ |
| C-83 | Equalsで同じコードページのインスタンスが等しい | E-10 | ○ |
| C-84 | Equalsで異なるコードページのインスタンスが等しくない | E-10 | ○ |
| C-85 | Fallback(char, int)で未知の文字でフォールバック文字が返却される | E-10 | ○ |
| C-86 | Fallback(char, char, int)でサロゲートペアでフォールバックが動作する | E-10 | ○ |
| C-87 | Fallback(char, char, int)で無効な高サロゲートでArgumentOutOfRangeExceptionがスローされる | E-10 | ○ |
| C-88 | GetNextCharでフォールバック文字が順番に返却される | E-10 | ○ |
| C-89 | GetNextCharでフォールバック文字がなくなると'\0'が返却される | E-10 | ○ |
| C-90 | MovePreviousでカウンタが戻る | E-10 | ○ |
| C-91 | Remainingで残り文字数が正しく返却される | E-10 | ○ |
| C-92 | Resetで状態がリセットされる | E-10 | ○ |

### InternalDecoderBestFitFallback関連（C-93〜C-97）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | CreateFallbackBufferでFallbackBufferが作成される | E-11 | ○ |
| C-94 | MaxCharCountで最大文字数が1である | E-11 | ○ |
| C-95 | Fallback(byte[], int)で未知のバイト列でフォールバック文字が返却される | E-11 | ○ |
| C-96 | TryBestFitで空のバイト配列で'\0'が返却される | E-11 | ○ |
| C-97 | TryBestFitで3バイト以上の配列で'\0'が返却される | E-11 | ○ |

### EncoderFallbackBufferHelper関連（C-98〜C-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | InternalResetで状態がリセットされる | E-12 | ○ |
| C-99 | InternalFallbackで高サロゲートのフォールバックが正しく処理される | E-12 | ○ |
| C-100 | InternalFallbackで通常文字のフォールバックが正しく処理される | E-12 | ○ |
| C-101 | ThrowLastCharRecursiveで再帰フォールバックでArgumentExceptionがスローされる | E-12 | ○ |

### DecoderFallbackBufferHelper関連（C-102〜C-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | InternalInitializeで初期化が正しく行われる | E-13 | ○ |
| C-103 | InternalFallback(byte[], byte*, ref char*)でフォールバック文字が出力バッファに書き込まれる | E-13 | ○ |
| C-104 | InternalFallback(byte[], byte*, ref char*)で無効なサロゲートシーケンスでArgumentExceptionがスローされる | E-13 | ○ |
| C-105 | InternalFallback(byte[], byte*)でフォールバック文字数が正しくカウントされる | E-13 | ○ |

### EncodingByteBuffer関連（C-106〜C-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | AddByte(byte)でバイトが追加される | E-14 | ○ |
| C-107 | AddByte(byte)でバッファが一杯の場合falseが返却される | E-14 | ○ |
| C-108 | AddByte(byte, byte)で2バイトが追加される | E-14 | ○ |
| C-109 | AddByte(byte, byte, byte)で3バイトが追加される | E-14 | ○ |
| C-110 | AddByte(byte, byte, byte, byte)で4バイトが追加される | E-14 | ○ |
| C-111 | GetNextCharで次の文字が取得できる | E-14 | ○ |
| C-112 | GetNextCharでフォールバックバッファから文字が取得される | E-14 | ○ |
| C-113 | MoreDataでデータがある場合trueが返却される | E-14 | ○ |
| C-114 | MoreDataでデータがない場合falseが返却される | E-14 | ○ |
| C-115 | CharsUsedで使用した文字数が正しく返却される | E-14 | ○ |
| C-116 | Countでバイト数が正しく返却される | E-14 | ○ |

### EncodingCharBuffer関連（C-117〜C-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | AddChar(char)で文字が追加される | E-15 | ○ |
| C-118 | AddChar(char)でバッファが一杯の場合falseが返却される | E-15 | ○ |
| C-119 | AddChar(char, char, int)で2文字が追加される | E-15 | ○ |
| C-120 | GetNextByteで次のバイトが取得できる | E-15 | ○ |
| C-121 | GetNextByteでバッファ終端で0が返却される | E-15 | ○ |
| C-122 | MoreDataでデータがある場合trueが返却される | E-15 | ○ |
| C-123 | EvenMoreDataで指定数以上のデータがある場合trueが返却される | E-15 | ○ |
| C-124 | Fallback(byte)で1バイトのフォールバックが実行される | E-15 | ○ |
| C-125 | Fallback(byte, byte)で2バイトのフォールバックが実行される | E-15 | ○ |
| C-126 | Fallback(byte, byte, byte, byte)で4バイトのフォールバックが実行される | E-15 | ○ |
| C-127 | BytesUsedで使用したバイト数が正しく返却される | E-15 | ○ |
| C-128 | Countで文字数が正しく返却される | E-15 | ○ |

### BaseCodePageEncoding関連（C-129〜C-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | CodePageでコードページ番号が正しく返却される | E-09 | ○ |
| C-130 | GetBestFitUnicodeToBytesDataでベストフィットデータが取得できる | E-09 | ○ |
| C-131 | GetBestFitBytesToUnicodeDataでベストフィットデータが取得できる | E-09 | ○ |

### ISCIIEncoding関連（C-132〜C-136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | GetByteCountでISCIIでバイト数が正しく計算される | E-17 | △ |
| C-133 | GetBytesでISCIIで文字がバイトにエンコードされる | E-17 | △ |
| C-134 | GetCharsでISCIIでバイトが文字にデコードされる | E-17 | △ |
| C-135 | GetDecoderで状態を保持するDecoderが取得できる | E-17 | ○ |
| C-136 | GetEncoderで状態を保持するEncoderが取得できる | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- **GB18030Encoding.cs**: ファイルの読み込みに失敗したため、詳細なメソッドシグネチャと実装の確認ができなかった
  - 候補：ファイルを手動で確認 / 既存のテストコードを参照 / ドキュメントを参照
- **ISO2022Encoding.cs**: ファイルサイズが大きく、全体を読み込めなかったため、エスケープシーケンス処理の詳細が未確認
  - 候補：部分的な読み込みを実施 / 既存のテストコードを参照
- **ISCIIEncoding.cs**: ファイルサイズが大きく、全体を読み込めなかったため、インド系言語エンコーディングの詳細が未確認
  - 候補：部分的な読み込みを実施 / 既存のテストコードを参照

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - GB18030Encoding関連のテストケース（C-76〜C-80）は、ソースコードの直接確認ができていないため、入力値・期待結果の精度に懸念あり
- **1: 中リスク** - ISO2022Encoding関連のテストケース（C-70〜C-73）は、エスケープシーケンス処理の詳細が未確認のため、テスト観点に漏れがある可能性
- **1: 中リスク** - ISCIIEncoding関連のテストケース（C-132〜C-134）は、インド系言語固有の処理詳細が未確認
- **0: 低リスク** - その他のテストケースは、ソースコードから直接メソッドシグネチャと実装を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GB18030Encoding関連テストケース（C-76〜C-80）の入力値・期待結果が正確か確認
- [ ] ISO2022Encoding関連テストケース（C-70〜C-73）でエスケープシーケンス処理のテスト観点に漏れがないか確認
- [ ] ISCIIEncoding関連テストケース（C-132〜C-134）でインド系言語固有の処理が網羅されているか確認
- [ ] 全テストケースのテストID命名規則（UT-ECP-xxx）が一貫しているか確認
- [ ] 優先度の設定が適切か確認（金額計算相当の重要なエンコード/デコード処理が「高」になっているか）
- [ ] 異常系テストケースで、実際にスローされる例外型が正しいか確認
- [ ] 境界値テストケースで、バッファサイズや配列インデックスの境界が網羅されているか確認
