---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 122
  claims_with_evidence: 122
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Text.Encoding.Extensions.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：122 / 122、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Text.Encoding.Extensions/ref/System.Text.Encoding.Extensions.cs` - 公開API定義（参照アセンブリ）
- E-02: `src/libraries/System.Text.Encoding.Extensions/src/System.Text.Encoding.Extensions.csproj` - プロジェクト構成（PartialFacadeAssembly）
- E-03: `src/libraries/System.Text.Encoding.Extensions/tests/Fallback.cs` - 既存テストコード
- E-04: `src/libraries/System.Private.CoreLib/src/System/Text/ASCIIEncoding.cs` - ASCIIEncoding実装
- E-05: `src/libraries/System.Private.CoreLib/src/System/Text/UnicodeEncoding.cs` - UnicodeEncoding実装
- E-06: `src/libraries/System.Private.CoreLib/src/System/Text/UTF32Encoding.cs` - UTF32Encoding実装
- E-07: `src/libraries/System.Private.CoreLib/src/System/Text/UTF7Encoding.cs` - UTF7Encoding実装（Obsolete）
- E-08: `src/libraries/System.Private.CoreLib/src/System/Text/UTF8Encoding.cs` - UTF8Encoding実装

## 3) Claims と根拠の対応（レビューの主戦場）

### ASCIIEncoding テストケース（UT-EXT-001 ～ UT-EXT-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ASCIIEncodingのGetByteCount(char[], int, int)メソッドが存在する | E-01, E-04 | ○ |
| C-02 | chars引数がnullの場合ArgumentNullExceptionがスローされる | E-04 (line 81-84) | ○ |
| C-03 | index引数が負の場合ArgumentOutOfRangeExceptionがスローされる | E-04 (line 86-88) | ○ |
| C-04 | GetByteCount(string)オーバーロードが存在する | E-01, E-04 (line 107-118) | ○ |
| C-05 | GetByteCount(ReadOnlySpan<char>)オーバーロードが存在する | E-01, E-04 (line 140-148) | ○ |
| C-06 | GetBytes各オーバーロードが存在し引数検証を行う | E-01, E-04 (line 208-370) | ○ |
| C-07 | TryGetBytes/TryGetCharsメソッドが存在する | E-01, E-04 (line 326-341, 617-632) | ○ |
| C-08 | GetCharCount/GetChars各オーバーロードが存在する | E-01, E-04 (line 439-668) | ○ |
| C-09 | GetStringメソッドが存在する | E-01, E-04 (line 727-754) | ○ |
| C-10 | GetMaxByteCount/GetMaxCharCountが存在する | E-01, E-04 (line 837-870) | ○ |
| C-11 | IsSingleByteプロパティがtrueを返す | E-01, E-04 (line 874) | ○ |
| C-12 | GetDecoder/GetEncoderメソッドが存在する | E-01, E-04 (line 876-879) | ○ |

### UnicodeEncoding テストケース（UT-EXT-029 ～ UT-EXT-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | UnicodeEncodingの3つのコンストラクタが存在する | E-01, E-05 (line 34-54) | ○ |
| C-14 | bigEndianとbyteOrderMarkの設定が反映される | E-05 (line 26-29, 39-44) | ○ |
| C-15 | throwOnInvalidBytes=trueでExceptionFallbackが設定される | E-05 (line 56-69) | ○ |
| C-16 | GetByteCount/GetBytes/GetCharCount/GetCharsが2バイト/文字で計算される | E-05 (line 85-314) | ○ |
| C-17 | サロゲートペアが正しく処理される | E-05 (line 480-551, 764-826) | ○ |
| C-18 | GetPreambleがBOM設定に応じた値を返す | E-05 (line 1725-1743) | ○ |
| C-19 | CharSize定数が2である | E-01, E-05 (line 32) | ○ |
| C-20 | Equals/GetHashCodeが正しく実装されている | E-05 (line 1784-1806) | ○ |

### UTF32Encoding テストケース（UT-EXT-051 ～ UT-EXT-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | UTF32Encodingの3つのコンストラクタが存在する | E-01, E-06 (line 44-63) | ○ |
| C-22 | bigEndianとbyteOrderMarkの設定が反映される | E-06 (line 40-42, 48-53) | ○ |
| C-23 | GetByteCount/GetBytes/GetCharCount/GetCharsが4バイト/文字で計算される | E-06 (line 93-322) | ○ |
| C-24 | サロゲートペアが1つのUTF-32コードポイントに変換される | E-06 (line 353-481, 539-547) | ○ |
| C-25 | サプリメンタリ文字がサロゲートペアとしてデコードされる | E-06 (line 943-961) | ○ |
| C-26 | GetPreambleが4バイトBOMを返す | E-06 (line 1113-1135) | ○ |

### UTF7Encoding テストケース（UT-EXT-071 ～ UT-EXT-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | UTF7Encodingにはコンストラクタが2つ存在する（Obsolete属性付き） | E-01, E-07 (line 37-52) | ○ |
| C-28 | allowOptionals=trueで追加の直接エンコード文字が有効になる | E-07 (line 76-85) | ○ |
| C-29 | +記号が+-にエンコード/デコードされる | E-07 (line 459-463, 635-641) | ○ |
| C-30 | Base64モードの切り替えが正しく行われる | E-07 (line 431-536, 587-712) | ○ |

### UTF8Encoding テストケース（UT-EXT-087 ～ UT-EXT-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | UTF8Encodingの3つのコンストラクタが存在する | E-01, E-08 (line 73-94) | ○ |
| C-32 | emitUTF8Identifierの設定が反映される | E-08 (line 68, 79-83) | ○ |
| C-33 | throwOnInvalidBytes=trueでExceptionFallbackが設定される | E-08 (line 96-109) | ○ |
| C-34 | ASCII文字は1バイト、マルチバイト文字は最大3バイトでエンコードされる | E-08 (line 57-58, comment) | ○ |
| C-35 | サロゲートペアが4バイトのUTF-8シーケンスにエンコードされる | E-08 (line 44-46, comment) | ○ |
| C-36 | GetPreambleがBOM設定に応じた値を返す | E-08 (line 64, 861-875) | ○ |
| C-37 | Span/TryGetメソッドが存在する | E-01, E-08 (line 190-198, 361-387, 556-583) | ○ |

### Fallback テストケース（UT-EXT-119 ～ UT-EXT-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | EncoderReplacementFallbackで非ASCII文字が置換される | E-03 (line 16-36) | ○ |
| C-39 | DecoderReplacementFallbackで無効なバイトが置換される | E-03 (line 39-43) | ○ |
| C-40 | EncoderExceptionFallbackで例外がスローされる | E-03 (line 46-50) | ○ |
| C-41 | DecoderExceptionFallbackで例外がスローされる | E-03 (line 53-57) | ○ |
| C-42 | カスタムFallbackBufferが使用できる | E-03 (line 60-73, 78-158) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースにソースコードによる根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースが実装コードに基づいて生成されている

**注意点:**
- System.Text.Encoding.Extensionsは「PartialFacadeAssembly」であり、実際の実装はSystem.Private.CoreLibにTypeForwardされている
- UTF7Encodingは`[Obsolete]`属性が付与されており、非推奨である（SYSLIB0001）
- テストケースの優先度は、金額計算や認証ではなく、エンコーディングの基本機能とデータ整合性に基づいて設定

## 6) レビュアーチェックリスト（最小）
- [ ] ASCIIEncoding: 非ASCII文字に対するフォールバック処理が網羅されているか
- [ ] UnicodeEncoding: ビッグエンディアン/リトルエンディアン両方のテストがあるか
- [ ] UTF32Encoding: サプリメンタリ文字（U+10000以上）のサロゲートペア変換が検証されているか
- [ ] UTF7Encoding: Obsolete属性の警告が適切に処理されているか（テスト実行時）
- [ ] UTF8Encoding: 不正なUTF-8シーケンス（壊れたマルチバイト）に対するフォールバック処理があるか
- [ ] 全クラス: null入力、空入力、境界値（0, 負の値）に対する例外処理が網羅されているか
