---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 123
  claims_with_evidence: 118
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：libraries-System.Text.Encodings.Web 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：118 / 123、根拠なし：5
- 優先レビュー（高）
  1. **UT-TEW-087**：UnicodeRanges.BasicLatinの具体的な範囲は生成コードで確認必要
  2. **UT-TEW-101〜103**：GetUtf8RepresentationForScalarValueの戻り値フォーマット詳細
  3. **UT-TEW-095**：ForbidUndefinedCharactersで禁止される具体的なカテゴリ一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/TextEncoder.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/HtmlEncoder.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/JavaScriptEncoder.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/UrlEncoder.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/TextEncoderSettings.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Unicode/UnicodeRange.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Unicode/UnicodeRanges.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/DefaultHtmlEncoder.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/DefaultJavaScriptEncoder.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/DefaultUrlEncoder.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/AllowedBmpCodePointsBitmap.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/OptimizedInboxTextEncoder.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/AsciiByteMap.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Encodings/Web/ScalarEscaperBase.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Text.Encodings.Web/src/System/Text/Unicode/UnicodeHelpers.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextEncoder.Encode(string)がエンコード不要時に入力をそのまま返す | E-01 (L136-139) | ○ |
| C-02 | TextEncoder.Encode(string)がnull入力で例外をスロー | E-01 (L131-134) | ○ |
| C-03 | TextEncoder.Encode(TextWriter, string)の動作 | E-01 (L192-195) | ○ |
| C-04 | TextEncoder.Encode(TextWriter, string, int, int)の範囲検証 | E-01 (L609-619) | ○ |
| C-05 | TextEncoder.Encode(ReadOnlySpan)のOperationStatus返却 | E-01 (L407-449) | ○ |
| C-06 | TextEncoder.EncodeUtf8の動作 | E-01 (L277-319) | ○ |
| C-07 | TextEncoder.FindFirstCharacterToEncodeUtf8の動作 | E-01 (L559-574) | ○ |
| C-08 | HtmlEncoder.Defaultがシングルトンを返す | E-02 (L16), E-08 (L13) | ○ |
| C-09 | HtmlEncoder.Createファクトリメソッド | E-02 (L23-37) | ○ |
| C-10 | HtmlEncoderが<を&lt;にエンコード | E-08 (L69-72, L135-138) | ○ |
| C-11 | HtmlEncoderが>を&gt;にエンコード | E-08 (L73-76, L139-142) | ○ |
| C-12 | HtmlEncoderが&を&amp;にエンコード | E-08 (L77-81, L143-147) | ○ |
| C-13 | HtmlEncoderが"を&quot;にエンコード | E-08 (L82-87, L148-153) | ○ |
| C-14 | HtmlEncoder.MaxOutputCharactersPerInputCharacterが8 | E-08 (L27) | ○ |
| C-15 | JavaScriptEncoder.Defaultがシングルトンを返す | E-03 (L16), E-09 (L11) | ○ |
| C-16 | JavaScriptEncoder.UnsafeRelaxedJsonEscaping | E-03 (L36), E-09 (L12) | ○ |
| C-17 | JavaScriptEncoderがバックスラッシュをエスケープ | E-09 (L90) | ○ |
| C-18 | JavaScriptEncoderが\n, \t, \r, \b, \fをエスケープ | E-09 (L85-89) | ○ |
| C-19 | JavaScriptEncoderがBMP文字を\uXXXX形式でエスケープ | E-09 (L132-141, L183-191) | ○ |
| C-20 | JavaScriptEncoderが補助文字を\uXXXX\uYYYY形式でエスケープ | E-09 (L142-156, L193-206) | ○ |
| C-21 | JavaScriptEncoder.MaxOutputCharactersPerInputCharacterが6 | E-09 (L39) | ○ |
| C-22 | UrlEncoder.Defaultがシングルトンを返す | E-04 (L16), E-10 (L11) | ○ |
| C-23 | UrlEncoderがスペースを%20にエンコード | E-10 (L68) | ○ |
| C-24 | UrlEncoderが特殊文字を%XX形式でエンコード | E-10 (L142-169, L171-198) | ○ |
| C-25 | UrlEncoder.MaxOutputCharactersPerInputCharacterが9 | E-10 (L102) | ○ |
| C-26 | TextEncoderSettingsコンストラクタの動作 | E-05 (L17-49) | ○ |
| C-27 | TextEncoderSettings.AllowCharacterの動作 | E-05 (L54-57) | ○ |
| C-28 | TextEncoderSettings.AllowCharactersの動作 | E-05 (L62-73) | ○ |
| C-29 | TextEncoderSettings.AllowCodePointsの動作 | E-05 (L78-93) | ○ |
| C-30 | TextEncoderSettings.AllowRangeの動作 | E-05 (L98-113) | ○ |
| C-31 | TextEncoderSettings.AllowRangesの動作 | E-05 (L118-129) | ○ |
| C-32 | TextEncoderSettings.Clearの動作 | E-05 (L134-137) | ○ |
| C-33 | TextEncoderSettings.ForbidCharacterの動作 | E-05 (L142-145) | ○ |
| C-34 | TextEncoderSettings.ForbidCharactersの動作 | E-05 (L150-161) | ○ |
| C-35 | TextEncoderSettings.ForbidRangeの動作 | E-05 (L166-181) | ○ |
| C-36 | TextEncoderSettings.ForbidRangesの動作 | E-05 (L186-197) | ○ |
| C-37 | TextEncoderSettings.GetAllowedCodePointsの動作 | E-05 (L202-211) | ○ |
| C-38 | UnicodeRangeコンストラクタの範囲検証 | E-06 (L21-36) | ○ |
| C-39 | UnicodeRange.Createの動作 | E-06 (L54-62) | ○ |
| C-40 | UnicodeRange.FirstCodePoint, Lengthプロパティ | E-06 (L41, L46) | ○ |
| C-41 | UnicodeRanges.Noneが空範囲を返す | E-07 (L19-20, L30-35) | ○ |
| C-42 | UnicodeRanges.AllがBMP全体を返す | E-07 (L26-27, L37-43) | ○ |
| C-43 | AllowedBmpCodePointsBitmap.AllowCharの動作 | E-11 (L27-32) | ○ |
| C-44 | AllowedBmpCodePointsBitmap.ForbidCharの動作 | E-11 (L37-42) | ○ |
| C-45 | AllowedBmpCodePointsBitmap.IsCharAllowedの動作 | E-11 (L97-104) | ○ |
| C-46 | AllowedBmpCodePointsBitmap.IsCodePointAllowedの動作 | E-11 (L109-116) | ○ |
| C-47 | AllowedBmpCodePointsBitmap.ForbidHtmlCharactersの動作 | E-11 (L47-55) | ○ |
| C-48 | AllowedBmpCodePointsBitmap.ForbidUndefinedCharactersの動作 | E-11 (L64-92) | ○ |
| C-49 | AsciiByteMap.InsertAsciiCharの動作 | E-13 (L18-27) | ○ |
| C-50 | AsciiByteMap.TryLookupの動作 | E-13 (L33-48) | ○ |
| C-51 | UnicodeHelpers.GetUtf8RepresentationForScalarValueの動作 | E-15 (L43-79) | ○ |
| C-52 | UnicodeHelpers.GetUtf16SurrogatePairFromAstralScalarValueの動作 | E-15 (L26-37) | ○ |
| C-53 | UnicodeHelpers.IsSupplementaryCodePointの動作 | E-15 (L87-90) | ○ |
| C-54 | OptimizedInboxTextEncoder.Encodeの動作 | E-12 (L133-250) | ○ |
| C-55 | OptimizedInboxTextEncoder.EncodeUtf8の動作 | E-12 (L252-357) | ○ |
| C-56 | OptimizedInboxTextEncoder.GetIndexOfFirstCharToEncodeの動作 | E-12 (L395-461) | ○ |
| C-57 | OptimizedInboxTextEncoder.GetIndexOfFirstByteToEncodeの動作 | E-12 (L359-393) | ○ |
| C-58 | OptimizedInboxTextEncoder.IsScalarValueAllowedの動作 | E-12 (L467-471) | ○ |
| C-59 | ScalarEscaperBase抽象メソッド定義 | E-14 (L9-13) | ○ |
| C-60 | DefaultHtmlEncoder.WillEncodeの動作 | E-08 (L53-54) | ○ |
| C-61 | DefaultJavaScriptEncoder.WillEncodeの動作 | E-09 (L65-66) | ○ |
| C-62 | DefaultUrlEncoder.WillEncodeの動作 | E-10 (L128-129) | ○ |
| C-63 | TextEncoder.TryCopyCharactersの動作 | E-01 (L576-593) | ○ |
| C-64 | TextEncoder.TryWriteScalarAsCharの動作 | E-01 (L595-607) | ○ |
| C-65 | UnicodeRanges.BasicLatinの範囲定義 | **根拠なし** - 生成コード参照必要 | △ |
| C-66 | GetUtf8RepresentationForScalarValueの2バイト戻り値詳細 | **根拠不足** - 実装詳細 | △ |
| C-67 | GetUtf8RepresentationForScalarValueの3バイト戻り値詳細 | **根拠不足** - 実装詳細 | △ |
| C-68 | GetUtf8RepresentationForScalarValueの4バイト戻り値詳細 | **根拠不足** - 実装詳細 | △ |
| C-69 | ForbidUndefinedCharactersの具体的禁止カテゴリ | **根拠不足** - コメントのみ | △ |

## 4) 不足情報（Unknown / Missing）
- **UnicodeRanges.BasicLatin**: `UnicodeRanges.generated.cs` で定義されており、自動生成コードのため直接確認が必要
  - 候補：`src/libraries/System.Text.Encodings.Web/src/System/Text/Unicode/UnicodeRanges.generated.cs`
- **GetUtf8RepresentationForScalarValue戻り値フォーマット**: 実装からリトルエンディアン形式であることは推測可能だが、テストケースの期待値として厳密な値を記載するには実行確認が必要
- **ForbidUndefinedCharacters**: コードコメント（E-11 L62-63）に記載があるが、具体的なUnicodeカテゴリ一覧は`UnicodeHelpers.generated.cs`を参照する必要がある

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大半のテストケースはソースコードから直接導出可能
- **1: 中リスク** - UTF-8変換の具体的バイト列テストケース（UT-TEW-101〜103）は実装詳細に依存
- **0: 低リスク** - エンコーダの基本動作（HTML/JS/URL特殊文字）は仕様が明確

## 6) レビュアーチェックリスト（最小）
- [ ] HTML特殊文字（<, >, &, ", '）のエンコード結果が正しいか確認
- [ ] JavaScript特殊文字（\, \n, \t, \r, \b, \f）のエスケープ結果が正しいか確認
- [ ] URL特殊文字（スペース、#、%、?等）のパーセントエンコード結果が正しいか確認
- [ ] UnicodeRange境界値テスト（BMP範囲0x0000-0xFFFF）の妥当性確認
- [ ] サロゲートペア処理のテストケースがエッジケースを網羅しているか確認
- [ ] null入力に対するArgumentNullException系テストが網羅的か確認
- [ ] OperationStatus（Done, DestinationTooSmall, NeedMoreData）の各状態遷移テストの妥当性確認
