---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Text.Json 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **JsonSchemaExporter関連テストケース（C-139）**：スキーマ生成機能の詳細仕様要確認
  2. **ソース生成コンテキスト関連テストケース（C-136）**：AOT対応の具体的な動作要確認
  3. **ReferenceHandler.IgnoreCycles（C-138）**：循環参照のnull処理の詳細動作要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Text.Json/src/System/Text/Json/Reader/Utf8JsonReader.cs` - JSON読み取りクラスの実装
- E-02: `src/libraries/System.Text.Json/src/System/Text/Json/Reader/Utf8JsonReader.TryGet.cs` - TryGetメソッド群の実装
- E-03: `src/libraries/System.Text.Json/src/System/Text/Json/Writer/Utf8JsonWriter.cs` - JSON書き込みクラスの実装
- E-04: `src/libraries/System.Text.Json/src/System/Text/Json/Document/JsonDocument.cs` - JsonDocumentクラスの実装
- E-05: `src/libraries/System.Text.Json/src/System/Text/Json/Nodes/JsonNode.cs` - JsonNodeベースクラスの実装
- E-06: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializer.Helpers.cs` - シリアライザーヘルパー
- E-07: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializerOptions.cs` - オプションクラスの実装
- E-08: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonConverter.cs` - コンバーターベースクラス
- E-09: `src/libraries/System.Text.Json/src/System/Text/Json/Reader/JsonReaderOptions.cs` - リーダーオプション
- E-10: `src/libraries/System.Text.Json/src/System/Text/Json/Writer/JsonWriterOptions.cs` - ライターオプション
- E-11: .NET公式ドキュメント - System.Text.Json名前空間
- E-12: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/Attributes/` - 各種属性クラス
- E-13: `src/libraries/System.Text.Json/src/System/Text/Json/Serialization/Metadata/` - メタデータ関連クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Utf8JsonReader.Readが有効なJSONを読み取れること | E-01 | ○ |
| C-002 | 不正なJSONでJsonExceptionがスローされること | E-01 | ○ |
| C-003 | 空のJSONで正しく処理されること | E-01 | ○ |
| C-004 | GetStringで文字列値を正しく取得できること | E-02 | ○ |
| C-005 | 数値トークンでGetString呼び出し時にInvalidOperationExceptionがスローされること | E-02 | ○ |
| C-006 | GetInt32で整数値を正しく取得できること | E-02 | ○ |
| C-007 | Int32最大値を正しく取得できること | E-02 | ○ |
| C-008 | Int32最小値を正しく取得できること | E-02 | ○ |
| C-009 | オーバーフロー時にFormatExceptionがスローされること | E-02 | ○ |
| C-010 | GetDoubleで浮動小数点数を正しく取得できること | E-02 | ○ |
| C-011 | GetBooleanでtrue値を正しく取得できること | E-02 | ○ |
| C-012 | GetBooleanでfalse値を正しく取得できること | E-02 | ○ |
| C-013 | TryGetInt32が有効な整数でtrueを返却すること | E-02 | ○ |
| C-014 | TryGetInt32が無効な値でfalseを返却すること | E-02 | ○ |
| C-015 | TokenTypeが現在のトークン種別を正しく返却すること | E-01 | ○ |
| C-016 | CurrentDepthがネスト深度を正しく返却すること | E-01 | ○ |
| C-017 | ValueIsEscapedがエスケープされた値を正しく検出すること | E-01 | ○ |
| C-018 | WriteStartObjectがJSONオブジェクト開始を正しく書き込むこと | E-03 | ○ |
| C-019 | WriteEndObjectがJSONオブジェクト終了を正しく書き込むこと | E-03 | ○ |
| C-020 | WriteStartArrayがJSON配列開始を正しく書き込むこと | E-03 | ○ |
| C-021 | WriteEndArrayがJSON配列終了を正しく書き込むこと | E-03 | ○ |
| C-022 | WriteStringが文字列プロパティを正しく書き込むこと | E-03 | ○ |
| C-023 | WriteNumberが数値プロパティを正しく書き込むこと | E-03 | ○ |
| C-024 | WriteBooleanが真偽値プロパティを正しく書き込むこと | E-03 | ○ |
| C-025 | WriteNullがnullプロパティを正しく書き込むこと | E-03 | ○ |
| C-026 | WritePropertyNameがプロパティ名を正しく書き込むこと | E-03 | ○ |
| C-027 | Flushがバッファをフラッシュすること | E-03 | ○ |
| C-028 | Resetがライターをリセットすること | E-03 | ○ |
| C-029 | CurrentDepthがネスト深度を正しく追跡すること | E-03 | ○ |
| C-030 | 最大深度超過でInvalidOperationExceptionがスローされること | E-03 | ○ |
| C-031 | Dispose後に再利用不可となること | E-03 | ○ |
| C-032 | JsonDocument.ParseがJSON文字列を正しくパースできること | E-04 | ○ |
| C-033 | JsonDocument.ParseがUTF-8バイト配列を正しくパースできること | E-04 | ○ |
| C-034 | 不正なJSONでJsonExceptionがスローされること | E-04 | ○ |
| C-035 | RootElementがルート要素を正しく取得できること | E-04 | ○ |
| C-036 | Dispose後にアクセス不可となること | E-04 | ○ |
| C-037 | WriteToがドキュメントをライターに書き込むこと | E-04 | ○ |
| C-038 | JsonElement.GetPropertyが存在するプロパティを取得できること | E-04 | ○ |
| C-039 | 存在しないプロパティでKeyNotFoundExceptionがスローされること | E-04 | ○ |
| C-040 | TryGetPropertyが存在するプロパティでtrueを返却すること | E-04 | ○ |
| C-041 | TryGetPropertyが存在しないプロパティでfalseを返却すること | E-04 | ○ |
| C-042 | GetArrayLengthが配列の長さを正しく取得できること | E-04 | ○ |
| C-043 | 配列以外でGetArrayLength呼び出し時にInvalidOperationExceptionがスローされること | E-04 | ○ |
| C-044 | EnumerateArrayが配列要素を列挙できること | E-04 | ○ |
| C-045 | EnumerateObjectがオブジェクトプロパティを列挙できること | E-04 | ○ |
| C-046 | ValueKindが値の種別を正しく取得できること | E-04 | ○ |
| C-047 | GetStringが文字列値を正しく取得できること | E-04 | ○ |
| C-048 | GetInt32が整数値を正しく取得できること | E-04 | ○ |
| C-049 | Cloneが要素のクローンを作成すること | E-04 | ○ |
| C-050 | GetRawTextが生のJSON文字列を取得できること | E-04 | ○ |
| C-051 | JsonSerializer.SerializeがオブジェクトをJSON文字列にシリアライズすること | E-06, E-11 | ○ |
| C-052 | ネストしたオブジェクトが正しくシリアライズされること | E-06 | ○ |
| C-053 | 配列が正しくシリアライズされること | E-06 | ○ |
| C-054 | nullが正しくシリアライズされること | E-06 | ○ |
| C-055 | 循環参照がReferenceHandlerで処理されること | E-07 | ○ |
| C-056 | JSON文字列がオブジェクトにデシリアライズされること | E-06 | ○ |
| C-057 | 配列JSONがリストにデシリアライズされること | E-06 | ○ |
| C-058 | 型不一致でJsonExceptionがスローされること | E-06 | ○ |
| C-059 | 不正なJSONでJsonExceptionがスローされること | E-06 | ○ |
| C-060 | nullがnull許容型にデシリアライズされること | E-06 | ○ |
| C-061 | SerializeAsyncが非同期でシリアライズを完了すること | E-06 | ○ |
| C-062 | DeserializeAsyncが非同期でデシリアライズを完了すること | E-06 | ○ |
| C-063 | JsonSerializerOptions.Defaultがデフォルトオプションを取得できること | E-07 | ○ |
| C-064 | JsonSerializerOptions.WebがWebオプションを取得できること | E-07 | ○ |
| C-065 | PropertyNameCaseInsensitiveで大文字小文字を無視してデシリアライズできること | E-07 | ○ |
| C-066 | WriteIndentedでインデント付きJSONが出力されること | E-07 | ○ |
| C-067 | MaxDepthで最大深度が設定できること | E-07 | ○ |
| C-068 | 最大深度超過でJsonExceptionがスローされること | E-07 | ○ |
| C-069 | AllowTrailingCommasで末尾カンマを許可してパースできること | E-07 | ○ |
| C-070 | PropertyNamingPolicyでcamelCase変換が適用されること | E-07 | ○ |
| C-071 | Convertersでカスタムコンバーターが適用されること | E-07 | ○ |
| C-072 | NumberHandlingで文字列から数値への変換が許可されること | E-07 | ○ |
| C-073 | ReferenceHandlerで循環参照が処理されること | E-07 | ○ |
| C-074 | IgnoreReadOnlyPropertiesで読み取り専用プロパティが無視されること | E-07 | ○ |
| C-075 | DefaultIgnoreConditionでnull値が無視されること | E-07 | ○ |
| C-076 | MakeReadOnlyでオプションが読み取り専用になること | E-07 | ○ |
| C-077 | 読み取り専用後の変更でInvalidOperationExceptionがスローされること | E-07 | ○ |
| C-078 | JsonNode.ParseがJSON文字列からJsonNodeを作成すること | E-05 | ○ |
| C-079 | JsonNode.Parseで不正なJSONでJsonExceptionがスローされること | E-05 | ○ |
| C-080 | AsArrayがJsonArrayにキャストできること | E-05 | ○ |
| C-081 | 非配列でAsArray呼び出し時にInvalidOperationExceptionがスローされること | E-05 | ○ |
| C-082 | AsObjectがJsonObjectにキャストできること | E-05 | ○ |
| C-083 | AsValueがJsonValueにキャストできること | E-05 | ○ |
| C-084 | GetValueが指定型で値を取得できること | E-05 | ○ |
| C-085 | 型不一致でGetValue呼び出し時にInvalidOperationExceptionがスローされること | E-05 | ○ |
| C-086 | Parentが親ノードを正しく取得できること | E-05 | ○ |
| C-087 | Rootがルートノードを正しく取得できること | E-05 | ○ |
| C-088 | GetPathがJSONパスを正しく取得できること | E-05 | ○ |
| C-089 | DeepCloneがノードの深いクローンを作成すること | E-05 | ○ |
| C-090 | DeepEqualsが同値のノードでtrueを返却すること | E-05 | ○ |
| C-091 | JsonObject.Addがプロパティを追加すること | E-05 | ○ |
| C-092 | JsonObject.Removeがプロパティを削除すること | E-05 | ○ |
| C-093 | ContainsKeyが存在するキーでtrueを返却すること | E-05 | ○ |
| C-094 | TryGetPropertyValueがプロパティ値を取得できること | E-05 | ○ |
| C-095 | インデクサーでプロパティが取得できること | E-05 | ○ |
| C-096 | JsonArray.Addが要素を追加すること | E-05 | ○ |
| C-097 | JsonArray.Removeが要素を削除すること | E-05 | ○ |
| C-098 | Countが要素数を正しく返却すること | E-05 | ○ |
| C-099 | インデクサーで要素が取得できること | E-05 | ○ |
| C-100 | 範囲外インデックスでArgumentOutOfRangeExceptionがスローされること | E-05 | ○ |
| C-101 | JsonValue.Createが値からJsonValueを作成すること | E-05 | ○ |
| C-102 | JsonValue.Createがnullからnullを返却すること | E-05 | ○ |
| C-103 | TryGetValueが指定型で値を取得できること | E-05 | ○ |
| C-104 | JsonConverter.CanConvertがサポートする型でtrueを返却すること | E-08 | ○ |
| C-105 | JsonConverter.ReadがJSONから値を読み取ること | E-08 | ○ |
| C-106 | JsonConverter.Writeが値をJSONに書き込むこと | E-08 | ○ |
| C-107 | JsonConverterFactory.CreateConverterが適切なコンバーターを作成すること | E-08 | ○ |
| C-108 | JsonReaderOptions.AllowTrailingCommasで末尾カンマが許可されること | E-09 | ○ |
| C-109 | JsonReaderOptions.CommentHandlingでコメントが許可されること | E-09 | ○ |
| C-110 | JsonReaderOptions.MaxDepthで最大深度が設定されること | E-09 | ○ |
| C-111 | JsonWriterOptions.Indentedでインデント出力が有効化されること | E-10 | ○ |
| C-112 | JsonWriterOptions.SkipValidationでバリデーションがスキップされること | E-10 | ○ |
| C-113 | JsonWriterOptions.Encoderでカスタムエンコーダーが使用されること | E-10 | ○ |
| C-114 | JsonDocumentOptions.AllowTrailingCommasで末尾カンマが許可されること | E-04 | ○ |
| C-115 | JsonDocumentOptions.CommentHandlingでコメントが処理されること | E-04 | ○ |
| C-116 | JsonEncodedText.Encodeで文字列がエンコードされること | E-11 | ○ |
| C-117 | 特殊文字がエスケープされること | E-11 | ○ |
| C-118 | JsonNamingPolicy.CamelCaseでcamelCase変換が正しく行われること | E-07, E-11 | ○ |
| C-119 | JsonNamingPolicy.SnakeCaseLowerでsnake_case変換が正しく行われること | E-07 | ○ |
| C-120 | JsonNamingPolicy.SnakeCaseUpperでSNAKE_CASE変換が正しく行われること | E-07 | ○ |
| C-121 | JsonNamingPolicy.KebabCaseLowerでkebab-case変換が正しく行われること | E-07 | ○ |
| C-122 | JsonPropertyNameAttributeでカスタムプロパティ名が使用されること | E-12 | ○ |
| C-123 | JsonIgnoreAttributeでプロパティが無視されること | E-12 | ○ |
| C-124 | JsonRequiredAttributeで必須プロパティがないとエラーになること | E-12 | ○ |
| C-125 | JsonConstructorAttributeで指定コンストラクターが使用されること | E-12 | ○ |
| C-126 | JsonConverterAttributeで指定コンバーターが使用されること | E-12 | ○ |
| C-127 | JsonExtensionDataAttributeで未知のプロパティが拡張データに格納されること | E-12 | ○ |
| C-128 | JsonDerivedTypeAttributeで派生型がポリモーフィックにシリアライズされること | E-12 | ○ |
| C-129 | JsonPolymorphicAttributeでポリモーフィック設定が適用されること | E-12 | ○ |
| C-130 | JsonNumberHandlingAttributeで数値ハンドリングが適用されること | E-12 | ○ |
| C-131 | JsonTypeInfo.CreateJsonTypeInfoで型情報が作成されること | E-13 | ○ |
| C-132 | JsonTypeInfo.Propertiesでプロパティ一覧が取得できること | E-13 | ○ |
| C-133 | JsonPropertyInfo.Nameでプロパティ名が取得できること | E-13 | ○ |
| C-134 | JsonPropertyInfo.PropertyTypeでプロパティ型が取得できること | E-13 | ○ |
| C-135 | DefaultJsonTypeInfoResolverで型情報が解決されること | E-13 | ○ |
| C-136 | JsonSerializerContextでソース生成された型情報が取得できること | **根拠不足** | △ |
| C-137 | ReferenceHandler.Preserveで参照が保持されること | E-07 | ○ |
| C-138 | ReferenceHandler.IgnoreCyclesで循環がnullで処理されること | **根拠不足** | △ |
| C-139 | JsonSchemaExporter.GetJsonSchemaAsNodeでJSONスキーマが生成されること | **根拠不足** | △ |
| C-140 | JsonExceptionが正しく作成されること | E-11 | ○ |
| C-141 | JsonException.PathでJSONパスが取得できること | E-11 | ○ |
| C-142 | JsonException.LineNumberで行番号が取得できること | E-11 | ○ |
| C-143 | Utf8JsonReader.Skipで現在の値がスキップされること | E-01 | ○ |
| C-144 | Utf8JsonReader.TrySkipでスキップが試行されること | E-01 | ○ |
| C-145 | Utf8JsonWriter.WriteRawValueで生のJSONが書き込まれること | E-03 | ○ |
| C-146 | Utf8JsonWriter.WriteCommentValueでコメントが書き込まれること | E-03 | ○ |
| C-147 | JsonSerializer.IsReflectionEnabledByDefaultでリフレクション有効フラグが取得できること | **根拠不足** | △ |
| C-148 | JsonSerializerOptions.TypeInfoResolverで型情報リゾルバが設定できること | E-07 | ○ |
| C-149 | JsonSerializerOptions.TypeInfoResolverChainでリゾルバチェーンが取得できること | E-07 | ○ |
| C-150 | JsonSerializerOptions.UnmappedMemberHandlingで未マップメンバーハンドリングが設定できること | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **JsonSerializerContext（C-136）**: ソース生成機能の詳細な動作確認ソースコードが参照されていない
  - 候補：`src/libraries/System.Text.Json/gen/` / ソース生成関連テスト / .NET公式ドキュメント
- **ReferenceHandler.IgnoreCycles（C-138）**: 循環参照時のnull処理の具体的な実装詳細
  - 候補：`src/libraries/System.Text.Json/src/System/Text/Json/Serialization/ReferenceHandler.cs` / 既存テストコード
- **JsonSchemaExporter（C-139）**: スキーマ生成機能は比較的新しい機能であり、詳細な仕様確認が必要
  - 候補：`src/libraries/System.Text.Json/src/System/Text/Json/Schema/` / .NET 9以降のドキュメント
- **IsReflectionEnabledByDefault（C-147）**: AOT/Trimming対応のフラグであり、詳細動作の確認が必要
  - 候補：.NET AOT対応ドキュメント / Trimming関連設定
- **UnmappedMemberHandling（C-150）**: .NET 8で追加された機能であり、詳細な動作確認が必要
  - 候補：`src/libraries/System.Text.Json/src/System/Text/Json/Serialization/JsonSerializerOptions.cs` / 既存テストコード

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的なReader/Writer機能（C-001〜C-050）
- **0: 低リスク** - 標準的なシリアライズ/デシリアライズ機能（C-051〜C-062）
- **0: 低リスク** - JsonNode関連機能（C-078〜C-103）
- **1: 中リスク** - JsonSerializerOptions詳細設定（C-063〜C-077）- 組み合わせによる動作変化の可能性
- **1: 中リスク** - 属性関連機能（C-122〜C-130）- 属性の優先順位や組み合わせの確認が必要
- **2: 高リスク** - ソース生成・AOT関連（C-136, C-147）- 環境依存の動作確認が必要
- **1: 中リスク** - スキーマ生成機能（C-139）- 比較的新しい機能

## 6) レビュアーチェックリスト（最小）
- [ ] 基本的なJSON読み書き機能（C-001〜C-031）のテストケースが網羅的か確認
- [ ] JsonDocument/JsonElementの主要操作（C-032〜C-050）が正しくカバーされているか確認
- [ ] シリアライズ/デシリアライズの境界値・異常系（C-051〜C-062）が十分か確認
- [ ] JsonSerializerOptionsの各設定項目（C-063〜C-077）の組み合わせテストの必要性を評価
- [ ] JsonNode APIの操作（C-078〜C-103）が実際の利用シナリオをカバーしているか確認
- [ ] カスタムコンバーター（C-104〜C-107）の実装パターンが網羅されているか確認
- [ ] 属性適用（C-122〜C-130）の優先順位・組み合わせテストの必要性を評価
- [ ] ソース生成関連（C-136）のAOT環境でのテスト方針を確認
- [ ] 根拠不足の項目（△）について追加調査の要否を判断
