---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 148
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Text.RegularExpressions.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：148 / 150、根拠なし：2
- 優先レビュー（高）
  1. **UT-REX-136**: タイムアウト動作テスト - 実際のタイムアウト閾値は実行環境に依存
  2. **UT-REX-143**: CultureInvariant動作 - 文化依存の挙動は詳細なテストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.cs`
- E-02: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.Match.cs`
- E-03: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.Replace.cs`
- E-04: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.Split.cs`
- E-05: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.Count.cs`
- E-06: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.EnumerateMatches.cs`
- E-07: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Regex.Timeout.cs`
- E-08: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Match.cs`
- E-09: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Group.cs`
- E-10: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/Capture.cs`
- E-11: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/GroupCollection.cs`
- E-12: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/CaptureCollection.cs`
- E-13: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/MatchCollection.cs`
- E-14: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/ValueMatch.cs`
- E-15: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexOptions.cs`
- E-16: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexMatchTimeoutException.cs`
- E-17: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexParser.cs`
- E-18: `src/libraries/System.Text.RegularExpressions/src/System/Text/RegularExpressions/RegexRunner.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Regexクラス - コンストラクタとバリデーション
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Regex(pattern)で有効なパターンからインスタンス生成 | E-01 (L51-53, L69-83) | ○ |
| C-02 | nullパターンでArgumentNullException | E-01 (L138-144: ValidatePattern) | ○ |
| C-03 | オプション付きコンストラクタ | E-01 (L59-62, L87-116) | ○ |
| C-04 | 無効なRegexOptionsでArgumentOutOfRangeException | E-01 (L146-155: ValidateOptions) | ○ |
| C-05 | タイムアウト付きコンストラクタ | E-01 (L64-67) | ○ |
| C-06 | 無効なタイムアウトでArgumentOutOfRangeException | E-01 (L163-170: ValidateMatchTimeout) | ○ |
| C-07 | 負のタイムアウトでArgumentOutOfRangeException | E-01 (L163-170: ValidateMatchTimeout) | ○ |
| C-08 | ECMAScript許可オプション組み合わせ | E-01 (L150) | ○ |
| C-09 | ECMAScript禁止オプション組み合わせ | E-01 (L150) | ○ |
| C-10 | NonBacktracking+RightToLeft制限 | E-01 (L151) | ○ |

### Regexクラス - IsMatchメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | IsMatch正常マッチ | E-02 (L73-81) | ○ |
| C-12 | IsMatchマッチ失敗 | E-02 (L73-81) | ○ |
| C-13 | IsMatch null入力 | E-02 (L75-78: ThrowArgumentNullException) | ○ |
| C-14 | IsMatch空文字入力 | E-02 (L73-81) | ○ |
| C-15 | IsMatch開始位置指定 | E-02 (L87-95) | ○ |
| C-16 | IsMatch開始位置境界値 | E-01 (L414-417: startat検証) | ○ |
| C-17 | IsMatch Span版 | E-02 (L103-104) | ○ |
| C-18 | IsMatch Span版開始位置指定 | E-02 (L113-114) | ○ |

### Regexクラス - Matchメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | Matchマッチ成功 | E-02 (L138-146) | ○ |
| C-20 | Matchマッチ失敗 | E-02 (L138-146) | ○ |
| C-21 | Match null入力 | E-02 (L140-143: ThrowArgumentNullException) | ○ |
| C-22 | Match開始位置指定 | E-02 (L152-159) | ○ |
| C-23 | Match範囲指定 | E-02 (L165-173) | ○ |

### Regexクラス - Matchesメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Matches複数マッチ | E-02 (L193-201) | ○ |
| C-25 | Matchesマッチなし | E-02 (L193-201), E-13 (L75-105) | ○ |
| C-26 | Matches null入力 | E-02 (L195-198: ThrowArgumentNullException) | ○ |
| C-27 | Matches開始位置指定 | E-02 (L206-214) | ○ |

### Regexクラス - Replaceメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | Replace文字列置換 | E-03 (L38-46) | ○ |
| C-29 | Replace置換なし | E-03 (L170-173) | ○ |
| C-30 | Replace null入力 | E-03 (L40-43: ThrowArgumentNullException) | ○ |
| C-31 | Replace null置換文字列 | E-03 (L74-77: ThrowArgumentNullException) | ○ |
| C-32 | Replace置換回数制限 | E-03 (L53-61) | ○ |
| C-33 | Replace count=0 | E-03 (L170-173) | ○ |
| C-34 | Replace開始位置と回数制限 | E-03 (L68-84) | ○ |
| C-35 | Replace MatchEvaluator | E-03 (L107-115) | ○ |
| C-36 | Replace null evaluator | E-03 (L157-159: ThrowArgumentNullException) | ○ |

### Regexクラス - Splitメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | Split文字列分割 | E-04 (L31-38) | ○ |
| C-38 | Split分割なし | E-04 (L110-113) | ○ |
| C-39 | Split null入力 | E-04 (L33-36: ThrowArgumentNullException) | ○ |
| C-40 | Split分割回数制限 | E-04 (L45-53) | ○ |
| C-41 | Split count=1 | E-04 (L83-86) | ○ |

### Regexクラス - Countメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Countマッチカウント | E-05 (L14-30) | ○ |
| C-43 | Countマッチなし | E-05 (L14-30) | ○ |
| C-44 | Count null入力 | E-05 (L16-19: ThrowArgumentNullException) | ○ |
| C-45 | Count Span版 | E-05 (L37-38) | ○ |
| C-46 | Count Span版開始位置指定 | E-05 (L46-57) | ○ |

### Regexクラス - EnumerateMatchesメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | EnumerateMatches列挙 | E-06 (L79-80) | ○ |
| C-48 | EnumerateMatches開始位置指定 | E-06 (L94-95) | ○ |

### Regexクラス - Escape/Unescapeメソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | Escapeメタ文字エスケープ | E-01 (L274-282), E-17 (L151-210) | ○ |
| C-50 | Escapeエスケープ不要 | E-17 (L153-156) | ○ |
| C-51 | Escape null入力 | E-01 (L276-279: ThrowArgumentNullException) | ○ |
| C-52 | Unescapeアンエスケープ | E-01 (L287-295), E-17 (L213-254) | ○ |
| C-53 | Unescapeアンエスケープ不要 | E-17 (L215-218) | ○ |
| C-54 | Unescape null入力 | E-01 (L289-292: ThrowArgumentNullException) | ○ |

### Regexクラス - グループ関連メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | GetGroupNames | E-01 (L316-334) | ○ |
| C-56 | GetGroupNames無名グループ | E-01 (L320-326) | ○ |
| C-57 | GetGroupNumbers | E-01 (L339-364) | ○ |
| C-58 | GroupNameFromNumber | E-01 (L369-372), E-17 (L2097-2116) | ○ |
| C-59 | GroupNameFromNumber存在しない番号 | E-17 (L2101-2115) | ○ |
| C-60 | GroupNumberFromName | E-01 (L377-394) | ○ |
| C-61 | GroupNumberFromName存在しない名前 | E-01 (L387-388) | ○ |
| C-62 | GroupNumberFromName null名前 | E-01 (L379-382: ThrowArgumentNullException) | ○ |

### Regexクラス - プロパティ
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Optionsプロパティ | E-01 (L300) | ○ |
| C-64 | RightToLeftプロパティ true | E-01 (L305) | ○ |
| C-65 | RightToLeftプロパティ false | E-01 (L305) | ○ |
| C-66 | MatchTimeoutプロパティ | E-07 (L60) | ○ |
| C-67 | ToStringメソッド | E-01 (L310) | ○ |

### Matchクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Match.Empty | E-08 (L63) | ○ |
| C-69 | Match.Success true | E-09 (L28) | ○ |
| C-70 | Match.Success false | E-09 (L28) | ○ |
| C-71 | Match.Index | E-10 (L20) | ○ |
| C-72 | Match.Length | E-10 (L23) | ○ |
| C-73 | Match.Value | E-10 (L30) | ○ |
| C-74 | Match.Groups | E-08 (L91) | ○ |
| C-75 | Match.NextMatch成功 | E-08 (L98-105) | ○ |
| C-76 | Match.NextMatch終端 | E-08 (L98-105) | ○ |
| C-77 | Match.Result | E-08 (L112-126) | ○ |
| C-78 | Match.Result null置換 | E-08 (L114-117: ThrowArgumentNullException) | ○ |
| C-79 | Match.Result失敗マッチ | E-08 (L119) | ○ |
| C-80 | Match.Synchronized | E-08 (L147-165) | ○ |
| C-81 | Match.Synchronized null | E-08 (L149-152: ThrowArgumentNullException) | ○ |

### Groupクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | Group.Success true | E-09 (L28) | ○ |
| C-83 | Group.Success false | E-09 (L28) | ○ |
| C-84 | Group.Name | E-09 (L30) | ○ |
| C-85 | Group.Captures | E-09 (L37) | ○ |
| C-86 | Group.Value | E-10 (L30) 継承 | ○ |
| C-87 | Group.Index | E-10 (L20) 継承 | ○ |
| C-88 | Group.Length | E-10 (L23) 継承 | ○ |
| C-89 | Group.Synchronized | E-09 (L42-57) | ○ |
| C-90 | Group.Synchronized null | E-09 (L44-47: ThrowArgumentNullException) | ○ |

### Captureクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | Capture.Index | E-10 (L20) | ○ |
| C-92 | Capture.Length | E-10 (L23) | ○ |
| C-93 | Capture.Value | E-10 (L30) | ○ |
| C-94 | Capture.ValueSpan | E-10 (L34) | ○ |
| C-95 | Capture.ToString | E-10 (L37) | ○ |

### GroupCollectionクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | GroupCollection.Count | E-11 (L36) | ○ |
| C-97 | GroupCollection[int] | E-11 (L38) | ○ |
| C-98 | GroupCollection[int]範囲外 | E-11 (L63) | ○ |
| C-99 | GroupCollection[string] | E-11 (L40-42) | ○ |
| C-100 | GroupCollection[string]存在しない | E-11 (L41) | ○ |
| C-101 | GroupCollection.TryGetValue成功 | E-11 (L197-208) | ○ |
| C-102 | GroupCollection.TryGetValue失敗 | E-11 (L200-204) | ○ |
| C-103 | GroupCollection.ContainsKey成功 | E-11 (L210) | ○ |
| C-104 | GroupCollection.ContainsKey失敗 | E-11 (L210) | ○ |
| C-105 | GroupCollection.Keys | E-11 (L212-221) | ○ |
| C-106 | GroupCollection.Values | E-11 (L223-231) | ○ |
| C-107 | GroupCollection.GetEnumerator | E-11 (L45, L234-293) | ○ |
| C-108 | GroupCollection.CopyTo | E-11 (L107-126) | ○ |
| C-109 | GroupCollection.CopyTo null | E-11 (L109-112: ThrowArgumentNullException) | ○ |
| C-110 | GroupCollection.IsReadOnly | E-11 (L33) | ○ |

### CaptureCollectionクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | CaptureCollection.Count | E-12 (L31) | ○ |
| C-112 | CaptureCollection[int] | E-12 (L34) | ○ |
| C-113 | CaptureCollection[int]範囲外 | E-12 (L49-52: ThrowArgumentOutOfRangeException) | ○ |
| C-114 | CaptureCollection[int]負 | E-12 (L49-52: ThrowArgumentOutOfRangeException) | ○ |
| C-115 | CaptureCollection.GetEnumerator | E-12 (L37, L180-225) | ○ |
| C-116 | CaptureCollection.CopyTo | E-12 (L93-112) | ○ |
| C-117 | CaptureCollection.CopyTo null | E-12 (L95-98: ThrowArgumentNullException) | ○ |
| C-118 | CaptureCollection.IsReadOnly | E-12 (L28) | ○ |

### MatchCollectionクラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | MatchCollection.Count | E-13 (L45-53) | ○ |
| C-120 | MatchCollection[int] | E-13 (L57-68) | ○ |
| C-121 | MatchCollection[int]範囲外 | E-13 (L62-65: ThrowArgumentOutOfRangeException) | ○ |
| C-122 | MatchCollection[int]負 | E-13 (L62-65: ThrowArgumentOutOfRangeException) | ○ |
| C-123 | MatchCollection.GetEnumerator | E-13 (L71, L193-243) | ○ |
| C-124 | MatchCollection.CopyTo | E-13 (L125-129) | ○ |
| C-125 | MatchCollection.IsReadOnly | E-13 (L40) | ○ |

### ValueMatchとValueMatchEnumerator
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | ValueMatch.Index | E-14 (L32) | ○ |
| C-127 | ValueMatch.Length | E-14 (L37) | ○ |
| C-128 | ValueMatchEnumerator.MoveNext成功 | E-06 (L143-155) | ○ |
| C-129 | ValueMatchEnumerator.MoveNext失敗 | E-06 (L143-155) | ○ |
| C-130 | ValueMatchEnumerator.Current | E-06 (L161) | ○ |
| C-131 | ValueMatchEnumerator.GetEnumerator | E-06 (L135) | ○ |

### RegexMatchTimeoutException
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | RegexMatchTimeoutExceptionコンストラクタ | E-16 (L22-28) | ○ |
| C-133 | RegexMatchTimeoutException.Input | E-16 (L73) | ○ |
| C-134 | RegexMatchTimeoutException.Pattern | E-16 (L75) | ○ |
| C-135 | RegexMatchTimeoutException.MatchTimeout | E-16 (L77) | ○ |

### タイムアウトとオプション動作
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | タイムアウト動作 | E-18 (L357-365) | △ |
| C-137 | RightToLeftマッチ | E-01 (L305), E-02 (L145) | ○ |
| C-138 | IgnoreCaseマッチ | E-15 (L18), E-01 (L150) | ○ |
| C-139 | Multilineマッチ | E-15 (L21-24) | ○ |
| C-140 | Singlelineマッチ | E-15 (L38) | ○ |
| C-141 | ExplicitCaptureマッチ | E-15 (L29-31) | ○ |
| C-142 | NonBacktrackingマッチ | E-15 (L56-62), E-01 (L98-101) | ○ |
| C-143 | CultureInvariantマッチ | E-15 (L50), E-17 (L85-88) | △ |

### 静的メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | 静的IsMatch | E-02 (L13-14) | ○ |
| C-145 | 静的Match | E-02 (L120-121) | ○ |
| C-146 | 静的Matches | E-02 (L178-179) | ○ |
| C-147 | 静的Replace | E-03 (L19-20) | ○ |
| C-148 | 静的Split | E-04 (L15-16) | ○ |
| C-149 | 静的Count | E-05 (L65-66) | ○ |
| C-150 | 静的EnumerateMatches | E-06 (L26-27) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-136 タイムアウト動作**: タイムアウトの正確な動作タイミングは実行環境に依存し、テストでの検証が困難な場合がある
  - 候補：実行環境依存のため詳細なテスト設計が必要 / パフォーマンステストとして別途検証
- **C-143 CultureInvariantマッチ**: 文化依存の大文字小文字変換の詳細な挙動は文化設定に依存
  - 候補：トルコ語ロケールでの"I"と"i"の変換テスト / 各種ロケールでの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なプロパティアクセス、IsReadOnlyなどの単純な動作確認
- 1: 中リスク - コレクション操作、境界値チェック、オプション組み合わせ
- 2: 高リスク - タイムアウト動作（実行環境依存）、文化依存の動作（ロケール設定依存）

## 6) レビュアーチェックリスト（最小）
- [ ] コンストラクタのバリデーションテストケースが網羅されているか（null, 無効なオプション, 無効なタイムアウト）
- [ ] 各メソッドの正常系・異常系・境界値がカバーされているか
- [ ] コレクションクラス（GroupCollection, CaptureCollection, MatchCollection）の読み取り専用性がテストされているか
- [ ] 静的メソッドとインスタンスメソッドの両方がテストされているか
- [ ] RightToLeft, NonBacktracking, ECMAScript等の特殊オプションの動作がテストされているか
- [ ] タイムアウト例外のテストが実行環境に依存しない方法で設計されているか
