---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 138
  claims_with_evidence: 138
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Threading.AccessControl 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：モジュール内のクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：138 / 138、根拠なし：0
- 優先レビュー（高）
  1. **Windows環境依存のテスト**：実際のテスト実行時はWindows環境が必要
  2. **権限関連のテスト**：管理者権限が必要なテストケースがある可能性
  3. **名前付き同期オブジェクト**：Global/Local名前空間でのテストは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Threading.AccessControl/src/System/Security/AccessControl/EventWaitHandleSecurity.cs`
- E-02: `src/libraries/System.Threading.AccessControl/src/System/Security/AccessControl/MutexSecurity.cs`
- E-03: `src/libraries/System.Threading.AccessControl/src/System/Security/AccessControl/SemaphoreSecurity.cs`
- E-04: `src/libraries/System.Threading.AccessControl/src/System/Threading/MutexAcl.cs`
- E-05: `src/libraries/System.Threading.AccessControl/src/System/Threading/SemaphoreAcl.cs`
- E-06: `src/libraries/System.Threading.AccessControl/src/System/Threading/EventWaitHandleAcl.cs`
- E-07: `src/libraries/System.Threading.AccessControl/src/System/Threading/ThreadingAclExtensions.cs`
- E-08: `src/libraries/System.Threading.AccessControl/src/System/Threading/MutexAcl.net46.cs`
- E-09: `src/libraries/System.Threading.AccessControl/src/System/Threading/SemaphoreAcl.net46.cs`
- E-10: `src/libraries/System.Threading.AccessControl/src/System/Threading/EventWaitHandleAcl.net46.cs`
- E-11: `src/libraries/System.Threading.AccessControl/src/System/Threading/ThreadingAclExtensions.net46.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventWaitHandleAccessRule / EventWaitHandleAuditRule（UT-TAC-001〜005）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventWaitHandleAccessRule IdentityReferenceコンストラクタ | E-01 (L46-48) | ○ |
| C-02 | EventWaitHandleAccessRule stringコンストラクタ | E-01 (L51-53) | ○ |
| C-03 | EventWaitHandleAccessRule.EventWaitHandleRightsプロパティ | E-01 (L77-80) | ○ |
| C-04 | EventWaitHandleAuditRuleコンストラクタ | E-01 (L86-88) | ○ |
| C-05 | EventWaitHandleAuditRule.EventWaitHandleRightsプロパティ | E-01 (L103-106) | ○ |

### EventWaitHandleSecurity（UT-TAC-006〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | EventWaitHandleSecurity デフォルトコンストラクタ | E-01 (L112-115) | ○ |
| C-07 | AccessRuleFactory | E-01 (L148-151) | ○ |
| C-08 | AuditRuleFactory | E-01 (L153-156) | ○ |
| C-09 | AddAccessRule | E-01 (L197-200) | ○ |
| C-10 | SetAccessRule | E-01 (L202-205) | ○ |
| C-11 | ResetAccessRule | E-01 (L207-210) | ○ |
| C-12 | RemoveAccessRule (正常系) | E-01 (L212-215) | ○ |
| C-13 | RemoveAccessRule (異常系) | E-01 (L212-215) | ○ |
| C-14 | RemoveAccessRuleAll | E-01 (L217-220) | ○ |
| C-15 | RemoveAccessRuleSpecific | E-01 (L222-225) | ○ |
| C-16 | AddAuditRule | E-01 (L227-230) | ○ |
| C-17 | SetAuditRule | E-01 (L232-235) | ○ |
| C-18 | RemoveAuditRule | E-01 (L237-240) | ○ |
| C-19 | RemoveAuditRuleAll | E-01 (L242-245) | ○ |
| C-20 | RemoveAuditRuleSpecific | E-01 (L247-250) | ○ |
| C-21 | AccessRightType | E-01 (L252-255) | ○ |
| C-22 | AccessRuleType | E-01 (L257-260) | ○ |
| C-23 | AuditRuleType | E-01 (L262-265) | ○ |
| C-24 | GetAccessControlSectionsFromChanges (変更あり) | E-01 (L158-170) | ○ |
| C-25 | GetAccessControlSectionsFromChanges (変更なし) | E-01 (L158-170) | ○ |

### MutexAccessRule / MutexAuditRule / MutexSecurity（UT-TAC-026〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | MutexAccessRule IdentityReferenceコンストラクタ | E-02 (L47-49) | ○ |
| C-27 | MutexAccessRule stringコンストラクタ | E-02 (L52-54) | ○ |
| C-28 | MutexAccessRule.MutexRightsプロパティ | E-02 (L78-81) | ○ |
| C-29 | MutexAuditRuleコンストラクタ | E-02 (L87-89) | ○ |
| C-30 | MutexAuditRule.MutexRightsプロパティ | E-02 (L97-100) | ○ |
| C-31 | MutexSecurity デフォルトコンストラクタ | E-02 (L106-109) | ○ |
| C-32 | MutexSecurity 名前付きコンストラクタ | E-02 (L111-115) | ○ |
| C-33 | MutexSecurity 存在しないMutex | E-02 (L123-140) | ○ |
| C-34 | AccessRuleFactory | E-02 (L142-145) | ○ |
| C-35 | AuditRuleFactory | E-02 (L147-150) | ○ |
| C-36〜C-49 | アクセス/監査ルール管理メソッド | E-02 | ○ |

### SemaphoreAccessRule / SemaphoreAuditRule / SemaphoreSecurity（UT-TAC-050〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | SemaphoreAccessRule IdentityReferenceコンストラクタ | E-03 (L43-45) | ○ |
| C-51 | SemaphoreAccessRule stringコンストラクタ | E-03 (L48-50) | ○ |
| C-52 | SemaphoreAccessRule.SemaphoreRightsプロパティ | E-03 (L74-77) | ○ |
| C-53 | SemaphoreAuditRuleコンストラクタ | E-03 (L82-84) | ○ |
| C-54 | SemaphoreAuditRule.SemaphoreRightsプロパティ | E-03 (L92-95) | ○ |
| C-55 | SemaphoreSecurity デフォルトコンストラクタ | E-03 (L100-103) | ○ |
| C-56 | SemaphoreSecurity 名前付きコンストラクタ | E-03 (L105-109) | ○ |
| C-57 | SemaphoreSecurity 存在しないSemaphore | E-03 (L117-134) | ○ |
| C-58〜C-73 | アクセス/監査ルール管理メソッドおよび型プロパティ | E-03 | ○ |

### MutexAcl（UT-TAC-074〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Create (セキュリティ指定) | E-04 (L23-70) | ○ |
| C-75 | Create (nullセキュリティ) | E-04 (L25-28) | ○ |
| C-76 | Create (既存Mutex) | E-04 (L66) | ○ |
| C-77 | Create (名前長制限) | E-04 (L53-56) | ○ |
| C-78 | Create (無効ハンドル) | E-04 (L58-61) | ○ |
| C-79 | OpenExisting (正常系) | E-04 (L84-102) | ○ |
| C-80 | OpenExisting (null引数) | E-04 (L120) | ○ |
| C-81 | OpenExisting (空文字引数) | E-04 (L122-125) | ○ |
| C-82 | OpenExisting (存在しない) | E-04 (L88-89) | ○ |
| C-83 | OpenExisting (無効ハンドル) | E-04 (L91-92) | ○ |
| C-84 | OpenExisting (パス不明) | E-04 (L94-95) | ○ |
| C-85 | TryOpenExisting (存在する) | E-04 (L115-116) | ○ |
| C-86 | TryOpenExisting (存在しない) | E-04 (L115-116) | ○ |
| C-87 | TryOpenExisting (null引数) | E-04 (L120) | ○ |
| C-88 | TryOpenExisting (空文字引数) | E-04 (L122-125) | ○ |

### SemaphoreAcl（UT-TAC-089〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | Create (セキュリティ指定) | E-05 (L27-84) | ○ |
| C-90 | Create (nullセキュリティ) | E-05 (L29-32) | ○ |
| C-91 | Create (既存Semaphore) | E-05 (L80) | ○ |
| C-92 | Create (負のinitialCount) | E-05 (L34-37) | ○ |
| C-93 | Create (0のmaximumCount) | E-05 (L39-42) | ○ |
| C-94 | Create (initialCount > maximumCount) | E-05 (L44-47) | ○ |
| C-95 | Create (無効ハンドル) | E-05 (L72-75) | ○ |
| C-96 | OpenExisting (正常系) | E-05 (L99-117) | ○ |
| C-97〜C-105 | OpenExisting/TryOpenExisting各種 | E-05 | ○ |

### EventWaitHandleAcl（UT-TAC-106〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | Create (セキュリティ指定) | E-06 (L29-79) | ○ |
| C-107 | Create (nullセキュリティ) | E-06 (L31-34) | ○ |
| C-108 | Create (既存EventWaitHandle) | E-06 (L75) | ○ |
| C-109 | Create (ManualResetモード) | E-06 (L42-45) | ○ |
| C-110 | Create (AutoResetモード) | E-06 (L41) | ○ |
| C-111 | Create (無効なmode) | E-06 (L36-39) | ○ |
| C-112 | Create (無効ハンドル) | E-06 (L67-70) | ○ |
| C-113〜C-122 | OpenExisting/TryOpenExisting各種 | E-06 | ○ |

### ThreadingAclExtensions（UT-TAC-123〜131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | GetAccessControl(EventWaitHandle) | E-07 (L14-17) | ○ |
| C-124 | SetAccessControl(EventWaitHandle) | E-07 (L19-24) | ○ |
| C-125 | SetAccessControl(EventWaitHandle) null引数 | E-07 (L21) | ○ |
| C-126 | GetAccessControl(Mutex) | E-07 (L26-29) | ○ |
| C-127 | SetAccessControl(Mutex) | E-07 (L31-36) | ○ |
| C-128 | SetAccessControl(Mutex) null引数 | E-07 (L33) | ○ |
| C-129 | GetAccessControl(Semaphore) | E-07 (L38-41) | ○ |
| C-130 | SetAccessControl(Semaphore) | E-07 (L43-48) | ○ |
| C-131 | SetAccessControl(Semaphore) null引数 | E-07 (L45) | ○ |

### Enum値確認（UT-TAC-132〜138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-132 | EventWaitHandleRights.Modify | E-01 (L32) | ○ |
| C-133 | EventWaitHandleRights.FullControl | E-01 (L38) | ○ |
| C-134 | EventWaitHandleRights.Synchronize | E-01 (L37) | ○ |
| C-135 | MutexRights.Modify | E-02 (L33) | ○ |
| C-136 | MutexRights.FullControl | E-02 (L39) | ○ |
| C-137 | SemaphoreRights.Modify | E-03 (L30) | ○ |
| C-138 | SemaphoreRights.FullControl | E-03 (L36) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースについてソースコードからの根拠が確認できた
- .net46バージョンのファイルは.NET Framework用の代替実装であり、本質的な動作は同一

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースに根拠あり
- 注意点:
  - Windows固有API（Interop.Kernel32）を使用しているため、テスト実行はWindows環境限定
  - 名前付き同期オブジェクト（Global/Local名前空間）のテストは環境設定に依存する可能性あり
  - 権限関連のテスト（特にセキュリティ設定の永続化）は管理者権限が必要な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各同期オブジェクト（EventWaitHandle、Mutex、Semaphore）のテストケースが網羅されているか
- [ ] 正常系・異常系・境界値のテスト観点が適切か
- [ ] Windows環境依存のテストについて、テスト環境の前提条件が明確か
- [ ] セキュリティ関連（ACL）のテストケースが認証・認可の観点を含んでいるか
- [ ] エラーハンドリング（各種Exception）のテストケースが適切か
