---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 146
  claims_with_evidence: 146
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Threading.Channels 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・分岐条件を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：146 / 146、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースがソースコードに基づいて生成されており、根拠不足の項目はありません
  2. BoundedChannelFullModeの各モード（Wait/DropWrite/DropNewest/DropOldest）のテストは重要
  3. キャンセル処理・完了処理のテストは並行処理の正確性に直結

## 2) 参照した情報（Evidence一覧）
> 以下のソースファイルを解析して単体テストケースを生成しました。

- E-01: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/Channel.cs`
- E-02: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/Channel.netcoreapp.cs`
- E-03: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelReader.cs`
- E-04: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelWriter.cs`
- E-05: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/BoundedChannel.cs`
- E-06: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/UnboundedChannel.cs`
- E-07: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/SingleConsumerUnboundedChannel.cs`
- E-08: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/RendezvousChannel.cs`
- E-09: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/UnboundedPriorityChannel.cs`
- E-10: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelOptions.cs`
- E-11: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelOptions.netcoreapp.cs`
- E-12: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/BoundedChannelFullMode.cs`
- E-13: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelClosedException.cs`
- E-14: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/ChannelUtilities.cs`
- E-15: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/AsyncOperation.cs`
- E-16: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/Channel_1.cs`
- E-17: `src/libraries/System.Threading.Channels/src/System/Threading/Channels/Channel_2.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Channel ファクトリメソッド (UT-CHN-001 〜 UT-CHN-013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateUnbounded<T>()でUnboundedChannel作成 | E-01 L11-12 | ○ |
| C-02 | SingleReader=trueでSingleConsumerUnboundedChannel作成 | E-01 L23-25 | ○ |
| C-03 | SingleReader=falseでUnboundedChannel作成 | E-01 L28 | ○ |
| C-04 | nullオプションでArgumentNullException | E-01 L21 | ○ |
| C-05 | CreateBounded(int)で正の容量指定 | E-01 L40-43 | ○ |
| C-06 | capacity=0でRendezvousChannel作成 | E-01 L42 | ○ |
| C-07 | 負の容量でArgumentOutOfRangeException | E-01 L43 | ○ |
| C-08 | BoundedChannelOptions指定でBoundedChannel作成 | E-01 L50-51, L63-65 | ○ |
| C-09 | itemDroppedコールバック付きチャネル作成 | E-01 L59-65 | ○ |
| C-10 | nullオプションでArgumentNullException | E-01 L61 | ○ |
| C-11 | CreateUnboundedPrioritized<T>()でUnboundedPrioritizedChannel作成 | E-02 L17-18 | ○ |
| C-12 | カスタムComparerでチャネル作成 | E-02 L29-33 | ○ |
| C-13 | nullオプションでArgumentNullException | E-02 L31 | ○ |

### ChannelReader<T> (UT-CHN-014 〜 UT-CHN-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | CompletionデフォルトはneverCompletingTask | E-03 L21 | ○ |
| C-15 | CanCountデフォルトはfalse | E-03 L24 | ○ |
| C-16 | CanPeekデフォルトはfalse | E-03 L27 | ○ |
| C-17 | Countデフォルトは NotSupportedException | E-03 L31 | ○ |
| C-18 | TryPeekデフォルトはfalse | E-03 L41-45 | ○ |
| C-19 | ReadAsyncキャンセル済みトークン処理 | E-03 L60-63 | ○ |
| C-20 | ReadAsync同期高速パス | E-03 L67-70 | ○ |
| C-21 | ReadAsync非同期待機 | E-03 L77-93 | ○ |
| C-22 | ReadAsyncチャネル完了後ChannelClosedException | E-03 L85-86 | ○ |
| C-23 | ReadAllAsync列挙 | E-03 L103-112 | ○ |
| C-24 | ReadAllAsyncチャネル完了で終了 | E-03 L105 | ○ |

### ChannelWriter<T> (UT-CHN-025 〜 UT-CHN-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | TryCompleteデフォルトはfalse | E-04 L20 | ○ |
| C-26 | WriteAsyncキャンセル済みトークン処理 | E-04 L44 | ○ |
| C-27 | WriteAsync同期高速パス | E-04 L45 | ○ |
| C-28 | WriteAsync非同期待機 | E-04 L54-65 | ○ |
| C-29 | WriteAsyncチャネル完了後例外 | E-04 L64 | ○ |
| C-30 | Complete成功 | E-04 L70-76 | ○ |
| C-31 | Complete二重呼び出しでInvalidOperationException | E-04 L72-75 | ○ |

### BoundedChannel<T> (UT-CHN-032 〜 UT-CHN-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | TryRead成功 | E-05 L109-126 | ○ |
| C-33 | TryRead失敗 | E-05 L117-125 | ○ |
| C-34 | TryPeek成功 | E-05 L128-145 | ○ |
| C-35 | TryPeek失敗 | E-05 L142-144 | ○ |
| C-36 | ReadAsyncキャンセル処理 | E-05 L149-152 | ○ |
| C-37 | ReadAsync同期返却 | E-05 L160-162 | ○ |
| C-38 | ReadAsyncブロック | E-05 L173-186 | ○ |
| C-39 | ReadAsync完了後例外 | E-05 L167-169 | ○ |
| C-40 | WaitToReadAsync即座完了 | E-05 L203-206 | ○ |
| C-41 | WaitToReadAsync完了チャネルでfalse | E-05 L209-213 | ○ |
| C-42 | WaitToReadAsyncエラー完了で例外 | E-05 L211-212 | ○ |
| C-43 | TryWrite成功 | E-05 L404-410 | ○ |
| C-44 | TryWrite満杯Waitモードでfalse | E-05 L412-416 | ○ |
| C-45 | TryWrite満杯DropWriteモード | E-05 L418-425 | ○ |
| C-46 | TryWrite満杯DropNewestモード | E-05 L431 | ○ |
| C-47 | TryWrite満杯DropOldestモード | E-05 L433 | ○ |
| C-48 | TryWrite完了後false | E-05 L377-381 | ○ |
| C-49 | TryWrite直接転送 | E-05 L391-402 | ○ |
| C-50 | WriteAsyncキャンセル処理 | E-05 L517-519 | ○ |
| C-51 | WriteAsync同期完了 | E-05 L561-567 | ○ |
| C-52 | WriteAsyncブロック | E-05 L569-591 | ○ |
| C-53 | WriteAsync完了後例外 | E-05 L535-538 | ○ |
| C-54 | WaitToWriteAsync即座完了 | E-05 L487-492 | ○ |
| C-55 | WaitToWriteAsyncブロック | E-05 L495-511 | ○ |
| C-56 | WaitToWriteAsyncドロップモード | E-05 L490 | ○ |
| C-57 | WaitToWriteAsync完了チャネル | E-05 L480-485 | ○ |
| C-58 | TryComplete成功 | E-05 L305-361 | ○ |
| C-59 | TryCompleteエラー完了 | E-05 L326, L348 | ○ |
| C-60 | TryComplete二重完了防止 | E-05 L320-323 | ○ |
| C-61 | TryComplete遅延完了 | E-05 L327, L346-349 | ○ |
| C-62 | Count | E-05 L89-99 | ○ |
| C-63 | CanCount | E-05 L85 | ○ |
| C-64 | CanPeek | E-05 L87 | ○ |

### UnboundedChannel<T> (UT-CHN-065 〜 UT-CHN-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | TryRead成功 | E-06 L109-118 | ○ |
| C-66 | TryRead失敗 | E-06 L120-121 | ○ |
| C-67 | TryPeek成功 | E-06 L124-125 | ○ |
| C-68 | TryPeek失敗 | E-06 L124-125 | ○ |
| C-69 | ReadAsync同期返却 | E-06 L77-81 | ○ |
| C-70 | ReadAsyncブロック | E-06 L83-106 | ○ |
| C-71 | TryWrite成功 | E-06 L238-275 | ○ |
| C-72 | TryWrite完了後false | E-06 L248-251 | ○ |
| C-73 | TryWrite直接転送 | E-06 L253-268 | ○ |
| C-74 | WaitToWriteAsync未完了でtrue | E-06 L277-284 | ○ |
| C-75 | WaitToWriteAsync完了後false | E-06 L283-284 | ○ |
| C-76 | WriteAsync同期完了 | E-06 L287-290 | ○ |
| C-77 | WriteAsync完了後例外 | E-06 L290 | ○ |
| C-78 | TryComplete成功 | E-06 L188-236 | ○ |
| C-79 | Count | E-06 L66 | ○ |

### SingleConsumerUnboundedChannel<T> (UT-CHN-080 〜 UT-CHN-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | TryRead成功 | E-07 L123-135 | ○ |
| C-81 | TryRead失敗 | E-07 L134 | ○ |
| C-82 | ReadAsync前の操作キャンセル | E-07 L101-119 | ○ |
| C-83 | WaitToReadAsync前の操作キャンセル | E-07 L171-191 | ○ |
| C-84 | TryWrite成功 | E-07 L279-336 | ○ |
| C-85 | TryComplete成功 | E-07 L209-277 | ○ |

### RendezvousChannel<T> (UT-CHN-086 〜 UT-CHN-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | TryReadランデブー成功 | E-08 L81-107 | ○ |
| C-87 | TryReadランデブー失敗 | E-08 L105-106 | ○ |
| C-88 | TryPeek成功 | E-08 L109-128 | ○ |
| C-89 | TryWriteランデブー成功 | E-08 L303-324 | ○ |
| C-90 | TryWriteドロップモード | E-08 L326-331 | ○ |
| C-91 | TryWrite待機モード | E-08 L333 | ○ |
| C-92 | WriteAsync同期ランデブー | E-08 L417-419 | ○ |
| C-93 | WriteAsync非同期ランデブー | E-08 L397-414 | ○ |
| C-94 | Count常に0 | E-08 L79 | ○ |
| C-95 | WaitToWriteAsyncリーダーあり | E-08 L357-359 | ○ |
| C-96 | WaitToWriteAsyncドロップモード | E-08 L357 | ○ |
| C-97 | TryComplete成功 | E-08 L252-301 | ○ |

### UnboundedPrioritizedChannel<T> (UT-CHN-098 〜 UT-CHN-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | TryRead優先度読み取り | E-09 L110-125 | ○ |
| C-99 | TryPeek優先度ピーク | E-09 L127-134 | ○ |
| C-100 | TryWrite優先度書き込み | E-09 L244-281 | ○ |
| C-101 | カスタムComparer優先度 | E-09 L46 | ○ |

### ChannelOptions (UT-CHN-102 〜 UT-CHN-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | BoundedChannelOptionsコンストラクタ正常 | E-10 L53-61 | ○ |
| C-103 | BoundedChannelOptionsコンストラクタ異常 | E-10 L55-58 | ○ |
| C-104 | Capacity設定 | E-10 L65-76 | ○ |
| C-105 | Capacity負値エラー | E-10 L70-73 | ○ |
| C-106 | FullMode設定 | E-10 L80-97 | ○ |
| C-107 | FullMode無効値エラー | E-10 L93-94 | ○ |
| C-108 | SingleWriterデフォルト | E-10 L17 | ○ |
| C-109 | SingleReaderデフォルト | E-10 L27 | ○ |
| C-110 | AllowSynchronousContinuationsデフォルト | E-10 L39 | ○ |
| C-111 | Comparerデフォルト | E-11 L12 | ○ |
| C-112 | Comparer設定 | E-11 L12 | ○ |

### ChannelClosedException (UT-CHN-113 〜 UT-CHN-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | デフォルトコンストラクタ | E-13 L10-11 | ○ |
| C-114 | messageコンストラクタ | E-13 L15 | ○ |
| C-115 | nullメッセージ処理 | E-13 L15 | ○ |
| C-116 | innerExceptionコンストラクタ | E-13 L19-20 | ○ |
| C-117 | message+innerExceptionコンストラクタ | E-13 L25 | ○ |

### Channel<TWrite, TRead> (UT-CHN-118 〜 UT-CHN-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | Readerプロパティ | E-17 L15 | ○ |
| C-119 | Writerプロパティ | E-17 L18 | ○ |
| C-120 | ChannelReader暗黙変換 | E-17 L22 | ○ |
| C-121 | ChannelWriter暗黙変換 | E-17 L26 | ○ |

### ChannelUtilities (UT-CHN-122 〜 UT-CHN-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | Complete成功完了 | E-14 L47-50 | ○ |
| C-123 | Completeキャンセル完了 | E-14 L32-35 | ○ |
| C-124 | Completeエラー完了 | E-14 L36-45 | ○ |
| C-125 | CreateInvalidCompletionExceptionnull | E-14 L362 | ○ |
| C-126 | CreateInvalidCompletionExceptionキャンセル | E-14 L362 | ○ |
| C-127 | CreateInvalidCompletionExceptionラップ | E-14 L363-364 | ○ |

### AsyncOperation (UT-CHN-128 〜 UT-CHN-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | TrySetException | E-15 L147-157 | ○ |
| C-129 | TrySetCanceled成功 | E-15 L162-172 | ○ |
| C-130 | TrySetCanceled失敗 | E-15 L164 | ○ |
| C-131 | TryReserveCompletionIfCancelable非キャンセル | E-15 L181 | ○ |
| C-132 | TryReserveCompletionIfCancelable未予約 | E-15 L182-186 | ○ |
| C-133 | TryReserveCompletionIfCancelable予約済み | E-15 L183-186 | ○ |
| C-134 | TrySetResult | E-15 L534-543 | ○ |
| C-135 | TryOwnAndReset成功 | E-15 L516-529 | ○ |
| C-136 | TryOwnAndReset失敗 | E-15 L519 | ○ |
| C-137 | GetResult成功 | E-15 L489-512 | ○ |
| C-138 | GetResult未完了 | E-15 L497-499 | ○ |
| C-139 | GetResultトークン不正 | E-15 L491-494 | ○ |
| C-140 | GetStatusPending | E-15 L437 | ○ |
| C-141 | GetStatusSucceeded | E-15 L438 | ○ |
| C-142 | GetStatusCanceled | E-15 L439 | ○ |
| C-143 | GetStatusFaulted | E-15 L440 | ○ |
| C-144 | OnCompleted登録 | E-15 L292-389 | ○ |
| C-145 | OnCompleted即時実行 | E-15 L350-388 | ○ |
| C-146 | OnCompleted二重登録 | E-15 L303-306, L360-361 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに直接対応しており、実装との整合性が高い
- 並行処理に関するテストケース（キャンセル、完了、ブロック）は特に重要で、実行時の競合条件に注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BoundedChannelFullModeの各モード（Wait/DropWrite/DropNewest/DropOldest）のテストケースが網羅されているか確認
- [ ] キャンセルトークン処理のテストケースが全チャネル実装に存在するか確認
- [ ] 完了状態での読み書き操作のテストケースが適切にエラーを期待しているか確認
- [ ] SingleConsumerUnboundedChannelの単一コンシューマ制約テストが適切か確認
- [ ] RendezvousChannelのランデブー動作テストが書き込み/読み取り両方向で網羅されているか確認
- [ ] UnboundedPrioritizedChannelの優先度順序テストが適切か確認
- [ ] AsyncOperationのプール再利用テストが適切か確認
