---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 94
  claims_with_evidence: 94
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Threading.Overlapped 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・API定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：94 / 94、根拠なし：0
- 優先レビュー（高）
  1. なし - 全てのテストケースにソースコードまたは既存テストからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/ref/System.Threading.Overlapped.cs` - 公開API定義（参照アセンブリ）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/OverlappedTests.cs` - Overlappedクラスの既存テスト
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_BindHandleTests.cs` - BindHandleメソッドの既存テスト
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_AllocateNativeOverlappedTests.cs` - AllocateNativeOverlappedメソッドの既存テスト
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_PreAllocatedOverlappedTests.cs` - PreAllocatedOverlappedクラスの既存テスト
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_FreeNativeOverlappedTests.cs` - FreeNativeOverlappedメソッドの既存テスト
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_GetNativeOverlappedStateTests.cs` - GetNativeOverlappedStateメソッドの既存テスト
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_DisposeTests.cs` - Disposeメソッドの既存テスト
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_HandleTests.cs` - Handleプロパティの既存テスト
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_IntegrationTests.cs` - 統合テスト
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_IntegrationTests.netcoreapp.cs` - .NET Core固有統合テスト
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/ThreadPoolBoundHandle_Helpers.cs` - テストヘルパークラス
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/HandleFactory.cs` - ハンドル作成ユーティリティ
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/Win32Handle.cs` - Win32ハンドルラッパー
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/AsyncResult.cs` - IAsyncResult実装
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Overlapped/tests/DllImport.cs` - P/Invoke定義

## 3) Claims と根拠の対応（レビューの主戦場）

### Overlappedクラス（UT-OVL-001〜UT-OVL-020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsyncResultプロパティの取得と設定 | E-01, E-02 (PropertyTest1) | ○ |
| C-02 | AsyncResultがnullで初期化 | E-01, E-02 (PropertyTest1: Assert.Null) | ○ |
| C-03 | EventHandleプロパティの取得と設定（32bit） | E-01, E-02 (PropertyTest1, PropertyTest2) | ○ |
| C-04 | EventHandleが0で初期化 | E-02 (PropertyTest1: Assert.Equal(0)) | ○ |
| C-05 | EventHandleIntPtrプロパティの取得と設定 | E-01, E-02 (PropertyTest1) | ○ |
| C-06 | OffsetHighプロパティの取得と設定 | E-01, E-02 (PropertyTest1) | ○ |
| C-07 | OffsetHighに0を設定 | E-02 (PropertyTest1: obj.OffsetHigh = 0) | ○ |
| C-08 | OffsetLowプロパティの取得と設定 | E-01, E-02 (PropertyTest1) | ○ |
| C-09 | OffsetLowに0を設定 | E-02 (PropertyTest1: obj.OffsetLow = 0) | ○ |
| C-10 | デフォルトコンストラクタ | E-01, E-02 (PropertyTest1: new Overlapped()) | ○ |
| C-11 | パラメータ付きコンストラクタ（IntPtr版） | E-01, E-02 (PropertyTest3) | ○ |
| C-12 | パラメータ付きコンストラクタ（int版） | E-01, E-02 (PropertyTest2) | ○ |
| C-13 | Packメソッドの正常動作 | E-01, E-02 (PackNegTest, PackPosTest1) | ○ |
| C-14 | 二重PackでInvalidOperationException | E-02 (PackNegTest: Assert.Throws<InvalidOperationException>) | ○ |
| C-15 | Pack(IOCompletionCallback)の動作 | E-01, E-02 (PackNegTest1, PackPosTest) | ○ |
| C-16 | Pack(IOCompletionCallback)の二重呼び出し | E-02 (PackNegTest1) | ○ |
| C-17 | Unpackの正常動作 | E-01, E-02 (UnPackTest) | ○ |
| C-18 | UnpackにnullでArgumentNullException | E-02 (UnPackTest: Assert.Throws<ArgumentNullException>) | ○ |
| C-19 | Freeの正常動作 | E-01, E-02 (全テストでOverlapped.Free使用) | ○ |
| C-20 | UnsafePackの正常動作 | E-01 (API定義) | ○ |

### ThreadPoolBoundHandle.BindHandle（UT-OVL-021〜UT-OVL-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | nullハンドルでArgumentNullException | E-03 (BindHandle_NullAsHandle_ThrowsArgumentNullException) | ○ |
| C-22 | IntPtr.ZeroでArgumentException | E-03 (BindHandle_ZeroAsHandle_ThrowsArgumentException) | ○ |
| C-23 | IntPtr(-1)でArgumentException | E-03 (BindHandle_MinusOneAsHandle_ThrowsArgumentException) | ○ |
| C-24 | UnixでPlatformNotSupportedException | E-03 (BindHandle_ValidHandle_ThrowsPlatformNotSupportedException) | ○ |
| C-25 | 同期ハンドルでArgumentException | E-03 (BindHandle_SyncHandleAsHandle_ThrowsArgumentException) | ○ |
| C-26 | クローズ済み同期ハンドルでArgumentException | E-03 (BindHandle_ClosedSyncHandleAsHandle_ThrowsArgumentException) | ○ |
| C-27 | クローズ済み非同期ハンドルでArgumentException | E-03 (BindHandle_ClosedAsyncHandleAsHandle_ThrowsArgumentException) | ○ |
| C-28 | Dispose済み同期ハンドルでArgumentException | E-03 (BindHandle_DisposedSyncHandleAsHandle_ThrowsArgumentException) | ○ |
| C-29 | Dispose済み非同期ハンドルでArgumentException | E-03 (BindHandle_DisposedAsyncHandleAsHandle_ThrowsArgumentException) | ○ |
| C-30 | 既にバインド済みハンドルでArgumentException | E-03 (BindHandle_AlreadyBoundHandleAsHandle_ThrowsArgumentException) | ○ |

### ThreadPoolBoundHandle.Handle（UT-OVL-031〜UT-OVL-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Handleプロパティがバインドしたハンドルを返却 | E-09 (Handle_ReturnsHandle) | ○ |
| C-32 | Dispose後もHandleプロパティがアクセス可能 | E-09 (Handle_AfterDisposed_DoesNotThrow) | ○ |

### ThreadPoolBoundHandle.AllocateNativeOverlapped（UT-OVL-033〜UT-OVL-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | callbackがnullでArgumentNullException | E-04 (AllocateNativeOverlapped_NullAsCallback_ThrowsArgumentNullException) | ○ |
| C-34 | stateがnullでも正常動作 | E-04 (AllocateNativeOverlapped_NullAsContext_DoesNotThrow) | ○ |
| C-35 | pinDataがnullでも正常動作 | E-04 (AllocateNativeOverlapped_NullAsPinData_DoesNotThrow) | ○ |
| C-36 | pinDataが空配列でも正常動作 | E-04 (AllocateNativeOverlapped_EmptyArrayAsPinData_DoesNotThrow) | ○ |
| C-37 | 非Blittable型でArgumentException | E-04 (AllocateNativeOverlapped_NonBlittableTypeAsPinData_Throws) | ○ |
| C-38 | Blittable型で正常動作 | E-04 (AllocateNativeOverlapped_BlittableTypeAsPinData_DoesNotThrow) | ○ |
| C-39 | オブジェクト配列で正常動作 | E-04 (AllocateNativeOverlapped_ObjectArrayAsPinData_DoesNotThrow) | ○ |
| C-40 | 配列内非Blittable型でArgumentException | E-04 (AllocateNativeOverlapped_ObjectArrayWithNonBlittableTypeAsPinData_Throws) | ○ |
| C-41 | 返却NativeOverlappedの全フィールドがゼロ | E-04 (AllocateNativeOverlapped_ReturnedNativeOverlapped_AllFieldsZero) | ○ |
| C-42 | 再利用時のフィールドリセット | E-04 (AllocateNativeOverlapped_PossibleReusedReturnedNativeOverlapped_OffsetLowAndOffsetHighSetToZero) | ○ |
| C-43 | Dispose済みでObjectDisposedException | E-04 (AllocateNativeOverlapped_WhenDisposed_ThrowsObjectDisposedException) | ○ |
| C-44 | PreAllocatedがnullでArgumentNullException | E-04 (AllocateNativeOverlapped_PreAllocated_ThrowsArgumentNullException) | ○ |
| C-45 | PreAllocated版の全フィールドがゼロ | E-04 (AllocateNativeOverlapped_PreAllocated_ReturnedNativeOverlapped_AllFieldsZero) | ○ |
| C-46 | PreAllocated再利用時のリセット | E-04 (AllocateNativeOverlapped_PreAllocated_ReusedReturnedNativeOverlapped_OffsetLowAndOffsetHighSetToZero) | ○ |
| C-47 | Dispose済みPreAllocatedでObjectDisposedException | E-04 (AllocateNativeOverlapped_PreAllocated_WhenDisposed_ThrowsObjectDisposedException) | ○ |
| C-48 | Dispose済みハンドルでObjectDisposedException | E-04 (AllocateNativeOverlapped_PreAllocated_WhenHandleDisposed_ThrowsObjectDisposedException) | ○ |
| C-49 | 既に割り当て済みでArgumentException | E-04 (AllocateNativeOverlapped_PreAllocated_WhenAlreadyAllocated_ThrowsArgumentException) | ○ |
| C-50 | Unsafe版callbackがnullでArgumentNullException | E-04 (AllocateNativeOverlapped_NullAsCallback_ThrowsArgumentNullException) | ○ |
| C-51 | Unsafe版stateがnullでも正常動作 | E-04 (AllocateNativeOverlapped_NullAsContext_DoesNotThrow) | ○ |
| C-52 | Unsafe版pinDataがnullでも正常動作 | E-04 (AllocateNativeOverlapped_NullAsPinData_DoesNotThrow) | ○ |
| C-53 | Unsafe版返却NativeOverlappedの全フィールドがゼロ | E-04 (AllocateNativeOverlapped_ReturnedNativeOverlapped_AllFieldsZero) | ○ |
| C-54 | Unsafe版Dispose済みでObjectDisposedException | E-04 (AllocateNativeOverlapped_WhenDisposed_ThrowsObjectDisposedException) | ○ |

### ThreadPoolBoundHandle.FreeNativeOverlapped（UT-OVL-055〜UT-OVL-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | nullポインタでArgumentNullException | E-06 (FreeNativeOverlapped_NullAsNativeOverlapped_ThrowsArgumentNullException) | ○ |
| C-56 | Dispose後も解放が正常動作 | E-06 (FreeNativeOverlapped_WhenDisposed_DoesNotThrow) | ○ |
| C-57 | 異なるハンドルでArgumentException | E-06 (FreeNativeOverlapped_WithWrongHandle_ThrowsArgumentException) | ○ |

### ThreadPoolBoundHandle.GetNativeOverlappedState（UT-OVL-058〜UT-OVL-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | nullポインタでArgumentNullException | E-07 (GetNativeOverlappedState_NullAsNativeOverlapped_ThrowsArgumentNullException) | ○ |
| C-59 | stateがnullの場合nullが返却 | E-07 (GetNativeOverlappedState_WhenUnderlyingStateIsNull_ReturnsNull) | ○ |
| C-60 | stateがobjectの場合そのオブジェクトが返却 | E-07 (GetNativeOverlappedState_WhenUnderlyingStateIsObject_ReturnsObject) | ○ |
| C-61 | stateがIAsyncResultの場合そのオブジェクトが返却 | E-07 (GetNativeOverlappedState_WhenUnderlyingStateIsIAsyncResult_ReturnsIAsyncResult) | ○ |

### ThreadPoolBoundHandle.Dispose（UT-OVL-062〜UT-OVL-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 複数回Disposeで例外なし | E-08 (Dispose_CalledMultipleTimes_DoesNotThrow) | ○ |
| C-63 | Disposeでハンドルがクローズされない | E-08 (Dispose_DoesNotDisposeHandle) | ○ |
| C-64 | 未解放overlappedでDispose可能 | E-08 (Dispose_WithoutFreeingNativeOverlapped_DoesNotThrow) | ○ |

### PreAllocatedOverlapped（UT-OVL-065〜UT-OVL-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | コンストラクタcallbackがnullでArgumentNullException | E-05 (PreAllocatedOverlapped_NullAsCallback_ThrowsArgumentNullException) | ○ |
| C-66 | コンストラクタstateがnullでも正常動作 | E-05 (PreAllocatedOverlapped_NullAsContext_DoesNotThrow) | ○ |
| C-67 | コンストラクタpinDataがnullでも正常動作 | E-05 (PreAllocatedOverlapped_NullAsPinData_DoesNotThrow) | ○ |
| C-68 | コンストラクタpinDataが空配列でも正常動作 | E-05 (PreAllocatedOverlapped_EmptyArrayAsPinData_DoesNotThrow) | ○ |
| C-69 | コンストラクタ非Blittable型でArgumentException | E-05 (PreAllocatedOverlapped_NonBlittableTypeAsPinData_Throws) | ○ |
| C-70 | コンストラクタBlittable型で正常動作 | E-05 (PreAllocatedOverlapped_BlittableTypeAsPinData_DoesNotThrow) | ○ |
| C-71 | コンストラクタオブジェクト配列で正常動作 | E-05 (PreAllocatedOverlapped_ObjectArrayAsPinData_DoesNotThrow) | ○ |
| C-72 | コンストラクタ配列内非Blittable型でArgumentException | E-05 (PreAllocatedOverlapped_ObjectArrayWithNonBlittableTypeAsPinData_Throws) | ○ |
| C-73 | UnsafeCreate callbackがnullでArgumentNullException | E-05 (PreAllocatedOverlapped_NullAsCallback_ThrowsArgumentNullException) | ○ |
| C-74 | UnsafeCreate stateがnullでも正常動作 | E-05 (PreAllocatedOverlapped_NullAsContext_DoesNotThrow) | ○ |
| C-75 | UnsafeCreate pinDataがnullでも正常動作 | E-05 (PreAllocatedOverlapped_NullAsPinData_DoesNotThrow) | ○ |
| C-76 | UnsafeCreate非Blittable型でArgumentException | E-05 (PreAllocatedOverlapped_NonBlittableTypeAsPinData_Throws) | ○ |
| C-77 | UnsafeCreate Blittable型で正常動作 | E-05 (PreAllocatedOverlapped_BlittableTypeAsPinData_DoesNotThrow) | ○ |
| C-78 | Disposeの正常完了 | E-01 (API定義) | ○ |

### NativeOverlapped構造体（UT-OVL-079〜UT-OVL-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | EventHandleフィールドの読み書き | E-01 (構造体定義), E-04 (Assert.Equal(IntPtr.Zero, overlapped->EventHandle)) | ○ |
| C-80 | InternalHighフィールドの読み書き | E-01 (構造体定義), E-04 (Assert.Equal(IntPtr.Zero, overlapped->InternalHigh)) | ○ |
| C-81 | InternalLowフィールドの読み書き | E-01 (構造体定義), E-04 (Assert.Equal(IntPtr.Zero, overlapped->InternalLow)) | ○ |
| C-82 | OffsetHighフィールドの読み書き | E-01 (構造体定義), E-04 (overlapped->OffsetHigh = 1) | ○ |
| C-83 | OffsetLowフィールドの読み書き | E-01 (構造体定義), E-04 (overlapped->OffsetLow = 1) | ○ |

### IOCompletionCallback・ThreadPool（UT-OVL-084〜UT-OVL-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | IOCompletionCallbackデリゲートの呼び出し | E-01 (デリゲート定義), E-10 (OnOverlappedOperationCompleted) | ○ |
| C-85 | UnsafeQueueNativeOverlappedの正常動作 | E-02 (PackPosTest, PackPosTest1) | ○ |
| C-86 | UnsafeQueueNativeOverlappedにnullでArgumentNullException | E-02 (UnsafeQueueNativeOverlappedNegTest) | ○ |

### 統合テスト（UT-OVL-087〜UT-OVL-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | 単一ハンドル単一操作 | E-10 (SingleOperationOverSingleHandle) | ○ |
| C-88 | 単一ハンドル複数操作 | E-10 (MultipleOperationsOverSingleHandle) | ○ |
| C-89 | 複数ハンドル複数操作 | E-10 (MultipleOperationsOverMultipleHandles) | ○ |
| C-90 | AsyncLocal伝播（フロー有り） | E-10 (FlowsAsyncLocalsToCallback shouldFlow=true) | ○ |
| C-91 | AsyncLocal伝播（フロー無し） | E-10 (FlowsAsyncLocalsToCallback shouldFlow=false) | ○ |
| C-92 | PreAllocated AsyncLocal伝播（フロー有り） | E-10 (FlowsAsyncLocalsToCallback_PreAllocatedOverlapped shouldFlow=true) | ○ |
| C-93 | PreAllocated AsyncLocal伝播（フロー無し） | E-10 (FlowsAsyncLocalsToCallback_PreAllocatedOverlapped shouldFlow=false) | ○ |
| C-94 | CompletedWorkItemCount増加 | E-11 (MultipleOperationsOverSingleHandle_CompletedWorkItemCountTest) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースは既存のテストコードまたはAPI定義に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 既存テストコードに完全に対応したテストケース一覧であり、信頼性は高い

## 6) レビュアーチェックリスト（最小）
- [x] 全てのテストケースに対応する既存テストまたはAPI定義が存在することを確認
- [x] テストID（UT-OVL-XXX）の連番が正しいことを確認
- [x] プラットフォーム固有のテスト（Windows限定など）が適切にマークされていることを確認
- [ ] 実際のテスト実装時に、Windows環境でのみ実行されるテストが正しく条件付けされていることを確認
- [ ] Obsolete APIのテストが警告抑制付きで実装されていることを確認
- [ ] unsafeコードを使用するテストが適切なコンテキストで実行されることを確認
