---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 130
  claims_with_evidence: 130
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Threading.RateLimiting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：130 / 130、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースにソースコードの根拠あり
  2. 特に確認が必要な項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/RateLimiter.cs`
- E-02: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/PartitionedRateLimiter.T.cs`
- E-03: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/TokenBucketRateLimiter.cs`
- E-04: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/FixedWindowRateLimiter.cs`
- E-05: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/SlidingWindowRateLimiter.cs`
- E-06: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/ConcurrencyLimiter.cs`
- E-07: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/RateLimitLease.cs`
- E-08: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/ReplenishingRateLimiter.cs`
- E-09: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/ChainedRateLimiter.cs`
- E-10: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/PartitionedRateLimiter.cs`
- E-11: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/ChainedPartitionedRateLimiter.cs`
- E-12: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/DefaultPartitionedRateLimiter.cs`
- E-13: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/RateLimitPartition.cs`
- E-14: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/RateLimitPartition.T.cs`
- E-15: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/CombinedRateLimitLease.cs`
- E-16: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/TranslatingLimiter.cs`
- E-17: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/NoopLimiter.cs`
- E-18: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/MetadataName.cs`
- E-19: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/MetadataName.T.cs`
- E-20: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/RateLimiterStatistics.cs`
- E-21: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/QueueProcessingOrder.cs`
- E-22: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/TokenBucketRateLimiterOptions.cs`
- E-23: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/FixedWindowRateLimiterOptions.cs`
- E-24: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/SlidingWindowRateLimiterOptions.cs`
- E-25: `src/libraries/System.Threading.RateLimiting/src/System/Threading/RateLimiting/ConcurrencyLimiterOptions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### RateLimiter基底クラス（UT-TRL-001 〜 UT-TRL-011）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateChainedで複数リミッターをチェーン | E-01 (L33-43) | ○ |
| C-02 | CreateChainedでnull入力時に例外 | E-01 (L35) | ○ |
| C-03 | CreateChainedで空配列入力時に例外 | E-01 (L37-40) | ○ |
| C-04 | AttemptAcquireでpermitCount=0の状態確認 | E-01 (L69-77) | ○ |
| C-05 | AttemptAcquireでパーミット取得 | E-01 (L69-77) | ○ |
| C-06 | AttemptAcquireで負の値に例外 | E-01 (L71-74) | ○ |
| C-07 | AcquireAsyncで非同期取得 | E-01 (L96-109) | ○ |
| C-08 | AcquireAsyncで負の値に例外 | E-01 (L98-101) | ○ |
| C-09 | AcquireAsyncでキャンセル済みトークン処理 | E-01 (L103-106) | ○ |
| C-10 | Disposeでリソース解放 | E-01 (L128-133) | ○ |
| C-11 | DisposeAsyncで非同期リソース解放 | E-01 (L147-157) | ○ |

### TokenBucketRateLimiter（UT-TRL-012 〜 UT-TRL-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | 有効なオプションでインスタンス作成 | E-03 (L49-88) | ○ |
| C-13 | nullオプションで例外 | E-03 (L51) | ○ |
| C-14 | TokenLimit<=0で例外 | E-03 (L52-55) | ○ |
| C-15 | TokensPerPeriod<=0で例外 | E-03 (L56-59) | ○ |
| C-16 | QueueLimit<0で例外 | E-03 (L60-63) | ○ |
| C-17 | ReplenishmentPeriod<=0で例外 | E-03 (L64-67) | ○ |
| C-18 | GetStatisticsで統計取得 | E-03 (L91-101) | ○ |
| C-19 | Dispose後GetStatisticsで例外 | E-03 (L425-431) | ○ |
| C-20 | AttemptAcquireCoreでトークン取得成功 | E-03 (L104-135) | ○ |
| C-21 | AttemptAcquireCoreでトークン不足時失敗 | E-03 (L104-135) | ○ |
| C-22 | TokenLimit超過でArgumentOutOfRangeException | E-03 (L107-110) | ○ |
| C-23 | AcquireAsyncCoreで非同期取得 | E-03 (L138-212) | ○ |
| C-24 | AcquireAsyncCoreでキュー追加 | E-03 (L163-210) | ○ |
| C-25 | NewestFirstで古いリクエスト削除 | E-03 (L166-196) | ○ |
| C-26 | OldestFirstでキュー満杯時失敗 | E-03 (L197-202) | ○ |
| C-27 | TryReplenishでAutoReplenishment=false時true | E-03 (L264-272) | ○ |
| C-28 | TryReplenishでAutoReplenishment=true時false | E-03 (L266-269) | ○ |
| C-29 | IdleDurationでアイドル時間取得 | E-03 (L37) | ○ |
| C-30 | IdleDurationで使用中はnull | E-03 (L244, L383-385) | ○ |

### FixedWindowRateLimiter（UT-TRL-031 〜 UT-TRL-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | 有効なオプションでインスタンス作成 | E-04 (L47-80) | ○ |
| C-32 | nullオプションで例外 | E-04 (L49) | ○ |
| C-33 | PermitLimit<=0で例外 | E-04 (L50-53) | ○ |
| C-34 | QueueLimit<0で例外 | E-04 (L54-57) | ○ |
| C-35 | Window<=0で例外 | E-04 (L58-61) | ○ |
| C-36 | GetStatisticsで統計取得 | E-04 (L83-93) | ○ |
| C-37 | AttemptAcquireCoreでパーミット取得成功 | E-04 (L96-130) | ○ |
| C-38 | AttemptAcquireCoreでパーミット不足時失敗 | E-04 (L96-130) | ○ |
| C-39 | PermitLimit超過でArgumentOutOfRangeException | E-04 (L100-103) | ○ |
| C-40 | TryReplenishでウィンドウリセット | E-04 (L257-265) | ○ |

### SlidingWindowRateLimiter（UT-TRL-041 〜 UT-TRL-050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 有効なオプションでインスタンス作成 | E-05 (L51-94) | ○ |
| C-42 | nullオプションで例外 | E-05 (L53) | ○ |
| C-43 | PermitLimit<=0で例外 | E-05 (L54-57) | ○ |
| C-44 | SegmentsPerWindow<=0で例外 | E-05 (L58-61) | ○ |
| C-45 | QueueLimit<0で例外 | E-05 (L62-65) | ○ |
| C-46 | Window<=0で例外 | E-05 (L66-69) | ○ |
| C-47 | GetStatisticsで統計取得 | E-05 (L97-107) | ○ |
| C-48 | AttemptAcquireCoreでパーミット取得成功 | E-05 (L110-142) | ○ |
| C-49 | TryReplenishでセグメントスライド | E-05 (L261-271) | ○ |
| C-50 | ReplenishmentPeriodがWindow/SegmentsPerWindow | E-05 (L82) | ○ |

### ConcurrencyLimiter（UT-TRL-051 〜 UT-TRL-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | 有効なオプションでインスタンス作成 | E-06 (L40-60) | ○ |
| C-52 | nullオプションで例外 | E-06 (L42) | ○ |
| C-53 | PermitLimit<=0で例外 | E-06 (L43-46) | ○ |
| C-54 | QueueLimit<0で例外 | E-06 (L47-50) | ○ |
| C-55 | GetStatisticsで統計取得 | E-06 (L63-73) | ○ |
| C-56 | AttemptAcquireCoreでパーミット取得成功 | E-06 (L76-112) | ○ |
| C-57 | AttemptAcquireCoreでパーミット不足時失敗 | E-06 (L76-112) | ○ |
| C-58 | リースDisposeでパーミット解放 | E-06 (L229-317, L397-407) | ○ |
| C-59 | リース解放後キュー処理 | E-06 (L246-309) | ○ |
| C-60 | IdleDurationでアイドル時間取得 | E-06 (L35) | ○ |

### PartitionedRateLimiter（UT-TRL-061 〜 UT-TRL-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | AttemptAcquireでパーミット取得 | E-02 (L30-38) | ○ |
| C-62 | AttemptAcquireで負の値に例外 | E-02 (L32-35) | ○ |
| C-63 | AcquireAsyncで非同期取得 | E-02 (L59-72) | ○ |
| C-64 | AcquireAsyncでキャンセル処理 | E-02 (L66-69) | ○ |
| C-65 | WithTranslatedKeyでキー変換 | E-02 (L135-138) | ○ |
| C-66 | Createでリミッター作成 | E-10 (L26-31) | ○ |
| C-67 | CreateChainedでチェーン作成 | E-10 (L54-63) | ○ |
| C-68 | CreateChainedでnull入力時に例外 | E-10 (L57) | ○ |
| C-69 | CreateChainedで空配列入力時に例外 | E-10 (L58-61) | ○ |

### RateLimitLease（UT-TRL-070 〜 UT-TRL-074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | TryGetMetadata<T>でメタデータ取得 | E-07 (L35-52) | ○ |
| C-71 | TryGetMetadata<T>でメタデータなし時false | E-07 (L50-51) | ○ |
| C-72 | MetadataName.Nameがnull時false | E-07 (L37-41) | ○ |
| C-73 | GetAllMetadataで全メタデータ列挙 | E-07 (L63-72) | ○ |
| C-74 | Disposeでリソース解放 | E-07 (L77-81) | ○ |

### MetadataName<T>（UT-TRL-075 〜 UT-TRL-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | 有効な名前でインスタンス作成 | E-19 (L20-23) | ○ |
| C-76 | null名前で例外 | E-19 (L22) | ○ |
| C-77 | 同じ名前で等しいと判定 | E-19 (L49-57) | ○ |
| C-78 | 異なる名前で等しくないと判定 | E-19 (L49-57) | ○ |
| C-79 | 同じ名前で同じハッシュコード | E-19 (L37-40) | ○ |

### RateLimitPartition（UT-TRL-080 〜 UT-TRL-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | RateLimitPartition<TKey>コンストラクタ | E-14 (L17-21) | ○ |
| C-81 | Getでパーティション作成 | E-13 (L21-26) | ○ |
| C-82 | GetConcurrencyLimiterでパーティション作成 | E-13 (L35-40) | ○ |
| C-83 | GetNoLimiterでパーティション作成 | E-13 (L49-52) | ○ |
| C-84 | GetTokenBucketLimiterでパーティション作成 | E-13 (L64-86) | ○ |
| C-85 | AutoReplenishment=trueをfalseに変更 | E-13 (L72-84) | ○ |
| C-86 | GetSlidingWindowLimiterでパーティション作成 | E-13 (L98-120) | ○ |
| C-87 | GetFixedWindowLimiterでパーティション作成 | E-13 (L132-153) | ○ |

### ChainedRateLimiter（UT-TRL-088 〜 UT-TRL-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | GetStatisticsで最小CurrentAvailablePermits | E-09 (L24-55) | ○ |
| C-89 | GetStatisticsでCurrentQueuedCount合計 | E-09 (L24-55) | ○ |
| C-90 | IdleDurationで最小値 | E-09 (L57-78) | ○ |
| C-91 | AttemptAcquireCoreでCombinedLease返却 | E-09 (L80-109) | ○ |
| C-92 | AttemptAcquireCoreで失敗時ロールバック | E-09 (L155-181) | ○ |
| C-93 | AttemptAcquireCoreで例外時ロールバック | E-09 (L155-170) | ○ |

### CombinedRateLimitLease（UT-TRL-094 〜 UT-TRL-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | IsAcquiredで常にtrue | E-15 (L19) | ○ |
| C-95 | MetadataNamesで統合 | E-15 (L21-44) | ○ |
| C-96 | TryGetMetadataで最初のメタデータ | E-15 (L46-64) | ○ |
| C-97 | Disposeで逆順解放 | E-15 (L66-96) | ○ |
| C-98 | Disposeで例外時も全解放 | E-15 (L73-95) | ○ |

### TranslatingLimiter（UT-TRL-099 〜 UT-TRL-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | GetStatisticsでキー変換 | E-16 (L23-28) | ○ |
| C-100 | AttemptAcquireCoreでキー変換 | E-16 (L30-35) | ○ |
| C-101 | leaveOpen=falseで内部リミッターDispose | E-16 (L44-53) | ○ |
| C-102 | leaveOpen=trueで内部リミッターDispose不要 | E-16 (L44-53) | ○ |

### NoopLimiter（UT-TRL-103 〜 UT-TRL-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | AttemptAcquireCoreで常にtrue | E-17 (L30-34) | ○ |
| C-104 | AcquireAsyncCoreで常にtrue | E-17 (L36-40) | ○ |
| C-105 | GetStatisticsでlong.MaxValue | E-17 (L19-28) | ○ |
| C-106 | IdleDurationで常にnull | E-17 (L17) | ○ |

### DefaultPartitionedRateLimiter（UT-TRL-107 〜 UT-TRL-113）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | GetRateLimiterでリミッター取得 | E-12 (L87-104) | ○ |
| C-108 | GetRateLimiterで新規作成 | E-12 (L94-101) | ○ |
| C-109 | GetRateLimiterでキャッシュ利用 | E-12 (L94) | ○ |
| C-110 | Heartbeatでアイドルリミッター削除 | E-12 (L228-266) | ○ |
| C-111 | HeartbeatでTryReplenish呼び出し | E-12 (L254-265) | ○ |
| C-112 | Disposeで全リミッターDispose | E-12 (L106-147) | ○ |
| C-113 | Disposeでタイマー停止 | E-12 (L185-197) | ○ |

### オプションクラス・列挙型（UT-TRL-114 〜 UT-TRL-124）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | RateLimiterStatisticsプロパティ初期化 | E-20 (L9-35) | ○ |
| C-115 | QueueProcessingOrder列挙値 | E-21 (L9-19) | ○ |
| C-116 | TokenBucketRateLimiterOptionsデフォルト値 | E-22 (L9-51) | ○ |
| C-117 | FixedWindowRateLimiterOptionsデフォルト値 | E-23 (L9-45) | ○ |
| C-118 | SlidingWindowRateLimiterOptionsデフォルト値 | E-24 (L9-51) | ○ |
| C-119 | ConcurrencyLimiterOptionsデフォルト値 | E-25 (L9-30) | ○ |
| C-120 | ReplenishingRateLimiter.ReplenishmentPeriod | E-08 (L14-15) | ○ |
| C-121 | ReplenishingRateLimiter.IsAutoReplenishing | E-08 (L20-21) | ○ |
| C-122 | MetadataName.RetryAfter | E-18 (L15) | ○ |
| C-123 | MetadataName.ReasonPhrase | E-18 (L20) | ○ |
| C-124 | MetadataName.Create | E-18 (L28) | ○ |

### キャンセル処理（UT-TRL-125 〜 UT-TRL-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | TokenBucketRateLimiterキャンセル処理 | E-03 (L493-510) | ○ |
| C-126 | FixedWindowRateLimiterキャンセル処理 | E-04 (L479-496) | ○ |
| C-127 | SlidingWindowRateLimiterキャンセル処理 | E-05 (L492-509) | ○ |
| C-128 | ConcurrencyLimiterキャンセル処理 | E-06 (L441-458) | ○ |

### ChainedPartitionedRateLimiter（UT-TRL-129 〜 UT-TRL-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | GetStatisticsで最小値取得 | E-11 (L26-57) | ○ |
| C-130 | AttemptAcquireCoreでCombinedLease | E-11 (L59-88) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目なし
- 全てのテストケースがソースコードの実装に基づいて定義済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] TokenBucketRateLimiterのトークン補充ロジックが正しくテストされているか確認
- [ ] FixedWindowRateLimiterのウィンドウリセットタイミングが正しいか確認
- [ ] SlidingWindowRateLimiterのセグメントスライディングロジックが正しいか確認
- [ ] ConcurrencyLimiterのリース解放時のパーミット返却が正しいか確認
- [ ] ChainedRateLimiterの例外処理とロールバックが網羅されているか確認
- [ ] PartitionedRateLimiterのキャッシュ管理とアイドルクリーンアップが正しいか確認
- [ ] キャンセル処理時のキューカウント更新が正しいか確認
- [ ] Dispose時のリソース解放順序が正しいか確認
