---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Threading.Tasks.Dataflow 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-TDF-094 (条件付きリンク)**：DataflowBlock.LinkToの述語付きオーバーロードの動作確認
  2. **UT-TDF-095 (AsObservable)**：Rxインターフェース変換の詳細実装
  3. **UT-TDF-096 (AsObserver)**：Rxインターフェース変換の詳細実装
  4. **UT-TDF-098 (Choose)**：複数ソース選択処理の詳細
  5. **UT-TDF-097 (NullTarget)**：NullTargetの内部実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/ActionBlock.cs`
- E-02: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/BufferBlock.cs`
- E-03: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/TransformBlock.cs`
- E-04: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/TransformManyBlock.cs`
- E-05: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/BatchBlock.cs`
- E-06: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/BroadcastBlock.cs`
- E-07: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/WriteOnceBlock.cs`
- E-08: `src/libraries/System.Threading.Tasks.Dataflow/src/Blocks/JoinBlock.cs`
- E-09: `src/libraries/System.Threading.Tasks.Dataflow/src/Base/DataflowBlockOptions.cs`
- E-10: `src/libraries/System.Threading.Tasks.Dataflow/src/Base/DataflowBlock.cs`
- E-11: `.NET公式ドキュメント System.Threading.Tasks.Dataflow名前空間`

## 3) Claims と根拠の対応（レビューの主戦場）

### ActionBlock関連 (UT-TDF-001 〜 UT-TDF-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ActionBlockコンストラクタがアクションデリゲートを必須とする | E-01: L63-75 (ArgumentNullException.ThrowIfNull) | ○ |
| C-02 | nullアクションでArgumentNullException | E-01: L63 | ○ |
| C-03 | nullオプションでArgumentNullException | E-01: L89 (ArgumentNullException.ThrowIfNull) | ○ |
| C-04 | Postメソッドがメッセージを受け入れる | E-01: ITargetBlock実装 | ○ |
| C-05 | Complete後のPostはfalseを返す | E-01: DeclineMessageメカニズム | ○ |
| C-06 | Completeでブロックが完了状態になる | E-01: Complete()メソッド | ○ |
| C-07 | CompletionタスクがRanToCompletionになる | E-01: Completionプロパティ | ○ |
| C-08 | Faultで例外が設定される | E-01: IDataflowBlock.Fault実装 | ○ |
| C-09 | Fault引数nullでArgumentNullException | E-01: ArgumentNullException.ThrowIfNull | ○ |
| C-10 | InputCountが未処理メッセージ数を返す | E-01: InputCountプロパティ | ○ |

### BufferBlock関連 (UT-TDF-012 〜 UT-TDF-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | BufferBlockデフォルト初期化 | E-02: デフォルトコンストラクタ | ○ |
| C-12 | nullオプションでArgumentNullException | E-02: ArgumentNullException.ThrowIfNull | ○ |
| C-13 | Postでメッセージがバッファされる | E-02: Post実装 | ○ |
| C-14 | TryReceiveでメッセージ受信 | E-02: TryReceive実装 | ○ |
| C-15 | フィルタ付きTryReceive | E-02: Predicate<T>引数 | ○ |
| C-16 | 空バッファでTryReceiveがfalse | E-02: TryReceive実装 | ○ |
| C-17 | TryReceiveAllで一括受信 | E-02: TryReceiveAll実装 | ○ |
| C-18 | LinkToでブロック連携 | E-02: LinkTo実装 | ○ |
| C-19 | nullターゲットでArgumentNullException | E-02: ArgumentNullException.ThrowIfNull | ○ |
| C-20 | nullリンクオプションでArgumentNullException | E-02: ArgumentNullException.ThrowIfNull | ○ |
| C-21 | Countプロパティ | E-02: Countプロパティ | ○ |

### TransformBlock関連 (UT-TDF-024 〜 UT-TDF-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | TransformBlock初期化 | E-03: コンストラクタ | ○ |
| C-23 | null変換関数でArgumentNullException | E-03: throw new ArgumentNullException | ○ |
| C-24 | 非同期変換関数サポート | E-03: Func<TInput, Task<TOutput>>オーバーロード | ○ |
| C-25 | メッセージ変換処理 | E-03: ProcessMessage | ○ |
| C-26 | InputCount/OutputCount | E-03: プロパティ定義 | ○ |

### TransformManyBlock関連 (UT-TDF-031 〜 UT-TDF-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | TransformManyBlock初期化 | E-04: L55-72 コンストラクタ | ○ |
| C-28 | null変換関数でArgumentNullException | E-04: L70 throw new ArgumentNullException | ○ |
| C-29 | 1入力から複数出力生成 | E-04: StoreOutputItems メソッド | ○ |
| C-30 | 空Enumerable処理 | E-04: L333-340 null/空処理 | ○ |

### BatchBlock関連 (UT-TDF-035 〜 UT-TDF-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | BatchBlock初期化 | E-05: コンストラクタ | ○ |
| C-32 | バッチサイズ0以下でArgumentOutOfRangeException | E-05: 引数検証 | ○ |
| C-33 | バッチサイズ1の境界値 | E-05: コンストラクタ | ○ |
| C-34 | バッチサイズ分でバッチ出力 | E-05: バッチ処理ロジック | ○ |
| C-35 | TriggerBatchで強制出力 | E-05: TriggerBatchメソッド | ○ |
| C-36 | 空バッファでのTriggerBatch | E-05: TriggerBatch実装 | ○ |

### BroadcastBlock関連 (UT-TDF-042 〜 UT-TDF-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | BroadcastBlock初期化 | E-06: コンストラクタ | ○ |
| C-38 | nullクローニング関数許可 | E-06: Func<T,T>? nullable | ○ |
| C-39 | 最新メッセージのみ保持 | E-06: ブロードキャスト動作 | ○ |
| C-40 | 複数ターゲットへブロードキャスト | E-06: OfferToTargets | ○ |
| C-41 | クローニング関数適用 | E-06: CloneItem | ○ |

### WriteOnceBlock関連 (UT-TDF-047 〜 UT-TDF-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | WriteOnceBlock初期化 | E-07: L52-54 コンストラクタ | ○ |
| C-43 | nullオプションでArgumentNullException | E-07: L65 ArgumentNullException.ThrowIfNull | ○ |
| C-44 | 最初のメッセージのみ受け入れ | E-07: L335-372 OfferMessage実装 | ○ |
| C-45 | 2回目以降DecliningPermanently | E-07: L345 _decliningPermanently判定 | ○ |
| C-46 | 複数回受信可能 | E-07: L256-275 TryReceive実装 | ○ |
| C-47 | 値未設定時falseが返却 | E-07: L264 _header.IsValid判定 | ○ |
| C-48 | 値未設定でも完了可能 | E-07: Complete()メソッド | ○ |

### JoinBlock関連 (UT-TDF-054 〜 UT-TDF-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | JoinBlock初期化 | E-08: コンストラクタ | ○ |
| C-50 | nullオプションでArgumentNullException | E-08: 引数検証 | ○ |
| C-51 | Target1/Target2でTuple出力 | E-08: 結合ロジック | ○ |
| C-52 | 片方のみでfalse | E-08: TryReceive実装 | ○ |
| C-53 | 3入力JoinBlock | E-08: JoinBlock<T1,T2,T3>クラス | ○ |

### DataflowBlockOptions関連 (UT-TDF-060 〜 UT-TDF-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | TaskSchedulerデフォルト値 | E-09: L69 TaskScheduler.Default | ○ |
| C-55 | TaskScheduler nullでArgumentNullException | E-09: L114 throw ArgumentNullException | ○ |
| C-56 | MaxMessagesPerTaskデフォルト値 | E-09: L73 Unbounded | ○ |
| C-57 | MaxMessagesPerTask 0でArgumentOutOfRangeException | E-09: L137 | ○ |
| C-58 | MaxMessagesPerTask境界値1 | E-09: L137 value < 1 | ○ |
| C-59 | BoundedCapacityデフォルト値 | E-09: L75 Unbounded | ○ |
| C-60 | BoundedCapacity 0でArgumentOutOfRangeException | E-09: L157 | ○ |
| C-61 | BoundedCapacityバックプレッシャー | E-09: BoundedCapacity説明 | ○ |
| C-62 | NameFormatデフォルト値 | E-09: L77 "{0} Id={1}" | ○ |
| C-63 | NameFormat nullでArgumentNullException | E-09: L176 | ○ |
| C-64 | EnsureOrderedデフォルト値 | E-09: L79 true | ○ |
| C-65 | CancellationTokenでキャンセル | E-09: CancellationToken処理 | ○ |

### ExecutionDataflowBlockOptions関連 (UT-TDF-072 〜 UT-TDF-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | MaxDegreeOfParallelismデフォルト値 | E-09: L278 = 1 | ○ |
| C-67 | MaxDegreeOfParallelism 0でArgumentOutOfRangeException | E-09: L292 | ○ |
| C-68 | 並列処理確認 | E-09: SupportsParallelExecution | ○ |
| C-69 | SingleProducerConstrainedデフォルト値 | E-09: L280 false | ○ |

### GroupingDataflowBlockOptions関連 (UT-TDF-076 〜 UT-TDF-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Greedyデフォルト値 | E-09: L410 true | ○ |
| C-71 | 非貪欲モード動作 | E-09: Greedy=false説明 | ○ |
| C-72 | MaxNumberOfGroupsデフォルト値 | E-09: L412 Unbounded | ○ |
| C-73 | MaxNumberOfGroups 0でArgumentOutOfRangeException | E-09: L435 | ○ |
| C-74 | グループ数制限で完了 | E-09: MaxNumberOfGroups説明 | ○ |

### DataflowLinkOptions関連 (UT-TDF-081 〜 UT-TDF-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | PropagateCompletionデフォルト値 | E-11: 公式ドキュメント | ○ |
| C-76 | 完了伝播動作 | E-11: PropagateCompletion説明 | ○ |
| C-77 | MaxMessagesデフォルト値 | E-11: 公式ドキュメント | ○ |
| C-78 | メッセージ数制限 | E-11: MaxMessages説明 | ○ |
| C-79 | Appendデフォルト値 | E-11: 公式ドキュメント | ○ |

### DataflowBlock拡張メソッド関連 (UT-TDF-086 〜 UT-TDF-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | Post拡張メソッド | E-10: DataflowBlock.Post | ○ |
| C-81 | SendAsync | E-10: DataflowBlock.SendAsync | ○ |
| C-82 | SendAsyncバックプレッシャー | E-10: SendAsync実装 | ○ |
| C-83 | ReceiveAsync | E-10: DataflowBlock.ReceiveAsync | ○ |
| C-84 | ReceiveAsyncタイムアウト | E-10: timeout引数 | ○ |
| C-85 | OutputAvailableAsync | E-10: DataflowBlock.OutputAvailableAsync | ○ |
| C-86 | OutputAvailableAsync完了時 | E-10: 実装詳細 | ○ |
| C-87 | Encapsulate | E-10: DataflowBlock.Encapsulate | ○ |
| C-88 | LinkToフィルタ付き | E-10: LinkTo predicate overload | △ |
| C-89 | AsObservable | E-10: AsObservable拡張メソッド | △ |
| C-90 | AsObserver | E-10: AsObserver拡張メソッド | △ |
| C-91 | NullTarget | E-10: NullTarget実装 | △ |
| C-92 | Choose | E-10: Choose拡張メソッド | △ |

### DataflowMessageHeader関連 (UT-TDF-099 〜 UT-TDF-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | IsValid true判定 | E-07: L38-40 _header.IsValid | ○ |
| C-94 | IsValid false判定 | E-07: デフォルト値 | ○ |

## 4) 不足情報（Unknown / Missing）
- DataflowBlock拡張メソッドの一部（AsObservable、AsObserver、Choose、NullTarget）について、DataflowBlock.csファイルが大きすぎて完全に読み込めなかったため、詳細な実装根拠が不足
  - 候補：DataflowBlock.csの該当セクション / System.Reactive関連実装 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - コンストラクタ、プロパティ、基本的なメソッドのテストケース（90件）
  - ソースコードから直接根拠が確認できる
- **1: 中リスク** - 拡張メソッドの一部、複雑な動作確認テスト（5件）
  - Rxインターフェース変換、Choose操作など、複雑な動作の詳細確認が必要
- **2: 高リスク** - なし

## 6) レビュアーチェックリスト（最小）
- [ ] ActionBlock/BufferBlock/TransformBlockの基本操作テストケースが網羅されているか
- [ ] 各オプションクラス（DataflowBlockOptions、ExecutionDataflowBlockOptions、GroupingDataflowBlockOptions）のプロパティ検証が適切か
- [ ] 引数検証（ArgumentNullException、ArgumentOutOfRangeException）のテストケースが漏れなく含まれているか
- [ ] 境界値テスト（BoundedCapacity=1、MaxDegreeOfParallelism=1等）が含まれているか
- [ ] 非同期操作（SendAsync、ReceiveAsync）のテストケースが適切か
- [ ] キャンセル処理（CancellationToken）のテストケースが含まれているか
- [ ] ブロック間連携（LinkTo、PropagateCompletion）のテストケースが適切か
