---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Threading.Tasks.Parallel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で△の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-TPL-079**: シングルスレッド環境の動作確認 - 実行時の環境依存
  2. **UT-TPL-080**: シングルスレッド環境でのyield制約 - 実行時の環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/Parallel.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/Parallel.ForEachAsync.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/ParallelLoopState.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/ParallelRangeManager.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/TaskReplicator.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/src/System/Threading/Tasks/ParallelETWProvider.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Threading.Tasks.Parallel/ref/System.Threading.Tasks.Parallel.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ParallelOptions クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MaxDegreeOfParallelismに有効な値を設定できる | E-01 (line 81-90) | ○ |
| C-02 | MaxDegreeOfParallelismに-1を設定できる | E-01 (line 81-90) | ○ |
| C-03 | MaxDegreeOfParallelism=0でArgumentOutOfRangeException | E-01 (line 86) | ○ |
| C-04 | MaxDegreeOfParallelism<-1でArgumentOutOfRangeException | E-01 (line 87) | ○ |
| C-05 | EffectiveMaxConcurrencyLevelが正しく計算される | E-01 (line 109-121) | ○ |
| C-06 | TaskSchedulerにnullを設定した場合の動作 | E-01 (line 65) | ○ |

### Parallel.Invoke メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | 複数のアクションが並列実行される | E-01 (line 168-375) | ○ |
| C-08 | 空の配列で即座に完了する | E-01 (line 241) | ○ |
| C-09 | actionsがnullでArgumentNullException | E-01 (line 204) | ○ |
| C-10 | parallelOptionsがnullでArgumentNullException | E-01 (line 203) | ○ |
| C-11 | 配列内のnullでArgumentException | E-01 (line 220-224) | ○ |
| C-12 | 例外がAggregateExceptionにラップされる | E-01 (line 330-331) | ○ |
| C-13 | キャンセル時にOperationCanceledException | E-01 (line 212) | ○ |

### Parallel.For メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | 指定範囲のイテレーションが実行される | E-01 (line 919-1165) | ○ |
| C-15 | fromInclusive >= toExclusiveで即座に完了 | E-01 (line 938-942) | ○ |
| C-16 | bodyがnullでArgumentNullException | E-01 (line 395) | ○ |
| C-17 | long型の範囲で正しく実行される | E-01 (line 419-426) | ○ |
| C-18 | ParallelLoopState.Stop()でループが停止 | E-03 (line 140-143) | ○ |
| C-19 | ParallelLoopState.Break()でLowestBreakIterationが設定 | E-03 (line 179-221) | ○ |
| C-20 | localInit/localFinallyが適切に呼ばれる | E-01 (line 1038-1042, 1107-1110) | ○ |

### Parallel.ForEach メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | IEnumerableのすべての要素が処理される | E-01 (line 1640-1680) | ○ |
| C-22 | 空のコレクションで即座に完了 | E-01 (line 1657) | ○ |
| C-23 | sourceがnullでArgumentNullException | E-01 (line 1189) | ○ |
| C-24 | 配列に対して最適化パスが使用される | E-01 (line 1660-1665) | ○ |
| C-25 | IListに対して最適化パスが使用される | E-01 (line 1669-1674) | ○ |
| C-26 | Partitioner.SupportsDynamicPartitions=falseでInvalidOperationException | E-01 (line 1956-1959) | ○ |
| C-27 | OrderablePartitioner.KeysNormalized=falseでInvalidOperationException | E-01 (line 1956-1959) | ○ |

### Parallel.ForAsync / ForEachAsync メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | ForAsync<T>が非同期で完了する | E-02 (line 20-189) | ○ |
| C-29 | fromInclusive >= toExclusiveでCompletedTask | E-02 (line 90-93) | ○ |
| C-30 | bodyがnullでArgumentNullException | E-02 (line 23-25) | ○ |
| C-31 | ForEachAsync (IEnumerable)が動作する | E-02 (line 198-344) | ○ |
| C-32 | ForEachAsync (IAsyncEnumerable)が動作する | E-02 (line 353-499) | ○ |

### ParallelLoopState クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Stop()後にIsStoppedがtrue | E-03 (line 73-79) | ○ |
| C-34 | Break()後にStop()でInvalidOperationException | E-03 (line 332-339) | ○ |
| C-35 | Stop()後にBreak()でInvalidOperationException | E-03 (line 196-200) | ○ |
| C-36 | ShouldExitCurrentIterationが正しく動作 | E-03 (line 256-259) | ○ |
| C-37 | IsExceptionalが例外発生後にtrue | E-03 (line 85-91) | ○ |

### ParallelLoopResult 構造体

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | 正常完了時にIsCompleted=true | E-03 (line 432) | ○ |
| C-39 | Break()未使用時にLowestBreakIteration=null | E-03 (line 371-377) | ○ |

### ParallelLoopStateFlags クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | AtomicLoopStateUpdateがアトミックに動作 | E-03 (line 310-324) | ○ |
| C-41 | SetExceptionalが例外フラグを設定 | E-03 (line 326-330) | ○ |
| C-42 | ShouldExitLoopが正しく判定 | E-03 (line 395-409) | ○ |

### RangeManager / RangeWorker クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | RangeManagerが適切にレンジを分割 | E-04 (line 214-283) | ○ |
| C-44 | RegisterNewWorkerが有効なRangeWorkerを返す | E-04 (line 289-296) | ○ |
| C-45 | FindNewWorkが正しく作業範囲を返す | E-04 (line 93-174) | ○ |

### TaskReplicator クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Run<TState>がアクションを実行 | E-05 (line 130-158) | ○ |
| C-47 | stopOnFirstFailure=trueで例外時に停止 | E-05 (line 91-92) | ○ |
| C-48 | シングルスレッド環境で同期実行 | E-05 (line 134-143) | △ |
| C-49 | シングルスレッド環境でyield時に例外 | E-05 (line 141-142) | △ |

### ParallelEtwProvider クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | ParallelLoopBeginイベントが発行される | E-06 (line 101-150) | ○ |
| C-51 | ParallelLoopEndイベントが発行される | E-06 (line 163-200) | ○ |
| C-52 | ParallelInvokeBegin/Endイベントが発行される | E-06 (line 212-271) | ○ |
| C-53 | ParallelFork/Joinイベントが発行される | E-06 (line 283-306) | ○ |

### ForEachAsyncState / 関連クラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | QueueWorkerIfDopAvailableが正しく動作 | E-02 (line 558-584) | ○ |
| C-55 | SignalWorkerCompletedIteratingが正しく判定 | E-02 (line 588) | ○ |
| C-56 | RecordExceptionが例外を記録しキャンセルをトリガー | E-02 (line 614-636) | ○ |
| C-57 | Completeが正しく完了状態を設定 | E-02 (line 639-666) | ○ |
| C-58 | SyncForEachAsyncState.Disposeがリソースを解放 | E-02 (line 699-703) | ○ |
| C-59 | AsyncForEachAsyncState.DisposeAsyncがリソースを解放 | E-02 (line 721-725) | ○ |
| C-60 | ForAsyncStateがプリミティブ型で最適化 | E-02 (line 739) | ○ |

## 4) 不足情報（Unknown / Missing）
- **シングルスレッド環境のテスト（UT-TPL-079, UT-TPL-080）**
  - `IsSingleThreaded`プロパティはコンパイル時フラグ（`FEATURE_SINGLE_THREADED`）で制御されており、通常のテスト環境では検証が困難
  - 候補：ブラウザ環境（WASM）/ WASI環境でのテスト / モック/スタブによるテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースは明確なソースコード根拠がある
- **1: 中リスク** - シングルスレッド環境関連のテストは実行環境依存
- **0: 低リスク** - ETWトレーシングのテストは`IsEnabled`プロパティに依存するが、実装は明確

## 6) レビュアーチェックリスト（最小）
- [ ] ParallelOptions.MaxDegreeOfParallelismのバリデーションテスト（UT-TPL-001〜004）が実装要件を満たしているか
- [ ] Parallel.For/ForEachのキャンセル処理テスト（UT-TPL-014, UT-TPL-042）がCancellationTokenの全パターンをカバーしているか
- [ ] ParallelLoopStateのStop/Breakの相互排他テスト（UT-TPL-049, UT-TPL-052）が状態遷移を正しく検証しているか
- [ ] ForEachAsyncStateの完了処理テスト（UT-TPL-094〜096）が全ての完了パターンを網羅しているか
- [ ] シングルスレッド環境のテスト（UT-TPL-079〜080）の実行方法を確認
- [ ] 既存のテストコード（/tests/配下）との重複・補完関係を確認
