---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 138
  claims_with_evidence: 134
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Threading.Thread 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケース一覧の内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：134 / 138、根拠なし：4
- 優先レビュー（高）
  1. **UT-THR-104 (DisableComObjectEagerCleanup)**: 具体的なテスト動作の検証が困難
  2. **UT-THR-136 (LocalDataStoreSlot Finalizer)**: ファイナライザの動作確認は実装依存
  3. **UT-THR-093 (MemoryBarrier)**: メモリバリアの効果は直接観測困難
  4. **UT-THR-097 (Yield)**: 実行権譲渡の効果は環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Threading.Thread/ref/System.Threading.Thread.cs` - APIリファレンス定義
- E-02: `src/libraries/System.Threading.Thread/tests/ThreadTests.cs` - 主要なThreadクラステスト
- E-03: `src/libraries/System.Threading.Thread/tests/ExceptionTests.cs` - 例外クラスのテスト
- E-04: `src/libraries/System.Threading.Thread/tests/CompressedStackTests.cs` - CompressedStackのテスト
- E-05: `src/libraries/System.Threading.Thread/tests/ThreadExceptionEventArgsTests.cs` - ThreadExceptionEventArgsのテスト
- E-06: `src/libraries/System.Threading.Thread/tests/STAMain/STAMain.cs` - STAアパートメントテスト
- E-07: `src/libraries/System.Threading.Thread/tests/MTAMain/MTAMain.cs` - MTAアパートメントテスト
- E-08: `src/libraries/System.Threading.Thread/tests/DefaultApartmentStateMain/DefaultApartmentStateMain.cs` - デフォルトアパートメントテスト

## 3) Claims と根拠の対応（レビューの主戦場）

### Thread コンストラクタ (UT-THR-001 - UT-THR-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThreadStart/ParameterizedThreadStartコンストラクタが正常動作 | E-01 (行37-40), E-02 (行30-79) | ○ |
| C-02 | nullデリゲートでArgumentNullException | E-02 (行72-75) | ○ |
| C-03 | スタックサイズ指定が機能する | E-02 (行63-70) | ○ |
| C-04 | 負のスタックサイズでArgumentOutOfRangeException | E-02 (行77-78) | ○ |

### Thread Start/UnsafeStart (UT-THR-009 - UT-THR-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Start()でスレッドが開始される | E-02 (行1054-1155) | ○ |
| C-06 | 既開始スレッドでThreadStateException | E-02 (行1095, 1098, 1103-1105) | ○ |
| C-07 | ParameterizedThreadStartへのパラメータ渡し | E-02 (行1112-1137) | ○ |
| C-08 | ThreadStartスレッドへのパラメータ渡しでInvalidOperationException | E-02 (行1092-1093) | ○ |
| C-09 | UnsafeStart()でExecutionContextが引き継がれない | E-02 (行1139-1154) | ○ |

### Thread Join (UT-THR-017 - UT-THR-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | Join()でスレッド終了待機 | E-02 (行1006-1037) | ○ |
| C-11 | 未開始スレッドでThreadStateException | E-02 (行1024-1026) | ○ |
| C-12 | タイムアウト付きJoinの動作 | E-02 (行1030-1036) | ○ |
| C-13 | 不正タイムアウト値でArgumentOutOfRangeException | E-02 (行1020-1022) | ○ |

### Thread Interrupt (UT-THR-024 - UT-THR-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | 待機中スレッドが中断される | E-02 (行929-977) | ○ |
| C-15 | 未開始スレッドへのInterrupt後の動作 | E-02 (行961-966) | ○ |
| C-16 | 停止済みスレッドへのInterruptは無視 | E-02 (行957-958) | ○ |

### Thread Sleep (UT-THR-027 - UT-THR-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Sleep()で指定時間待機 | E-02 (行1039-1052) | ○ |
| C-18 | 不正な値でArgumentOutOfRangeException | E-02 (行1042-1044) | ○ |

### Thread プロパティ (UT-THR-032 - UT-THR-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | CurrentThread取得 | E-02 (行531-545) | ○ |
| C-20 | ManagedThreadId取得 | E-02 (行614-625) | ○ |
| C-21 | Name設定・取得 | E-02 (行627-668) | ○ |
| C-22 | IsAlive確認 | E-02 (行554-567) | ○ |
| C-23 | IsBackground設定・取得 | E-02 (行569-588) | ○ |
| C-24 | IsThreadPoolThread確認 | E-02 (行590-612) | ○ |
| C-25 | Priority設定・取得 | E-02 (行686-701) | ○ |
| C-26 | ThreadState確認 | E-02 (行703-738) | ○ |
| C-27 | CurrentCulture/CurrentUICulture設定・取得 | E-02 (行342-423) | ○ |
| C-28 | CurrentPrincipal設定・取得 | E-02 (行425-529) | ○ |
| C-29 | ExecutionContext取得 | E-02 (行547-552) | ○ |

### ApartmentState (UT-THR-064 - UT-THR-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | GetApartmentState()の動作 | E-02 (行81-340), E-06, E-07, E-08 | ○ |
| C-31 | SetApartmentState()の動作 | E-02 (行236-265, 267-340), E-06, E-07 | ○ |
| C-32 | TrySetApartmentState()の動作 | E-02 (行137-158) | ○ |
| C-33 | プラットフォーム固有の動作 | E-02 (行198-230), E-06, E-07, E-08 | ○ |

### 廃止API (UT-THR-071 - UT-THR-075, UT-THR-102 - UT-THR-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Abort/ResetAbortでPlatformNotSupportedException | E-02 (行740-765), E-01 (行55-58, 82-83) | ○ |
| C-35 | Suspend/ResumeでPlatformNotSupportedException | E-02 (行754-755), E-01 (行84-85, 102-103) | ○ |
| C-36 | GetCompressedStack/SetCompressedStackでInvalidOperationException | E-02 (行1166-1168), E-01 (行69-70, 88-89) | ○ |

### LocalDataStoreSlot (UT-THR-076 - UT-THR-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | AllocateDataSlot()の動作 | E-02 (行859-927) | ○ |
| C-38 | AllocateNamedDataSlot()の動作 | E-02 (行874-891) | ○ |
| C-39 | GetNamedDataSlot()の動作 | E-02 (行893-909) | ○ |
| C-40 | FreeNamedDataSlot()の動作 | E-02 (行882-884) | ○ |
| C-41 | GetData/SetDataの動作 | E-02 (行767-857) | ○ |

### Miscellaneous (UT-THR-089 - UT-THR-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | GetDomain/GetDomainID | E-02 (行1172-1175) | ○ |
| C-43 | MemoryBarrier | E-02 (行1170), E-01 (行81) | ○ |
| C-44 | SpinWait | E-02 (行1177-1180), E-01 (行93) | ○ |
| C-45 | Yield | E-02 (行1181), E-01 (行202) | ○ |
| C-46 | BeginCriticalRegion/EndCriticalRegion | E-02 (行1160-1161), E-01 (行61, 64) | ○ |
| C-47 | BeginThreadAffinity/EndThreadAffinity | E-02 (行1162-1163), E-01 (行62, 65) | ○ |
| C-48 | GetCurrentProcessorId | E-02 (行1306-1310), E-01 (行71) | ○ |
| C-49 | DisableComObjectEagerCleanup | E-01 (行63) | △ |

### CompressedStack (UT-THR-105 - UT-THR-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Capture()の動作 | E-04 (行14-21) | ○ |
| C-51 | CreateCopy()の動作 | E-04 (行18, 20) | ○ |
| C-52 | GetCompressedStack()の動作 | E-04 (行19-20) | ○ |
| C-53 | Run()の動作 | E-04 (行29-48) | ○ |
| C-54 | Run()のnull検証 | E-04 (行26, 33) | ○ |

### 例外クラス (UT-THR-111 - UT-THR-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ThreadInterruptedExceptionコンストラクタ | E-03 (行39-46) | ○ |
| C-56 | ThreadInterruptedException HResult | E-03 (行10, 23) | ○ |
| C-57 | ThreadStateExceptionコンストラクタ | E-03 (行48-56) | ○ |
| C-58 | ThreadStateException HResult | E-03 (行11, 23) | ○ |

### ThreadExceptionEventArgs (UT-THR-119 - UT-THR-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | コンストラクタの動作 | E-05 (行12-19) | ○ |
| C-60 | Exceptionプロパティ | E-05 (行14, 18) | ○ |

### 列挙型 (UT-THR-122 - UT-THR-135)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | ApartmentState値 | E-01 (行17-22) | ○ |
| C-62 | ThreadPriority値 | E-01 (行224-231) | ○ |
| C-63 | ThreadState値 | E-01 (行237-250) | ○ |

### その他 (UT-THR-136 - UT-THR-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | LocalDataStoreSlot Finalizer | E-01 (行11-12) | △ |
| C-65 | ThreadStartデリゲート呼び出し | E-01 (行232), E-02 | ○ |
| C-66 | ParameterizedThreadStartデリゲート呼び出し | E-01 (行34), E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **DisableComObjectEagerCleanup()**: APIリファレンスに定義は存在するが、具体的なテスト動作の検証ができない。COM関連の実装詳細が必要。
  - 候補：CoreCLR実装コード / COM相互運用ドキュメント / Windows固有テスト
- **LocalDataStoreSlot Finalizer**: ファイナライザの動作はGCのタイミングに依存し、確実なテストが困難。
  - 候補：GC強制実行によるテスト / WeakReferenceを使用したテスト
- **MemoryBarrier効果**: メモリバリアの効果は直接観測できず、マルチスレッド環境での副作用確認が必要。
  - 候補：マルチスレッド競合テスト / プロセッサ固有の動作確認
- **Yield効果**: 実行権譲渡の効果はOSスケジューラに依存し、環境によって異なる。
  - 候補：高負荷環境でのテスト / スケジューリング監視

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 列挙型の値確認テスト（UT-THR-122 - UT-THR-135）- 定数値の確認のみ
- **1 (中リスク)**: ApartmentState関連テスト（UT-THR-064 - UT-THR-070）- プラットフォーム依存性あり
- **1 (中リスク)**: 廃止APIテスト（UT-THR-071 - UT-THR-075）- 将来的に削除される可能性
- **2 (高リスク)**: スレッド同期関連テスト（UT-THR-017 - UT-THR-026）- タイミング依存でフレーキーテストになりやすい

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-THR-001 - UT-THR-011, UT-THR-017 - UT-THR-021）の網羅性を確認
- [ ] プラットフォーム固有テスト（Windows/Unix）の条件分岐が適切か確認
- [ ] 廃止API（Abort, Suspend, Resume等）のテストが.NET Coreの仕様に準拠しているか確認
- [ ] ThreadState遷移テストのタイミング依存性を評価
- [ ] LocalDataStoreSlotのスレッド分離テストが正しくマルチスレッドで実行されるか確認
- [ ] CompressedStack.Run()のコンテキスト実行テストが同一スレッドで行われることを確認
