---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Threading.ThreadPool 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースに根拠あり
  2. Windows固有機能（BindHandle, UnsafeQueueNativeOverlapped）は実機検証推奨
  3. 並行処理テストは環境依存性を考慮

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Threading.ThreadPool/ref/System.Threading.ThreadPool.cs` - 公開APIリファレンス
- E-02: `src/libraries/System.Private.CoreLib/src/System/Threading/ThreadPoolWorkQueue.cs` - ThreadPoolWorkQueue実装
- E-03: `src/libraries/System.Private.CoreLib/src/System/Threading/ThreadPool.Windows.cs` - Windows固有実装
- E-04: `src/libraries/System.Private.CoreLib/src/System/Threading/ThreadPool.Unix.cs` - Unix固有実装
- E-05: `src/libraries/System.Private.CoreLib/src/System/Threading/RegisteredWaitHandle.Portable.cs` - RegisteredWaitHandle実装
- E-06: `src/libraries/System.Private.CoreLib/src/System/Threading/RegisteredWaitHandle.Windows.cs` - RegisteredWaitHandle Windows実装
- E-07: `src/libraries/System.Threading.ThreadPool/tests/ThreadPoolTests.cs` - 既存単体テスト
- E-08: `src/libraries/System.Threading.ThreadPool/tests/RegisteredWaitTests.cs` - RegisteredWait単体テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### ThreadPool基本メソッド（UT-TPL-001 - UT-TPL-012）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueueUserWorkItem(WaitCallback)でコールバックがキューイングされる | E-02 L1586-1605, E-07 L270-276 | ○ |
| C-02 | callBack=nullでArgumentNullExceptionがスローされる | E-02 L1591-1594, E-08 L152 | ○ |
| C-03 | stateがコールバックに正しく渡される | E-02 L1589-1604, E-07 L297-309 | ○ |
| C-04 | state=nullでもコールバックが正常実行 | E-02 L1589, E-07 L281-293 | ○ |
| C-05 | ジェネリック版でstateが型安全に渡される | E-02 L1607-1623, E-07 L311-325 | ○ |
| C-06 | preferLocal=trueでローカルキューに追加 | E-02 L1620, E-07 L329-345 | ○ |
| C-07 | callBack=nullでArgumentNullException（ジェネリック版） | E-02 L1609-1612 | ○ |
| C-08 | UnsafeQueueUserWorkItemでECがフローしない | E-02 L1656-1668, E-07 L349-363 | ○ |
| C-09 | UnsafeQueueUserWorkItem<TState>でECがフローしない | E-02 L1625-1654, E-07 L349-363 | ○ |
| C-10 | IThreadPoolWorkItemのExecuteが呼び出される | E-02 L1670-1685, E-07 L374-387 | ○ |
| C-11 | IThreadPoolWorkItem null検証 | E-02 L1672-1675 | ○ |
| C-12 | Taskがcallbackの場合ArgumentOutOfRangeException | E-02 L1676-1681, E-07 L367-371 | ○ |

### スレッド数設定メソッド（UT-TPL-013 - UT-TPL-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | SetMinThreadsで有効値が設定される | E-03 L100-103, E-07 L107-167 | ○ |
| C-14 | SetMinThreadsで負の値がfalse | E-07 L128-129 | ○ |
| C-15 | SetMinThreadsで最大値超えがfalse | E-07 L122-127 | ○ |
| C-16 | SetMinThreads(0,0)で1,1に正規化 | E-07 L180-181 | ○ |
| C-17 | SetMaxThreadsで有効値が設定される | E-03 L83-86, E-07 L119-120 | ○ |
| C-18 | SetMaxThreadsで負の値がfalse | E-07 L141 | ○ |
| C-19 | SetMaxThreadsで最小値未満がfalse | E-07 L131-132 | ○ |
| C-20 | SetMaxThreads上限正規化 | E-07 L137-142 | ○ |
| C-21 | GetMinThreadsで設定値取得 | E-03 L105-114, E-07 L214-220 | ○ |
| C-22 | GetMaxThreadsで設定値取得 | E-03 L88-98, E-07 L222-228 | ○ |
| C-23 | GetAvailableThreadsで利用可能数取得 | E-03 L117-127, E-07 L91-103 | ○ |
| C-24 | 利用可能数が最大数以下 | E-07 L99-102 | ○ |
| C-25 | ThreadCountで現在スレッド数取得 | E-03 L199-205, E-07 L546 | ○ |
| C-26 | CompletedWorkItemCountで完了数取得 | E-03 L213-218, E-07 L536-577 | ○ |
| C-27 | 完了後にカウント増加 | E-07 L572-576, E-07 L1496-1497 | ○ |
| C-28 | PendingWorkItemCountで保留数取得 | E-02 L1761-1768, E-07 L555 | ○ |

### RegisterWaitForSingleObject（UT-TPL-029 - UT-TPL-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | シグナル時にコールバック呼び出し | E-08 L195-209 | ○ |
| C-30 | タイムアウト時にコールバック呼び出し | E-08 L211-225 | ○ |
| C-31 | waitObject=nullでArgumentNullException | E-08 L157 | ○ |
| C-32 | callBack=nullでArgumentNullException | E-08 L158 | ○ |
| C-33 | timeout=-2でArgumentOutOfRangeException | E-08 L159-161 | ○ |
| C-34 | timeout>int.MaxValueでArgumentOutOfRangeException | E-08 L163-164, E-02 L1517-1518 | ○ |
| C-35 | TimeSpan timeout範囲検証 | E-08 L165-173 | ○ |
| C-36 | executeOnlyOnce=falseで繰り返しコールバック | E-08 L278-300 | ○ |
| C-37 | stateがコールバックに渡される | E-08 L370-384 | ○ |
| C-38 | timeout=-1で無限待機 | E-08 L317, E-08 L131-147 | ○ |
| C-39 | UnsafeRegisterWaitでECがフローしない | E-08 L113-128, E-07 L902-912 | ○ |

### BindHandle/UnsafeQueueNativeOverlapped（UT-TPL-040 - UT-TPL-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Windowsでハンドルがバインドされる | E-03 L61-65 | ○ |
| C-41 | 非WindowsでPlatformNotSupportedException | E-04 L101-108 | ○ |
| C-42 | Windowsでネイティブオーバーラップキューイング | E-03 L47-52 | ○ |
| C-43 | 非WindowsでPlatformNotSupportedException | E-04 L97-99 | ○ |

### RegisteredWaitHandle.Unregister（UT-TPL-044 - UT-TPL-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | 登録解除成功でtrue | E-05 L92-158, E-08 L237 | ○ |
| C-45 | 二重解除でfalse | E-05 L102-105 | ○ |
| C-46 | null解除で非ブロッキング | E-08 L467-472, E-05 L107-110 | ○ |
| C-47 | InvalidHandleValueでブロッキング解除 | E-05 L118-121, E-08 L414-444 | ○ |
| C-48 | 解除後シグナル観察されない | E-08 L462-472 | ○ |
| C-49 | コールバック実行中解除で完了待機 | E-05 L224-245, E-08 L386-412 | ○ |

### WorkStealingQueue（UT-TPL-050 - UT-TPL-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | LocalPushでキュー追加 | E-02 L117-180 | ○ |
| C-51 | キュー満杯で自動拡張 | E-02 L149-161 | ○ |
| C-52 | tailIndex=MaxValueでオーバーフロー処理 | E-02 L122-125, L182-215 | ○ |
| C-53 | LocalPopでLIFO動作 | E-02 L273-335 | ○ |
| C-54 | 空キューでnull返却 | E-02 L273 | ○ |
| C-55 | TryStealでワークスチール | E-02 L339-384 | ○ |
| C-56 | ロック競合でmissedSteal=true | E-02 L379 | ○ |
| C-57 | TrySteal空キューでnull | E-02 L382 | ○ |
| C-58 | LocalFindAndPopで検索成功 | E-02 L217-271 | ○ |
| C-59 | LocalFindAndPopで不在検出 | E-02 L270 | ○ |
| C-60 | Countで正確なカウント | E-02 L386-404 | ○ |
| C-61 | CanStealで可否判定 | E-02 L337 | ○ |
| C-62 | WorkStealingQueueList.Add | E-02 L40-56 | ○ |
| C-63 | WorkStealingQueueList.Remove | E-02 L58-96 | ○ |

### ThreadPoolWorkQueue（UT-TPL-064 - UT-TPL-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | Enqueue forceGlobal=trueでグローバル追加 | E-02 L572-603 | ○ |
| C-65 | Enqueue forceGlobal=falseでローカル追加 | E-02 L587-591 | ○ |
| C-66 | EnqueueAtHighPriorityで高優先度追加 | E-02 L641-651 | ○ |
| C-67 | Dequeueでローカル優先 | E-02 L699-706 | ○ |
| C-68 | Dequeueで高優先度次 | E-02 L708-726 | ○ |
| C-69 | Dequeueでワークスチール | E-02 L764-783 | ○ |
| C-70 | Dispatchで作業項目実行 | E-02 L849-1021 | ○ |
| C-71 | Dispatchで量子時間制御 | E-02 L840, L984-987 | ○ |
| C-72 | LocalCountで合計取得 | E-02 L804-815 | ○ |
| C-73 | GlobalCountで合計取得 | E-02 L817-836 | ○ |

### ThreadPoolWorkQueueThreadLocals（UT-TPL-074 - UT-TPL-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | TransferLocalWorkでグローバル転送 | E-02 L1093-1099 | ○ |
| C-75 | ファイナライザでワーク転送 | E-02 L1101-1109 | ○ |

### コールバッククラス（UT-TPL-076 - UT-TPL-079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | QueueUserWorkItemCallback.ExecuteでEC内実行 | E-02 L1271-1276 | ○ |
| C-77 | QueueUserWorkItemCallbackDefaultContext.Execute | E-02 L1319-1331 | ○ |
| C-78 | PerformWaitOrTimerCallbackでtimedOutフラグ | E-02 L1395-1408 | ○ |
| C-79 | EC無しで直接実行 | E-02 L1400-1403 | ○ |

### 統合テスト（UT-TPL-080 - UT-TPL-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | ProcessorCount個の並列実行 | E-07 L581-605 | ○ |
| C-81 | スレッド状態リセット | E-07 L710-792 | ○ |
| C-82 | ブロッキングでスレッド追加 | E-07 L649-675, E-07 L916-980 | ○ |
| C-83 | 64個以上の待機登録 | E-08 L353-368 | ○ |
| C-84 | QueueUserWorkItemでECフロー | E-07 L349-363 (42行目useUnsafe=false) | ○ |
| C-85 | UnsafeQueueUserWorkItemでEC非フロー | E-07 L349-363 (42行目useUnsafe=true) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに根拠あり
- 追加考慮事項：
  - Windows固有機能（BindHandle, UnsafeQueueNativeOverlapped）はWindows環境での実機テストが必要
  - 並行処理テスト（UT-TPL-080, UT-TPL-082）はプロセッサ数に依存するため環境による差異がある可能性

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全テストケースに明確な根拠あり
- 注意点：
  - プラットフォーム固有のテスト（Windows/Unix）は環境に応じて選択実行が必要
  - 並行処理のタイミングに依存するテストは偶発的失敗の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 全85テストケースがCSVに正しく記録されているか
- [ ] テストID（UT-TPL-001～UT-TPL-085）が連番で重複なく付与されているか
- [ ] 優先度「高」のテストケースが主要な機能を網羅しているか
- [ ] プラットフォーム固有テスト（UT-TPL-040～043）が適切にマークされているか
- [ ] 境界値テスト（timeout=-1, 0, MaxValue等）が含まれているか
- [ ] ExecutionContextフローに関するテストが安全/非安全の両方を含むか
