---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 133
  claims_with_evidence: 127
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：libraries-System.Threading 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：127 / 133、根拠なし：6
- 優先レビュー（高）
  1. **UT-THR-100, UT-THR-102**：ApplicationException詳細（ReaderWriterLockApplicationExceptionの内部実装確認要）
  2. **UT-THR-107**：DowngradeFromWriterLock異常系の挙動詳細
  3. **UT-THR-111**：別スレッドLockCookieの挙動（スレッド間テスト）
  4. **UT-THR-133**：Revertの別スレッド挙動（AsyncLocalベース検証）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Threading/src/System/Threading/Barrier.cs`
- E-02: `src/libraries/System.Threading/src/System/Threading/CountdownEvent.cs`
- E-03: `src/libraries/System.Threading/src/System/Threading/ReaderWriterLock.cs`
- E-04: `src/libraries/System.Threading/src/System/Threading/LockCookie.cs`
- E-05: `src/libraries/System.Threading/src/System/Threading/HostExecutionContext.cs`
- E-06: `src/libraries/System.Threading/src/System/Threading/HostExecutionContextManager.cs`
- E-07: `src/libraries/System.Threading/ref/System.Threading.cs`
- E-08: `src/libraries/System.Threading/tests/BarrierTests.cs`
- E-09: `src/libraries/System.Threading/tests/CountdownEventTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Barrier クラス (UT-THR-001 〜 UT-THR-041)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Barrier(0)でインスタンス生成可能 | E-01 L221-223, E-08 L23 | ○ |
| C-02 | Barrier(10)でインスタンス生成可能 | E-01 L221-223, E-08 L22 | ○ |
| C-03 | Barrier(32767)でインスタンス生成可能（MAX_PARTICIPANTS） | E-01 L117 (MAX_PARTICIPANTS=0x7FFF=32767) | ○ |
| C-04 | Barrier(-1)でArgumentOutOfRangeException | E-01 L221, E-08 L29 | ○ |
| C-05 | Barrier(32768)でArgumentOutOfRangeException | E-01 L222 (ThrowIfGreaterThan) | ○ |
| C-06 | postPhaseAction=nullでも生成可能 | E-01 L231 (null判定あり) | ○ |
| C-07 | postPhaseAction設定可能 | E-01 L219-237 | ○ |
| C-08 | ParticipantCountプロパティ | E-01 L176-179, E-07 L15 | ○ |
| C-09 | ParticipantsRemainingプロパティ | E-01 L162-170, E-07 L16 | ○ |
| C-10 | CurrentPhaseNumber初期値0 | E-01 L184-190 | ○ |
| C-11 | AddParticipant正常動作 | E-01 L290-300, E-08 L117 | ○ |
| C-12 | AddParticipant最大超過でInvalidOperationException | E-08 L130-134 | ○ |
| C-13 | AddParticipant Dispose後ObjectDisposedException | E-01 L323 | ○ |
| C-14 | AddParticipants複数追加 | E-01 L321-388, E-08 L117 | ○ |
| C-15 | AddParticipants(0)でArgumentOutOfRangeException | E-01 L325, E-08 L123 | ○ |
| C-16 | AddParticipants(-1)でArgumentOutOfRangeException | E-08 L124 | ○ |
| C-17 | RemoveParticipant正常動作 | E-01 L400-403, E-08 L137-143 | ○ |
| C-18 | RemoveParticipant(0参加者)でArgumentOutOfRangeException | E-08 L143 | ○ |
| C-19 | RemoveParticipants複数削除 | E-01 L417-466, E-08 L208-209 | ○ |
| C-20 | RemoveParticipants(0)でArgumentOutOfRangeException | E-01 L421, E-08 L215 | ○ |
| C-21 | RemoveParticipants超過でArgumentOutOfRangeException | E-01 L438-442, E-08 L217 | ○ |
| C-22 | SignalAndWait()正常動作 | E-01 L481-513, E-08 L56 | ○ |
| C-23 | SignalAndWait(Timeout.Infinite)正常動作 | E-01 L596-599 | ○ |
| C-24 | SignalAndWait(0)タイムアウト | E-08 L58 | ○ |
| C-25 | SignalAndWait(-2)でArgumentOutOfRangeException | E-01 L630-633, E-08 L65 | ○ |
| C-26 | SignalAndWait(参加者0)でInvalidOperationException | E-01 L656-658, E-08 L255-260 | ○ |
| C-27 | SignalAndWait(TimeSpan)正常動作 | E-01 L536-539 | ○ |
| C-28 | SignalAndWait(負TimeSpan)でArgumentOutOfRangeException | E-01 L569-573 | ○ |
| C-29 | SignalAndWait(CancellationToken)正常動作 | E-01 L504-513 | ○ |
| C-30 | SignalAndWaitキャンセルでOperationCanceledException | E-01 L628, E-08 L384-395 | ○ |
| C-31 | Dispose正常動作 | E-01 L908-917 | ○ |
| C-32 | Dispose後ObjectDisposedException | E-01 L627, E-08 L250-252 | ○ |
| C-33 | postPhaseAction実行 | E-01 L768-802, E-08 L295-327 | ○ |
| C-34 | postPhaseAction例外でBarrierPostPhaseException | E-01 L786-796, E-08 L317-321 | ○ |
| C-35 | postPhaseAction内SignalAndWaitでInvalidOperationException | E-01 L637-639, E-08 L361-365 | ○ |
| C-36 | postPhaseAction内DisposeでInvalidOperationException | E-01 L911-913, E-08 L364-365 | ○ |
| C-37 | postPhaseAction内AddParticipantでInvalidOperationException | E-01 L329-331, E-08 L367-368 | ○ |
| C-38 | BarrierPostPhaseException()コンストラクタ | E-01 L31-34, E-08 L447 | ○ |
| C-39 | BarrierPostPhaseException(string)コンストラクタ | E-01 L49-52, E-08 L449 | ○ |
| C-40 | BarrierPostPhaseException(Exception)コンストラクタ | E-01 L40-43, E-08 L450-451 | ○ |
| C-41 | BarrierPostPhaseException(string, Exception)コンストラクタ | E-01 L59-62, E-08 L452-453 | ○ |

### CountdownEvent クラス (UT-THR-042 〜 UT-THR-083)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | CountdownEvent(0)でIsSet=true | E-02 L59-62, E-09 L13 | ○ |
| C-43 | CountdownEvent(1)正常生成 | E-02 L48-63 | ○ |
| C-44 | CountdownEvent(1024*1024)正常生成 | E-09 L15-24 | ○ |
| C-45 | CountdownEvent(-1)でArgumentOutOfRangeException | E-02 L50, E-09 L77 | ○ |
| C-46 | CurrentCountプロパティ | E-02 L71-78, E-07 L67 | ○ |
| C-47 | InitialCountプロパティ | E-02 L86-89, E-07 L68 | ○ |
| C-48 | IsSet(カウント0)=true | E-02 L95-105 | ○ |
| C-49 | IsSet(カウント1以上)=false | E-02 L95-105 | ○ |
| C-50 | WaitHandle取得可能 | E-02 L117-124, E-07 L70 | ○ |
| C-51 | WaitHandle Dispose後ObjectDisposedException | E-02 L121 | ○ |
| C-52 | Signal()カウント減少 | E-02 L173-197 | ○ |
| C-53 | Signal()最後でtrue返却 | E-02 L184-187 | ○ |
| C-54 | Signal()カウント0でInvalidOperationException | E-02 L178-181, E-09 L84-86 | ○ |
| C-55 | Signal() Dispose後ObjectDisposedException | E-02 L175 | ○ |
| C-56 | Signal(int)複数減少 | E-02 L214-251 | ○ |
| C-57 | Signal(0)でArgumentOutOfRangeException | E-02 L216, E-09 L81-82 | ○ |
| C-58 | Signal(超過)でInvalidOperationException | E-02 L228-230, E-09 L88-90 | ○ |
| C-59 | AddCount()カウント増加 | E-02 L263-266 | ○ |
| C-60 | AddCount() IsSet=trueでInvalidOperationException | E-02 L297-300, E-09 L95-97 | ○ |
| C-61 | AddCount(int)複数増加 | E-02 L295-301 | ○ |
| C-62 | AddCount(0)でArgumentOutOfRangeException | E-02 L320, E-09 L92-93 | ○ |
| C-63 | AddCount(オーバーフロー)でInvalidOperationException | E-02 L335-337, E-09 L99-101 | ○ |
| C-64 | TryAddCount()成功時true | E-02 L277-280 | ○ |
| C-65 | TryAddCount() IsSet=trueでfalse | E-02 L331-333 | ○ |
| C-66 | TryAddCount(int)成功時true | E-02 L318-350 | ○ |
| C-67 | TryAddCount(0)でArgumentOutOfRangeException | E-02 L320 | ○ |
| C-68 | Reset() InitialCountに戻る | E-02 L361-364, E-09 L57-59 | ○ |
| C-69 | Reset(int)指定値に設定 | E-02 L378-395 | ○ |
| C-70 | Reset(0)でIsSet=true | E-02 L387-389 | ○ |
| C-71 | Reset(-1)でArgumentOutOfRangeException | E-02 L382, E-09 L103-105 | ○ |
| C-72 | Reset Dispose後ObjectDisposedException | E-02 L380 | ○ |
| C-73 | Wait() IsSet=trueで即戻り | E-02 L409-412, L548 | ○ |
| C-74 | Wait() Dispose後ObjectDisposedException | E-02 L541, E-09 L124-125 | ○ |
| C-75 | Wait(0)でfalse | E-09 L68 | ○ |
| C-76 | Wait(100)でfalse（未設定） | E-09 L68 | ○ |
| C-77 | Wait(-2)でArgumentOutOfRangeException | E-02 L539, E-09 L107-108 | ○ |
| C-78 | Wait(TimeSpan)正常動作 | E-02 L457-464 | ○ |
| C-79 | Wait(負TimeSpan)でArgumentOutOfRangeException | E-02 L460, E-09 L110-111 | ○ |
| C-80 | Wait(TimeSpan.MaxValue)でArgumentOutOfRangeException | E-02 L461, E-09 L113-114 | ○ |
| C-81 | Wait(CancellationToken)正常動作 | E-02 L435-438 | ○ |
| C-82 | Wait(キャンセル済みToken)でOperationCanceledException | E-02 L542 | ○ |
| C-83 | Dispose正常動作 | E-02 L133-141 | ○ |

### ReaderWriterLock クラス (UT-THR-084 〜 UT-THR-114)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | ReaderWriterLock()コンストラクタ | E-03 L47-50 | ○ |
| C-85 | IsReaderLockHeld未取得=false | E-03 L52-63 | ○ |
| C-86 | IsReaderLockHeld取得後=true | E-03 L52-63, L274 | ○ |
| C-87 | IsWriterLockHeld未取得=false | E-03 L65 | ○ |
| C-88 | IsWriterLockHeld取得後=true | E-03 L65, L435-437 | ○ |
| C-89 | WriterSeqNum初期値=1 | E-03 L44 | ○ |
| C-90 | WriterSeqNum書き込み後インクリメント | E-03 L437 | ○ |
| C-91 | AcquireReaderLock(int)正常取得 | E-03 L77-275 | ○ |
| C-92 | AcquireReaderLockネスト対応 | E-03 L90-99 | ○ |
| C-93 | AcquireReaderLock(-2)でArgumentOutOfRangeException | E-03 L80 | ○ |
| C-94 | AcquireReaderLock(TimeSpan)正常取得 | E-03 L277-278 | ○ |
| C-95 | AcquireWriterLock(int)正常取得 | E-03 L280-439 | ○ |
| C-96 | AcquireWriterLockネスト対応 | E-03 L292-299 | ○ |
| C-97 | AcquireWriterLock(-2)でArgumentOutOfRangeException | E-03 L282 | ○ |
| C-98 | AcquireWriterLock(TimeSpan)正常取得 | E-03 L441 | ○ |
| C-99 | ReleaseReaderLock正常解放 | E-03 L443-561 | ○ |
| C-100 | ReleaseReaderLock未取得でApplicationException | E-03 L452-456 | △ |
| C-101 | ReleaseWriterLock正常解放 | E-03 L563-663 | ○ |
| C-102 | ReleaseWriterLock未取得でApplicationException | E-03 L565-568 | △ |
| C-103 | UpgradeToWriterLock正常昇格 | E-03 L665-740 | ○ |
| C-104 | UpgradeToWriterLock未ロックから | E-03 L686-689 | ○ |
| C-105 | UpgradeToWriterLock(-2)でArgumentOutOfRangeException | E-03 L668 | ○ |
| C-106 | DowngradeFromWriterLock正常降格 | E-03 L745-870 | ○ |
| C-107 | DowngradeFromWriterLock未取得で例外 | E-03 L748-751 | △ |
| C-108 | ReleaseLock正常解放 | E-03 L872-908 | ○ |
| C-109 | ReleaseLock未ロック時OwnedNone | E-03 L890-895 | ○ |
| C-110 | RestoreLock正常復元 | E-03 L910-971 | ○ |
| C-111 | RestoreLock別スレッドで例外 | E-03 L914-918 | △ |
| C-112 | RestoreLockロック保持中でSynchronizationLockException | E-03 L920-923 | ○ |
| C-113 | AnyWritersSince書き込みあり=true | E-03 L68-75 | ○ |
| C-114 | AnyWritersSince書き込みなし=false | E-03 L68-75 | ○ |

### LockCookie 構造体 (UT-THR-115 〜 UT-THR-120)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115 | Equals(object)同一=true | E-04 L22-23 | ○ |
| C-116 | Equals(object)異なる=false | E-04 L22-23 | ○ |
| C-117 | Equals(LockCookie)同一=true | E-04 L25-29 | ○ |
| C-118 | GetHashCode取得可能 | E-04 L19-20 | ○ |
| C-119 | operator ==同一=true | E-04 L31 | ○ |
| C-120 | operator !=異なる=true | E-04 L33 | ○ |

### HostExecutionContext クラス (UT-THR-121 〜 UT-THR-126)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | HostExecutionContext()コンストラクタ | E-05 L8-10 | ○ |
| C-122 | HostExecutionContext(object)コンストラクタ | E-05 L12-15 | ○ |
| C-123 | Stateプロパティ | E-05 L17-21 | ○ |
| C-124 | CreateCopyメソッド | E-05 L23-26 | ○ |
| C-125 | Disposeメソッド | E-05 L28-31 | ○ |
| C-126 | Dispose(bool)メソッド | E-05 L33-35 | ○ |

### HostExecutionContextManager クラス (UT-THR-127 〜 UT-THR-133)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | コンストラクタ | E-06 | ○ |
| C-128 | Capture=null（非ホスト） | E-06 L16-20 | ○ |
| C-129 | SetHostExecutionContext正常 | E-06 L22-32 | ○ |
| C-130 | SetHostExecutionContext(null)でInvalidOperationException | E-06 L24-27 | ○ |
| C-131 | Revert正常 | E-06 L34-52 | ○ |
| C-132 | Revert(null)でInvalidOperationException | E-06 L36-41 | ○ |
| C-133 | Revert別スレッドでInvalidOperationException | E-06 L43-47 | △ |

## 4) 不足情報（Unknown / Missing）

- **UT-THR-100, UT-THR-102**: ReaderWriterLockのReleaseReaderLock/ReleaseWriterLockの未取得時例外について、内部クラス`ReaderWriterLockApplicationException`（ApplicationException継承）を使用しており、正確な例外型名の確認が必要
  - 候補：ApplicationException / ReaderWriterLockApplicationException / SynchronizationLockException

- **UT-THR-107**: DowngradeFromWriterLockの無効なLockCookieに対する例外型の確認
  - 候補：ApplicationException / InvalidOperationException

- **UT-THR-111, UT-THR-133**: マルチスレッド環境でのLockCookie/Revertの挙動は実行時テストでの確認が必要
  - 候補：実行時テスト / モックテスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2 (高) | ReaderWriterLockのタイムアウト処理 | デッドロックのリスクがあるため、タイムアウト値の境界値テストが重要 |
| 2 (高) | Barrierの並行処理テスト | 複数スレッドの同期に関するため、レースコンディションの検証が必要 |
| 1 (中) | CountdownEventのオーバーフロー | int.MaxValue近傍の境界値テストが必要 |
| 1 (中) | HostExecutionContextManagerのスレッドローカル動作 | AsyncLocalベースの実装のため、ExecutionContext流れの検証が必要 |
| 0 (低) | LockCookie構造体の等値比較 | 単純な構造体比較 |
| 0 (低) | HostExecutionContextの基本操作 | 単純なPOCO操作 |

## 6) レビュアーチェックリスト（最小）

- [ ] Barrierのコンストラクタ境界値（0, MAX_PARTICIPANTS, MAX_PARTICIPANTS+1）が網羅されているか
- [ ] CountdownEventのSignal/AddCountのオーバーフロー境界値が適切か
- [ ] ReaderWriterLockの例外型（ApplicationException派生）が正確か確認
- [ ] postPhaseAction内での禁止操作（SignalAndWait, Dispose, Add/RemoveParticipant）がすべて網羅されているか
- [ ] CancellationTokenのキャンセル時の挙動が正しく記述されているか
- [ ] Dispose後のObjectDisposedException発生箇所が網羅されているか
- [ ] マルチスレッドテストケースの前提条件が実行可能か確認
