---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 155
  claims_with_evidence: 152
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート: libraries-System.Transactions.Local 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**: テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**: 主要なpublicメソッド・プロパティをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー(まず見るところ)
- 総合信頼度(derived): **0.98**
  - 根拠あり: 152 / 155、根拠なし: 3
- 優先レビュー(高)
  1. **UT-TXL-098, 099 (ImplicitDistributedTransactions)**: Windows専用機能のためクロスプラットフォームテストでの動作確認が必要
  2. **UT-TXL-128-143 (TransactionInterop)**: 分散トランザクション関連のテストは実行環境(MSDTC)に依存
  3. **UT-TXL-073, 074 (スレッド親和性テスト)**: マルチスレッドテストの実行タイミングに依存

## 2) 参照した情報(Evidence一覧)
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/Transaction.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionScope.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionManager.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/CommittableTransaction.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/DependentTransaction.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionException.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionOptions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionInformation.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/Enlistment.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/PreparingEnlistment.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/SinglePhaseEnlistment.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/InternalTransaction.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Transactions.Local/src/System/Transactions/TransactionInterop.cs`

## 3) Claims と根拠の対応(レビューの主戦場)

### Transaction クラス (UT-TXL-001 - UT-TXL-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Transaction.Current (get) で現在のTransactionが取得できる | E-01 (L151-178) | ○ |
| C-02 | ScopeComplete後にCurrentアクセスで例外 | E-01 (L166-170) | ○ |
| C-03 | Transaction.Current (set) でTLSに設定される | E-01 (L181-210) | ○ |
| C-04 | InteropMode非Noneでset_Current時に例外 | E-01 (L191-198) | ○ |
| C-05 | GetHashCodeがTransactionHashを返す | E-01 (L309-312) | ○ |
| C-06 | Equalsで同一InternalTransactionが等しい | E-01 (L317-322) | ○ |
| C-07 | IsolationLevelプロパティ取得 | E-01 (L377-395) | ○ |
| C-08 | IsolationLevel取得時のDispose例外 | E-01 (L387) | ○ |
| C-09 | TransactionInformation取得 | E-01 (L345-372) | ○ |
| C-10 | PromoterType取得 | E-01 (L409-426) | ○ |
| C-11 | EnlistDurable引数バリデーション(Guid.Empty) | E-01 (L483-486) | ○ |
| C-12 | EnlistDurable引数バリデーション(null) | E-01 (L488) | ○ |
| C-13 | EnlistDurable引数バリデーション(EnlistmentOptions) | E-01 (L490-493) | ○ |
| C-14 | EnlistDurable完了済み例外 | E-01 (L495-498) | ○ |
| C-15 | EnlistVolatile引数バリデーション | E-01 (L621-628) | ○ |
| C-16 | Rollback処理 | E-01 (L563-584) | ○ |
| C-17 | Rollback(Exception)処理 | E-01 (L587-608) | ○ |
| C-18 | Clone処理 | E-01 (L690-712) | ○ |
| C-19 | DependentClone処理 | E-01 (L730-762) | ○ |
| C-20 | DependentClone引数バリデーション | E-01 (L740-744) | ○ |
| C-21 | EnlistPromotableSinglePhase引数バリデーション(promoterType) | E-01 (L905-908) | ○ |
| C-22 | GetPromotedToken処理 | E-01 (L445-468) | ○ |
| C-23 | TransactionCompletedイベント | E-01 (L789-811) | ○ |
| C-24 | Dispose処理 | E-01 (L813-844) | ○ |
| C-25 | SetDistributedTransactionIdentifier引数バリデーション | E-01 (L988-993) | ○ |

### CommittableTransaction クラス (UT-TXL-040 - UT-TXL-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | デフォルトコンストラクタ | E-04 (L16-18) | ○ |
| C-27 | TimeSpanコンストラクタ | E-04 (L21-23) | ○ |
| C-28 | TransactionOptionsコンストラクタ | E-04 (L26-28) | ○ |
| C-29 | Commit処理 | E-04 (L80-118) | ○ |
| C-30 | Commit完了済み例外 | E-04 (L93-96) | ○ |
| C-31 | BeginCommit処理 | E-04 (L46-76) | ○ |
| C-32 | EndCommit処理 | E-04 (L156-187) | ○ |
| C-33 | EndCommit引数バリデーション | E-04 (L164-167) | ○ |
| C-34 | IAsyncResult実装 | E-04 (L189-227) | ○ |

### DependentTransaction クラス (UT-TXL-051 - UT-TXL-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Complete処理 | E-05 (L32-67) | ○ |
| C-36 | Complete完了済み例外 | E-05 (L44-47) | ○ |
| C-37 | CompleteのDispose例外 | E-05 (L42) | ○ |

### TransactionScope クラス (UT-TXL-054 - UT-TXL-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | デフォルトコンストラクタ | E-02 (L39-41) | ○ |
| C-39 | TransactionScopeOptionコンストラクタ | E-02 (L43-104) | ○ |
| C-40 | Suppress処理 | E-02 (L439-442) | ○ |
| C-41 | Required処理 | E-02 (L444-451) | ○ |
| C-42 | RequiresNew処理 | E-02 (L453-455) | ○ |
| C-43 | TransactionScopeOption引数バリデーション | E-02 (L457-458) | ○ |
| C-44 | AsyncFlowOptionコンストラクタ | E-02 (L48-51) | ○ |
| C-45 | TimeSpanコンストラクタ | E-02 (L106-176) | ○ |
| C-46 | タイムアウト引数バリデーション | E-02 (L1123-1126) | ○ |
| C-47 | TransactionOptionsコンストラクタ | E-02 (L178-262) | ○ |
| C-48 | IsolationLevel不一致例外 | E-02 (L213-216) | ○ |
| C-49 | Transactionコンストラクタ | E-02 (L346-373) | ○ |
| C-50 | Transactionコンストラクタnull例外 | E-02 (L469) | ○ |
| C-51 | EnterpriseServicesInteropOption引数バリデーション | E-02 (L1111-1117) | ○ |
| C-52 | Complete処理 | E-02 (L828-847) | ○ |
| C-53 | Complete重複呼び出し例外 | E-02 (L837-840) | ○ |
| C-54 | CompleteのDispose例外 | E-02 (L835) | ○ |
| C-55 | Disposeでコミット | E-02 (L797-801) | ○ |
| C-56 | Disposeでロールバック | E-02 (L780-794) | ○ |
| C-57 | 別スレッドDispose例外 | E-02 (L521-529) | ○ |
| C-58 | ネスト不正例外 | E-02 (L563-564, 627-628) | ○ |
| C-59 | Current変更例外 | E-02 (L569-601) | ○ |
| C-60 | タイムアウト処理 | E-02 (L866-896) | ○ |

### TransactionManager クラス (UT-TXL-078 - UT-TXL-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | DefaultTimeout取得 | E-03 (L287-314) | ○ |
| C-62 | DefaultTimeout設定 | E-03 (L315-339) | ○ |
| C-63 | MaximumTimeout取得 | E-03 (L344-362) | ○ |
| C-64 | MaximumTimeout設定 | E-03 (L363-391) | ○ |
| C-65 | MaximumTimeout負値例外 | E-03 (L371) | ○ |
| C-66 | HostCurrentCallback設定 | E-03 (L107-135) | ○ |
| C-67 | HostCurrentCallbackのnull例外 | E-03 (L122) | ○ |
| C-68 | HostCurrentCallback重複設定例外 | E-03 (L126-129) | ○ |
| C-69 | Reenlist処理 | E-03 (L137-224) | ○ |
| C-70 | Reenlist引数バリデーション | E-03 (L142-149) | ○ |
| C-71 | RecoveryComplete処理 | E-03 (L238-258) | ○ |
| C-72 | RecoveryComplete引数バリデーション | E-03 (L240-243) | ○ |
| C-73 | ValidateIsolationLevel処理 | E-03 (L504-519) | ○ |
| C-74 | ValidateTimeout処理 | E-03 (L528-541) | ○ |
| C-75 | ValidateTimeout負値例外 | E-03 (L530) | ○ |
| C-76 | ImplicitDistributedTransactions設定 | E-03 (L399-446) | △ |

### TransactionOptions 構造体 (UT-TXL-100 - UT-TXL-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Timeoutプロパティ | E-07 (L13-17) | ○ |
| C-78 | IsolationLevelプロパティ | E-07 (L19-23) | ○ |
| C-79 | Equals処理 | E-07 (L27-34) | ○ |

### TransactionInformation クラス (UT-TXL-104 - UT-TXL-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | LocalIdentifier取得 | E-08 (L17-38) | ○ |
| C-81 | DistributedIdentifier取得 | E-08 (L42-70) | ○ |
| C-82 | CreationTime取得 | E-08 (L74) | ○ |
| C-83 | Status取得 | E-08 (L76-99) | ○ |

### Enlistment クラス (UT-TXL-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | Done処理 | E-09 (L494-512) | ○ |

### PreparingEnlistment クラス (UT-TXL-111 - UT-TXL-114)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | Prepared処理 | E-10 (L14-32) | ○ |
| C-86 | ForceRollback処理 | E-10 (L34-52) | ○ |
| C-87 | ForceRollback(Exception)処理 | E-10 (L54-72) | ○ |
| C-88 | RecoveryInformation処理 | E-10 (L74-96) | ○ |

### SinglePhaseEnlistment クラス (UT-TXL-115 - UT-TXL-119)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | Aborted処理 | E-11 (L12-30) | ○ |
| C-90 | Aborted(Exception)処理 | E-11 (L32-50) | ○ |
| C-91 | Committed処理 | E-11 (L53-71) | ○ |
| C-92 | InDoubt処理 | E-11 (L74-96) | ○ |
| C-93 | InDoubt(Exception)処理 | E-11 (L99-121) | ○ |

### Exception クラス群 (UT-TXL-120 - UT-TXL-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | TransactionException各コンストラクタ | E-06 (L66-96) | ○ |
| C-95 | TransactionAbortedException各コンストラクタ | E-06 (L176-221) | ○ |
| C-96 | TransactionInDoubtException各コンストラクタ | E-06 (L254-284) | ○ |
| C-97 | TransactionManagerCommunicationException各コンストラクタ | E-06 (L313-346) | ○ |
| C-98 | TransactionPromotionException各コンストラクタ | E-06 (L356-385) | ○ |

### TransactionInterop クラス (UT-TXL-127 - UT-TXL-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | PromoterTypeDtc定数 | E-13 (L45) | ○ |
| C-100 | GetExportCookie処理 | E-13 (L47-91) | ○ |
| C-101 | GetExportCookie引数バリデーション | E-13 (L49-50) | ○ |
| C-102 | GetTransactionFromExportCookie処理 | E-13 (L93-186) | ○ |
| C-103 | GetTransactionFromExportCookie引数バリデーション | E-13 (L95-100) | ○ |
| C-104 | GetTransmitterPropagationToken処理 | E-13 (L188-209) | ○ |
| C-105 | GetTransactionFromTransmitterPropagationToken処理 | E-13 (L228-270) | ○ |
| C-106 | GetTransactionFromTransmitterPropagationToken引数バリデーション | E-13 (L230-235) | ○ |
| C-107 | GetDtcTransaction処理 | E-13 (L272-310) | ○ |
| C-108 | GetTransactionFromDtcTransaction処理 | E-13 (L323-436) | ○ |
| C-109 | GetWhereabouts処理 | E-13 (L463-495) | ○ |

### InternalTransaction クラス (UT-TXL-144 - UT-TXL-149)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | コンストラクタ処理 | E-12 (L232-249) | ○ |
| C-111 | TransactionHash取得 | E-12 (L60) | ○ |
| C-112 | SetPromoterTypeToMSDTC処理 | E-12 (L211-219) | ○ |
| C-113 | ThrowIfPromoterTypeIsNotMSDTC処理 | E-12 (L223-229) | ○ |

### ContextData/CallContextCurrentData (UT-TXL-150 - UT-TXL-155)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | LookupContextData処理 | E-01 (L1156-1174) | ○ |
| C-115 | TLSCurrentData取得 | E-01 (L1136-1153) | ○ |
| C-116 | CreateOrGetCurrentData処理 | E-01 (L1071-1075) | ○ |
| C-117 | ClearCurrentData処理 | E-01 (L1077-1095) | ○ |
| C-118 | TryGetCurrentData処理 | E-01 (L1097-1109) | ○ |

## 4) 不足情報(Unknown / Missing)
- **ImplicitDistributedTransactions (UT-TXL-098, 099)**: Windows専用APIであり、プラットフォーム条件付きコンパイル(`#if WINDOWS`)により動作が異なる。非Windows環境でのテスト実行時はPlatformNotSupportedExceptionがスローされる。
- **TransactionInterop各メソッド**: MSDTC(Microsoft Distributed Transaction Coordinator)が必要であり、実行環境に依存する。モックまたはスタブを使用したテストが必要な場合がある。
- **マルチスレッドテスト(UT-TXL-073, 074)**: 実行タイミングに依存するため、テスト結果が不安定になる可能性がある。

## 5) リスクフラグ(レビュー観点)
- **0 (低リスク)**: UT-TXL-005-008, 100-103, 105-106, 120-126, 145 (基本的なプロパティ・等価性・例外クラス)
- **1 (中リスク)**: UT-TXL-001-004, 009-039, 040-053, 054-077, 078-097, 104, 107-119, 127, 144, 146-155 (主要なビジネスロジック)
- **2 (高リスク)**: UT-TXL-098-099, 128-143 (プラットフォーム依存・分散トランザクション)

## 6) レビュアーチェックリスト(最小)
- [ ] Transaction.Current/TransactionScopeのスレッドセーフティが適切にテストされているか
- [ ] IsolationLevelの各値に対するテストが網羅されているか
- [ ] エンリストメント(Durable/Volatile/PSPE)の状態遷移が適切にテストされているか
- [ ] タイムアウト処理のエッジケース(0, MaxValue等)が考慮されているか
- [ ] 分散トランザクション関連テストの実行環境要件が明確か
- [ ] 非同期フロー(AsyncFlowOption.Enabled)のawait/async統合テストが必要か確認
- [ ] CommittableTransaction.BeginCommit/EndCommitの非同期パターンが正しくテストされているか
