---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 135
  claims_with_evidence: 135
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Web.HttpUtility 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：対象モジュールのpublicメソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：135 / 135、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードまたは既存テストに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/src/System/Web/HttpUtility.cs` - HttpUtilityクラスの実装
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/src/System/Web/Util/HttpEncoder.cs` - HttpEncoder内部クラスの実装
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/src/System/Web/Util/UriUtil.cs` - UriUtil内部クラスの実装
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/src/System/Web/IHtmlString.cs` - IHtmlStringインターフェース定義
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/ref/System.Web.HttpUtility.cs` - API参照ファイル
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Web.HttpUtility/tests/HttpUtility/HttpUtilityTest.cs` - 既存テストファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### HtmlAttributeEncode メソッド（UT-HTP-001 - UT-HTP-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 空文字列がそのまま返却される | E-02 (L32-37: IsNullOrEmpty check) | ○ |
| C-02 | <が&lt;にエンコードされる | E-02 (L82-84: case '<') | ○ |
| C-03 | ダブルクォートが&quot;にエンコードされる | E-02 (L85-86: case '"') | ○ |
| C-04 | シングルクォートが&#39;にエンコードされる | E-02 (L87-89: case '\'') | ○ |
| C-05 | &が&amp;にエンコードされる | E-02 (L90-92: case '&') | ○ |
| C-06 | エンコード不要文字がそのまま返却される | E-02 (L40-44: pos < 0 check), E-06 (L53) | ○ |
| C-07 | nullがnullで返却される | E-02 (L32-37), E-06 (L58) | ○ |
| C-08 | TextWriterがnullでArgumentNullException | E-02 (L58), E-06 (L65-72) | ○ |
| C-09 | nullが渡された場合何も書き込まれない | E-02 (L53-56) | ○ |
| C-10 | エンコード結果がTextWriterに書き込まれる | E-02 (L51-68), E-06 (L74-82) | ○ |

### HtmlDecode メソッド（UT-HTP-011 - UT-HTP-018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 空文字列がそのまま返却される | E-02 (L107: IsNullOrEmpty) | ○ |
| C-12 | &lt;が<にデコードされる | E-02 (L107: WebUtility.HtmlDecode), E-06 (L86-92) | ○ |
| C-13 | 名前付きエンティティがデコードされる | E-06 (L95-175: HtmlDecodingData) | ○ |
| C-14 | 数値文字参照(10進)がデコードされる | E-06 (L157-158) | ○ |
| C-15 | 数値文字参照(16進)がデコードされる | E-06 (L165-174) | ○ |
| C-16 | 不正なエンティティがそのまま返却される | E-06 (L150-154) | ○ |
| C-17 | nullがnullで返却される | E-02 (L107) | ○ |
| C-18 | TextWriterがnullでArgumentNullException | E-02 (L111), E-06 (L185-192) | ○ |

### HtmlEncode メソッド（UT-HTP-019 - UT-HTP-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | 空文字列がそのまま返却される | E-02 (L117: IsNullOrEmpty) | ○ |
| C-20 | <が&lt;にエンコードされる | E-02 (L117: WebUtility.HtmlEncode), E-06 (L86-91) | ○ |
| C-21 | >が&gt;にエンコードされる | E-06 (L90) | ○ |
| C-22 | &が&amp;にエンコードされる | E-06 (L208-250) | ○ |
| C-23 | ダブルクォートが&quot;にエンコードされる | E-06 (L208-250) | ○ |
| C-24 | nullがnullで返却される | E-02 (L117), E-06 (L263) | ○ |
| C-25 | 整数値が文字列としてエンコードされる | E-01 (L145-151), E-06 (L261) | ○ |
| C-26 | IHtmlStringのToHtmlStringが使用される | E-01 (L149), E-06 (L287-294) | ○ |
| C-27 | object nullでnullが返却される | E-01 (L148), E-06 (L263) | ○ |
| C-28 | ToStringがnullを返すと空文字が返る | E-01 (L150), E-06 (L246-251) | ○ |
| C-29 | TextWriterがnullでArgumentNullException | E-02 (L121), E-06 (L278-285) | ○ |

### JavaScriptStringEncode メソッド（UT-HTP-030 - UT-HTP-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | エスケープ不要文字がそのまま返却される | E-02 (L131-134), E-06 (L311) | ○ |
| C-31 | タブが\\tにエスケープされる | E-02 (L158-159), E-06 (L327-328) | ○ |
| C-32 | 改行が\\nにエスケープされる | E-02 (L167-168), E-06 (L329-330) | ○ |
| C-33 | 復帰が\\rにエスケープされる | E-02 (L155-156), E-06 (L312) | ○ |
| C-34 | ダブルクォートが\\"にエスケープされる | E-02 (L161-162), E-06 (L339-340) | ○ |
| C-35 | バックスラッシュが\\\\にエスケープされる | E-02 (L164-165), E-06 (L342-343) | ○ |
| C-36 | バックスペースが\\bにエスケープされる | E-02 (L170-171), E-06 (L324-325) | ○ |
| C-37 | フォームフィードが\\fにエスケープされる | E-02 (L173-174), E-06 (L333-334) | ○ |
| C-38 | <が\\u003cにエスケープされる | E-02 (L27, L176-178), E-06 (L313) | ○ |
| C-39 | &が\\u0026にエスケープされる | E-02 (L27), E-06 (L316-318) | ○ |
| C-40 | シングルクォートが\\u0027にエスケープされる | E-02 (L27), E-06 (L316-318) | ○ |
| C-41 | U+2028が\\u2028にエスケープされる | E-02 (L29), E-06 (L316-318) | ○ |
| C-42 | U+2029が\\u2029にエスケープされる | E-02 (L29), E-06 (L316-318) | ○ |
| C-43 | nullで空文字が返却される | E-02 (L134), E-06 (L309) | ○ |
| C-44 | addDoubleQuotes=trueでクォート付加 | E-02 (L142-145, L187-190), E-06 (L361-366) | ○ |
| C-45 | addDoubleQuotes=falseでクォートなし | E-02 (L134), E-06 (L369-374) | ○ |

### ParseQueryString メソッド（UT-HTP-046 - UT-HTP-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | 単一key=valueがパースされる | E-01 (L83-134), E-06 (L386) | ○ |
| C-47 | 複数key=valueがパースされる | E-06 (L387) | ○ |
| C-48 | 同一キーの複数値がパースされる | E-06 (L388) | ○ |
| C-49 | キーなし値がnullキーでパースされる | E-01 (L113-116), E-06 (L389) | ○ |
| C-50 | 空文字列で空コレクションが返る | E-01 (L91-94), E-06 (L393) | ○ |
| C-51 | 先頭の?が無視される | E-01 (L90), E-06 (L408-414) | ○ |
| C-52 | URLエンコード値がデコードされる | E-01 (L120, L129), E-06 (L396-401) | ○ |
| C-53 | +がスペースにデコードされる | E-06 (L405) | ○ |
| C-54 | =を含む値が正しくパースされる | E-01 (L101-103), E-06 (L402) | ○ |
| C-55 | nullでArgumentNullException | E-01 (L85), E-06 (L431-438) | ○ |
| C-56 | EncodingがnullでArgumentNullException | E-01 (L86), E-06 (L440-447) | ○ |
| C-57 | 指定Encodingでデコードされる | E-01 (L83-134) | ○ |
| C-58 | 空コレクションのToStringが空文字を返す | E-01 (L52-56), E-06 (L450-453) | ○ |
| C-59 | ToStringでURLエンコードされた文字列が返る | E-01 (L58-77), E-06 (L454-458) | ○ |
| C-60 | null値がスキップされる | E-06 (L463-469) | ○ |

### UrlDecode メソッド（UT-HTP-061 - UT-HTP-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | %XXエンコードがデコードされる | E-02 (L221-231, L360-371), E-06 (L478) | ○ |
| C-62 | +がスペースにデコードされる | E-02 (L217-219, L336-338), E-06 (L486) | ○ |
| C-63 | %uXXXXがデコードされる | E-02 (L269-284, L342-357), E-06 (L483) | ○ |
| C-64 | 二重エンコードが1段階のみデコード | E-06 (L492-495) | ○ |
| C-65 | 不正%シーケンスが保持される | E-06 (L479-482) | ○ |
| C-66 | 末尾の不完全%が保持される | E-02 (L221: i < count - 2) | ○ |
| C-67 | 不正%uシーケンスが保持される | E-06 (L485) | ○ |
| C-68 | サロゲートペアが正しくデコードされる | E-06 (L487) | ○ |
| C-69 | 孤立ハイサロゲートが置換文字になる | E-02 (L683-696), E-06 (L488-489) | ○ |
| C-70 | 孤立ローサロゲートが置換文字になる | E-02 (L698-702), E-06 (L490-491) | ○ |
| C-71 | nullがnullで返却される | E-02 (L306-311), E-06 (L524-532) | ○ |
| C-72 | 指定Encodingでデコードされる | E-02 (L306-314) | ○ |
| C-73 | byte[] nullでnullが返却される | E-02 (L240-246), E-06 (L528) | ○ |
| C-74 | 負のoffsetでArgumentOutOfRangeException | E-02 (L605), E-06 (L538) | ○ |
| C-75 | offsetが配列長超でArgumentOutOfRangeException | E-02 (L606), E-06 (L539) | ○ |
| C-76 | countが範囲外でArgumentOutOfRangeException | E-02 (L609), E-06 (L540) | ○ |
| C-77 | countが負でArgumentOutOfRangeException | E-02 (L608), E-06 (L541) | ○ |

### UrlDecodeToBytes メソッド（UT-HTP-078 - UT-HTP-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | 文字列がバイト配列にデコードされる | E-01 (L193-213), E-06 (L544-556) | ○ |
| C-79 | string nullでnullが返却される | E-01 (L193), E-06 (L561-562) | ○ |
| C-80 | byte[] nullでnullが返却される | E-01 (L216), E-06 (L561) | ○ |
| C-81 | 負のoffsetでArgumentOutOfRangeException | E-06 (L572) | ○ |
| C-82 | null bytes, count>0でArgumentNullException | E-02 (L603), E-06 (L565) | ○ |

### UrlEncode メソッド（UT-HTP-083 - UT-HTP-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | 空文字列が空文字列で返却される | E-06 (L627) | ○ |
| C-84 | 安全文字がそのまま返却される | E-02 (L20-21, L419), E-06 (L589-607) | ○ |
| C-85 | 特殊安全文字がそのまま返却される | E-02 (L20-21), E-06 (L595-605) | ○ |
| C-86 | スペースが+にエンコードされる | E-02 (L423-425), E-06 (L615) | ○ |
| C-87 | 非安全ASCII文字が%XXにエンコードされる | E-02 (L427-432), E-06 (L623-633) | ○ |
| C-88 | 非ASCII文字がUTF-8で%XXエンコードされる | E-02 (L459-473), E-06 (L623-633) | ○ |
| C-89 | nullがnullで返却される | E-01 (L167-168), E-06 (L710-717) | ○ |
| C-90 | 指定Encodingでエンコードされる | E-01 (L167-168), E-02 (L459-473) | ○ |
| C-91 | バイト配列がURLエンコードされる | E-01 (L171), E-06 (L703-708) | ○ |
| C-92 | byte[] nullでnullが返却される | E-01 (L171), E-06 (L713) | ○ |
| C-93 | 指定範囲がエンコードされる | E-01 (L174), E-06 (L657-672) | ○ |
| C-94 | 負のoffsetでArgumentOutOfRangeException | E-02 (L605), E-06 (L723) | ○ |
| C-95 | offsetが配列長超でArgumentOutOfRangeException | E-02 (L606), E-06 (L724) | ○ |
| C-96 | countが範囲外でArgumentOutOfRangeException | E-02 (L609), E-06 (L725) | ○ |
| C-97 | countが負でArgumentOutOfRangeException | E-02 (L608), E-06 (L726) | ○ |

### UrlEncodeToBytes メソッド（UT-HTP-098 - UT-HTP-102）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | 文字列がバイト配列にエンコードされる | E-01 (L177, L219), E-06 (L643-655) | ○ |
| C-99 | string nullでnullが返却される | E-01 (L177), E-06 (L688) | ○ |
| C-100 | byte[] nullでnullが返却される | E-01 (L180), E-06 (L687) | ○ |
| C-101 | null bytes, count>0でArgumentNullException | E-02 (L603), E-06 (L690) | ○ |
| C-102 | null bytes, count=0でnullが返却される | E-02 (L598-601), E-06 (L689) | ○ |

### UrlEncodeUnicode メソッド（UT-HTP-103 - UT-HTP-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | 空文字列が空文字列で返却される | E-06 (L737) | ○ |
| C-104 | スペースが+にエンコードされる | E-02 (L497-499), E-06 (L738) | ○ |
| C-105 | 7bit安全文字がそのまま返却される | E-02 (L493-495), E-06 (L739) | ○ |
| C-106 | 7bit非安全文字が%XXにエンコードされる | E-02 (L501-506), E-06 (L741) | ○ |
| C-107 | 非ASCII文字が%uXXXXにエンコードされる | E-02 (L508-515), E-06 (L742-743) | ○ |
| C-108 | nullがnullで返却される | E-02 (L478-482), E-06 (L736) | ○ |
| C-109 | エンコード結果がASCIIバイト配列で返る | E-01 (L184), E-06 (L755-763) | ○ |
| C-110 | nullがnullで返却される | E-01 (L184), E-06 (L736) | ○ |

### UrlPathEncode メソッド（UT-HTP-111 - UT-HTP-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | nullがnullで返却される | E-02 (L524-527), E-06 (L768) | ○ |
| C-112 | 空文字列が空文字列で返却される | E-02 (L524), E-06 (L773) | ○ |
| C-113 | スペースが%20にエンコードされる | E-02 (L552, L575-579), E-06 (L769) | ○ |
| C-114 | 改行が%0aにエンコードされる | E-06 (L770) | ○ |
| C-115 | クエリ文字列がエンコードされない | E-02 (L558-563), E-06 (L771) | ○ |
| C-116 | パス部分のみがエンコードされる | E-02 (L533-541), E-06 (L779) | ○ |
| C-117 | 非ASCII文字がUTF-8でエンコードされる | E-02 (L569-584), E-06 (L778) | ○ |
| C-118 | file://スキームが処理される | E-03, E-06 (L780) | ○ |
| C-119 | mailto:スキームが処理される | E-03, E-06 (L781) | ○ |
| C-120 | ホスト名内非ASCII文字がエンコードされる | E-06 (L782-783) | ○ |

### 内部クラス HttpEncoder（UT-HTP-121 - UT-HTP-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | IndexOfHtmlAttributeEncodingCharsで位置検出 | E-02 (L126-127) | ○ |
| C-122 | UrlDecode: +がスペースにデコード | E-02 (L217-219) | ○ |
| C-123 | UrlDecode: %XXがバイトにデコード | E-02 (L221-231) | ○ |
| C-124 | UrlEncode: エンコード不要バイト列がそのまま返却 | E-02 (L402-406) | ○ |
| C-125 | UrlEncode: スペースが+にエンコード | E-02 (L423-425) | ○ |
| C-126 | UrlPathEncodeImpl: 範囲外文字がエンコード | E-02 (L545-594) | ○ |
| C-127 | ValidateUrlEncodingParameters: null,0でfalse | E-02 (L598-601) | ○ |
| C-128 | ValidateUrlEncodingParameters: null,>0で例外 | E-02 (L603) | ○ |
| C-129 | UrlDecoder: FlushBytesで文字変換 | E-02 (L628-635) | ○ |
| C-130 | UrlDecoder: 不正サロゲートが置換文字に変換 | E-02 (L683-703) | ○ |

### 内部クラス UriUtil（UT-HTP-131 - UT-HTP-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | TrySplitUriForPathEncodeでURL分割 | E-03 (L13-58) | ○ |
| C-132 | #フラグメントが分離される | E-03 (L16-28) | ○ |
| C-133 | 相対URLでfalseが返却される | E-03 (L33, L54-57) | ○ |
| C-134 | authorityが空でfalseが返却される | E-03 (L36-50) | ○ |

### IHtmlString インターフェース（UT-HTP-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | ToHtmlStringメソッドが呼び出し可能 | E-04 (L8-12) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードまたは既存テストコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに根拠あり
- 内部クラス(HttpEncoder, UriUtil, UrlDecoder)のテストケースは間接的にテスト可能であることを確認
- 既存テスト(HttpUtilityTest.cs)で検証済みのパターンを網羅

## 6) レビュアーチェックリスト（最小）
- [x] 全publicメソッドがテストケースでカバーされているか
- [x] 正常系/異常系/境界値の観点が網羅されているか
- [x] XSS対策関連のテストケースが高優先度に設定されているか
- [x] null安全性のテストケースが含まれているか
- [x] 引数検証（ArgumentNullException, ArgumentOutOfRangeException）のテストケースが含まれているか
- [x] エンコーディング指定時の動作確認テストケースが含まれているか
- [x] 既存テストコード(HttpUtilityTest.cs)との整合性が確認されているか
