---
generated_at: 2026-01-30 18:30:00
metrics:
  claims_total: 94
  claims_with_evidence: 91
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Windows.Extensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 91 / 94 = 0.97
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：91 / 94、根拠なし：3
- 優先レビュー（高）
  1. **UT-SWE-068, 070**: X509Certificate2UI.DisplayCertificateのUI表示テストはWindows環境でのみ実行可能
  2. **UT-SWE-072, 073**: SelectFromCollectionのUI表示テストはWindows環境でのみ実行可能
  3. **UT-SWE-090-094**: X509Utils内部メソッドは直接テスト不可の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Media/SoundPlayer.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Media/SystemSound.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Media/SystemSounds.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Security/Cryptography/X509Certificates/X509Certificate2UI.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Security/Cryptography/X509Certificates/X509Utils.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/src/System/Xaml/Permissions/XamlAccessLevel.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/tests/System/Media/SoundPlayerTests.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/tests/System/Media/SystemSoundTests.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/tests/System/Media/SystemSoundsTests.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/tests/X509Certificate2UITests.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/tests/XamlAccessLevelTests.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Windows.Extensions/ref/System.Windows.Extensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SoundPlayer クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SWE-001) | デフォルトコンストラクタで初期状態が正しいこと | E-01 (行49-52), E-07 (行19-29) | ○ |
| C-02 (UT-SWE-002) | Streamを指定してインスタンス生成できること | E-01 (行59-62), E-07 (行37-49) | ○ |
| C-03 (UT-SWE-003) | nullストリームでインスタンス生成できること | E-01 (行59-62), E-07 (行31-35) | ○ |
| C-04 (UT-SWE-004) | 有効なパスでインスタンス生成できること | E-01 (行54-57), E-07 (行51-65) | ○ |
| C-05 (UT-SWE-005) | ファイルパスでインスタンス生成できること | E-01 (行54-57), E-07 (行51-65) | ○ |
| C-06 (UT-SWE-006) | nullでArgumentExceptionがスローされること | E-01 (行54-57), E-07 (行67-73) | ○ |
| C-07 (UT-SWE-007) | 空文字でArgumentExceptionがスローされること | E-01 (行54-57), E-07 (行67-73) | ○ |
| C-08 (UT-SWE-008) | シリアライズコンストラクタでPlatformNotSupportedExceptionがスローされること | E-01 (行64-71) | ○ |
| C-09 (UT-SWE-009) | LoadTimeout=0を設定できること | E-01 (行73-85), E-07 (行323-329) | ○ |
| C-10 (UT-SWE-010) | LoadTimeout正の値を設定できること | E-01 (行73-85), E-07 (行323-329) | ○ |
| C-11 (UT-SWE-011) | 負のLoadTimeoutでArgumentOutOfRangeException | E-01 (行78-81), E-07 (行332-337) | ○ |
| C-12 (UT-SWE-012) | 有効なURLをSoundLocationに設定できること | E-01 (行87-102), E-07 (行339-370) | ○ |
| C-13 (UT-SWE-013) | ファイルURIをSoundLocationに設定できること | E-01 (行87-102), E-07 (行339-370) | ○ |
| C-14 (UT-SWE-014) | 同じ値設定でイベント非発火 | E-01 (行94-97), E-07 (行349-356) | ○ |
| C-15 (UT-SWE-015) | 異なる値設定でイベント発火 | E-01 (行99-100), E-07 (行357-360) | ○ |
| C-16 (UT-SWE-016) | 既存パス設定済みでnull設定時ArgumentException | E-01 (行388-406), E-07 (行372-381) | ○ |
| C-17 (UT-SWE-017) | 既存パス設定済みで空文字設定時ArgumentException | E-01 (行388-406), E-07 (行372-381) | ○ |
| C-18 (UT-SWE-018) | URIが設定されている場合Streamはnullを返す | E-01 (行104-116) | ○ |
| C-19 (UT-SWE-019) | 有効なストリームを設定できること | E-01 (行117-127), E-07 (行390-421) | ○ |
| C-20 (UT-SWE-020) | nullストリームを設定できること | E-01 (行117-127), E-07 (行390-421) | ○ |
| C-21 (UT-SWE-021) | 同じストリーム設定でイベント非発火 | E-01 (行119-122), E-07 (行400-403) | ○ |
| C-22 (UT-SWE-022) | 異なるストリーム設定でイベント発火 | E-01 (行124-126), E-07 (行405-411) | ○ |
| C-23 (UT-SWE-023) | Tag=null設定可能 | E-01 (行131), E-07 (行423-429) | ○ |
| C-24 (UT-SWE-024) | Tag=任意オブジェクト設定可能 | E-01 (行131), E-07 (行423-429) | ○ |
| C-25 (UT-SWE-025) | 有効なWAVファイル読み込み | E-01 (行185-203), E-07 (行87-100) | ○ |
| C-26 (UT-SWE-026) | ストリームから読み込み | E-01 (行185-203), E-07 (行161-177) | ○ |
| C-27 (UT-SWE-027) | 存在しないファイルでFileNotFoundException | E-01 (行192-196), E-07 (行179-184) | ○ |
| C-28 (UT-SWE-028) | nullストリームでNullReferenceException | E-01 (行279), E-07 (行186-194) | ○ |
| C-29 (UT-SWE-029) | 2回連続Load正常 | E-01 (行185-203), E-07 (行87-100) | ○ |
| C-30 (UT-SWE-030) | 非同期ロード正常完了 | E-01 (行133-164), E-07 (行102-143) | ○ |
| C-31 (UT-SWE-031) | ファイルURI即座完了 | E-01 (行137-149) | ○ |
| C-32 (UT-SWE-032) | LoadAsync存在しないファイルでFileNotFoundException | E-01 (行142-146) | ○ |
| C-33 (UT-SWE-033) | ロード中キャンセル | E-01 (行238-242), E-07 (行476-510) | ○ |
| C-34 (UT-SWE-034) | Play正常再生 | E-01 (行345-348), E-07 (行215-228) | ○ |
| C-35 (UT-SWE-035) | Playストリーム再生 | E-01 (行345-348), E-07 (行237-253) | ○ |
| C-36 (UT-SWE-036) | Play未設定時Beep再生 | E-01 (行207-211) | ○ |
| C-37 (UT-SWE-037) | Play存在しないファイルでFileNotFoundException | E-01 (行205-236), E-07 (行230-235) | ○ |
| C-38 (UT-SWE-038) | Play無効WAVでInvalidOperationException | E-01 (行631-702), E-07 (行266-272) | ○ |
| C-39 (UT-SWE-039) | PlaySync動作 | E-01 (行350-353), E-07 (行312-321) | ○ |
| C-40 (UT-SWE-040) | PlaySync null時Beep | E-01 (行207-211), E-07 (行312-321) | ○ |
| C-41 (UT-SWE-041) | PlayLooping開始 | E-01 (行355-358), E-07 (行285-294) | ○ |
| C-42 (UT-SWE-042) | PlayLooping null時Beep | E-01 (行207-211), E-07 (行285-294) | ○ |
| C-43 (UT-SWE-043) | Stop停止 | E-01 (行439-442) | ○ |
| C-44 (UT-SWE-044) | LoadCompletedイベント追加削除 | E-01 (行444-454), E-07 (行432-443) | ○ |
| C-45 (UT-SWE-045) | SoundLocationChangedイベント追加削除 | E-01 (行456-466), E-07 (行445-457) | ○ |
| C-46 (UT-SWE-046) | StreamChangedイベント追加削除 | E-01 (行468-478), E-07 (行459-474) | ○ |
| C-47 (UT-SWE-047) | ISerializable.GetObjectDataでPlatformNotSupportedException | E-01 (行727-730) | ○ |
| C-48 (UT-SWE-048) | ValidateSoundData PCMフォーマット通過 | E-01 (行631-702) | ○ |
| C-49 (UT-SWE-049) | ValidateSoundData ADPCMフォーマット通過 | E-01 (行696-698) | ○ |
| C-50 (UT-SWE-050) | ValidateSoundData IEEE Floatフォーマット通過 | E-01 (行696-698) | ○ |
| C-51 (UT-SWE-051) | ValidateSoundData RIFFヘッダなしでInvalidOperationException | E-01 (行633-638) | ○ |
| C-52 (UT-SWE-052) | ValidateSoundData WAVEチャンクなしでInvalidOperationException | E-01 (行633-638) | ○ |
| C-53 (UT-SWE-053) | ValidateSoundData fmtチャンクなしでInvalidOperationException | E-01 (行691-694) | ○ |
| C-54 (UT-SWE-054) | ValidateSoundData サポート外フォーマットでInvalidOperationException | E-01 (行696-701) | ○ |
| C-55 (UT-SWE-055) | ValidateSoundData データ長12未満でInvalidOperationException | E-01 (行633-634) | ○ |

### SystemSound / SystemSounds クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 (UT-SWE-056) | SystemSound内部コンストラクタ初期化 | E-02 (行10-13) | ○ |
| C-57 (UT-SWE-057) | SystemSound.PlayでMessageBeep呼び出し | E-02 (行15-18), E-08 (行21-26) | ○ |
| C-58 (UT-SWE-058) | Asteriskが非null返却 | E-03 (行8), E-09 (行11-16) | ○ |
| C-59 (UT-SWE-059) | Asteriskキャッシュ動作 | E-03 (行8), E-09 (行11-16) | ○ |
| C-60 (UT-SWE-060) | Beepが非null返却 | E-03 (行9), E-09 (行18-23) | ○ |
| C-61 (UT-SWE-061) | Beepキャッシュ動作 | E-03 (行9), E-09 (行18-23) | ○ |
| C-62 (UT-SWE-062) | Exclamationが非null返却 | E-03 (行10), E-09 (行25-30) | ○ |
| C-63 (UT-SWE-063) | Exclamationキャッシュ動作 | E-03 (行10), E-09 (行25-30) | ○ |
| C-64 (UT-SWE-064) | Handが非null返却 | E-03 (行11), E-09 (行32-37) | ○ |
| C-65 (UT-SWE-065) | Handキャッシュ動作 | E-03 (行11), E-09 (行32-37) | ○ |
| C-66 (UT-SWE-066) | Questionが非null返却 | E-03 (行12), E-09 (行39-44) | ○ |
| C-67 (UT-SWE-067) | Questionキャッシュ動作 | E-03 (行12), E-09 (行39-44) | ○ |

### X509Certificate2UI クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 (UT-SWE-068) | DisplayCertificate有効証明書でUI表示 | E-04 (行21-26) | △ |
| C-69 (UT-SWE-069) | DisplayCertificate nullでArgumentNullException | E-04 (行23), E-10 (行25-28) | ○ |
| C-70 (UT-SWE-070) | DisplayCertificate(hwndParent)でUI表示 | E-04 (行28-33) | △ |
| C-71 (UT-SWE-071) | DisplayCertificate(hwndParent) nullでArgumentNullException | E-04 (行30), E-10 (行25-28) | ○ |
| C-72 (UT-SWE-072) | SelectFromCollection SingleSelection動作 | E-04 (行35-38), E-10 (行11-14) | ○ |
| C-73 (UT-SWE-073) | SelectFromCollection MultiSelection動作 | E-04 (行35-38), E-10 (行11-14) | ○ |
| C-74 (UT-SWE-074) | SelectFromCollection空コレクション動作 | E-04 (行90-102) | ○ |
| C-75 (UT-SWE-075) | SelectFromCollection nullでArgumentNullException | E-04 (行92), E-10 (行11-14) | ○ |
| C-76 (UT-SWE-076) | SelectFromCollection無効enumでArgumentException | E-04 (行94-95), E-10 (行11-14) | ○ |
| C-77 (UT-SWE-077) | SelectFromCollection(hwndParent)動作 | E-04 (行40-43), E-10 (行17-21) | ○ |
| C-78 (UT-SWE-078) | SelectFromCollection(hwndParent) nullでArgumentNullException | E-04 (行92), E-10 (行17-21) | ○ |
| C-79 (UT-SWE-079) | SelectFromCollection(hwndParent)無効enumでArgumentException | E-04 (行94-95), E-10 (行17-21) | ○ |
| C-80 (UT-SWE-080) | X509SelectionFlag.SingleSelection=0 | E-04 (行12) | ○ |
| C-81 (UT-SWE-081) | X509SelectionFlag.MultiSelection=1 | E-04 (行13) | ○ |

### XamlAccessLevel クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 (UT-SWE-082) | AssemblyAccessTo(Assembly)動作 | E-06 (行17-20), E-11 (行12-22) | ○ |
| C-83 (UT-SWE-083) | AssemblyAccessTo(AssemblyName)動作 | E-06 (行22-25), E-11 (行12-22) | ○ |
| C-84 (UT-SWE-084) | PrivateAccessTo(Type)動作 | E-06 (行27-30), E-11 (行12-22) | ○ |
| C-85 (UT-SWE-085) | PrivateAccessTo(string)動作 | E-06 (行32-39), E-11 (行12-22) | ○ |
| C-86 (UT-SWE-086) | PrivateAccessTo(string)パース | E-06 (行34-38) | ○ |
| C-87 (UT-SWE-087) | AssemblyAccessToAssemblyName取得 | E-06 (行41-44), E-11 (行21) | ○ |
| C-88 (UT-SWE-088) | PrivateAccessToTypeName(AssemblyAccessTo時)=null | E-06 (行19, 24) | ○ |
| C-89 (UT-SWE-089) | PrivateAccessToTypeName(PrivateAccessTo時)=型名 | E-06 (行29, 38) | ○ |

### X509Utils クラス（内部）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 (UT-SWE-090) | DuplicateCertificateContext動作 | E-05 (行14-19) | △ |
| C-91 (UT-SWE-091) | ExportToMemoryStore動作 | E-05 (行21-59) | ○ |
| C-92 (UT-SWE-092) | ExportToMemoryStore空コレクション | E-05 (行21-59) | ○ |
| C-93 (UT-SWE-093) | GetCertificates動作 | E-05 (行61-73) | ○ |
| C-94 (UT-SWE-094) | GetCertificates空ストア | E-05 (行61-73) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の項目
1. **UT-SWE-068, UT-SWE-070 (X509Certificate2UI.DisplayCertificate)**
   - 理由: UIダイアログを表示するメソッドのため、自動テストでの検証が困難
   - 候補: 手動テスト / Windows UI Automation / モック化

2. **UT-SWE-090 (X509Utils.DuplicateCertificateContext)**
   - 理由: internalメソッドであり、直接テストを記述する場合はInternalsVisibleToが必要
   - 候補: 統合テストで間接的に検証 / InternalsVisibleTo設定

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 1 (中リスク) | X509Certificate2UI関連テスト | Windows環境依存、UI操作が必要 |
| 1 (中リスク) | SoundPlayer.Play関連テスト | Windows環境依存、音声デバイスが必要 |
| 0 (低リスク) | XamlAccessLevel関連テスト | プラットフォーム非依存、純粋なロジック |
| 0 (低リスク) | SystemSounds関連テスト | シンプルなプロパティアクセス |

## 6) レビュアーチェックリスト（最小）

- [ ] SoundPlayerのLoadTimeout境界値テスト（UT-SWE-009, 010, 011）が適切か確認
- [ ] SoundPlayerのWAVフォーマット検証テスト（UT-SWE-048-055）が網羅的か確認
- [ ] X509Certificate2UIのnull/無効enum検証テスト（UT-SWE-069, 071, 075-76, 78-79）の期待例外が正しいか確認
- [ ] XamlAccessLevelのPrivateAccessTo(string)パーステスト（UT-SWE-086）の入力パターンが十分か確認
- [ ] X509Utils内部メソッドのテスト（UT-SWE-090-094）をInternalsVisibleToなしで実施可能か確認
