---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 158
  claims_with_evidence: 158
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Xml.ReaderWriter 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：158 / 158、根拠なし：0
- 優先レビュー（高）
  1. **XmlReader/XmlWriter の基本機能**: 高優先度テストケース多数（UT-XRW-001〜040）
  2. **XmlDocument DOM操作**: 高優先度（UT-XRW-045〜060）
  3. **Schema検証**: 高優先度（UT-XRW-093〜108）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Xml.ReaderWriter/ref/System.Xml.ReaderWriter.cs` - 公開API参照ファイル（2950行）
- E-02: `src/libraries/System.Xml.ReaderWriter/src/System.Xml.ReaderWriter.csproj` - プロジェクト定義
- E-03: `src/libraries/System.Xml.ReaderWriter/README.md` - モジュール説明
- E-04: `src/libraries/System.Private.Xml/` - 実装本体への参照（Partial Facade）
- E-05: Microsoft Docs - System.Xml 名前空間ドキュメント
- E-06: .NET API Browser - XmlReader/XmlWriter API仕様

## 3) Claims と根拠の対応（レビューの主戦場）

### XmlReader 関連（UT-XRW-001〜024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XmlReader.Create(Stream) でストリームからリーダーが生成される | E-01 (line 810-813) | ○ |
| C-02 | XmlReader.Create(TextReader) でテキストリーダーからリーダーが生成される | E-01 (line 814-817) | ○ |
| C-03 | XmlReader.Create(string) でURIからリーダーが生成される | E-01 (line 818-820) | ○ |
| C-04 | XmlReader.Read() でXMLノードを順次読み取れる | E-01 (line 843) | ○ |
| C-05 | 不正なXMLでXmlExceptionがスローされる | E-01, E-05 | ○ |
| C-06 | XmlReader.GetAttribute() で属性値を取得できる | E-01 (line 824-826) | ○ |
| C-07 | XmlReaderSettings でDTD処理を制御できる | E-01 (line 934) | ○ |
| C-08 | XmlReaderSettings.MaxCharactersInDocument で文字数制限できる | E-01 (line 941) | ○ |

### XmlWriter 関連（UT-XRW-025〜044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | XmlWriter.Create(Stream) でストリームへのライターが生成される | E-01 (line 1241-1242) | ○ |
| C-10 | XmlWriter.WriteStartDocument() でXML宣言が出力される | E-01 (line 1314-1317) | ○ |
| C-11 | XmlWriter.WriteStartElement() で開始タグが出力される | E-01 (line 1318-1321) | ○ |
| C-12 | XmlWriter.WriteAttributeString() で属性が出力される | E-01 (line 1259-1262) | ○ |
| C-13 | XmlWriter.WriteString() で特殊文字がエスケープされる | E-01 (line 1322-1323), E-05 | ○ |
| C-14 | XmlWriterSettings.Indent で整形出力を制御できる | E-01 (line 1350) | ○ |
| C-15 | XmlWriterSettings.Encoding でエンコーディングを指定できる | E-01 (line 1349) | ○ |

### XmlDocument DOM操作（UT-XRW-045〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | XmlDocument.Load() でファイル/ストリームからXMLを読み込める | E-01 (line 356-359) | ○ |
| C-17 | XmlDocument.LoadXml() で文字列からXMLを読み込める | E-01 (line 360) | ○ |
| C-18 | XmlDocument.Save() でファイル/ストリームにXMLを保存できる | E-01 (line 362-365) | ○ |
| C-19 | XmlDocument.CreateElement() で要素ノードを作成できる | E-01 (line 338-340) | ○ |
| C-20 | XmlDocument.SelectNodes() でXPath検索ができる | E-01 (line 586-587) | ○ |
| C-21 | XmlNode.AppendChild() で子ノードを追加できる | E-01 (line 572) | ○ |
| C-22 | XmlElement.GetAttribute/SetAttribute で属性を操作できる | E-01 (line 419-438) | ○ |

### XmlConvert 型変換（UT-XRW-071〜079）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | XmlConvert.ToString() で各種型をXML文字列に変換できる | E-01 (line 235-259) | ○ |
| C-24 | XmlConvert.ToBoolean/ToDateTime等で文字列から型変換できる | E-01 (line 215-226) | ○ |
| C-25 | XmlConvert.EncodeName/DecodeName でXML名前をエンコード/デコードできる | E-01 (line 202-208) | ○ |
| C-26 | XmlConvert.VerifyName で有効なXML名前を検証できる | E-01 (line 267-269) | ○ |

### 名前空間管理（UT-XRW-080〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | XmlNamespaceManager で名前空間を管理できる | E-01 (line 515-528) | ○ |
| C-28 | NameTable で文字列をアトム化できる | E-01 (line 61-68) | ○ |

### Schema検証（UT-XRW-093〜108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | XmlSchemaSet.Add() でスキーマを追加できる | E-01 (line 2180-2183) | ○ |
| C-30 | XmlSchemaSet.Compile() でスキーマをコンパイルできる | E-01 (line 2184) | ○ |
| C-31 | XmlSchemaValidator で個別の要素/属性を検証できる | E-01 (line 2366-2395) | ○ |
| C-32 | XmlSchema.Read() でスキーマを読み込める | E-01 (line 1488-1490) | ○ |
| C-33 | XmlSchemaInference.InferSchema() でスキーマを推論できる | E-01 (line 1989-1990) | ○ |

### XPath（UT-XRW-109〜129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | XPathExpression.Compile() でXPath式をコンパイルできる | E-01 (line 2619-2620) | ○ |
| C-35 | XPathNavigator.Select() でXPath選択ができる | E-01 (line 2746-2748) | ○ |
| C-36 | XPathNavigator.Evaluate() でXPath式を評価できる | E-01 (line 2689-2692) | ○ |
| C-37 | XPathNavigator でDOMをナビゲートできる | E-01 (line 2712-2735) | ○ |
| C-38 | XPathNavigator.AppendChild/SetValue/DeleteSelf で編集できる | E-01 (line 2675-2688) | ○ |

### XSLT（UT-XRW-130〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | XslCompiledTransform.Load() でスタイルシートを読み込める | E-01 (line 2825-2832) | ○ |
| C-40 | XslCompiledTransform.Transform() でXSLT変換できる | E-01 (line 2833-2847) | ○ |
| C-41 | XsltArgumentList でパラメータ/拡張オブジェクトを渡せる | E-01 (line 2849-2862) | ○ |
| C-42 | XsltSettings でdocument関数等を制御できる | E-01 (line 2939-2948) | ○ |

### その他（UT-XRW-144〜158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | XmlNodeReader でDOMからストリーミング読み取りできる | E-01 (line 631-678) | ○ |
| C-44 | XmlParserContext でパーサー設定を指定できる | E-01 (line 722-743) | ○ |
| C-45 | XmlQualifiedName で修飾名を扱える | E-01 (line 762-776) | ○ |
| C-46 | XmlPreloadedResolver でデータをプリロードできる | E-01 (line 1373-1391) | ○ |
| C-47 | IXmlSerializable でカスタムシリアライズができる | E-01 (line 2480-2486) | ○ |

## 4) 不足情報（Unknown / Missing）
- 本モジュールはPartial Facade Assemblyであり、実装本体は`System.Private.Xml`に存在する
- テストケースは公開APIの参照ファイル（ref/System.Xml.ReaderWriter.cs）に基づいて生成
- 内部実装の詳細なテストは`System.Private.Xml`モジュールで実施されるべき
- 既存のテストコード（`src/libraries/System.Xml.ReaderWriter/tests/`）が存在しないため、既存テストとの重複確認は不要

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 標準的なXML処理API
  - XmlReader/XmlWriter の基本操作（Create, Read, Write等）
  - XmlDocument のDOM操作
  - XmlConvert の型変換
- **1 (中リスク)**: 名前空間・スキーマ関連
  - XmlNamespaceManager のスコープ管理
  - XmlSchemaSet のスキーマコンパイル
  - XPathNavigator の編集機能
- **2 (高リスク)**: セキュリティ関連
  - XmlReaderSettings.DtdProcessing（XXE対策）
  - XmlReaderSettings.MaxCharactersInDocument（DoS対策）
  - XmlResolver.ThrowingResolver（外部エンティティ解決禁止）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（優先度「高」）が主要なユースケースをカバーしているか
- [ ] セキュリティ関連のテストケース（DTD処理、MaxCharacters）が含まれているか
- [ ] 異常系テストケース（不正なXML、存在しない属性等）が十分か
- [ ] 非同期API（ReadAsync, FlushAsync等）のテストケースが含まれているか
- [ ] Schema検証の正常系・異常系が網羅されているか
- [ ] XSLT変換の基本機能がカバーされているか
- [ ] テストIDの命名規則（UT-XRW-XXX）が一貫しているか
- [ ] 各テストケースの前提条件・入力値・期待結果が明確か

## 補足：モジュール構造について

`System.Xml.ReaderWriter`は.NET Runtimeの一部として提供されるPartial Facade Assemblyです。

### 含まれる名前空間
1. **System.Xml** - コアXMLクラス（XmlReader, XmlWriter, XmlDocument等）
2. **System.Xml.Resolvers** - XmlPreloadedResolver
3. **System.Xml.Schema** - XMLスキーマ検証（XmlSchemaSet, XmlSchemaValidator等）
4. **System.Xml.Serialization** - シリアライズ属性（IXmlSerializable等）
5. **System.Xml.XPath** - XPath処理（XPathNavigator, XPathExpression等）
6. **System.Xml.Xsl** - XSLT変換（XslCompiledTransform等）

### 依存関係
- System.Private.Xml（実装本体）
- System.Collections.NonGeneric
- System.Runtime

### テストケース生成の観点
本テストケース一覧は、公開API参照ファイル（ref/System.Xml.ReaderWriter.cs）に定義されているすべてのpublic API（クラス、メソッド、プロパティ）を対象に、以下の観点でテストケースを生成しています：

1. **正常系**: 期待通りの入力で期待通りの結果が返ること
2. **異常系**: null/空値、不正なデータ型、構文エラー等の場合の挙動
3. **境界値**: 存在しない要素へのアクセス、空のコレクション等
4. **セキュリティ**: DTD処理、外部エンティティ解決、文字数制限等
