---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 234
  claims_with_evidence: 234
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Xml.XDocument 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・APIドキュメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要なテストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：234 / 234、根拠なし：0
- 優先レビュー（高）
  1. **XDocument Load/Save メソッド群**：ファイルI/O、ストリーム処理の動作確認が重要
  2. **XElement 型変換演算子**：各型への明示的変換の境界値確認
  3. **XAttribute バリデーション**：名前空間宣言時の制約確認

## 2) 参照した情報（Evidence一覧）
> System.Private.Xml.Linq の実際のソースコードから抽出

- E-01: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XDocument.cs`
- E-02: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XElement.cs`
- E-03: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XAttribute.cs`
- E-04: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XNode.cs`
- E-05: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XName.cs`
- E-06: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XNamespace.cs`
- E-07: `src/libraries/System.Private.Xml.Linq/src/System/Xml/Linq/XContainer.cs`
- E-08: `src/libraries/System.Xml.XDocument/ref/System.Xml.XDocument.cs` (APIリファレンス)
- E-09: `src/libraries/System.Xml.XDocument/README.md` (モジュール概要)

## 3) Claims と根拠の対応（レビューの主戦場）

### XDocument クラス (UT-XDC-001 ~ UT-XDC-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XDocument コンストラクタがXDeclarationとコンテンツを受け取る | E-01: `public XDocument(XDeclaration? declaration, params object?[] content)` | ○ |
| C-02 | XDocument.Load がファイルパスからXMLを読み込む | E-01: `public static XDocument Load(string uri)` | ○ |
| C-03 | XDocument.Parse がXML文字列からドキュメントを生成 | E-01: `public static XDocument Parse(string text)` | ○ |
| C-04 | XDocument.Root がルート要素を返す | E-01: `public XElement? Root { get }` | ○ |
| C-05 | XDocument.Declaration がXML宣言を返す | E-01: `public XDeclaration? Declaration { get; set; }` | ○ |
| C-06 | XDocument.LoadAsync が非同期読み込みをサポート | E-01: `public static Task<XDocument> LoadAsync(...)` | ○ |
| C-07 | XDocument.SaveAsync が非同期保存をサポート | E-01: `public Task SaveAsync(...)` | ○ |

### XElement クラス (UT-XDC-025 ~ UT-XDC-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | XElement コンストラクタがXNameを受け取る | E-02: `public XElement(XName name)` | ○ |
| C-09 | XElement.Name プロパティで要素名を取得/設定 | E-02: `public XName Name { get; set; }` | ○ |
| C-10 | XElement.Value プロパティでテキスト値を取得/設定 | E-02: `public string Value { get; set; }` | ○ |
| C-11 | XElement.Attribute(XName) で属性を取得 | E-02: `public XAttribute? Attribute(XName name)` | ○ |
| C-12 | XElement.Elements() で子要素を列挙 | E-02: `public IEnumerable<XElement> Elements()` | ○ |
| C-13 | XElement.Descendants() で子孫要素を列挙 | E-02: `public IEnumerable<XElement> Descendants()` | ○ |
| C-14 | XElement.SetAttributeValue で属性値を設定/削除 | E-02: `public void SetAttributeValue(XName name, object? value)` | ○ |
| C-15 | XElement.SetElementValue で子要素値を設定/削除 | E-02: `public void SetElementValue(XName name, object? value)` | ○ |
| C-16 | XElement への明示的型変換演算子 | E-02: `explicit operator string/int/bool/DateTime/...` | ○ |

### XAttribute クラス (UT-XDC-082 ~ UT-XDC-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | XAttribute コンストラクタが名前とnullでArgumentNullExceptionをスロー | E-03: `ArgumentNullException.ThrowIfNull(name); ArgumentNullException.ThrowIfNull(value);` | ○ |
| C-18 | XAttribute.IsNamespaceDeclaration がxmlns属性を判定 | E-03: `public bool IsNamespaceDeclaration { get }` (xmlns判定ロジック) | ○ |
| C-19 | XAttribute.NextAttribute/PreviousAttribute で属性ナビゲーション | E-03: `public XAttribute? NextAttribute { get }`, `public XAttribute? PreviousAttribute { get }` | ○ |
| C-20 | XAttribute.Remove() で親なし時にInvalidOperationException | E-03: `if (parent == null) throw new InvalidOperationException(SR.InvalidOperation_MissingParent);` | ○ |
| C-21 | XAttribute への明示的型変換演算子 | E-03: `explicit operator string/int/bool/DateTime/Guid/TimeSpan/...` | ○ |
| C-22 | ValidateAttribute で名前空間制約をチェック | E-03: `private static void ValidateAttribute(XName name, string value)` | ○ |

### XNode クラス (UT-XDC-111 ~ UT-XDC-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | XNode.NextNode/PreviousNode で兄弟ナビゲーション | E-04: `public XNode? NextNode { get }`, `public XNode? PreviousNode { get }` | ○ |
| C-24 | XNode.AddAfterSelf/AddBeforeSelf で兄弟追加 | E-04: `public void AddAfterSelf(object? content)`, `public void AddBeforeSelf(object? content)` | ○ |
| C-25 | XNode.Remove() で親なし時にInvalidOperationException | E-04: `if (parent == null) throw new InvalidOperationException(SR.InvalidOperation_MissingParent);` | ○ |
| C-26 | XNode.CompareDocumentOrder で順序比較 | E-04: `public static int CompareDocumentOrder(XNode? n1, XNode? n2)` | ○ |
| C-27 | XNode.DeepEquals で深い等価比較 | E-04: `public static bool DeepEquals(XNode? n1, XNode? n2)` | ○ |
| C-28 | XNode.ReadFrom でXmlReaderからノード生成 | E-04: `public static XNode ReadFrom(XmlReader reader)` | ○ |

### XName クラス (UT-XDC-143 ~ UT-XDC-159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | XName.Get(string) で展開名からXNameを取得 | E-05: `public static XName Get(string expandedName)` | ○ |
| C-30 | XName.Get(string) で空文字列時にArgumentExceptionをスロー | E-05: `ArgumentException.ThrowIfNullOrEmpty(expandedName);` | ○ |
| C-31 | XName.LocalName/Namespace/NamespaceName プロパティ | E-05: `public string LocalName { get }`, `public XNamespace Namespace { get }`, `public string NamespaceName { get }` | ○ |
| C-32 | XName への暗黙変換演算子 | E-05: `public static implicit operator XName?(string? expandedName)` | ○ |
| C-33 | XName.ToString() で展開名形式を返す | E-05: `if (_ns.NamespaceName.Length == 0) return _localName; return "{" + _ns.NamespaceName + "}" + _localName;` | ○ |

### XNamespace クラス (UT-XDC-160 ~ UT-XDC-174)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | XNamespace.Get(string) で名前空間を取得 | E-06: `public static XNamespace Get(string namespaceName)` | ○ |
| C-35 | XNamespace.None/Xml/Xmlns 静的プロパティ | E-06: `public static XNamespace None { get }`, `public static XNamespace Xml { get }`, `public static XNamespace Xmlns { get }` | ○ |
| C-36 | XNamespace + string 演算子でXNameを生成 | E-06: `public static XName operator +(XNamespace ns, string localName)` | ○ |
| C-37 | XNamespace.GetName(string) でXNameを取得 | E-06: `public XName GetName(string localName)` | ○ |

### XContainer クラス (UT-XDC-175 ~ UT-XDC-188)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | XContainer.FirstNode/LastNode で子ノードアクセス | E-07: `public XNode? FirstNode { get }`, `public XNode? LastNode { get }` | ○ |
| C-39 | XContainer.Add(object) でコンテンツ追加 | E-07: `public void Add(object? content)` | ○ |
| C-40 | XContainer.Nodes() で子ノード列挙 | E-07: `public IEnumerable<XNode> Nodes()` | ○ |
| C-41 | XContainer.RemoveNodes() で子ノード全削除 | E-07: `public void RemoveNodes()` | ○ |
| C-42 | XContainer.ReplaceNodes(object) で子ノード置換 | E-07: `public void ReplaceNodes(object? content)` | ○ |
| C-43 | XContainer.GetStringValue で値変換 | E-07: `internal static string GetStringValue(object value)` (switch式による型変換) | ○ |

### その他のクラス (UT-XDC-189 ~ UT-XDC-234)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | XText/XCData/XComment/XProcessingInstruction/XDocumentType の各ノード型 | E-08: APIリファレンス定義 | ○ |
| C-45 | XDeclaration の Version/Encoding/Standalone プロパティ | E-08: APIリファレンス定義 | ○ |
| C-46 | XObject の Parent/Document/アノテーション機能 | E-08: APIリファレンス定義 | ○ |
| C-47 | XStreamingElement の遅延評価機能 | E-08: APIリファレンス定義 | ○ |
| C-48 | XNodeDocumentOrderComparer/XNodeEqualityComparer | E-04: `public static XNodeDocumentOrderComparer DocumentOrderComparer`, `public static XNodeEqualityComparer EqualityComparer` | ○ |

## 4) 不足情報（Unknown / Missing）
- 本テストケース一覧は全てソースコードおよびAPIリファレンスから生成されており、根拠なしの項目はありません。
- System.Xml.XDocumentはファサードアセンブリであり、実装はSystem.Private.Xml.Linqに存在します。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて作成されている
- 注意点：
  - 非同期メソッド（LoadAsync, SaveAsync等）のキャンセル処理テストは実際の実行環境での検証が必要
  - XStreamingElementの遅延評価に関するテストは、コンテンツが実際にいつ評価されるかの確認が必要
  - 名前空間宣言のバリデーション（ValidateAttribute）は、XMLの標準仕様に基づく複雑な制約があるため慎重なレビューを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] XDocument/XElement のLoad/Parseメソッドのエラーハンドリングテストケースが十分か確認
- [ ] 型変換演算子（explicit operator）の境界値テストが適切か確認
- [ ] XAttributeのValidateAttributeで検証される名前空間制約のテストケースが網羅的か確認
- [ ] 非同期メソッドのキャンセル処理テストが含まれているか確認
- [ ] XNode.CompareDocumentOrderの共通祖先なしケースが含まれているか確認
- [ ] イベント（Changing/Changed）の発火タイミングテストが含まれているか確認
