---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Xml.XPath.XDocument 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. **UT-XPD-006, UT-XPD-015, UT-XPD-024**：null引数に対するArgumentNullException - コード上でArgumentNullException.ThrowIfNullを確認済み
  2. **UT-XPD-081**：MoveToIdのNotSupportedException - コード上でthrow new NotSupportedExceptionを確認済み
  3. **UT-XPD-113**：型不一致時のInvalidOperationException - コード上でthrow new InvalidOperationExceptionを確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Xml.XPath.XDocument/src/System/Xml/XPath/XDocumentExtensions.cs`
- E-02: `src/libraries/System.Private.Xml.Linq/src/System/Xml/XPath/XNodeNavigator.cs`
- E-03: `src/libraries/System.Private.Xml.Linq/src/System/Xml/XPath/XObjectExtensions.cs`
- E-04: `src/libraries/System.Xml.XPath.XDocument/ref/System.Xml.XPath.XDocument.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### XDocumentExtensions クラス（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-XPD-001) | ToXPathNavigableがIXPathNavigableを返却 | E-01 L22-25 | ○ |
| C-02 (UT-XPD-002) | CreateNavigatorでXPathNavigatorが作成可能 | E-01 L17-20, E-02 | ○ |
| C-03 (UT-XPD-003) | XDocumentからIXPathNavigableが取得可能 | E-01 L10-20 | ○ |

### Extensions クラス（E-02, E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 (UT-XPD-004) | CreateNavigator(XNode)でXPathNavigatorが作成可能 | E-02 L911-914 | ○ |
| C-05 (UT-XPD-005) | XDocumentからXPathNavigatorが作成可能 | E-02 L923-935 | ○ |
| C-06 (UT-XPD-006) | nullでArgumentNullExceptionがスロー | E-02 L925 | ○ |
| C-07 (UT-XPD-007) | XDocumentTypeでArgumentExceptionがスロー | E-02 L927 | ○ |
| C-08 (UT-XPD-008) | Document直下テキストでArgumentExceptionがスロー | E-02 L931 | ○ |
| C-09 (UT-XPD-009) | カスタムXmlNameTableでNavigator作成可能 | E-02 L923 | ○ |
| C-10 (UT-XPD-010) | nameTableがnullでデフォルトが使用される | E-02 L54 | ○ |
| C-11 (UT-XPD-011) | XPathEvaluateで要素を評価可能 | E-02 L944-963 | ○ |
| C-12 (UT-XPD-012) | XPathEvaluateで文字列値を取得可能 | E-02 L865-877 | ○ |
| C-13 (UT-XPD-013) | XPathEvaluateで数値を取得可能 | E-02 L865-877 | ○ |
| C-14 (UT-XPD-014) | XPathEvaluateでbool値を取得可能 | E-02 L865-877 | ○ |
| C-15 (UT-XPD-015) | nullノードでArgumentNullExceptionがスロー | E-02 L960 | ○ |
| C-16 (UT-XPD-016) | 名前空間付きXPath式を評価可能 | E-02 L958-962 | ○ |
| C-17 (UT-XPD-017) | resolverがnullでも動作 | E-02 L958 | ○ |
| C-18 (UT-XPD-018) | XPathSelectElementで単一要素を選択可能 | E-02 L984-987 | ○ |
| C-19 (UT-XPD-019) | 複数マッチ時に最初の要素が返却される | E-02 L986 (FirstOrDefault) | ○ |
| C-20 (UT-XPD-020) | マッチしない場合にnullが返却される | E-02 L986 (FirstOrDefault) | ○ |
| C-21 (UT-XPD-021) | 名前空間付きXPathで要素を選択可能 | E-02 L984-987 | ○ |
| C-22 (UT-XPD-022) | XPathSelectElementsで複数要素を選択可能 | E-02 L1008-1013 | ○ |
| C-23 (UT-XPD-023) | マッチしない場合に空のIEnumerableが返却される | E-02 L1012 | ○ |
| C-24 (UT-XPD-024) | nullノードでArgumentNullExceptionがスロー | E-02 L1010 | ○ |
| C-25 (UT-XPD-025) | 名前空間付きXPathで複数要素を選択可能 | E-02 L1008-1013 | ○ |

### XNodeNavigator クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 (UT-XPD-026) | コンストラクタでNavigator作成可能 | E-02 L51-55 | ○ |
| C-27 (UT-XPD-027) | nameTableがnullでデフォルトが作成される | E-02 L54 | ○ |
| C-28 (UT-XPD-028) | BaseURIがソースノードのBaseUriを返却 | E-02 L64-78 | ○ |
| C-29 (UT-XPD-029) | ソースがnullで空文字列が返却される | E-02 L68-76 | ○ |
| C-30 (UT-XPD-030) | HasAttributesが属性ありでtrue | E-02 L80-97 | ○ |
| C-31 (UT-XPD-031) | HasAttributesが属性なしでfalse | E-02 L95 | ○ |
| C-32 (UT-XPD-032) | 名前空間宣言のみでHasAttributesがfalse | E-02 L89 (IsNamespaceDeclaration check) | ○ |
| C-33 (UT-XPD-033) | HasChildrenが子ありでtrue | E-02 L99-116 | ○ |
| C-34 (UT-XPD-034) | HasChildrenが子なしでfalse | E-02 L114 | ○ |
| C-35 (UT-XPD-035) | IsEmptyElementが空要素でtrue | E-02 L118-125 | ○ |
| C-36 (UT-XPD-036) | IsEmptyElementがコンテンツありでfalse | E-02 L123 | ○ |
| C-37 (UT-XPD-037) | LocalNameが要素のローカル名を返却 | E-02 L127-154 | ○ |
| C-38 (UT-XPD-038) | 名前空間付き要素のLocalName | E-02 L137 | ○ |
| C-39 (UT-XPD-039) | 属性のLocalName | E-02 L139-147 | ○ |
| C-40 (UT-XPD-040) | PIのLocalName(Target) | E-02 L148-152 | ○ |
| C-41 (UT-XPD-041) | Nameがプレフィックス付き完全名を返却 | E-02 L156-167 | ○ |
| C-42 (UT-XPD-042) | Nameがプレフィックスなしでローカル名を返却 | E-02 L163 | ○ |
| C-43 (UT-XPD-043) | NamespaceURIが名前空間URIを返却 | E-02 L169-191 | ○ |
| C-44 (UT-XPD-044) | 名前空間なしで空文字列 | E-02 L190 | ○ |
| C-45 (UT-XPD-045) | NodeTypeがElementでXPathNodeType.Element | E-02 L198-223 | ○ |
| C-46 (UT-XPD-046) | NodeTypeがDocumentでXPathNodeType.Root | E-02 L211-212 | ○ |
| C-47 (UT-XPD-047) | NodeTypeが属性でXPathNodeType.Attribute | E-02 L208-210 | ○ |
| C-48 (UT-XPD-048) | 名前空間宣言でXPathNodeType.Namespace | E-02 L210 | ○ |
| C-49 (UT-XPD-049) | コメントでXPathNodeType.Comment | E-02 L213-214 | ○ |
| C-50 (UT-XPD-050) | PIでXPathNodeType.ProcessingInstruction | E-02 L215-216 | ○ |
| C-51 (UT-XPD-051) | テキストでXPathNodeType.Text | E-02 L217-218 | ○ |
| C-52 (UT-XPD-052) | Prefixが名前空間プレフィックスを返却 | E-02 L225-256 | ○ |
| C-53 (UT-XPD-053) | プレフィックスなしで空文字列 | E-02 L240, 255 | ○ |
| C-54 (UT-XPD-054) | Valueが要素の値を返却 | E-02 L266-294 | ○ |
| C-55 (UT-XPD-055) | Valueが属性の値を返却 | E-02 L277 | ○ |
| C-56 (UT-XPD-056) | Valueがルート要素の値を返却 | E-02 L278-280 | ○ |
| C-57 (UT-XPD-057) | 連続テキストノードが結合される | E-02 L724-737 | ○ |
| C-58 (UT-XPD-058) | Cloneがコピーを作成 | E-02 L296-299 | ○ |
| C-59 (UT-XPD-059) | Cloneが独立している | E-02 L57-62 | ○ |
| C-60 (UT-XPD-060) | IsSamePositionが同じ位置でtrue | E-02 L301-309, L757-760 | ○ |
| C-61 (UT-XPD-061) | IsSamePositionが異なる位置でfalse | E-02 L759 | ○ |
| C-62 (UT-XPD-062) | 異なる型でIsSamePositionがfalse | E-02 L303-306 | ○ |
| C-63 (UT-XPD-063) | MoveToで位置移動可能 | E-02 L311-321 | ○ |
| C-64 (UT-XPD-064) | 異なる型でMoveToがfalse | E-02 L313-314 | ○ |
| C-65 (UT-XPD-065) | MoveToAttributeで属性に移動可能 | E-02 L323-340 | ○ |
| C-66 (UT-XPD-066) | 名前空間付き属性に移動可能 | E-02 L330-331 | ○ |
| C-67 (UT-XPD-067) | 存在しない属性でfalse | E-02 L339 | ○ |
| C-68 (UT-XPD-068) | 名前空間宣言は属性として移動不可 | E-02 L332 | ○ |
| C-69 (UT-XPD-069) | MoveToChildで子要素に移動可能 | E-02 L342-358 | ○ |
| C-70 (UT-XPD-070) | 存在しない子要素でfalse | E-02 L357 | ○ |
| C-71 (UT-XPD-071) | MoveToChild(XPathNodeType)で移動可能 | E-02 L360-380 | ○ |
| C-72 (UT-XPD-072) | Document直下でテキストノードに移動不可 | E-02 L366-368 | ○ |
| C-73 (UT-XPD-073) | MoveToFirstAttributeで最初の属性に移動 | E-02 L382-397 | ○ |
| C-74 (UT-XPD-074) | 属性がない要素でfalse | E-02 L396 | ○ |
| C-75 (UT-XPD-075) | 名前空間宣言はスキップされる | E-02 L389 | ○ |
| C-76 (UT-XPD-076) | MoveToFirstChildで最初の子に移動 | E-02 L399-414 | ○ |
| C-77 (UT-XPD-077) | 子がない要素でfalse | E-02 L413 | ○ |
| C-78 (UT-XPD-078) | MoveToFirstNamespace(Local)で移動可能 | E-02 L416-447 | ○ |
| C-79 (UT-XPD-079) | MoveToFirstNamespace(ExcludeXml)で移動可能 | E-02 L427-432 | ○ |
| C-80 (UT-XPD-080) | MoveToFirstNamespace(All)で移動可能 | E-02 L434-437 | ○ |
| C-81 (UT-XPD-081) | MoveToIdでNotSupportedException | E-02 L449-452 | ○ |
| C-82 (UT-XPD-082) | MoveToNamespaceで名前空間に移動可能 | E-02 L454-489 | ○ |
| C-83 (UT-XPD-083) | xml名前空間に移動可能 | E-02 L481-486 | ○ |
| C-84 (UT-XPD-084) | 空文字列でデフォルト名前空間に移動 | E-02 L464-467 | ○ |
| C-85 (UT-XPD-085) | xmlns指定でfalse | E-02 L459-461 | ○ |
| C-86 (UT-XPD-086) | MoveToNextで次の兄弟に移動 | E-02 L491-516 | ○ |
| C-87 (UT-XPD-087) | 次の兄弟がない場合にfalse | E-02 L503-505 | ○ |
| C-88 (UT-XPD-088) | 連続テキストノードがスキップされる | E-02 L507 | ○ |
| C-89 (UT-XPD-089) | MoveToNext(string, string)で移動可能 | E-02 L518-534 | ○ |
| C-90 (UT-XPD-090) | MoveToNext(XPathNodeType)で移動可能 | E-02 L536-566 | ○ |
| C-91 (UT-XPD-091) | MoveToNextAttributeで次の属性に移動 | E-02 L568-587 | ○ |
| C-92 (UT-XPD-092) | 次の属性がない場合にfalse | E-02 L576 | ○ |
| C-93 (UT-XPD-093) | 名前空間宣言はスキップされる | E-02 L578 | ○ |
| C-94 (UT-XPD-094) | MoveToNextNamespace(Local)で移動可能 | E-02 L589-631 | ○ |
| C-95 (UT-XPD-095) | ローカルスコープ制限 | E-02 L597-601 | ○ |
| C-96 (UT-XPD-096) | MoveToParentで親に移動 | E-02 L633-648 | ○ |
| C-97 (UT-XPD-097) | 名前空間ノードから親に移動 | E-02 L635-639 | ○ |
| C-98 (UT-XPD-098) | ルートで親なしfalse | E-02 L647 | ○ |
| C-99 (UT-XPD-099) | MoveToPreviousで前の兄弟に移動 | E-02 L650-679 | ○ |
| C-100 (UT-XPD-100) | 前の兄弟がない場合にfalse | E-02 L668 | ○ |
| C-101 (UT-XPD-101) | ReadSubtreeでXmlReaderが作成される | E-02 L681-686 | ○ |
| C-102 (UT-XPD-102) | 非コンテナでInvalidOperationException | E-02 L684 | ○ |
| C-103 (UT-XPD-103) | IXmlLineInfo.HasLineInfoがtrue | E-02 L688-696 | ○ |
| C-104 (UT-XPD-104) | IXmlLineInfo.HasLineInfoがfalse | E-02 L695 | ○ |
| C-105 (UT-XPD-105) | IXmlLineInfo.LineNumber取得 | E-02 L698-709 | ○ |
| C-106 (UT-XPD-106) | LineNumberが0 | E-02 L707 | ○ |
| C-107 (UT-XPD-107) | IXmlLineInfo.LinePosition取得 | E-02 L711-722 | ○ |
| C-108 (UT-XPD-108) | LinePositionが0 | E-02 L720 | ○ |
| C-109 (UT-XPD-109) | UnderlyingObjectが基オブジェクトを返却 | E-02 L258-264 | ○ |
| C-110 (UT-XPD-110) | NameTableが返却される | E-02 L193-196 | ○ |

### XPathEvaluator クラス（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 (UT-XPD-111) | Evaluateで評価結果を返却 | E-02 L866-877 | ○ |
| C-112 (UT-XPD-112) | XPathNodeIteratorがIEnumerableに変換 | E-02 L870-874, L879-898 | ○ |
| C-113 (UT-XPD-113) | 型不一致でInvalidOperationException | E-02 L875 | ○ |

### XObjectExtensions クラス（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 (UT-XPD-114) | GetParentが親コンテナを返却 | E-03 L10-18 | ○ |
| C-115 (UT-XPD-115) | 親がない場合にDocumentが返却 | E-03 L12 | ○ |
| C-116 (UT-XPD-116) | 自身がDocumentでnullが返却 | E-03 L13-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対してソースコードからの根拠が確認できました
- 不足情報はありません

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースはソースコードに直接対応する根拠があり、信頼度は高い
- 内部クラス（XNodeNavigator, XPathEvaluator, XObjectExtensions）のテストケースは直接テストできない可能性があるため、公開API経由でのテストを検討する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] 公開APIのテストケース（UT-XPD-001〜025）が網羅的であるか
- [ ] 例外系テストケース（UT-XPD-006, 007, 008, 015, 024, 081, 102, 113）の前提条件が正しいか
- [ ] 境界値テストケース（UT-XPD-020, 023, 029, 067, 070, 074, 077, 085, 087, 092, 95, 98, 100, 106, 108）が十分か
- [ ] 内部クラスのテストケースをどのように実行するか（リフレクション使用 or 公開API経由）の方針確認
- [ ] 名前空間関連のテストケース（UT-XPD-016, 021, 025, 032, 038, 043, 48, 52, 66, 68, 75, 78-85, 93-95）の複雑なシナリオが十分か
