---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 194
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Xml.XPath 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：194 / 200、根拠なし：6
- 優先レビュー（高）
  1. **UT-XPT-057, UT-XPT-058 (MoveToId)**: ID参照機能の詳細実装確認が必要
  2. **UT-XPT-134, UT-XPT-135 (CheckValidity)**: スキーマ検証の内部動作確認が必要
  3. **UT-XPT-185〜UT-XPT-191 (内部メソッド)**: 内部APIのためテスト可能性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathDocument.cs`
- E-02: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathException.cs`
- E-03: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNavigator.cs`
- E-04: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNodeIterator.cs`
- E-05: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathItem.cs`
- E-06: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathExpr.cs`
- E-07: `src/libraries/System.Private.Xml/src/System/Xml/XPath/IXPathNavigable.cs`
- E-08: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNamespaceScope.cs`
- E-09: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNodeType.cs`
- E-10: `src/libraries/System.Private.Xml/src/System/Xml/XPath/XPathNavigatorKeyComparer.cs`
- E-11: `src/libraries/System.Private.Xml/src/System/Xml/XPath/Internal/CompiledXPathExpr.cs`
- E-12: `src/libraries/System.Xml.XPath/ref/System.Xml.XPath.cs` (公開API定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### XPathDocument クラス（UT-XPT-001〜UT-XPT-015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XPathDocument(XmlReader)コンストラクタ | E-01 L62-74 | ○ |
| C-02 | nullのXmlReaderでArgumentNullException | E-01 L71 `ArgumentNullException.ThrowIfNull(reader)` | ○ |
| C-03 | XPathDocument(XmlReader, XmlSpace) | E-01 L69-74 | ○ |
| C-04 | XmlSpace.Defaultで空白フィルタ | E-01 L257-258 条件分岐 | ○ |
| C-05 | XPathDocument(TextReader)コンストラクタ | E-01 L79-93 | ○ |
| C-06 | nullのTextReaderでArgumentNullException | E-01 L81 `ArgumentNullException.ThrowIfNull(textReader)` | ○ |
| C-07 | XPathDocument(Stream)コンストラクタ | E-01 L98-112 | ○ |
| C-08 | nullのStreamでArgumentNullException | E-01 L100 `ArgumentNullException.ThrowIfNull(stream)` | ○ |
| C-09 | XPathDocument(string)コンストラクタ | E-01 L117-119 | ○ |
| C-10 | XPathDocument(string, XmlSpace)コンストラクタ | E-01 L124-136 | ○ |
| C-11 | CreateNavigatorがXPathNavigatorを返却 | E-01 L297-300 | ○ |
| C-12 | LoadFromReaderで各種ノードタイプ処理 | E-01 L186-286 switchステートメント | ○ |
| C-13 | LoadFromReaderで名前空間処理 | E-01 L205-217 xmlns処理 | ○ |
| C-14 | PI/コメント処理 | E-01 L261-266 | ○ |
| C-15 | CDATA処理 | E-01 L237-238 TextとCDATAを同等に処理 | ○ |

### XPathException クラス（UT-XPT-016〜UT-XPT-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | デフォルトコンストラクタ | E-02 L65 | ○ |
| C-17 | メッセージ付きコンストラクタ | E-02 L67 | ○ |
| C-18 | nullメッセージ許容 | E-02 L67 `string? message` | ○ |
| C-19 | 内部例外付きコンストラクタ | E-02 L69-72 | ○ |
| C-20 | Messageプロパティ | E-02 L122-128 | ○ |
| C-21 | GetObjectDataメソッド | E-02 L57-63 | ○ |
| C-22 | Create(string)ファクトリ | E-02 L74-77 | ○ |
| C-23 | Create(string, string)ファクトリ | E-02 L79-82 | ○ |

### XPathNavigator クラス - 基本ナビゲーション（UT-XPT-024〜UT-XPT-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Cloneメソッド（抽象） | E-03 L519 `public abstract XPathNavigator Clone()` | ○ |
| C-25 | IsSamePositionメソッド（抽象） | E-03 L906 | ○ |
| C-26 | IsSamePosition異なる位置でfalse | E-03 L906（抽象、実装依存） | ○ |
| C-27 | MoveToFirstChild（抽象） | E-03 L686 | ○ |
| C-28 | MoveToFirstChild子なしでfalse | E-03 L686（抽象、実装依存） | ○ |
| C-29 | MoveToNext（抽象） | E-03 L666 | ○ |
| C-30 | MoveToNext次なしでfalse | E-03 L666（抽象、実装依存） | ○ |
| C-31 | MoveToPrevious（抽象） | E-03 L668 | ○ |
| C-32 | MoveToPrevious前なしでfalse | E-03 L668（抽象、実装依存） | ○ |
| C-33 | MoveToParent（抽象） | E-03 L688 | ○ |
| C-34 | MoveToParentルートでfalse | E-03 L688（抽象、実装依存） | ○ |
| C-35 | MoveToRootメソッド | E-03 L690-694 | ○ |
| C-36 | MoveToFirstAttribute（抽象） | E-03 L618 | ○ |
| C-37 | MoveToFirstAttribute属性なしでfalse | E-03 L618（抽象、実装依存） | ○ |
| C-38 | MoveToNextAttribute（抽象） | E-03 L620 | ○ |
| C-39 | MoveToAttribute(string, string) | E-03 L601-616 | ○ |
| C-40 | MoveToAttribute存在しない属性 | E-03 L612-613 `MoveToParent()` でfalse | ○ |
| C-41 | GetAttributeメソッド | E-03 L588-599 | ○ |
| C-42 | GetAttribute存在しない属性で空文字 | E-03 L593 `return ""` | ○ |
| C-43 | MoveToFirstNamespace（抽象） | E-03 L658 | ○ |
| C-44 | MoveToNextNamespace（抽象） | E-03 L660 | ○ |
| C-45 | MoveToNamespaceメソッド | E-03 L641-656 | ○ |
| C-46 | GetNamespaceメソッド | E-03 L622-639 | ○ |
| C-47 | GetNamespace xmlプレフィックス | E-03 L628-629 | ○ |
| C-48 | MoveToChild(string, string) | E-03 L700-714 | ○ |
| C-49 | MoveToChild(XPathNodeType) | E-03 L716-732 | ○ |
| C-50 | MoveToFollowing(string, string) | E-03 L734-798 | ○ |
| C-51 | MoveToFollowing(XPathNodeType) | E-03 L800-863 | ○ |
| C-52 | MoveToNext(string, string) | E-03 L865-876 | ○ |
| C-53 | MoveToNext(XPathNodeType) | E-03 L878-891 | ○ |
| C-54 | MoveToFirstメソッド | E-03 L670-684 | ○ |
| C-55 | MoveToFirst属性ノードでfalse | E-03 L673-678 | ○ |
| C-56 | MoveTo（抽象） | E-03 L696 | ○ |
| C-57 | MoveToId（抽象） | E-03 L698 | ○ |
| C-58 | MoveToId存在しないID | E-03 L698（実装依存） | △ |

### XPathNavigator クラス - プロパティ（UT-XPT-059〜UT-XPT-075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | NodeType（抽象） | E-03 L521 | ○ |
| C-60 | LocalName（抽象） | E-03 L523 | ○ |
| C-61 | Name（抽象） | E-03 L525 | ○ |
| C-62 | NamespaceURI（抽象） | E-03 L527 | ○ |
| C-63 | Prefix（抽象） | E-03 L529 | ○ |
| C-64 | Value（継承自XPathItem） | E-05 L26 | ○ |
| C-65 | BaseURI（抽象） | E-03 L531 | ○ |
| C-66 | IsEmptyElement（抽象） | E-03 L533 | ○ |
| C-67 | IsEmptyElementコンテンツ付き | E-03 L533（実装依存） | ○ |
| C-68 | XmlLangプロパティ | E-03 L535-549 | ○ |
| C-69 | HasChildrenプロパティ | E-03 L893-904 | ○ |
| C-70 | HasChildren子なしでfalse | E-03 L897-902 | ○ |
| C-71 | HasAttributesプロパティ | E-03 L576-586 | ○ |
| C-72 | HasAttributes属性なしでfalse | E-03 L580-581 | ○ |
| C-73 | IsNodeプロパティ | E-03 L39-42 `return true` | ○ |
| C-74 | ValueTypeプロパティ | E-03 L136-172 | ○ |
| C-75 | TypedValueプロパティ | E-03 L70-106 | ○ |

### XPathNavigator クラス - 型変換（UT-XPT-076〜UT-XPT-081）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | ValueAsBooleanプロパティ | E-03 L174-206 | ○ |
| C-77 | ValueAsDoubleプロパティ | E-03 L242-274 | ○ |
| C-78 | ValueAsIntプロパティ | E-03 L276-308 | ○ |
| C-79 | ValueAsLongプロパティ | E-03 L310-342 | ○ |
| C-80 | ValueAsDateTimeプロパティ | E-03 L208-240 | ○ |
| C-81 | ValueAsメソッド | E-03 L344-374 | ○ |

### XPathNavigator クラス - 名前空間解決（UT-XPT-082〜UT-XPT-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | LookupNamespaceメソッド | E-03 L400-429 | ○ |
| C-83 | LookupNamespace存在しないプレフィックス | E-03 L428 `return null` | ○ |
| C-84 | LookupPrefixメソッド | E-03 L431-467 | ○ |
| C-85 | GetNamespacesInScopeメソッド | E-03 L469-505 | ○ |
| C-86 | GetNamespacesInScope Allでxml含む | E-03 L484-485 | ○ |

### XPathNavigator クラス - 位置比較（UT-XPT-087〜UT-XPT-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | ComparePositionでSame | E-03 L927-928 | ○ |
| C-88 | ComparePositionでBefore | E-03 L943-944 | ○ |
| C-89 | ComparePositionでAfter | E-03 L954-955 | ○ |
| C-90 | ComparePositionでnullはUnknown | E-03 L922-925 | ○ |
| C-91 | IsDescendantメソッド | E-03 L908-918 | ○ |
| C-92 | IsDescendant子孫でない場合 | E-03 L917 `return false` | ○ |

### XPathNavigator クラス - XPath式評価（UT-XPT-093〜UT-XPT-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | Compileメソッド | E-03 L1114-1117 | ○ |
| C-94 | Compile無効式で例外 | E-06 L64-66 QueryBuilder.Build | ○ |
| C-95 | Select(string)メソッド | E-03 L1140-1143 | ○ |
| C-96 | Select(XPathExpression)メソッド | E-03 L1150-1158 | ○ |
| C-97 | Selectノードセット以外で例外 | E-03 L1153-1156 | ○ |
| C-98 | SelectSingleNode(string)メソッド | E-03 L1119-1122 | ○ |
| C-99 | SelectSingleNodeマッチなしでnull | E-03 L1136-1137 | ○ |
| C-100 | Evaluate(string)メソッド | E-03 L1160-1163 | ○ |
| C-101 | Evaluate(XPathExpression)メソッド | E-03 L1170-1173 | ○ |
| C-102 | Evaluate数値結果 | E-03 L1189（XPathNodeIterator以外の結果） | ○ |
| C-103 | Evaluate文字列結果 | E-03 L1195 | ○ |
| C-104 | Evaluateブール結果 | E-03 L1195 | ○ |
| C-105 | Matches(string)メソッド | E-03 L1219-1222 | ○ |
| C-106 | Matchesマッチしない場合 | E-03 L1211 `return query.MatchNode(this) != null` | ○ |
| C-107 | Matches(XPathExpression)メソッド | E-03 L1198-1217 | ○ |

### XPathNavigator クラス - 選択メソッド（UT-XPT-108〜UT-XPT-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | SelectChildren(XPathNodeType) | E-03 L1224-1227 | ○ |
| C-109 | SelectChildren(string, string) | E-03 L1229-1232 | ○ |
| C-110 | SelectAncestorsメソッド | E-03 L1234-1242 | ○ |
| C-111 | SelectDescendantsメソッド | E-03 L1244-1252 | ○ |

### XPathNavigator クラス - XML読み書き（UT-XPT-112〜UT-XPT-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | ReadSubtreeメソッド | E-03 L551-562 | ○ |
| C-113 | ReadSubtree要素以外で例外 | E-03 L558-559 | ○ |
| C-114 | WriteSubtreeメソッド | E-03 L564-569 | ○ |
| C-115 | WriteSubtree nullで例外 | E-03 L566 | ○ |
| C-116 | OuterXmlプロパティ | E-03 L1323-1368 | ○ |
| C-117 | OuterXml属性ノード | E-03 L1332-1335 | ○ |
| C-118 | InnerXmlプロパティ | E-03 L1371-1443 | ○ |
| C-119 | InnerXml属性ノード | E-03 L1410-1412 | ○ |
| C-120 | ToStringメソッド | E-03 L30-33 | ○ |

### XPathNavigator クラス - 編集機能（UT-XPT-121〜UT-XPT-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | CreateNavigatorメソッド | E-03 L389-392 | ○ |
| C-122 | NavigatorComparerプロパティ | E-03 L514-517 | ○ |
| C-123 | SetValueメソッド | E-03 L65-68 `throw new NotSupportedException()` | ○ |
| C-124 | SetTypedValue不正ノード型で例外 | E-03 L117-118 | ○ |
| C-125 | SetTypedValue nullで例外 | E-03 L110 | ○ |
| C-126 | CanEditプロパティ | E-03 L1254-1260 | ○ |
| C-127 | AppendChildメソッド | E-03 L1267-1269 | ○ |
| C-128 | PrependChildメソッド | E-03 L1262-1265 | ○ |
| C-129 | InsertBeforeメソッド | E-03 L1277-1280 | ○ |
| C-130 | InsertAfterメソッド | E-03 L1272-1275 | ○ |
| C-131 | DeleteSelfメソッド | E-03 L1558-1561 | ○ |
| C-132 | ReplaceSelf不正ノード型で例外 | E-03 L1302-1308 | ○ |
| C-133 | ReplaceSelf nullで例外 | E-03 L1300 | ○ |
| C-134 | CheckValidityメソッド | E-03 L985-1051 | △ |
| C-135 | CheckValidity スキーマnullで例外 | E-03 L995-998 | ○ |

### XPathNodeIterator クラス（UT-XPT-138〜UT-XPT-149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | Clone（抽象） | E-04 L16 | ○ |
| C-139 | MoveNext（抽象） | E-04 L17 | ○ |
| C-140 | MoveNext最後でfalse | E-04 L17（実装依存） | ○ |
| C-141 | Currentプロパティ（抽象） | E-04 L18 | ○ |
| C-142 | CurrentPositionプロパティ（抽象） | E-04 L19 | ○ |
| C-143 | Countプロパティ | E-04 L20-32 | ○ |
| C-144 | Count空イテレータで0 | E-04 L27-28 | ○ |
| C-145 | GetEnumeratorメソッド | E-04 L33-36 | ○ |
| C-146 | foreachで反復可能 | E-04 L33-36, L43-98 | ○ |
| C-147 | Enumerator.Current MoveNext前で例外 | E-04 L70-71 | ○ |
| C-148 | Enumerator.Current 完了後で例外 | E-04 L63-64 | ○ |
| C-149 | Enumerator.Resetメソッド | E-04 L94-97 | ○ |

### XPathExpression クラス（UT-XPT-150〜UT-XPT-159）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | Compile(string)メソッド | E-06 L57-60 | ○ |
| C-151 | Compile(string, IXmlNamespaceResolver) | E-06 L62-72 | ○ |
| C-152 | Expressionプロパティ | E-06 L43, E-11 L39-42 | ○ |
| C-153 | ReturnTypeプロパティ | E-06 L55, E-11 L107 | ○ |
| C-154 | Cloneメソッド | E-06 L49, E-11 L84-87 | ○ |
| C-155 | SetContext(XmlNamespaceManager) | E-06 L51, E-11 L89-92 | ○ |
| C-156 | SetContext(IXmlNamespaceResolver) | E-06 L53, E-11 L94-105 | ○ |
| C-157 | AddSort(object, IComparer) | E-06 L45, E-11 L49-77 | ○ |
| C-158 | AddSort詳細パラメータ | E-06 L47, E-11 L79-82 | ○ |
| C-159 | AddSort無効式で例外 | E-11 L68 `throw XPathException.Create` | ○ |

### その他クラス（UT-XPT-160〜UT-XPT-200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-160 | XPathItem.IsNode | E-05 L16 | ○ |
| C-161 | XPathItem.Value | E-05 L26 | ○ |
| C-162 | XPathItem.ValueAs(Type) | E-05 L34 | ○ |
| C-163 | IXPathNavigable.CreateNavigator | E-07 L8 | ○ |
| C-164 | XPathNavigatorKeyComparer.Equals | E-10 L11-20 | ○ |
| C-165 | XPathNavigatorKeyComparer.Equals異なる位置 | E-10 L18-19 | ○ |
| C-166 | XPathNavigatorKeyComparer.Equals null含む | E-10 L15-16 | ○ |
| C-167 | XPathNavigatorKeyComparer.GetHashCode | E-10 L23-54 | ○ |
| C-168 | XPathNavigatorKeyComparer.GetHashCode null | E-10 L25 | ○ |
| C-169 | XPathNodeType.All | E-09 L17 | ○ |
| C-170 | XPathNamespaceScope.All | E-08 L7 | ○ |
| C-171 | XPathNamespaceScope.ExcludeXml | E-08 L8 | ○ |
| C-172 | XPathNamespaceScope.Local | E-08 L9 | ○ |
| C-173 | XPathResultType.NodeSet | E-06 L33 | ○ |
| C-174 | XPathResultType.Number | E-06 L30 | ○ |
| C-175 | XPathResultType.String | E-06 L31 | ○ |
| C-176 | XPathResultType.Boolean | E-06 L32 | ○ |
| C-177 | CompiledXpathExpr.QueryTree | E-11 L27-37 | ○ |
| C-178 | CompiledXpathExpr.QueryTree未設定で例外 | E-11 L32-34 | ○ |
| C-179 | XPathComparerHelper.Compareテキスト | E-11 L200-213 | ○ |
| C-180 | XPathComparerHelper.Compare数値 | E-11 L215-219 | ○ |
| C-181 | XPathComparerHelper.Compare昇順 | E-11 L206, L219 | ○ |
| C-182 | XPathComparerHelper.Compare降順 | E-11 L179-189 | ○ |
| C-183 | XPathComparerHelper.Compare大文字優先 | E-11 L213 | ○ |
| C-184 | XPathComparerHelper.Compare小文字優先 | E-11 L213 | ○ |
| C-185 | XPathDocument.AddNamespace | E-01 L383-389 | ○ |
| C-186 | XPathDocument.LookupNamespaces | E-01 L395-410 | ○ |
| C-187 | XPathDocument.LookupNamespaces名前空間なし | E-01 L401-405 | ○ |
| C-188 | XPathDocument.AddIdElement | E-01 L415-421 | ○ |
| C-189 | XPathDocument.AddIdElement重複ID | E-01 L419-420 | ○ |
| C-190 | XPathDocument.LookupIdElement | E-01 L426-439 | ○ |
| C-191 | XPathDocument.LookupIdElement存在しないID | E-01 L430-434 | ○ |
| C-192 | XPathDocument.NameTable | E-01 L310-313 | ○ |
| C-193 | XPathDocument.HasLineInfo | E-01 L318-321 | ○ |
| C-194 | XPathNavigator.MoveToNonDescendant | E-03 L1657-1694 | ○ |
| C-195 | MoveToNonDescendantルートでfalse | E-03 L1660-1661 | ○ |
| C-196 | XPathNavigator.IndexInParent | E-03 L1701-1731 | ○ |
| C-197 | XPathNavigator.UniqueId | E-03 L1754-1788 | ○ |
| C-198 | UniqueId同一ノードで同一ID | E-03 L1754-1788（実装による） | ○ |
| C-199 | BuildSubtreeメソッド | E-03 L2022-2135 | ○ |
| C-200 | BuildSubtree不正状態で例外 | E-03 L2028-2032 | ○ |

## 4) 不足情報（Unknown / Missing）
- **MoveToId機能の詳細**: DTD/スキーマによるID定義に依存するため、テスト環境の準備方法が不明
  - 候補：DTDを含むXMLテストデータ / スキーマ検証済みドキュメント / XPathDocumentBuilder内部実装
- **CheckValidity内部動作**: XmlSchemaSetとの連携詳細が複雑
  - 候補：System.Xml.Schema名前空間の詳細調査 / 既存テストコード参照
- **内部メソッド（AddNamespace, LookupNamespaces等）**: internalアクセス修飾子のためテスト可能性要確認
  - 候補：InternalsVisibleTo属性 / リフレクション / 統合テストアプローチ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: UT-XPT-169〜UT-XPT-176（列挙型定義のテスト、変更可能性低）
- **1: 中リスク**: UT-XPT-123〜UT-XPT-135（編集機能、NotSupportedExceptionの挙動確認必要）
- **1: 中リスク**: UT-XPT-177〜UT-XPT-184（内部クラス、アクセス制限考慮必要）
- **2: 高リスク**: UT-XPT-057〜UT-XPT-058（ID参照、DTD依存の複雑な前提条件）
- **2: 高リスク**: UT-XPT-134〜UT-XPT-135（スキーマ検証、複雑な設定が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] XPathDocumentのコンストラクタパラメータ検証（null, 空など）が網羅されているか
- [ ] XPathNavigatorの抽象メソッドに対して、XPathDocumentNavigator実装でのテストが可能か
- [ ] XPathNodeIteratorの抽象メソッドに対して、具体的な実装クラスでのテストが可能か
- [ ] XPath式のコンパイル・評価に関するエラーケースが十分か
- [ ] 内部クラス（MS.Internal.Xml.XPath名前空間）のテスト戦略が明確か
- [ ] 編集機能（AppendChild, DeleteSelf等）のNotSupportedException発生パターンが正確か
- [ ] スキーマ検証機能のテストに必要な前提条件（XmlSchemaSet準備）が明確か
